/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.logging;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.repo.logging.Log;
import com.amazon.carbonado.repo.logging.LoggingQuery;
import com.amazon.carbonado.repo.logging.LoggingRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LoggingStorage<S extends Storable>
implements Storage<S> {
    private final Storage<S> mStorage;
    final Log mLog;

    LoggingStorage(LoggingRepository repo, Storage<S> storage) {
        this.mStorage = storage;
        this.mLog = repo.getLog();
        storage.addTrigger(new LoggingTrigger(this.mLog));
    }

    @Override
    public Class<S> getStorableType() {
        return this.mStorage.getStorableType();
    }

    @Override
    public S prepare() {
        return this.mStorage.prepare();
    }

    @Override
    public Query<S> query() throws FetchException {
        return new LoggingQuery<S>(this, this.mStorage.query());
    }

    @Override
    public Query<S> query(String filter) throws FetchException {
        return new LoggingQuery<S>(this, this.mStorage.query(filter));
    }

    @Override
    public Query<S> query(Filter<S> filter) throws FetchException {
        return new LoggingQuery<S>(this, this.mStorage.query(filter));
    }

    @Override
    public void truncate() throws PersistException {
        if (this.mLog.isEnabled()) {
            this.mLog.write("Storage.truncate() on " + this.getStorableType().getClass());
        }
        this.mStorage.truncate();
    }

    @Override
    public boolean addTrigger(Trigger<? super S> trigger) {
        return this.mStorage.addTrigger(trigger);
    }

    @Override
    public boolean removeTrigger(Trigger<? super S> trigger) {
        return this.mStorage.removeTrigger(trigger);
    }

    protected Query<S> wrap(Query<S> query) {
        return new LoggingQuery<S>(this, query);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggingTrigger<S extends Storable>
    extends Trigger<S> {
        private final Log mLog;

        LoggingTrigger(Log log) {
            this.mLog = log;
        }

        @Override
        public Object beforeInsert(S storable) {
            if (this.mLog.isEnabled()) {
                this.mLog.write("Storable.insert() on " + storable.toString());
            }
            return null;
        }

        @Override
        public Object beforeTryInsert(S storable) {
            if (this.mLog.isEnabled()) {
                this.mLog.write("Storable.tryInsert() on " + storable.toString());
            }
            return null;
        }

        @Override
        public Object beforeUpdate(S storable) {
            if (this.mLog.isEnabled()) {
                this.mLog.write("Storable.update() on " + storable.toString());
            }
            return null;
        }

        @Override
        public Object beforeTryUpdate(S storable) {
            if (this.mLog.isEnabled()) {
                this.mLog.write("Storable.tryUpdate() on " + storable.toString());
            }
            return null;
        }

        @Override
        public Object beforeDelete(S storable) {
            if (this.mLog.isEnabled()) {
                this.mLog.write("Storable.delete() on " + storable.toString());
            }
            return null;
        }

        @Override
        public Object beforeTryDelete(S storable) {
            if (this.mLog.isEnabled()) {
                this.mLog.write("Storable.tryDelete() on " + storable.toString());
            }
            return null;
        }

        @Override
        public void afterLoad(S storable) {
            if (this.mLog.isEnabled()) {
                this.mLog.write("Loaded " + storable.toString());
            }
        }
    }
}

