/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCStorableInfo;
import com.amazon.carbonado.repo.jdbc.JoinNode;
import com.amazon.carbonado.repo.jdbc.TableAliasGenerator;
import java.lang.reflect.UndeclaredThrowableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JoinNodeBuilder<S extends Storable>
extends Visitor<S, Object, Object> {
    private final JDBCRepository mRepository;
    private final TableAliasGenerator mAliasGenerator;
    private final JoinNode mRootJoinNode;

    JoinNodeBuilder(JDBCRepository repository, JDBCStorableInfo<S> info, TableAliasGenerator aliasGenerator) {
        this.mRepository = repository;
        this.mAliasGenerator = aliasGenerator;
        this.mRootJoinNode = new JoinNode(info, aliasGenerator.nextAlias());
    }

    public JoinNode getRootJoinNode() {
        return this.mRootJoinNode;
    }

    public void captureOrderings(OrderingList<?> ordering) {
        try {
            if (ordering != null) {
                for (OrderedProperty orderedProperty : ordering) {
                    ChainedProperty chained = orderedProperty.getChainedProperty();
                    if (chained.isDerived()) continue;
                    this.mRootJoinNode.addJoin(this.mRepository, chained, this.mAliasGenerator);
                }
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public Object visit(PropertyFilter<S> filter, Object param) {
        try {
            this.visit(filter);
            return null;
        }
        catch (RepositoryException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void visit(PropertyFilter<S> filter) throws RepositoryException {
        ChainedProperty<S> chained = filter.getChainedProperty();
        this.mRootJoinNode.addJoin(this.mRepository, chained, this.mAliasGenerator);
    }

    @Override
    public Object visit(ExistsFilter<S> filter, Object param) {
        try {
            this.visit(filter);
            return null;
        }
        catch (RepositoryException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private void visit(ExistsFilter<S> filter) throws RepositoryException {
        this.mRootJoinNode.aliasIsRequired();
        ChainedProperty<S> chained = filter.getChainedProperty();
        this.mRootJoinNode.addJoin(this.mRepository, chained, this.mAliasGenerator);
    }
}

