/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.raw;

import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.lob.Lob;
import com.amazon.carbonado.raw.GenericPropertyInfo;
import java.lang.reflect.Method;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.TypeDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorablePropertyInfo
implements GenericPropertyInfo {
    private final StorableProperty<?> mProp;
    private final TypeDesc mPropertyType;
    private final TypeDesc mStorageType;
    private final Method mFromStorage;
    private final Method mToStorage;

    StorablePropertyInfo(StorableProperty<?> property) {
        this(property, null, null, null);
    }

    StorablePropertyInfo(StorableProperty<?> property, Class<?> storageType, Method fromStorage, Method toStorage) {
        this.mProp = property;
        this.mPropertyType = TypeDesc.forClass(property.getType());
        this.mStorageType = storageType == null ? this.mPropertyType : TypeDesc.forClass(storageType);
        this.mFromStorage = fromStorage;
        this.mToStorage = toStorage;
    }

    @Override
    public String getPropertyName() {
        return this.mProp.getName();
    }

    @Override
    public TypeDesc getPropertyType() {
        return this.mPropertyType;
    }

    @Override
    public TypeDesc getStorageType() {
        return this.mStorageType;
    }

    @Override
    public boolean isNullable() {
        return this.mProp.isNullable();
    }

    @Override
    public boolean isLob() {
        Class clazz = this.mPropertyType.toClass();
        return clazz != null && Lob.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isDerived() {
        return this.mProp.isDerived();
    }

    @Override
    public Method getFromStorageAdapter() {
        return this.mFromStorage;
    }

    @Override
    public Method getToStorageAdapter() {
        return this.mToStorage;
    }

    public String getReadMethodName() {
        return this.mProp.getReadMethodName();
    }

    public void addInvokeReadMethod(CodeAssembler a) {
        a.invoke(this.mProp.getReadMethod());
    }

    public void addInvokeReadMethod(CodeAssembler a, TypeDesc instanceType) {
        Class clazz = instanceType.toClass();
        if (clazz == null) {
            throw new IllegalArgumentException("Instance type has no known class");
        }
        if (clazz.isInterface()) {
            a.invokeInterface(instanceType, this.getReadMethodName(), this.getPropertyType(), null);
        } else {
            a.invokeVirtual(instanceType, this.getReadMethodName(), this.getPropertyType(), null);
        }
    }

    public String getWriteMethodName() {
        return this.mProp.getWriteMethodName();
    }

    public void addInvokeWriteMethod(CodeAssembler a) {
        a.invoke(this.mProp.getWriteMethod());
    }

    public void addInvokeWriteMethod(CodeAssembler a, TypeDesc instanceType) {
        Class clazz = instanceType.toClass();
        if (clazz == null) {
            throw new IllegalArgumentException("Instance type has no known class");
        }
        if (clazz.isInterface()) {
            a.invokeInterface(instanceType, this.getWriteMethodName(), null, new TypeDesc[]{this.getPropertyType()});
        } else {
            a.invokeVirtual(instanceType, this.getWriteMethodName(), null, new TypeDesc[]{this.getPropertyType()});
        }
    }

    public String toString() {
        return ((Object)this.mProp).toString();
    }
}

