/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.util.SoftValuedCache;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecutorCache<S extends Storable>
implements QueryExecutorFactory<S> {
    static final int cMinCapacity;
    private final QueryExecutorFactory<S> mFactory;
    private final Map<Key<S>, QueryExecutor<S>> mPrimaryCache;
    private final Map<Filter<S>, SoftValuedCache<Object, QueryExecutor<S>>> mFilterToExecutor;

    public QueryExecutorCache(QueryExecutorFactory<S> factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this.mFactory = factory;
        this.mPrimaryCache = new LinkedHashMap<Key<S>, QueryExecutor<S>>(17, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Key<S>, QueryExecutor<S>> eldest) {
                return this.size() > cMinCapacity;
            }
        };
        this.mFilterToExecutor = new WeakIdentityMap(7);
    }

    @Override
    public Class<S> getStorableType() {
        return this.mFactory.getStorableType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryExecutor<S> executor(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws RepositoryException {
        QueryExecutor<Object> executor;
        SoftValuedCache<Object, QueryExecutor<Object>> cache;
        Object executor2;
        Key<S> key = new Key<S>(filter, ordering, hints);
        Map<Key<S>, QueryExecutor<S>> map = this.mPrimaryCache;
        synchronized (map) {
            executor2 = this.mPrimaryCache.get(key);
            if (executor2 != null) {
                return executor2;
            }
        }
        executor2 = this.mFilterToExecutor;
        synchronized (executor2) {
            cache = this.mFilterToExecutor.get(filter);
            if (cache == null) {
                cache = SoftValuedCache.newCache(7);
                this.mFilterToExecutor.put(filter, cache);
            }
        }
        Object subKey = hints == null || hints.isEmpty() ? ordering : new Key<S>(null, ordering, hints);
        Object object = cache;
        synchronized (object) {
            executor = cache.get(subKey);
            if (executor == null) {
                executor = this.mFactory.executor(filter, ordering, hints);
                cache.put(subKey, executor);
            }
        }
        object = this.mPrimaryCache;
        synchronized (object) {
            this.mPrimaryCache.put(key, executor);
        }
        return executor;
    }

    static {
        int minCapacity = 100;
        String prop = System.getProperty(QueryExecutorCache.class.getName().concat(".minCapacity"));
        if (prop != null) {
            try {
                minCapacity = Integer.parseInt(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        cMinCapacity = minCapacity;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key<S extends Storable> {
        private final Filter<S> mFilter;
        private final OrderingList<S> mOrdering;
        private final QueryHints mHints;

        Key(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) {
            this.mFilter = filter;
            this.mOrdering = ordering;
            this.mHints = hints;
        }

        public int hashCode() {
            QueryHints hints;
            Filter<S> filter = this.mFilter;
            int hash = filter == null ? 0 : filter.hashCode();
            OrderingList<S> ordering = this.mOrdering;
            if (ordering != null) {
                hash = hash * 31 + ordering.hashCode();
            }
            if ((hints = this.mHints) != null) {
                hash = hash * 31 + hints.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return Key.equals(this.mFilter, other.mFilter) && Key.equals(this.mOrdering, other.mOrdering) && Key.equals(this.mHints, other.mHints);
            }
            return false;
        }

        private static boolean equals(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }
    }
}

