/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import com.amazon.carbonado.qe.QueryExecutorCache;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.QueryFactory;
import com.amazon.carbonado.qe.QueryHints;
import com.amazon.carbonado.qe.RepositoryAccess;
import com.amazon.carbonado.qe.StandardQuery;
import com.amazon.carbonado.qe.StandardQueryFactory;
import com.amazon.carbonado.qe.UnionQueryAnalyzer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEngine<S extends Storable>
extends StandardQueryFactory<S>
implements QueryExecutorFactory<S> {
    final RepositoryAccess mRepoAccess;
    final QueryExecutorFactory<S> mExecutorFactory;

    public QueryEngine(Class<S> type, RepositoryAccess access) {
        super(type);
        this.mRepoAccess = access;
        this.mExecutorFactory = new QueryExecutorCache<S>(new UnionQueryAnalyzer<S>(type, access));
    }

    @Override
    public QueryExecutor<S> executor(Filter<S> filter, OrderingList<S> ordering, QueryHints hints) throws RepositoryException {
        return this.mExecutorFactory.executor(filter, ordering, hints);
    }

    @Override
    protected StandardQuery<S> createQuery(Filter<S> filter, FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) {
        return new Query(filter, values, ordering, hints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Query
    extends StandardQuery<S> {
        Query(Filter<S> filter, FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) {
            super(filter, values, ordering, hints);
        }

        @Override
        protected Transaction enterTransaction(IsolationLevel level) {
            return QueryEngine.this.mRepoAccess.getRootRepository().enterTransaction(level);
        }

        @Override
        protected QueryFactory<S> queryFactory() {
            return QueryEngine.this;
        }

        @Override
        protected QueryExecutorFactory<S> executorFactory() {
            return QueryEngine.this.mExecutorFactory;
        }

        @Override
        protected StandardQuery<S> newInstance(FilterValues<S> values, OrderingList<S> ordering, QueryHints hints) {
            return new Query(values.getFilter(), values, ordering, hints);
        }
    }
}

