/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.FilteringScore;
import com.amazon.carbonado.qe.OrderingList;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyQueryExecutor<S extends Storable>
extends AbstractQueryExecutor<S> {
    private final Support<S> mSupport;
    private final StorableIndex<S> mIndex;
    private final Filter<S> mKeyFilter;

    public KeyQueryExecutor(Support<S> support, StorableIndex<S> index, FilteringScore<S> score) {
        if (support == null && this instanceof Support) {
            support = (Support)((Object)this);
        }
        if (support == null || index == null || score == null) {
            throw new IllegalArgumentException();
        }
        if (!index.isUnique() || !score.isKeyMatch()) {
            throw new IllegalArgumentException();
        }
        this.mSupport = support;
        this.mIndex = index;
        this.mKeyFilter = score.getIdentityFilter();
    }

    @Override
    public Class<S> getStorableType() {
        return this.mIndex.getStorableType();
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values) throws FetchException {
        return this.mSupport.fetchOne(this.mIndex, values.getValuesFor(this.mKeyFilter));
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values, Query.Controller controller) throws FetchException {
        return this.mSupport.fetchOne(this.mIndex, values.getValuesFor(this.mKeyFilter), controller);
    }

    @Override
    public Filter<S> getFilter() {
        return this.mKeyFilter;
    }

    @Override
    public OrderingList<S> getOrdering() {
        return OrderingList.emptyList();
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        this.indent(app, indentLevel);
        app.append("index key match: ");
        app.append(this.mIndex.getStorableType().getName());
        this.newline(app);
        this.indent(app, indentLevel);
        app.append("...index: ");
        this.mIndex.appendTo(app);
        this.newline(app);
        this.indent(app, indentLevel);
        app.append("...key filter: ");
        this.mKeyFilter.appendTo(app, values);
        this.newline(app);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Support<S extends Storable> {
        public Cursor<S> fetchOne(StorableIndex<S> var1, Object[] var2) throws FetchException;

        public Cursor<S> fetchOne(StorableIndex<S> var1, Object[] var2, Query.Controller var3) throws FetchException;
    }
}

