/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.LimitCursor;
import com.amazon.carbonado.cursor.SkipCursor;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.QueryExecutor;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryExecutor<S extends Storable>
implements QueryExecutor<S> {
    @Override
    public Class<S> getStorableType() {
        return this.getFilter().getStorableType();
    }

    @Override
    public Cursor<S> fetchSlice(FilterValues<S> values, long from, Long to) throws FetchException {
        Cursor<S> cursor = this.fetch(values);
        if (from > 0L) {
            cursor = new SkipCursor<S>(cursor, from);
        }
        if (to != null) {
            cursor = new LimitCursor<S>(cursor, to - from);
        }
        return cursor;
    }

    @Override
    public Cursor<S> fetchSlice(FilterValues<S> values, long from, Long to, Query.Controller controller) throws FetchException {
        Cursor<S> cursor = this.fetch(values, controller);
        if (from > 0L) {
            cursor = new SkipCursor<S>(cursor, from);
        }
        if (to != null) {
            cursor = new LimitCursor<S>(cursor, to - from);
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(FilterValues<S> values) throws FetchException {
        Cursor<S> cursor = this.fetch(values);
        try {
            long count = cursor.skipNext(Integer.MAX_VALUE);
            if (count == Integer.MAX_VALUE) {
                int amt;
                while ((amt = cursor.skipNext(Integer.MAX_VALUE)) > 0) {
                    count += (long)amt;
                }
            }
            long l = count;
            return l;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(FilterValues<S> values, Query.Controller controller) throws FetchException {
        Cursor<S> cursor = this.fetch(values, controller);
        try {
            long count = cursor.skipNext(Integer.MAX_VALUE);
            if (count == Integer.MAX_VALUE) {
                int amt;
                while ((amt = cursor.skipNext(Integer.MAX_VALUE)) > 0) {
                    count += (long)amt;
                }
            }
            long l = count;
            return l;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public boolean printNative(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        return false;
    }

    protected void indent(Appendable app, int indentLevel) throws IOException {
        for (int i = 0; i < indentLevel; ++i) {
            app.append(' ');
        }
    }

    protected void newline(Appendable app) throws IOException {
        app.append('\n');
    }

    protected int increaseIndent(int indentLevel) {
        return indentLevel + 2;
    }
}

