/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchMultipleException;
import com.amazon.carbonado.FetchNoneException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistNoneException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.util.Appender;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery<S extends Storable>
implements Query<S>,
Appender {
    protected AbstractQuery() {
    }

    @Override
    public Query<S> and(String filter) throws FetchException {
        return this.and(Filter.filterFor(this.getStorableType(), filter));
    }

    @Override
    public Query<S> or(String filter) throws FetchException {
        return this.or(Filter.filterFor(this.getStorableType(), filter));
    }

    @Override
    public <T extends S> Cursor<S> fetchAfter(T start) throws FetchException {
        return this.after(start).fetch();
    }

    @Override
    public <T extends S> Cursor<S> fetchAfter(T start, Query.Controller controller) throws FetchException {
        return this.after(start).fetch(controller);
    }

    @Override
    public S loadOne() throws FetchException {
        S obj = this.tryLoadOne();
        if (obj == null) {
            throw new FetchNoneException(this.toString());
        }
        return obj;
    }

    @Override
    public S loadOne(Query.Controller controller) throws FetchException {
        S obj = this.tryLoadOne(controller);
        if (obj == null) {
            throw new FetchNoneException(this.toString());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S tryLoadOne() throws FetchException {
        Cursor cursor = this.fetch();
        try {
            if (cursor.hasNext()) {
                Storable obj = (Storable)cursor.next();
                if (cursor.hasNext()) {
                    throw new FetchMultipleException(this.toString());
                }
                Storable storable = obj;
                return (S)storable;
            }
            S s = null;
            return s;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S tryLoadOne(Query.Controller controller) throws FetchException {
        Cursor cursor = this.fetch(controller);
        try {
            if (cursor.hasNext()) {
                Storable obj = (Storable)cursor.next();
                if (cursor.hasNext()) {
                    throw new FetchMultipleException(this.toString());
                }
                Storable storable = obj;
                return (S)storable;
            }
            S s = null;
            return s;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public void deleteOne() throws PersistException {
        if (!this.tryDeleteOne()) {
            throw new PersistNoneException(this.toString());
        }
    }

    @Override
    public void deleteOne(Query.Controller controller) throws PersistException {
        if (!this.tryDeleteOne(controller)) {
            throw new PersistNoneException(this.toString());
        }
    }

    @Override
    public boolean printNative() {
        try {
            return this.printNative(System.out);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public boolean printNative(Appendable app) throws IOException {
        return this.printNative(app, 0);
    }

    @Override
    public boolean printPlan() {
        try {
            return this.printPlan(System.out);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public boolean printPlan(Appendable app) throws IOException {
        return this.printPlan(app, 0);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        try {
            this.appendTo(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return b.toString();
    }

    @Override
    public abstract int hashCode();

    @Override
    public abstract boolean equals(Object var1);

    protected boolean checkSliceArguments(long from, Long to) {
        if (from < 0L) {
            throw new IllegalArgumentException("Slice from is negative: " + from);
        }
        if (to == null) {
            if (from == 0L) {
                return false;
            }
        } else if (from > to) {
            throw new IllegalArgumentException("Slice from is more than to: " + from + " > " + to);
        }
        return true;
    }
}

