/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.lob;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.lob.AbstractClob;
import com.amazon.carbonado.lob.Blob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class BlobClob
extends AbstractClob {
    private static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    private final Blob mBlob;

    public BlobClob(Blob blob) {
        this.mBlob = blob;
    }

    public Reader openReader() throws FetchException {
        return new BufferedReader(new InputStreamReader(this.mBlob.openInputStream(), UTF_16BE));
    }

    public Reader openReader(long pos) throws FetchException {
        return this.openReader(pos, -1);
    }

    public Reader openReader(long pos, int bufferSize) throws FetchException {
        this.rangeCheck(pos, "Position");
        Reader reader = new InputStreamReader(this.mBlob.openInputStream(pos << 1, 0), UTF_16BE);
        if (bufferSize < 0) {
            reader = new BufferedReader(reader);
        } else if (bufferSize > 0) {
            reader = new BufferedReader(reader, bufferSize);
        }
        return reader;
    }

    public long getLength() throws FetchException {
        return this.mBlob.getLength() >> 1;
    }

    public Writer openWriter() throws PersistException {
        return new BufferedWriter(new OutputStreamWriter(this.mBlob.openOutputStream(), UTF_16BE));
    }

    public Writer openWriter(long pos) throws PersistException {
        return this.openWriter(pos, -1);
    }

    public Writer openWriter(long pos, int bufferSize) throws PersistException {
        this.rangeCheck(pos, "Position");
        Writer writer = new OutputStreamWriter(this.mBlob.openOutputStream(pos << 1, 0), UTF_16BE);
        if (bufferSize < 0) {
            writer = new BufferedWriter(writer);
        } else if (bufferSize > 0) {
            writer = new BufferedWriter(writer, bufferSize);
        }
        return writer;
    }

    public void setLength(long length) throws PersistException {
        this.rangeCheck(length, "Length");
        this.mBlob.setLength(length << 1);
    }

    public Object getLocator() {
        return this.mBlob.getLocator();
    }

    protected Blob getWrappedBlob() {
        return this.mBlob;
    }

    private void rangeCheck(long value, String type) {
        if (value < 0L) {
            throw new IllegalArgumentException(type + " is negative: " + value);
        }
        if (value > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException(type + " too large: " + value);
        }
    }
}

