/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.layout;

import com.amazon.carbonado.CorruptEncodingException;
import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchNoneException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.capability.ResyncCapability;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.layout.LayoutFactory;
import com.amazon.carbonado.layout.LayoutOptions;
import com.amazon.carbonado.layout.LayoutProperty;
import com.amazon.carbonado.layout.StoredLayout;
import com.amazon.carbonado.layout.StoredLayoutProperty;
import com.amazon.carbonado.synthetic.SyntheticBuilder;
import com.amazon.carbonado.synthetic.SyntheticKey;
import com.amazon.carbonado.synthetic.SyntheticProperty;
import com.amazon.carbonado.synthetic.SyntheticStorableBuilder;
import com.amazon.carbonado.util.AnnotationDescPrinter;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout {
    private static SoftValuedCache<Long, Class<? extends Storable>> cReconstructed = SoftValuedCache.newCache(7);
    private final LayoutFactory mLayoutFactory;
    private final StoredLayout mStoredLayout;
    private final LayoutOptions mOptions;
    private volatile List<LayoutProperty> mAllProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<? extends Storable> reconstruct(final Layout layout, ClassLoader loader) throws FetchException, SupportException {
        SoftValuedCache<Long, Class<? extends Storable>> softValuedCache = cReconstructed;
        synchronized (softValuedCache) {
            Long key = layout.getLayoutID();
            Class<? extends Storable> clazz = cReconstructed.get(key);
            if (clazz != null) {
                return clazz;
            }
            SyntheticStorableBuilder builder = new SyntheticStorableBuilder(layout.getStorableTypeName(), loader);
            builder.setEvolvable(true);
            builder.setClassNameProvider(new SyntheticBuilder.ClassNameProvider(){

                public String getName() {
                    return layout.getStorableTypeName();
                }

                public boolean isExplicit() {
                    return false;
                }
            });
            SyntheticKey primaryKey = builder.addPrimaryKey();
            for (LayoutProperty property : layout.getAllProperties()) {
                Class propClass = property.getPropertyType(loader);
                if (Query.class.isAssignableFrom(propClass) || Storable.class.isAssignableFrom(propClass)) continue;
                SyntheticProperty synthProp = builder.addProperty(property.getPropertyName(), propClass);
                synthProp.setIsNullable(property.isNullable());
                synthProp.setIsVersion(property.isVersion());
                if (property.isPrimaryKeyMember()) {
                    primaryKey.addProperty(property.getPropertyName());
                }
                if (property.getAdapterTypeName() == null) continue;
                String desc = property.getAdapterParams();
                if (desc == null) {
                    desc = AnnotationDescPrinter.makePlainDescriptor(property.getAdapterTypeName());
                }
                synthProp.addAccessorAnnotationDescriptor(desc);
            }
            clazz = builder.build();
            cReconstructed.put(key, clazz);
            return clazz;
        }
    }

    Layout(LayoutFactory factory, StoredLayout storedLayout) throws CorruptEncodingException {
        this.mLayoutFactory = factory;
        this.mStoredLayout = storedLayout;
        byte[] extra = storedLayout.getExtraData();
        if (extra == null) {
            this.mOptions = null;
        } else {
            this.mOptions = new LayoutOptions();
            try {
                this.mOptions.decode(extra);
            }
            catch (IOException e) {
                throw new CorruptEncodingException(e);
            }
            this.mOptions.readOnly();
        }
    }

    Layout(LayoutFactory factory, StorableInfo<?> info, LayoutOptions options, long layoutID) {
        StoredLayout storedLayout;
        this.mLayoutFactory = factory;
        this.mStoredLayout = storedLayout = factory.mLayoutStorage.prepare();
        storedLayout.setLayoutID(layoutID);
        storedLayout.setStorableTypeName(info.getStorableType().getName());
        storedLayout.setCreationTimestamp(System.currentTimeMillis());
        try {
            storedLayout.setCreationUser(System.getProperty("user.name"));
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            storedLayout.setCreationHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (options == null) {
            this.mOptions = null;
        } else {
            options.readOnly();
            storedLayout.setExtraData(options.encode());
            this.mOptions = options;
        }
        Collection<StorableProperty<?>> properties = info.getAllProperties().values();
        ArrayList<LayoutProperty> list = new ArrayList<LayoutProperty>(properties.size());
        int ordinal = 0;
        for (StorableProperty<?> property : properties) {
            if (property.isDerived() || property.isJoin()) continue;
            StoredLayoutProperty storedLayoutProperty = this.mLayoutFactory.mPropertyStorage.prepare();
            list.add(new LayoutProperty(storedLayoutProperty, property, layoutID, ordinal));
            ++ordinal;
        }
        this.mAllProperties = Collections.unmodifiableList(list);
    }

    public long getLayoutID() {
        return this.mStoredLayout.getLayoutID();
    }

    public String getStorableTypeName() {
        return this.mStoredLayout.getStorableTypeName();
    }

    public int getGeneration() {
        return this.mStoredLayout.getGeneration();
    }

    public List<LayoutProperty> getDataProperties() throws FetchException {
        List<LayoutProperty> all = this.getAllProperties();
        ArrayList<LayoutProperty> data = new ArrayList<LayoutProperty>(all.size() - 1);
        for (LayoutProperty property : all) {
            if (property.isPrimaryKeyMember()) continue;
            data.add(property);
        }
        return Collections.unmodifiableList(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LayoutProperty> getAllProperties() throws FetchException {
        List<LayoutProperty> all = this.mAllProperties;
        if (all == null) {
            Cursor<StoredLayoutProperty> cursor = this.mLayoutFactory.mPropertyStorage.query("layoutID = ?").with(this.mStoredLayout.getLayoutID()).orderBy("ordinal").fetch();
            try {
                ArrayList<LayoutProperty> list = new ArrayList<LayoutProperty>();
                while (cursor.hasNext()) {
                    list.add(new LayoutProperty(cursor.next()));
                }
                this.mAllProperties = all = Collections.unmodifiableList(list);
            }
            finally {
                cursor.close();
            }
        }
        return all;
    }

    public DateTime getCreationDateTime() {
        return new DateTime(this.mStoredLayout.getCreationTimestamp());
    }

    public String getCreationUser() {
        return this.mStoredLayout.getCreationUser();
    }

    public String getCreationHost() {
        return this.mStoredLayout.getCreationHost();
    }

    public LayoutOptions getOptions() {
        return this.mOptions;
    }

    public Layout getGeneration(int generation) throws FetchNoneException, FetchException {
        StoredLayout storedLayout;
        String filter = "storableTypeName = ? & generation = ?";
        try {
            storedLayout = this.mLayoutFactory.mLayoutStorage.query("storableTypeName = ? & generation = ?").with(this.getStorableTypeName()).with(generation).loadOne();
        }
        catch (FetchNoneException e) {
            ResyncCapability cap = this.mLayoutFactory.mRepository.getCapability(ResyncCapability.class);
            if (cap == null) {
                throw e;
            }
            try {
                cap.resync(this.mLayoutFactory.mLayoutStorage.getStorableType(), 1.0, "storableTypeName = ? & generation = ?", this.getStorableTypeName(), generation);
            }
            catch (RepositoryException e2) {
                LogFactory.getLog(Layout.class).error((Object)"Unable to resync layout", (Throwable)e2);
                throw e;
            }
            storedLayout = this.mLayoutFactory.mLayoutStorage.query("storableTypeName = ? & generation = ?").with(this.getStorableTypeName()).with(generation).loadOne();
            try {
                cap.resync(this.mLayoutFactory.mPropertyStorage.getStorableType(), 1.0, "layoutID = ?", storedLayout.getLayoutID());
            }
            catch (RepositoryException e2) {
                LogFactory.getLog(Layout.class).error((Object)"Unable to resync layout", (Throwable)e2);
                throw e;
            }
        }
        return new Layout(this.mLayoutFactory, storedLayout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layout previousGeneration() throws FetchException {
        Cursor<StoredLayout> cursor = this.mLayoutFactory.mLayoutStorage.query("storableTypeName = ? & generation < ?").with(this.getStorableTypeName()).with(this.getGeneration()).orderBy("-generation").fetch();
        try {
            if (cursor.hasNext()) {
                Layout layout = new Layout(this.mLayoutFactory, cursor.next());
                return layout;
            }
        }
        finally {
            cursor.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layout nextGeneration() throws FetchException {
        Cursor<StoredLayout> cursor = this.mLayoutFactory.mLayoutStorage.query("storableTypeName = ? & generation > ?").with(this.getStorableTypeName()).with(this.getGeneration()).orderBy("+generation").fetch();
        try {
            if (cursor.hasNext()) {
                Layout layout = new Layout(this.mLayoutFactory, cursor.next());
                return layout;
            }
        }
        finally {
            cursor.close();
        }
        return null;
    }

    public Class<? extends Storable> reconstruct() throws FetchException, SupportException {
        return this.reconstruct(null);
    }

    public Class<? extends Storable> reconstruct(ClassLoader loader) throws FetchException, SupportException {
        Class<? extends Storable> reconstructed = Layout.reconstruct(this, loader);
        this.mLayoutFactory.registerReconstructed(reconstructed, this);
        return reconstructed;
    }

    public int hashCode() {
        long id = this.getLayoutID();
        return (int)id ^ (int)(id >> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Layout) {
            Layout other = (Layout)obj;
            try {
                return this.mStoredLayout.equals(other.mStoredLayout) && this.equalLayouts(other);
            }
            catch (FetchException e) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Layout {type=").append(this.getStorableTypeName());
        b.append(", generation=").append(this.getGeneration());
        b.append(", properties={");
        try {
            List<LayoutProperty> props = this.getAllProperties();
            for (int i = 0; i < props.size(); ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(props.get(i));
            }
        }
        catch (FetchException e) {
            b.append(e.toString());
        }
        b.append("}}");
        return b.toString();
    }

    public boolean equalLayouts(Layout layout) throws FetchException {
        if (this == layout) {
            return true;
        }
        return this.getStorableTypeName().equals(layout.getStorableTypeName()) && ((Object)this.getAllProperties()).equals(layout.getAllProperties()) && Arrays.equals(this.mStoredLayout.getExtraData(), layout.mStoredLayout.getExtraData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException, RepositoryException {
        this.mStoredLayout.writeTo(out);
        Cursor<StoredLayoutProperty> cursor = this.mLayoutFactory.mPropertyStorage.query("layoutID = ?").with(this.mStoredLayout.getLayoutID()).fetch();
        try {
            while (cursor.hasNext()) {
                StoredLayoutProperty prop = cursor.next();
                out.write(1);
                prop.writeTo(out);
            }
        }
        finally {
            cursor.close();
        }
        out.write(0);
    }

    void insert(boolean readOnly, int generation) throws PersistException {
        if (this.mAllProperties == null) {
            throw new IllegalStateException();
        }
        this.mStoredLayout.setGeneration(generation);
        if (readOnly) {
            return;
        }
        try {
            this.mStoredLayout.insert();
        }
        catch (UniqueConstraintException e) {
            StoredLayout existing = (StoredLayout)this.mStoredLayout.prepare();
            this.mStoredLayout.copyPrimaryKeyProperties(existing);
            try {
                existing.load();
            }
            catch (FetchException e2) {
                throw e2.toPersistException();
            }
            if (existing.getGeneration() != generation || !existing.getStorableTypeName().equals(this.getStorableTypeName()) || !Arrays.equals(existing.getExtraData(), this.mStoredLayout.getExtraData())) {
                throw e;
            }
            this.mStoredLayout.setVersionNumber(existing.getVersionNumber());
            this.mStoredLayout.update();
        }
        for (LayoutProperty property : this.mAllProperties) {
            property.insert();
        }
    }
}

