/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.info;

import com.amazon.carbonado.Alias;
import com.amazon.carbonado.AlternateKeys;
import com.amazon.carbonado.Authoritative;
import com.amazon.carbonado.Automatic;
import com.amazon.carbonado.Derived;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Independent;
import com.amazon.carbonado.Index;
import com.amazon.carbonado.Indexes;
import com.amazon.carbonado.Join;
import com.amazon.carbonado.Key;
import com.amazon.carbonado.MalformedTypeException;
import com.amazon.carbonado.Name;
import com.amazon.carbonado.Nullable;
import com.amazon.carbonado.PartitionKey;
import com.amazon.carbonado.PrimaryKey;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Sequence;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Version;
import com.amazon.carbonado.adapter.AdapterDefinition;
import com.amazon.carbonado.constraint.ConstraintDefinition;
import com.amazon.carbonado.info.AutomaticAdapterSelector;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableKey;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.info.StorablePropertyAnnotation;
import com.amazon.carbonado.info.StorablePropertyConstraint;
import com.amazon.carbonado.lob.Lob;
import com.amazon.carbonado.util.ConversionComparator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.BeanComparator;
import org.cojen.util.BeanIntrospector;
import org.cojen.util.BeanProperty;
import org.cojen.util.ThrowUnchecked;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorableIntrospector {
    private static Map<Class<?>, Reference<StorableInfo<?>>> cCache;
    private static final Class[] EMPTY_CLASSES_ARRAY;
    private static final Method cCovariantTypesMethod;

    private static Class<?>[] getCovariantTypes(BeanProperty property) {
        if (cCovariantTypesMethod != null) {
            try {
                return (Class[])cCovariantTypesMethod.invoke((Object)property, (Object[])null);
            }
            catch (InvocationTargetException e) {
                ThrowUnchecked.fireDeclaredCause((Throwable)e, (Class[])new Class[0]);
            }
            catch (IllegalAccessException e) {
                ThrowUnchecked.fireDeclared((Throwable)e, (Class[])new Class[0]);
            }
        }
        return EMPTY_CLASSES_ARRAY;
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            Class<?> clazz = Class.forName(arg);
            System.out.println("Examining: " + clazz.getName());
            try {
                StorableIntrospector.examine(clazz);
                System.out.println("Passed");
            }
            catch (MalformedTypeException e) {
                System.out.println("Malformed type: " + e.getMalformedType().getName());
                for (String message : e.getMessages()) {
                    System.out.println(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static <S extends Storable> StorableInfo<S> examine(Class<S> type) {
        if (type == null) {
            throw new IllegalArgumentException("Storable type must not be null");
        }
        Map<Class<?>, Reference<StorableInfo<?>>> map = cCache;
        synchronized (map) {
            boolean bl;
            String[] aliases;
            List<NameAndDirection> primaryKeyProps;
            StorableInfo<?> info;
            Reference<StorableInfo<?>> ref = cCache.get(type);
            if (ref != null && (info = ref.get()) != null) {
                return info;
            }
            ArrayList<String> errorMessages = new ArrayList<String>();
            try {
                primaryKeyProps = StorableIntrospector.gatherListProperties(errorMessages, type.getAnnotation(PrimaryKey.class));
            }
            catch (IndexOutOfBoundsException e) {
                errorMessages.add("No primary key defined");
                primaryKeyProps = Collections.emptyList();
            }
            List<List<NameAndDirection>> alternateKeyProps = StorableIntrospector.gatherListProperties(errorMessages, type.getAnnotation(AlternateKeys.class));
            List<List<NameAndDirection>> indexProps = StorableIntrospector.gatherListProperties(errorMessages, type.getAnnotation(Indexes.class));
            List<NameAndDirection> partitionKeyProps = StorableIntrospector.gatherListProperties(errorMessages, type.getAnnotation(PartitionKey.class));
            Map<String, StorableProperty<Object>> properties = StorableIntrospector.examineProperties(type, primaryKeyProps, alternateKeyProps, partitionKeyProps);
            Set<OrderedProperty<S>> propSet = StorableIntrospector.resolveKey(errorMessages, type, properties, "primary key", primaryKeyProps);
            SKey<S> primaryKey = new SKey<S>(true, propSet);
            StorableKey[] alternateKeys = new StorableKey[alternateKeyProps.size()];
            int i = 0;
            for (List<NameAndDirection> nameAndDirs : alternateKeyProps) {
                Set<OrderedProperty<S>> propSet2 = StorableIntrospector.resolveKey(errorMessages, type, properties, "alternate key", nameAndDirs);
                alternateKeys[i++] = new SKey<S>(false, propSet2);
            }
            SKey<S> partitionKey = null;
            if (partitionKeyProps != null) {
                Set<OrderedProperty<S>> propSet3 = StorableIntrospector.resolveKey(errorMessages, type, properties, "partition key", partitionKeyProps);
                partitionKey = new SKey<S>(false, propSet3);
            }
            StorableIndex[] indexes = new StorableIndex[indexProps.size()];
            int i2 = 0;
            for (List<NameAndDirection> list : indexProps) {
                int n = errorMessages.size();
                Set<OrderedProperty<S>> propSet4 = StorableIntrospector.resolveKey(errorMessages, type, properties, "index", list);
                if (errorMessages.size() <= n) {
                    OrderedProperty[] propArray = new OrderedProperty[propSet4.size()];
                    propSet4.toArray(propArray);
                    indexes[i2] = new StorableIndex(propArray, null);
                }
                ++i2;
            }
            LinkedHashMap<String, StorableProperty> arrangedProperties = new LinkedHashMap<String, StorableProperty>();
            for (OrderedProperty orderedProperty : primaryKey.getProperties()) {
                StorableProperty storableProperty = orderedProperty.getChainedProperty().getPrimeProperty();
                arrangedProperties.put(storableProperty.getName(), storableProperty);
            }
            ArrayList<StorableProperty<S>> nonPkProperties = new ArrayList<StorableProperty<S>>();
            for (StorableProperty<S> storableProperty : properties.values()) {
                if (arrangedProperties.containsKey(storableProperty.getName())) continue;
                nonPkProperties.add(storableProperty);
            }
            Collections.sort(nonPkProperties, BeanComparator.forClass(StorableProperty.class).orderBy("name"));
            for (StorableProperty storableProperty : nonPkProperties) {
                arrangedProperties.put(storableProperty.getName(), storableProperty);
            }
            properties = Collections.unmodifiableMap(arrangedProperties);
            Alias alias = type.getAnnotation(Alias.class);
            if (alias == null) {
                aliases = null;
            } else {
                aliases = alias.value();
                if (aliases.length == 0) {
                    errorMessages.add("Alias list is empty");
                }
            }
            info = new Info(type, aliases, indexes, properties, primaryKey, alternateKeys, partitionKey, type.getAnnotation(Independent.class) != null, type.getAnnotation(Authoritative.class) != null);
            cCache.put(type, new SoftReference(info));
            boolean bl2 = false;
            for (StorableProperty<Object> property : properties.values()) {
                void var16_26;
                if (property instanceof SimpleProperty) {
                    SimpleProperty sp = (SimpleProperty)property;
                    sp.setEnclosingInfo(info);
                    sp.setNumber((int)var16_26);
                }
                ++var16_26;
            }
            for (StorableProperty<Object> storableProperty : properties.values()) {
                if (!(storableProperty instanceof JoinProperty)) continue;
                ((JoinProperty)storableProperty).resolveJoin(errorMessages);
            }
            boolean bl3 = false;
            for (StorableProperty<Object> property : properties.values()) {
                if (!(property instanceof SimpleProperty) || !property.isDerived()) continue;
                bl = true;
                ((SimpleProperty)property).resolveDerivedFrom(errorMessages);
            }
            if (bl && errorMessages.size() == 0) {
                for (StorableIndex index : indexes) {
                    for (StorableProperty property : index.getProperties()) {
                        if (!property.isDerived() || property.getReadMethod() == null || property.getDerivedFromProperties().length != 0) continue;
                        Class<FetchException> exceptionType = FetchException.class;
                        Class<?>[] exceptions = property.getReadMethod().getExceptionTypes();
                        boolean fetches = false;
                        int i3 = exceptions.length;
                        while (--i3 >= 0) {
                            if (!exceptions[i3].isAssignableFrom(exceptionType)) continue;
                            fetches = true;
                            break;
                        }
                        if (!fetches) continue;
                        errorMessages.add("Index refers to a derived property which declares throwing a FetchException, but property does not list any derived-from properties: \"" + property.getName() + "'");
                    }
                }
            }
            if (errorMessages.size() > 0) {
                cCache.remove(type);
                throw new MalformedTypeException(type, errorMessages);
            }
            return info;
        }
    }

    public static Class<? extends Storable> inferType(Class clazz) {
        if (clazz == null || !Storable.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (clazz.isAnnotationPresent(PrimaryKey.class)) {
            return clazz;
        }
        Class<? extends Storable> candidate = StorableIntrospector.inferType(clazz.getSuperclass());
        for (Class<?> iface : clazz.getInterfaces()) {
            Class<? extends Storable> inferred = StorableIntrospector.inferType(iface);
            if (inferred == null) continue;
            if (candidate == null) {
                candidate = inferred;
                continue;
            }
            return null;
        }
        return candidate;
    }

    private static List<List<NameAndDirection>> gatherListProperties(List<String> errorMessages, Indexes indexes) {
        Index[] ixs;
        ArrayList<List<NameAndDirection>> listlist = new ArrayList<List<NameAndDirection>>();
        if (indexes != null && (ixs = indexes.value()) != null && ixs.length > 0) {
            for (int i = 0; i < ixs.length; ++i) {
                String[] propNames = ixs[i].value();
                if (propNames == null || propNames.length == 0) {
                    errorMessages.add("Empty index defined");
                    continue;
                }
                StorableIntrospector.gatherListProperties(errorMessages, "index", propNames, listlist);
            }
        }
        return listlist;
    }

    private static List<List<NameAndDirection>> gatherListProperties(List<String> errorMessages, AlternateKeys alternateKeys) {
        Key[] keys;
        ArrayList<List<NameAndDirection>> listlist = new ArrayList<List<NameAndDirection>>();
        if (alternateKeys != null && (keys = alternateKeys.value()) != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                String[] propNames = keys[i].value();
                if (propNames == null || propNames.length == 0) {
                    errorMessages.add("Empty alternate key defined");
                    continue;
                }
                StorableIntrospector.gatherListProperties(errorMessages, "alternate key", propNames, listlist);
            }
        }
        return listlist;
    }

    private static List<NameAndDirection> gatherListProperties(List<String> errorMessages, PrimaryKey primaryKey) {
        ArrayList<List<NameAndDirection>> listlist = new ArrayList<List<NameAndDirection>>();
        if (primaryKey != null) {
            String[] propNames = primaryKey.value();
            if (propNames == null || propNames.length == 0) {
                errorMessages.add("Empty primary key defined");
            } else {
                StorableIntrospector.gatherListProperties(errorMessages, "primary key", propNames, listlist);
            }
        }
        return (List)listlist.get(0);
    }

    private static List<NameAndDirection> gatherListProperties(List<String> errorMessages, PartitionKey partitionKey) {
        ArrayList<List<NameAndDirection>> listlist = new ArrayList<List<NameAndDirection>>();
        if (partitionKey != null) {
            String[] propNames = partitionKey.value();
            if (propNames == null || propNames.length == 0) {
                errorMessages.add("Empty partition key defined");
            } else {
                StorableIntrospector.gatherListProperties(errorMessages, "partition key", propNames, listlist);
            }
        }
        return listlist.size() > 0 ? (List)listlist.get(0) : null;
    }

    private static void gatherListProperties(List<String> errorMessages, String listName, String[] propNames, List<List<NameAndDirection>> listlist) {
        int length = propNames.length;
        ArrayList<NameAndDirection> nameAndDirs = new ArrayList<NameAndDirection>(length);
        for (int i = 0; i < length; ++i) {
            NameAndDirection nameAndDir;
            String name = propNames[i];
            Direction dir = Direction.UNSPECIFIED;
            if (name.length() > 0) {
                if (name.charAt(0) == '+') {
                    name = name.substring(1);
                    dir = Direction.ASCENDING;
                } else if (name.charAt(0) == '-') {
                    name = name.substring(1);
                    dir = Direction.DESCENDING;
                }
            }
            if (nameAndDirs.contains(nameAndDir = new NameAndDirection(name, dir))) {
                errorMessages.add("Duplicate property in " + listName + ": " + Arrays.toString(propNames));
                continue;
            }
            nameAndDirs.add(nameAndDir);
        }
        if (nameAndDirs.size() == 0) {
            return;
        }
        if (listlist.contains(nameAndDirs)) {
            errorMessages.add("Duplicate " + listName + " specification: " + Arrays.toString(propNames));
            return;
        }
        listlist.add(nameAndDirs);
    }

    private static <S extends Storable> Set<OrderedProperty<S>> resolveKey(List<String> errorMessages, Class<S> type, Map<String, StorableProperty<S>> properties, String elementName, List<NameAndDirection> nameAndDirs) {
        LinkedHashSet<OrderedProperty<S>> orderedProps = new LinkedHashSet<OrderedProperty<S>>();
        for (NameAndDirection nameAndDir : nameAndDirs) {
            String name = nameAndDir.name;
            if (name.indexOf(46) > 0) {
                errorMessages.add("Chained property not allowed in " + elementName + ": " + name);
                continue;
            }
            StorableProperty<S> prop = properties.get(name);
            if (prop == null) {
                errorMessages.add("Property for " + elementName + " not found: " + name);
                continue;
            }
            if (prop.isJoin()) {
                errorMessages.add("Property of " + elementName + " cannot reference a join property: " + name);
                continue;
            }
            if (Lob.class.isAssignableFrom(prop.getType())) {
                errorMessages.add("Property of " + elementName + " cannot reference a LOB property: " + name);
                continue;
            }
            orderedProps.add(OrderedProperty.get(prop, nameAndDir.direction));
        }
        if (orderedProps.size() == 0) {
            return Collections.emptySet();
        }
        if (orderedProps.size() == 1) {
            return Collections.singleton(orderedProps.iterator().next());
        }
        return Collections.unmodifiableSet(orderedProps);
    }

    private static <S extends Storable> Map<String, StorableProperty<S>> examineProperties(Class<S> type, List<NameAndDirection> primaryKeyProps, List<List<NameAndDirection>> alternateKeyProps, List<NameAndDirection> partitionKeyProps) throws MalformedTypeException {
        ArrayList<String> errorMessages;
        block31: {
            if (Storable.class.isAssignableFrom(type)) {
                if (Storable.class == type) {
                    throw new MalformedTypeException(type, "Storable interface must be extended");
                }
            } else {
                throw new MalformedTypeException(type, "Does not implement Storable interface");
            }
            int modifiers = type.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                throw new MalformedTypeException(type, "Class is declared final");
            }
            if (!Modifier.isPublic(modifiers)) {
                throw new MalformedTypeException(type, "Class is not public");
            }
            errorMessages = new ArrayList<String>();
            StorableIntrospector.checkTypeParameter(errorMessages, type);
            if (!type.isInterface()) {
                Constructor<?>[] ctors;
                for (Constructor<?> c : ctors = type.getDeclaredConstructors()) {
                    if (c.getParameterTypes().length != 0) continue;
                    modifiers = c.getModifiers();
                    if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) {
                        errorMessages.add("Cannot call constructor: " + c);
                    }
                    break block31;
                }
                if (type.getEnclosingClass() == null) {
                    errorMessages.add("Class must have a public or protected constructor that accepts no arguments");
                } else {
                    errorMessages.add("Inner class must have a public or protected constructor that accepts no arguments");
                }
            }
        }
        Map<String, Method> methods = StorableIntrospector.gatherAllDeclaredMethods(type);
        Iterator<Method> it = methods.values().iterator();
        while (it.hasNext()) {
            Method m = it.next();
            if (!Modifier.isAbstract(m.getModifiers()) || m.getDeclaringClass() == Storable.class) {
                it.remove();
                continue;
            }
            try {
                Method m2 = Storable.class.getMethod(m.getName(), m.getParameterTypes());
                if (m.getReturnType() == m2.getReturnType()) {
                    it.remove();
                }
                if (!m.getName().equals("copy") || !type.isAssignableFrom(m.getReturnType())) continue;
                it.remove();
            }
            catch (NoSuchMethodException e) {}
        }
        HashSet<String> pkPropertyNames = new HashSet<String>();
        HashSet<String> altKeyPropertyNames = new HashSet<String>();
        HashSet<String> parKeyPropertyNames = new HashSet<String>();
        for (NameAndDirection nameAndDirection : primaryKeyProps) {
            pkPropertyNames.add(nameAndDirection.name);
        }
        for (List list : alternateKeyProps) {
            for (NameAndDirection nameAndDir : list) {
                altKeyPropertyNames.add(nameAndDir.name);
            }
        }
        if (partitionKeyProps != null) {
            for (NameAndDirection nameAndDirection : partitionKeyProps) {
                parKeyPropertyNames.add(nameAndDirection.name);
            }
        }
        Map allProperties = BeanIntrospector.getAllProperties(type);
        HashMap<String, StorableProperty<S>> hashMap = new HashMap<String, StorableProperty<S>>();
        Iterator it2 = allProperties.values().iterator();
        while (it2.hasNext()) {
            String sig;
            BeanProperty property = (BeanProperty)BeanProperty.class.cast(it2.next());
            Method readMethod = property.getReadMethod();
            Method writeMethod = property.getWriteMethod();
            if (readMethod != null ? !Modifier.isAbstract(readMethod.getModifiers()) && readMethod.getAnnotation(Derived.class) == null : writeMethod == null || !Modifier.isAbstract(writeMethod.getModifiers()) && writeMethod.getAnnotation(Derived.class) == null) continue;
            StorableProperty<S> storableProp = StorableIntrospector.makeStorableProperty(errorMessages, property, type, pkPropertyNames, altKeyPropertyNames, parKeyPropertyNames);
            if (storableProp == null) continue;
            if (hashMap.containsKey(storableProp.getName())) {
                errorMessages.add("Duplicate property defined: " + storableProp.getName());
                continue;
            }
            if (readMethod != null) {
                sig = StorableIntrospector.createSig(readMethod);
                if (!storableProp.isDerived() && !methods.containsKey(sig)) continue;
                methods.remove(sig);
                hashMap.put(storableProp.getName(), storableProp);
            }
            if (writeMethod == null) continue;
            sig = StorableIntrospector.createSig(writeMethod);
            if (!storableProp.isDerived() && !methods.containsKey(sig)) continue;
            methods.remove(sig);
            hashMap.put(storableProp.getName(), storableProp);
        }
        if (errorMessages.size() == 0) {
            Iterator<Method> iter = methods.values().iterator();
            while (iter.hasNext()) {
                Method m = iter.next();
                int methodModifiers = m.getModifiers();
                if (!Modifier.isAbstract(methodModifiers)) continue;
                String message = !Modifier.isPublic(methodModifiers) && !Modifier.isProtected(methodModifiers) ? "Abstract method cannot be defined (neither public or protected): " : (!StorableIntrospector.isCovariant(allProperties, m) ? "Abstract method cannot be defined (not a bean property): " : null);
                if (message != null) {
                    errorMessages.add(message + m);
                }
                iter.remove();
            }
        }
        boolean hasVersionProp = false;
        for (StorableProperty property : hashMap.values()) {
            if (!property.isVersion()) continue;
            if (hasVersionProp) {
                errorMessages.add("At most one property may be designated as the version number");
                break;
            }
            hasVersionProp = true;
        }
        if (errorMessages.size() == 0 && methods.size() > 0) {
            for (Method m : methods.values()) {
                errorMessages.add("Method cannot be implemented: " + m);
            }
        }
        if (errorMessages.size() > 0) {
            throw new MalformedTypeException(type, errorMessages);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static boolean isCovariant(Map allProperties, Method m) {
        for (Object obj : allProperties.values()) {
            Class<?> type;
            BeanProperty property = (BeanProperty)obj;
            Class<?>[] covariantTypes = StorableIntrospector.getCovariantTypes(property);
            if (covariantTypes == null || covariantTypes.length == 0) continue;
            Class<?> returnType = m.getReturnType();
            Class<?>[] paramTypes = m.getParameterTypes();
            if (m.getName().equals(property.getReadMethod().getName())) {
                if (returnType == null || returnType == Void.TYPE || paramTypes == null || paramTypes.length > 0) continue;
                type = returnType;
            } else {
                if (!m.getName().equals(property.getWriteMethod().getName()) || returnType != null && returnType != Void.TYPE || paramTypes == null || paramTypes.length != 1) continue;
                type = paramTypes[0];
            }
            for (Class<?> covariantType : covariantTypes) {
                if (type != covariantType) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkTypeParameter(List<String> errorMessages, Class type) {
        if (type != null && Storable.class.isAssignableFrom(type)) {
            if (Storable.class == type) {
                return;
            }
        } else {
            return;
        }
        StorableIntrospector.checkTypeParameter(errorMessages, type.getSuperclass());
        for (Class<?> c : type.getInterfaces()) {
            StorableIntrospector.checkTypeParameter(errorMessages, c);
        }
        for (Type t : type.getGenericInterfaces()) {
            Class param;
            ParameterizedType pt;
            if (!(t instanceof ParameterizedType) || (pt = (ParameterizedType)t).getRawType() != Storable.class) continue;
            Type arg = pt.getActualTypeArguments()[0];
            if (arg instanceof ParameterizedType) {
                Type raw = ((ParameterizedType)arg).getRawType();
                if (!(raw instanceof Class)) continue;
                param = (Class)raw;
            } else if (arg instanceof Class) {
                param = (Class)arg;
            } else {
                if (!(arg instanceof TypeVariable)) continue;
                continue;
            }
            if (Storable.class.isAssignableFrom(param)) {
                if (param.isAssignableFrom(type)) continue;
                errorMessages.add("Type parameter passed from " + type + " to Storable must be a " + type.getName() + ": " + param);
                return;
            }
            errorMessages.add("Type parameter passed from " + type + " to Storable must be a Storable: " + param);
            return;
        }
    }

    private static <S extends Storable> StorableProperty<S> makeStorableProperty(List<String> errorMessages, BeanProperty property, Class<S> enclosing, Set<String> pkPropertyNames, Set<String> altKeyPropertyNames, Set<String> parKeyPropertyNames) {
        Class joinedType;
        String[] external;
        String[] internal;
        String sequenceName;
        StorablePropertyAdapter[] adapters;
        StorablePropertyConstraint[] constraints;
        String[] aliases;
        String propertyName;
        Derived derived;
        Independent independent;
        Automatic automatic;
        Version version;
        Nullable nullable;
        block73: {
            nullable = null;
            Alias alias = null;
            version = null;
            Sequence sequence = null;
            automatic = null;
            independent = null;
            Join join = null;
            derived = null;
            Name name = null;
            Method readMethod = property.getReadMethod();
            Method writeMethod = property.getWriteMethod();
            if (readMethod == null) {
                if (writeMethod == null || Modifier.isAbstract(writeMethod.getModifiers())) {
                    errorMessages.add("Must define proper 'get' method for property: " + property.getName());
                }
            } else {
                nullable = readMethod.getAnnotation(Nullable.class);
                alias = readMethod.getAnnotation(Alias.class);
                version = readMethod.getAnnotation(Version.class);
                sequence = readMethod.getAnnotation(Sequence.class);
                automatic = readMethod.getAnnotation(Automatic.class);
                independent = readMethod.getAnnotation(Independent.class);
                join = readMethod.getAnnotation(Join.class);
                derived = readMethod.getAnnotation(Derived.class);
                name = readMethod.getAnnotation(Name.class);
            }
            if (name == null) {
                propertyName = property.getName();
            } else {
                propertyName = name.value();
                int length = propertyName.length();
                if (length == 0) {
                    errorMessages.add("Property name for method cannot be blank: " + readMethod);
                } else if (!Character.isUnicodeIdentifierStart(propertyName.charAt(0))) {
                    errorMessages.add("First character of property name must be a unicode identifier start: " + propertyName);
                } else {
                    for (int i = 1; i < length; ++i) {
                        if (Character.isUnicodeIdentifierPart(propertyName.charAt(i))) continue;
                        errorMessages.add("Characters of property name must be a unicode identifier part: " + propertyName);
                        break;
                    }
                }
            }
            boolean pk = pkPropertyNames.contains(propertyName);
            boolean altKey = altKeyPropertyNames.contains(propertyName);
            boolean parKey = parKeyPropertyNames.contains(propertyName);
            if (writeMethod == null) {
                if ((readMethod == null || Modifier.isAbstract(readMethod.getModifiers())) && join == null && derived == null) {
                    errorMessages.add("Must define proper 'set' method for property: " + propertyName);
                }
            } else {
                Class<?>[] writeParams = writeMethod.getParameterTypes();
                if (writeParams == null || writeParams.length != 1) {
                    errorMessages.add("Mutator method must contain one parameter: " + writeMethod);
                } else if (!writeParams[0].isAssignableFrom(property.getType())) {
                    errorMessages.add("Property type doesn't match mutator method parameter: " + property.getType().getName() + " != " + writeParams[0].getName() + " for " + writeMethod);
                }
                if (writeMethod.getAnnotation(Nullable.class) != null) {
                    errorMessages.add("Nullable annotation not allowed on mutator: " + writeMethod);
                }
                if (writeMethod.getAnnotation(Alias.class) != null) {
                    errorMessages.add("Alias annotation not allowed on mutator: " + writeMethod);
                }
                if (writeMethod.getAnnotation(Version.class) != null) {
                    errorMessages.add("Version annotation not allowed on mutator: " + writeMethod);
                }
                if (writeMethod.getAnnotation(Sequence.class) != null) {
                    errorMessages.add("Sequence annotation not allowed on mutator: " + writeMethod);
                }
                if (writeMethod.getAnnotation(Automatic.class) != null) {
                    errorMessages.add("Automatic annotation not allowed on mutator: " + writeMethod);
                }
                if (writeMethod.getAnnotation(Independent.class) != null) {
                    errorMessages.add("Independent annotation not allowed on mutator: " + writeMethod);
                }
                if (writeMethod.getAnnotation(Join.class) != null) {
                    errorMessages.add("Join annotation not allowed on mutator: " + writeMethod);
                }
                if (writeMethod.getAnnotation(Derived.class) != null) {
                    errorMessages.add("Derived annotation not allowed on mutator: " + writeMethod);
                }
                if (writeMethod.getAnnotation(Name.class) != null) {
                    errorMessages.add("Name annotation not allowed on mutator: " + writeMethod);
                }
            }
            if (derived != null) {
                if (readMethod != null && Modifier.isAbstract(readMethod.getModifiers()) || writeMethod != null && Modifier.isAbstract(writeMethod.getModifiers())) {
                    errorMessages.add("Derived properties cannot be abstract: " + propertyName);
                }
                if (writeMethod == null && derived.shouldCopy()) {
                    errorMessages.add("Derived properties which should be copied must have a write method: " + propertyName);
                }
                if (pk) {
                    errorMessages.add("Derived properties cannot be a member of primary key: " + propertyName);
                }
                if (parKey) {
                    errorMessages.add("Derived properties cannot be a member of partition key: " + propertyName);
                }
                if (sequence != null) {
                    errorMessages.add("Derived properties cannot have a Sequence annotation: " + propertyName);
                }
                if (automatic != null) {
                    errorMessages.add("Derived properties cannot have an Automatic annotation: " + propertyName);
                }
                if (join != null) {
                    errorMessages.add("Derived properties cannot have a Join annotation: " + propertyName);
                }
            }
            if (nullable != null && property.getType().isPrimitive()) {
                errorMessages.add("Properties which have a primitive type cannot be declared nullable: Property \"" + propertyName + "\" has type \"" + property.getType() + '\"');
            }
            aliases = null;
            if (alias != null && (aliases = alias.value()).length == 0) {
                errorMessages.add("Alias list is empty for property: " + propertyName);
            }
            constraints = null;
            if (readMethod != null) {
                StorableIntrospector.gatherConstraints(property, readMethod, false, errorMessages);
            }
            if (writeMethod != null) {
                constraints = StorableIntrospector.gatherConstraints(property, writeMethod, true, errorMessages);
            }
            adapters = null;
            if (readMethod != null) {
                StorablePropertyAdapter autoAdapter;
                adapters = StorableIntrospector.gatherAdapters(property, readMethod, true, errorMessages);
                if (adapters != null && adapters.length > 0) {
                    if (join != null) {
                        errorMessages.add("Join properties cannot have adapters: " + propertyName);
                    }
                    if (adapters.length > 1) {
                        errorMessages.add("Only one adpater allowed per property: " + propertyName);
                    }
                }
                if ((adapters == null || adapters.length == 0) && (autoAdapter = AutomaticAdapterSelector.selectAdapterFor(property)) != null) {
                    adapters = new StorablePropertyAdapter[]{autoAdapter};
                }
            }
            if (writeMethod != null) {
                StorableIntrospector.gatherAdapters(property, writeMethod, false, errorMessages);
            }
            if (readMethod != null) {
                for (Class<?> ex : readMethod.getExceptionTypes()) {
                    if (RuntimeException.class.isAssignableFrom(ex) || Error.class.isAssignableFrom(ex)) continue;
                    if (join != null || derived != null) {
                        if (FetchException.class.isAssignableFrom(ex)) continue;
                        errorMessages.add("Checked exceptions thrown by join or derived property accessors must be of type FetchException: \"" + readMethod.getName() + "\" declares throwing \"" + ex.getName() + '\"');
                        break;
                    }
                    errorMessages.add("Only join and derived property accessors can throw checked exceptions: \"" + readMethod.getName() + "\" declares throwing \"" + ex.getName() + '\"');
                    break;
                }
            }
            if (writeMethod != null) {
                for (Class<?> ex : writeMethod.getExceptionTypes()) {
                    if (RuntimeException.class.isAssignableFrom(ex) || Error.class.isAssignableFrom(ex)) continue;
                    errorMessages.add("Mutators cannot throw checked exceptions: \"" + writeMethod.getName() + "\" declares throwing \"" + ex.getName() + '\"');
                    break;
                }
            }
            sequenceName = null;
            if (sequence != null) {
                sequenceName = sequence.value();
            }
            if (join == null) {
                if (errorMessages.size() > 0) {
                    return null;
                }
                return new SimpleProperty<S>(property, enclosing, nullable != null, pk, altKey, parKey, aliases, constraints, adapters == null ? null : adapters[0], version != null, sequenceName, independent != null, automatic != null, derived, propertyName);
            }
            internal = join.internal();
            external = join.external();
            if (internal == null) {
                internal = new String[]{};
            }
            if (external == null) {
                external = new String[]{};
            }
            if (internal.length != external.length) {
                errorMessages.add("Internal/external lists on Join property \"" + propertyName + "\" differ in length: " + internal.length + " != " + external.length);
            }
            if (Query.class == (joinedType = property.getType())) {
                if (nullable != null) {
                    errorMessages.add("Join property \"" + propertyName + "\" cannot be declared as nullable because the type is Query");
                }
                if (property.getWriteMethod() != null) {
                    errorMessages.add("Join property \"" + propertyName + "\" cannot have a mutator because the type is Query: " + property.getWriteMethod());
                }
                if (property.getReadMethod() == null) {
                    joinedType = Storable.class;
                } else {
                    Type genericType = property.getReadMethod().getGenericReturnType();
                    if (genericType instanceof Class) {
                        joinedType = Storable.class;
                    } else if (genericType instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)genericType;
                        Type[] args = pt.getActualTypeArguments();
                        if (args == null || args.length == 0) {
                            joinedType = Storable.class;
                        } else {
                            Object arg = args[0];
                            if (arg instanceof WildcardType) {
                                Type[] upper = ((WildcardType)arg).getUpperBounds();
                                arg = upper.length == 1 ? upper[0] : Storable.class;
                            }
                            while (arg instanceof ParameterizedType) {
                                arg = ((ParameterizedType)arg).getRawType();
                            }
                            if (arg instanceof Class) {
                                joinedType = (Class)arg;
                            }
                        }
                    }
                }
            }
            if (!Storable.class.isAssignableFrom(joinedType)) {
                errorMessages.add("Type of join property \"" + propertyName + "\" is not a Storable: " + joinedType);
            }
            if (property.getReadMethod() != null) {
                Class<FetchException> exceptionType = FetchException.class;
                Class<?>[] exceptions = property.getReadMethod().getExceptionTypes();
                int i = exceptions.length;
                while (--i >= 0) {
                    if (!exceptions[i].isAssignableFrom(exceptionType)) continue;
                    break block73;
                }
                String exceptionName = exceptionType.getName();
                int index = exceptionName.lastIndexOf(46);
                if (index >= 0) {
                    exceptionName = exceptionName.substring(index + 1);
                }
                errorMessages.add("Join property accessor must declare throwing a " + exceptionName + ": " + property.getReadMethod());
            }
        }
        if (version != null) {
            errorMessages.add("Join property cannot be declared as a version property: " + propertyName);
        }
        if (errorMessages.size() > 0) {
            return null;
        }
        return new JoinProperty<S>(property, enclosing, nullable != null, aliases, constraints, adapters == null ? null : adapters[0], sequenceName, independent != null, automatic != null, derived, joinedType, internal, external, propertyName);
    }

    private static StorablePropertyConstraint[] gatherConstraints(BeanProperty property, Method method, boolean isAllowed, List<String> errorMessages) {
        Annotation[] allAnnotations = method.getAnnotations();
        if (allAnnotations.length == 0) {
            return null;
        }
        ArrayList<StorablePropertyConstraint> list = new ArrayList<StorablePropertyConstraint>();
        for (Annotation annotation : allAnnotations) {
            Constructor<?> ctor;
            int modifiers;
            Class<? extends Annotation> type = annotation.annotationType();
            ConstraintDefinition cd = type.getAnnotation(ConstraintDefinition.class);
            if (cd == null) continue;
            if (!isAllowed) {
                errorMessages.add("Constraint not allowed on method: " + method);
                return null;
            }
            Class<?> constraintClass = cd.implementation();
            if (constraintClass == Void.TYPE) {
                Class<?>[] innerClasses;
                constraintClass = null;
                for (Class<?> c : innerClasses = type.getClasses()) {
                    if (!"Constraint".equals(c.getSimpleName())) continue;
                    constraintClass = c;
                    break;
                }
                if (constraintClass == null) {
                    errorMessages.add("By default, constraint implementation class must be a static inner class of the annotation named \"Constraint\". Fully qualified name: " + type.getCanonicalName() + ".Constraint");
                    continue;
                }
            }
            if (Modifier.isAbstract(modifiers = constraintClass.getModifiers()) || Modifier.isInterface(modifiers) || !Modifier.isPublic(modifiers)) {
                errorMessages.add("Constraint implementation class must be a concrete public class: " + constraintClass.getName());
                continue;
            }
            try {
                ctor = constraintClass.getConstructor(Class.class, String.class, type);
            }
            catch (NoSuchMethodException e) {
                errorMessages.add("Constraint implementation class does not have proper constructor: " + constraintClass.getName());
                continue;
            }
            ConversionComparator cc = new ConversionComparator(property.getType());
            Class<?> bestMatchingType = null;
            Method bestConstrainMethod = null;
            for (Method constrainMethod : constraintClass.getMethods()) {
                Class<?> candidateType;
                Class<?>[] paramTypes;
                if (!constrainMethod.getName().equals("constrain") || constrainMethod.getReturnType() != Void.TYPE || (paramTypes = constrainMethod.getParameterTypes()).length != 1 || !cc.isConversionPossible(candidateType = paramTypes[0]) || bestMatchingType != null && cc.compare(bestMatchingType, candidateType) <= 0) continue;
                bestMatchingType = candidateType;
                bestConstrainMethod = constrainMethod;
            }
            if (bestConstrainMethod == null) {
                errorMessages.add("Constraint does not support property type: " + TypeDesc.forClass((Class)property.getType()).getFullName() + "; constraint type: " + annotation.annotationType().getName());
                continue;
            }
            StorablePropertyAnnotation spa = new StorablePropertyAnnotation(annotation, method);
            list.add(new StorablePropertyConstraint(spa, ctor, bestConstrainMethod));
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new StorablePropertyConstraint[list.size()]);
    }

    private static StorablePropertyAdapter[] gatherAdapters(BeanProperty property, Method method, boolean isAllowed, List<String> errorMessages) {
        Annotation[] allAnnotations = method.getAnnotations();
        if (allAnnotations.length == 0) {
            return null;
        }
        ArrayList<StorablePropertyAdapter> list = new ArrayList<StorablePropertyAdapter>();
        for (Annotation annotation : allAnnotations) {
            Constructor ctor;
            Class<? extends Annotation> type = annotation.annotationType();
            AdapterDefinition ad = type.getAnnotation(AdapterDefinition.class);
            if (ad == null) continue;
            if (!isAllowed) {
                errorMessages.add("Adapter not allowed on method: " + method);
                return null;
            }
            Class adapterClass = StorablePropertyAdapter.findAdapterClass(type);
            if (adapterClass == null) {
                errorMessages.add("By default, adapter implementation class must be a static inner class of the annotation named \"Adapter\". Fully qualified name: " + type.getCanonicalName() + ".Adapter");
                continue;
            }
            int modifiers = adapterClass.getModifiers();
            if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || !Modifier.isPublic(modifiers)) {
                errorMessages.add("Adapter implementation class must be a concrete public class: " + adapterClass.getName());
                continue;
            }
            try {
                ctor = adapterClass.getConstructor(Class.class, String.class, type);
            }
            catch (NoSuchMethodException e) {
                errorMessages.add("Adapter implementation class does not have proper constructor: " + adapterClass.getName());
                continue;
            }
            Method[] adaptMethods = StorablePropertyAdapter.findAdaptMethods(property.getType(), adapterClass);
            if (adaptMethods.length == 0) {
                errorMessages.add("Adapter does not support property type: " + TypeDesc.forClass((Class)property.getType()).getFullName() + "; adapter type: " + annotation.annotationType().getName());
                continue;
            }
            StorablePropertyAnnotation spa = new StorablePropertyAnnotation(annotation, method);
            list.add(new StorablePropertyAdapter(property, spa, ad, ctor, adaptMethods));
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new StorablePropertyAdapter[list.size()]);
    }

    private static Map<String, Method> gatherAllDeclaredMethods(Class clazz) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        StorableIntrospector.gatherAllDeclaredMethods(methods, clazz);
        return methods;
    }

    private static void gatherAllDeclaredMethods(Map<String, Method> methods, Class clazz) {
        for (Method m : clazz.getDeclaredMethods()) {
            String desc = StorableIntrospector.createSig(m);
            if (methods.containsKey(desc)) continue;
            methods.put(desc, m);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            StorableIntrospector.gatherAllDeclaredMethods(methods, superclass);
        }
        for (Class<?> c : clazz.getInterfaces()) {
            StorableIntrospector.gatherAllDeclaredMethods(methods, c);
        }
    }

    private static String createSig(Method m) {
        return m.getName() + ':' + MethodDesc.forMethod((Method)m).getDescriptor();
    }

    static {
        Method method;
        cCache = new WeakIdentityMap();
        EMPTY_CLASSES_ARRAY = new Class[0];
        try {
            method = BeanProperty.class.getMethod("getCovariantTypes", null);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        cCovariantTypesMethod = method;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JoinProperty<S extends Storable>
    extends SimpleProperty<S> {
        private static final long serialVersionUID = 5617446241872193369L;
        private final Class<? extends Storable> mJoinedType;
        private String[] mInternalNames;
        private String[] mExternalNames;
        private StorableProperty<S>[] mInternal;
        private StorableProperty<?>[] mExternal;
        private boolean mOneToOne;

        JoinProperty(BeanProperty property, Class<S> enclosing, boolean nullable, String[] aliases, StorablePropertyConstraint[] constraints, StorablePropertyAdapter adapter, String sequence, boolean independent, boolean automatic, Derived derived, Class<? extends Storable> joinedType, String[] internal, String[] external, String name) {
            super(property, enclosing, nullable, false, false, false, aliases, constraints, adapter, false, sequence, independent, automatic, derived, name);
            this.mJoinedType = joinedType;
            int length = internal.length;
            if (length != external.length) {
                throw new IllegalArgumentException();
            }
            this.mInternalNames = internal;
            this.mExternalNames = external;
        }

        @Override
        public boolean isJoin() {
            return true;
        }

        @Override
        public boolean isOneToOneJoin() {
            return this.mOneToOne;
        }

        @Override
        public Class<? extends Storable> getJoinedType() {
            return this.mJoinedType;
        }

        @Override
        public int getJoinElementCount() {
            return this.mInternal.length;
        }

        @Override
        public StorableProperty<S> getInternalJoinElement(int index) {
            return this.mInternal[index];
        }

        @Override
        public StorableProperty<S>[] getInternalJoinElements() {
            return (StorableProperty[])this.mInternal.clone();
        }

        @Override
        public StorableProperty<?> getExternalJoinElement(int index) {
            return this.mExternal[index];
        }

        @Override
        public StorableProperty<?>[] getExternalJoinElements() {
            return (StorableProperty[])this.mExternal.clone();
        }

        @Override
        public boolean isQuery() {
            return this.getType() == Query.class;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        void resolveJoin(List<String> errorMessages) {
            try {
                joinedInfo = StorableIntrospector.examine(this.getJoinedType());
                if (this.mInternalNames.length == 0) {
                    primaryKeys /* !! */  = this.isQuery() != false ? StorableIntrospector.examine(this.getEnclosingType()).getPrimaryKeyProperties() : joinedInfo.getPrimaryKeyProperties();
                    this.mInternalNames = new String[primaryKeys /* !! */ .size()];
                    this.mExternalNames = new String[primaryKeys /* !! */ .size()];
                    i = 0;
                    i$ = primaryKeys /* !! */ .keySet().iterator();
                    while (i$.hasNext()) {
                        this.mInternalNames[i] = name = i$.next();
                        this.mExternalNames[i] = name;
                        ++i;
                    }
                }
            }
            catch (MalformedTypeException e) {
                this.mInternal = new StorableProperty[0];
                this.mExternal = new StorableProperty[0];
                throw e;
            }
            this.mInternal = new StorableProperty[this.mInternalNames.length];
            this.mExternal = new StorableProperty[this.mExternalNames.length];
            for (i = 0; i < this.mInternalNames.length; ++i) {
                internalName = this.mInternalNames[i];
                property = this.mEnclosingInfo.getAllProperties().get(internalName);
                if (property == null) {
                    errorMessages.add("Cannot find internal join element: \"" + this.getName() + "\" internally joins to property \"" + internalName + '\"');
                    continue;
                }
                if (property.isJoin()) {
                    errorMessages.add("Join properties cannot join to other join properties: \"" + this.getName() + "\" internally joins to property \"" + internalName + '\"');
                    continue;
                }
                if (Lob.class.isAssignableFrom(property.getType())) {
                    errorMessages.add("Join properties cannot join to LOB properties: \"" + this.getName() + "\" internally joins to LOB property \"" + internalName + '\"');
                    continue;
                }
                this.mInternal[i] = property;
            }
            externalProperties = joinedInfo.getAllProperties();
            mutatorAllowed = this.isQuery() == false;
            for (i = 0; i < this.mExternalNames.length; ++i) {
                externalName = this.mExternalNames[i];
                property = externalProperties.get(externalName);
                if (property == null) {
                    errorMessages.add("Cannot find external join element: \"" + this.getName() + "\" externally joins to property \"" + externalName + '\"');
                    continue;
                }
                if (property.isJoin()) {
                    errorMessages.add("Join properties cannot join to other join properties: \"" + this.getName() + "\" externally joins to property \"" + externalName + '\"');
                    continue;
                }
                if (Lob.class.isAssignableFrom(property.getType())) {
                    errorMessages.add("Join properties cannot join to LOB properties: \"" + this.getName() + "\" externally joins to LOB property \"" + externalName + '\"');
                    continue;
                }
                if (property.getReadMethod() == null) {
                    mutatorAllowed = false;
                    if (this.getWriteMethod() != null) {
                        errorMessages.add("Join property cannot have a mutator if external property has no accessor: Mutator = \"" + this.getWriteMethod() + "\", external property = \"" + property.getName() + '\"');
                        continue;
                    }
                }
                this.mExternal[i] = property;
            }
            if (errorMessages.size() > 0) {
                return;
            }
            block17: for (i = 0; i < this.mInternal.length; ++i) {
                block59: {
                    internalProperty = this.getInternalJoinElement(i);
                    externalProperty = this.getExternalJoinElement(i);
                    if (!internalProperty.isNullable() && externalProperty.isNullable()) {
                        mutatorAllowed = false;
                        if (this.getWriteMethod() != null) {
                            errorMessages.add("Join property cannot have a mutator if internal property is required, but external property is nullable: Mutator = \"" + this.getWriteMethod() + "\", internal property = \"" + internalProperty.getName() + "\", external property = \"" + externalProperty.getName() + '\"');
                        }
                    }
                    if ((internalClass = internalProperty.getType()) == (externalClass = externalProperty.getType()) || (internalType = TypeDesc.forClass(internalClass).toObjectType()) == (externalType = TypeDesc.forClass(externalClass).toObjectType())) continue;
                    if (externalClass == String.class || externalClass == Object.class || externalClass == CharSequence.class) break block59;
                    primInternal = internalType.toPrimitiveType();
                    primExternal = externalType.toPrimitiveType();
                    if (primInternal == null) ** GOTO lbl-1000
                    block1 : switch (primInternal.getTypeCode()) {
                        case 8: {
                            if (primExternal == null) {
                                if (externalType.toClass() == Number.class) {
                                    break;
                                }
                            } else {
                                switch (primExternal.getTypeCode()) {
                                    case 9: 
                                    case 10: 
                                    case 11: {
                                        break block1;
                                    }
                                }
                            }
                            ** GOTO lbl103
                        }
                        case 9: {
                            if (primExternal == null) {
                                if (externalType.toClass() == Number.class) {
                                    break;
                                }
                            } else {
                                switch (primExternal.getTypeCode()) {
                                    case 10: 
                                    case 11: {
                                        break block1;
                                    }
                                }
                            }
                            ** GOTO lbl103
                        }
                        case 10: {
                            if (primExternal == null ? externalType.toClass() == Number.class : primExternal == TypeDesc.LONG) {
                                break;
                            }
                            ** GOTO lbl103
                        }
                        case 6: {
                            if (primExternal == null ? externalType.toClass() == Number.class : primExternal == TypeDesc.DOUBLE) break;
                        }
lbl103:
                        // 7 sources

                        default: lbl-1000:
                        // 2 sources

                        {
                            errorMessages.add("Join property internal/external type mismatch for \"" + this.getName() + "\": internal join \"" + this.getInternalJoinElement(i).getName() + "\" is of type \"" + this.getInternalJoinElement(i).getType() + "\" and external join \"" + this.getExternalJoinElement(i).getName() + "\" is of type \"" + this.getExternalJoinElement(i).getType() + '\"');
                            continue block17;
                        }
                    }
                }
                if (this.getWriteMethod() == null) continue;
                mutatorAllowed = false;
                errorMessages.add("Join property cannot have a mutator if external type cannot be reliably converted to internal type: Mutator = \"" + this.getWriteMethod() + "\", internal join \"" + this.getInternalJoinElement(i).getName() + "\" is of type \"" + this.getInternalJoinElement(i).getType() + "\" and external join \"" + this.getExternalJoinElement(i).getName() + "\" is of type \"" + this.getExternalJoinElement(i).getType() + '\"');
            }
            if (errorMessages.size() > 0) {
                return;
            }
            primaryKey = new HashSet<StorableProperty<Storable>>(joinedInfo.getPrimaryKeyProperties().values());
            if (primaryKey.size() == 0) {
                primaryKey = null;
            } else {
                for (i = 0; i < this.mInternal.length; ++i) {
                    primaryKey.remove(this.getExternalJoinElement(i));
                }
            }
            altKeyCount = joinedInfo.getAlternateKeyCount();
            altKeys = new ArrayList<Set<StorableProperty<Storable>>>(altKeyCount);
            block19: for (i = 0; i < altKeyCount; ++i) {
                altKey = new HashSet<E>();
                for (OrderedProperty<Storable> op : joinedInfo.getAlternateKey(i).getProperties()) {
                    chained = op.getChainedProperty();
                    if (chained.getChainCount() > 0) continue block19;
                    altKey.add(chained.getPrimeProperty());
                }
                if (altKey.size() <= 0) continue;
                altKeys.add(altKey);
                for (j = 0; j < this.mInternal.length; ++j) {
                    altKey.remove(this.getExternalJoinElement(j));
                }
            }
            if (this.isQuery()) {
                if (primaryKey != null && primaryKey.size() <= 0) {
                    errorMessages.add("Join property \"" + this.getName() + "\" completely specifies primary key of joined object; " + "consider declaring the property type as just " + this.getJoinedType().getName());
                }
                for (Set<StorableProperty<Storable>> altKey : altKeys) {
                    if (altKey.size() > 0) continue;
                    errorMessages.add("Join property \"" + this.getName() + "\" completely specifies an alternate key of joined object; " + "consider declaring the property type as just " + this.getJoinedType().getName());
                    break;
                }
            } else {
                block58: {
                    block57: {
                        if (primaryKey != null && primaryKey.size() > 0) {
                            for (Set<StorableProperty<Storable>> altKey : altKeys) {
                                if (altKey.size() > 0) continue;
                                break block57;
                            }
                            errorMessages.add("Join property \"" + this.getName() + "\" doesn't completely specify any key of joined object; consider " + "declaring the property type as Query<" + this.getJoinedType().getName() + '>');
                        }
                    }
                    oneToOne = false;
                    internalPrimaryKey = new HashSet<StorableProperty<S>>(this.mEnclosingInfo.getPrimaryKeyProperties().values());
                    for (i = 0; i < this.mInternal.length; ++i) {
                        internalPrimaryKey.remove(this.getInternalJoinElement(i));
                        if (internalPrimaryKey.size() != 0) continue;
                        oneToOne = true;
                        break block58;
                    }
                    block25: for (i = 0; i < this.mEnclosingInfo.getAlternateKeyCount(); ++i) {
                        altKey = new HashSet<StorableProperty<S>>();
                        for (OrderedProperty<S> op : this.mEnclosingInfo.getAlternateKey(i).getProperties()) {
                            chained = op.getChainedProperty();
                            if (chained.getChainCount() > 0) continue block25;
                            altKey.add(chained.getPrimeProperty());
                        }
                        for (j = 0; j < this.mInternal.length; ++j) {
                            altKey.remove(this.getInternalJoinElement(j));
                            if (altKey.size() != 0) continue;
                            oneToOne = true;
                            break block25;
                        }
                    }
                }
                this.mOneToOne = oneToOne;
            }
            if (mutatorAllowed && this.getWriteMethod() == null) {
                errorMessages.add("Must define proper 'set' method for join property: " + this.getName());
            }
            if (errorMessages.size() == 0) {
                this.mInternalNames = null;
                this.mExternalNames = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleProperty<S extends Storable>
    implements StorableProperty<S> {
        private static final long serialVersionUID = 6599542401516624863L;
        private static final ChainedProperty[] EMPTY_CHAIN_ARRAY = new ChainedProperty[0];
        private final BeanProperty mBeanProperty;
        private final Class<S> mEnclosingType;
        private final boolean mNullable;
        private final boolean mPrimaryKey;
        private final boolean mAlternateKey;
        private final boolean mPartitionKey;
        private final String[] mAliases;
        private final StorablePropertyConstraint[] mConstraints;
        private final StorablePropertyAdapter mAdapter;
        private final boolean mIsVersion;
        private final String mSequence;
        private final boolean mIndependent;
        private final boolean mAutomatic;
        private final boolean mIsDerived;
        private final boolean mShouldCopyDerived;
        private final String mName;
        private final String mBeanName;
        private Derived mDerived;
        private ChainedProperty<S>[] mDerivedFrom;
        private ChainedProperty<S>[] mDerivedTo;
        private int mNumber = -1;
        protected StorableInfo<S> mEnclosingInfo;

        SimpleProperty(BeanProperty property, Class<S> enclosing, boolean nullable, boolean primaryKey, boolean alternateKey, boolean partitionKey, String[] aliases, StorablePropertyConstraint[] constraints, StorablePropertyAdapter adapter, boolean isVersion, String sequence, boolean independent, boolean automatic, Derived derived, String name) {
            this.mBeanProperty = property;
            this.mEnclosingType = enclosing;
            this.mNullable = property.getType().isPrimitive() ? false : nullable;
            this.mPrimaryKey = primaryKey;
            this.mAlternateKey = alternateKey;
            this.mPartitionKey = partitionKey;
            this.mAliases = aliases;
            this.mConstraints = constraints;
            this.mAdapter = adapter;
            this.mIsVersion = isVersion;
            this.mSequence = sequence;
            this.mIndependent = independent;
            this.mAutomatic = automatic;
            this.mIsDerived = derived != null;
            this.mShouldCopyDerived = this.mIsDerived ? derived.shouldCopy() : false;
            this.mDerived = derived;
            this.mBeanName = this.mBeanProperty.getName();
            this.mName = name == null ? this.mBeanName : name;
        }

        @Override
        public final String getName() {
            return this.mName;
        }

        @Override
        public final String getBeanName() {
            return this.mBeanName;
        }

        @Override
        public final Class<?> getType() {
            return this.mBeanProperty.getType();
        }

        @Override
        public Class<?>[] getCovariantTypes() {
            return StorableIntrospector.getCovariantTypes(this.mBeanProperty);
        }

        @Override
        public final int getNumber() {
            return this.mNumber;
        }

        @Override
        public final Class<S> getEnclosingType() {
            return this.mEnclosingType;
        }

        @Override
        public final Method getReadMethod() {
            return this.mBeanProperty.getReadMethod();
        }

        @Override
        public final String getReadMethodName() {
            Method m = this.mBeanProperty.getReadMethod();
            if (m != null) {
                return m.getName();
            }
            return "get" + this.getWriteMethod().getName().substring(3);
        }

        @Override
        public final Method getWriteMethod() {
            return this.mBeanProperty.getWriteMethod();
        }

        @Override
        public final String getWriteMethodName() {
            Method m = this.mBeanProperty.getWriteMethod();
            if (m != null) {
                return m.getName();
            }
            String readName = this.getReadMethod().getName();
            return "set" + readName.substring(readName.startsWith("is") ? 2 : 3);
        }

        @Override
        public final boolean isNullable() {
            return this.mNullable;
        }

        @Override
        public final boolean isPrimaryKeyMember() {
            return this.mPrimaryKey;
        }

        @Override
        public final boolean isAlternateKeyMember() {
            return this.mAlternateKey;
        }

        @Override
        public final boolean isPartitionKeyMember() {
            return this.mPartitionKey;
        }

        @Override
        public final int getAliasCount() {
            String[] aliases = this.mAliases;
            return aliases == null ? 0 : aliases.length;
        }

        @Override
        public final String getAlias(int index) {
            String[] aliases = this.mAliases;
            if (aliases == null) {
                throw new IndexOutOfBoundsException();
            }
            return aliases[index];
        }

        @Override
        public final String[] getAliases() {
            String[] aliases = this.mAliases;
            if (aliases == null) {
                return new String[0];
            }
            return (String[])aliases.clone();
        }

        @Override
        public final String getSequenceName() {
            return this.mSequence;
        }

        @Override
        public final boolean isAutomatic() {
            return this.mAutomatic;
        }

        @Override
        public final boolean isIndependent() {
            return this.mIndependent;
        }

        @Override
        public final boolean isVersion() {
            return this.mIsVersion;
        }

        @Override
        public final boolean isDerived() {
            return this.mIsDerived;
        }

        @Override
        public final ChainedProperty<S>[] getDerivedFromProperties() {
            return !this.mIsDerived || this.mDerivedFrom == null ? EMPTY_CHAIN_ARRAY : (ChainedProperty[])this.mDerivedFrom.clone();
        }

        @Override
        public final ChainedProperty<?>[] getDerivedToProperties() {
            if (this.mDerivedTo == null) {
                LinkedHashSet derivedToSet = new LinkedHashSet();
                HashSet examinedSet = new HashSet();
                this.addToDerivedToSet(derivedToSet, examinedSet, StorableIntrospector.examine(this.getEnclosingType()));
                this.mDerivedTo = derivedToSet.size() > 0 ? derivedToSet.toArray(new ChainedProperty[derivedToSet.size()]) : EMPTY_CHAIN_ARRAY;
            }
            return (ChainedProperty[])this.mDerivedTo.clone();
        }

        @Override
        public final boolean shouldCopyDerived() {
            return this.mShouldCopyDerived;
        }

        @Override
        public boolean isJoin() {
            return false;
        }

        @Override
        public boolean isOneToOneJoin() {
            return false;
        }

        @Override
        public Class<? extends Storable> getJoinedType() {
            return null;
        }

        @Override
        public int getJoinElementCount() {
            return 0;
        }

        @Override
        public StorableProperty<S> getInternalJoinElement(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public StorableProperty<S>[] getInternalJoinElements() {
            return new StorableProperty[0];
        }

        @Override
        public StorableProperty<?> getExternalJoinElement(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public StorableProperty<?>[] getExternalJoinElements() {
            return new StorableProperty[0];
        }

        @Override
        public boolean isQuery() {
            return false;
        }

        @Override
        public int getConstraintCount() {
            StorablePropertyConstraint[] constraints = this.mConstraints;
            return constraints == null ? 0 : constraints.length;
        }

        @Override
        public StorablePropertyConstraint getConstraint(int index) {
            StorablePropertyConstraint[] constraints = this.mConstraints;
            if (constraints == null) {
                throw new IndexOutOfBoundsException();
            }
            return constraints[index];
        }

        @Override
        public StorablePropertyConstraint[] getConstraints() {
            StorablePropertyConstraint[] constraints = this.mConstraints;
            if (constraints == null) {
                return new StorablePropertyConstraint[0];
            }
            return (StorablePropertyConstraint[])constraints.clone();
        }

        @Override
        public StorablePropertyAdapter getAdapter() {
            return this.mAdapter;
        }

        public int hashCode() {
            return (this.getName().hashCode() * 31 + this.getType().getName().hashCode()) * 31 + this.getEnclosingType().getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof StorableProperty) {
                StorableProperty other = (StorableProperty)obj;
                return this.getName().equals(other.getName()) && this.getType().equals(other.getType()) && this.getEnclosingType().equals(other.getEnclosingType());
            }
            return false;
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder();
            try {
                this.appendTo(b);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return b.toString();
        }

        @Override
        public void appendTo(Appendable app) throws IOException {
            app.append("StorableProperty {name=");
            app.append(this.getName());
            app.append(", type=");
            app.append(TypeDesc.forClass(this.getType()).getFullName());
            app.append(", enclosing=");
            app.append(this.getEnclosingType().getName());
            app.append('}');
        }

        void setNumber(int number) {
            this.mNumber = number;
        }

        void setEnclosingInfo(StorableInfo<S> info) {
            this.mEnclosingInfo = info;
        }

        void resolveDerivedFrom(List<String> errorMessages) {
            Derived derived = this.mDerived;
            this.mDerived = null;
            if (!this.mIsDerived || derived == null) {
                return;
            }
            String[] fromNames = derived.from();
            if (fromNames == null || fromNames.length == 0) {
                return;
            }
            LinkedHashSet<ChainedProperty<S>> derivedFromSet = new LinkedHashSet<ChainedProperty<S>>();
            for (String fromName : fromNames) {
                ChainedProperty<S> from;
                try {
                    from = ChainedProperty.parse(this.mEnclosingInfo, fromName);
                }
                catch (IllegalArgumentException e) {
                    errorMessages.add("Cannot find derived-from property: \"" + this.getName() + "\" reports being derived from \"" + fromName + '\"');
                    continue;
                }
                this.addToDerivedFromSet(errorMessages, derivedFromSet, from);
            }
            if (derivedFromSet.size() > 0) {
                if (derivedFromSet.contains(ChainedProperty.get(this))) {
                    errorMessages.add("Derived-from dependency cycle detected: \"" + this.getName() + '\"');
                }
                this.mDerivedFrom = derivedFromSet.toArray(new ChainedProperty[derivedFromSet.size()]);
            } else {
                this.mDerivedFrom = null;
            }
        }

        private boolean addToDerivedFromSet(List<String> errorMessages, Set<ChainedProperty<S>> derivedFromSet, ChainedProperty<S> from) {
            block19: {
                StorableProperty<?> lastInChain;
                ChainedProperty<S> trimmed;
                if (derivedFromSet.contains(from)) {
                    return false;
                }
                derivedFromSet.add(from);
                ChainedProperty<S> chainedProperty = trimmed = from.getChainCount() == 0 ? null : from.trim();
                if (trimmed != null) {
                    this.addToDerivedFromSet(errorMessages, derivedFromSet, trimmed);
                }
                if ((lastInChain = from.getLastProperty()).isDerived()) {
                    ((SimpleProperty)lastInChain).resolveDerivedFrom(errorMessages);
                    for (ChainedProperty<?> lastFrom : lastInChain.getDerivedFromProperties()) {
                        ChainedProperty<Object> dep = trimmed == null ? lastFrom : trimmed.append(lastFrom);
                        this.addToDerivedFromSet(errorMessages, derivedFromSet, dep);
                    }
                }
                if (lastInChain.isJoin() && errorMessages.size() == 0) {
                    int i;
                    Class<Storable> joined = lastInChain.getJoinedType();
                    for (StorableProperty<Storable> prop : StorableIntrospector.examine(joined).getAllProperties().values()) {
                        if (!prop.isJoin() || prop.getJoinedType() != lastInChain.getEnclosingType()) continue;
                        break block19;
                    }
                    StringBuilder suggest = new StringBuilder();
                    suggest.append("@Join");
                    int count = lastInChain.getJoinElementCount();
                    boolean naturalJoin = true;
                    for (i = 0; i < count; ++i) {
                        if (lastInChain.getInternalJoinElement(i).getName().equals(lastInChain.getExternalJoinElement(i).getName())) continue;
                        naturalJoin = false;
                        break;
                    }
                    if (!naturalJoin) {
                        suggest.append("(internal=");
                        if (count > 1) {
                            suggest.append('{');
                        }
                        for (i = 0; i < count; ++i) {
                            if (i > 0) {
                                suggest.append(", ");
                            }
                            suggest.append('\"');
                            suggest.append(lastInChain.getExternalJoinElement(i).getName());
                            suggest.append('\"');
                        }
                        if (count > 1) {
                            suggest.append('}');
                        }
                        suggest.append(", external=");
                        if (count > 1) {
                            suggest.append('{');
                        }
                        for (i = 0; i < count; ++i) {
                            if (i > 0) {
                                suggest.append(", ");
                            }
                            suggest.append('\"');
                            suggest.append(lastInChain.getInternalJoinElement(i).getName());
                            suggest.append('\"');
                        }
                        if (count > 1) {
                            suggest.append('}');
                        }
                        suggest.append(")");
                    }
                    suggest.append(' ');
                    if (!joined.isInterface()) {
                        suggest.append("public abstract ");
                    }
                    if (lastInChain.isOneToOneJoin() || lastInChain.isQuery()) {
                        suggest.append(lastInChain.getEnclosingType().getName());
                    } else {
                        suggest.append("Query<");
                        suggest.append(lastInChain.getEnclosingType().getName());
                        suggest.append('>');
                    }
                    suggest.append(" getXxx() throws FetchException");
                    errorMessages.add("Derived-from property is a join, but it is not doubly joined: \"" + this.getName() + "\" is derived from \"" + from + "\". Consider defining a join property in " + joined + " as: " + suggest);
                }
            }
            return true;
        }

        private boolean addToDerivedToSet(Set<ChainedProperty<?>> derivedToSet, Set<Class<?>> examinedSet, StorableInfo<?> info) {
            if (examinedSet.contains(info.getStorableType())) {
                return false;
            }
            examinedSet.add(info.getStorableType());
            int originalSize = derivedToSet.size();
            for (StorableProperty<?> property : info.getAllProperties().values()) {
                if (property.isDerived()) {
                    for (ChainedProperty<?> from : property.getDerivedFromProperties()) {
                        if (!from.getLastProperty().equals(this)) continue;
                        ChainedProperty<?> path = ChainedProperty.get(property);
                        if (from.getChainCount() > 0) {
                            path = path.append(from.trim());
                        }
                        derivedToSet.add(path);
                    }
                }
                if (!property.isJoin()) continue;
                this.addToDerivedToSet(derivedToSet, examinedSet, StorableIntrospector.examine(property.getJoinedType()));
            }
            return derivedToSet.size() > originalSize;
        }

        Object writeReplace() {
            return new NaET(this.mName, this.mEnclosingType);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class NaET
        implements Externalizable {
            private static final long serialVersionUID = 1L;
            private String mName;
            private Class<? extends Storable> mEnclosingType;

            public NaET() {
            }

            NaET(String name, Class<? extends Storable> enclosingType) {
                this.mName = name;
                this.mEnclosingType = enclosingType;
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeObject(this.mName);
                out.writeObject(this.mEnclosingType);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.mName = (String)in.readObject();
                this.mEnclosingType = (Class)in.readObject();
            }

            private Object readResolve() {
                return StorableIntrospector.examine(this.mEnclosingType).getAllProperties().get(this.mName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SKey<S extends Storable>
    implements StorableKey<S> {
        private final boolean mPrimary;
        private final Set<OrderedProperty<S>> mProperties;

        SKey(boolean primary, Set<OrderedProperty<S>> properties) {
            this.mPrimary = primary;
            this.mProperties = properties;
        }

        @Override
        public boolean isPrimary() {
            return this.mPrimary;
        }

        @Override
        public Set<OrderedProperty<S>> getProperties() {
            return this.mProperties;
        }

        public int hashCode() {
            return ((Object)this.mProperties).hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof StorableKey) {
                StorableKey other = (StorableKey)obj;
                return this.isPrimary() == other.isPrimary() && ((Object)this.getProperties()).equals(other.getProperties());
            }
            return false;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("StorableKey ");
            try {
                this.appendTo(b);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return b.toString();
        }

        @Override
        public void appendTo(Appendable app) throws IOException {
            app.append("{properties=[");
            int i = 0;
            for (OrderedProperty<S> prop : this.mProperties) {
                if (i++ > 0) {
                    app.append(", ");
                }
                prop.appendTo(app);
            }
            app.append(']');
            app.append(", primary=");
            app.append(String.valueOf(this.isPrimary()));
            app.append('}');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Info<S extends Storable>
    implements StorableInfo<S> {
        private final Class<S> mType;
        private final String[] mAliases;
        private final StorableIndex<S>[] mIndexes;
        private final Map<String, StorableProperty<S>> mAllProperties;
        private final StorableKey<S> mPrimaryKey;
        private final StorableKey<S>[] mAltKeys;
        private final StorableKey<S> mPartitionKey;
        private final boolean mIndependent;
        private final boolean mAuthoritative;
        private transient String mName;
        private transient Map<String, StorableProperty<S>> mPrimaryKeyProperties;
        private transient Map<String, StorableProperty<S>> mDataProperties;
        private transient StorableProperty<S> mVersionProperty;

        Info(Class<S> type, String[] aliases, StorableIndex<S>[] indexes, Map<String, StorableProperty<S>> properties, StorableKey<S> primaryKey, StorableKey<S>[] altKeys, StorableKey<S> partitionKey, boolean independent, boolean authoritative) {
            this.mType = type;
            this.mAliases = aliases;
            this.mIndexes = indexes;
            this.mAllProperties = properties;
            this.mPrimaryKey = primaryKey;
            this.mAltKeys = altKeys;
            this.mPartitionKey = partitionKey;
            this.mIndependent = independent;
            this.mAuthoritative = authoritative;
        }

        @Override
        public String getName() {
            String name = this.mName;
            if (name == null) {
                name = this.getStorableType().getName();
                int index = name.lastIndexOf(46);
                if (index >= 0) {
                    name = name.substring(index + 1);
                }
                this.mName = name;
            }
            return name;
        }

        @Override
        public Class<S> getStorableType() {
            return this.mType;
        }

        @Override
        public Map<String, StorableProperty<S>> getAllProperties() {
            return this.mAllProperties;
        }

        @Override
        public Map<String, StorableProperty<S>> getPrimaryKeyProperties() {
            if (this.mPrimaryKeyProperties == null) {
                Set<OrderedProperty<S>> pkSet = this.mPrimaryKey.getProperties();
                LinkedHashMap<String, StorableProperty<S>> pkProps = new LinkedHashMap<String, StorableProperty<S>>(pkSet.size());
                for (OrderedProperty<S> prop : pkSet) {
                    StorableProperty<S> prime = prop.getChainedProperty().getPrimeProperty();
                    pkProps.put(prime.getName(), prime);
                }
                this.mPrimaryKeyProperties = Collections.unmodifiableMap(pkProps);
            }
            return this.mPrimaryKeyProperties;
        }

        @Override
        public Map<String, StorableProperty<S>> getDataProperties() {
            if (this.mDataProperties == null) {
                LinkedHashMap<String, StorableProperty<S>> dataProps = new LinkedHashMap<String, StorableProperty<S>>(this.mAllProperties.size());
                for (Map.Entry<String, StorableProperty<S>> entry : this.mAllProperties.entrySet()) {
                    StorableProperty<S> property = entry.getValue();
                    if (property.isPrimaryKeyMember() || property.isJoin()) continue;
                    dataProps.put(entry.getKey(), property);
                }
                this.mDataProperties = Collections.unmodifiableMap(dataProps);
            }
            return this.mDataProperties;
        }

        @Override
        public StorableProperty<S> getVersionProperty() {
            if (this.mVersionProperty == null) {
                for (StorableProperty<S> property : this.mAllProperties.values()) {
                    if (!property.isVersion()) continue;
                    this.mVersionProperty = property;
                    break;
                }
            }
            return this.mVersionProperty;
        }

        @Override
        public StorableKey<S> getPrimaryKey() {
            return this.mPrimaryKey;
        }

        @Override
        public int getAlternateKeyCount() {
            StorableKey<S>[] keys = this.mAltKeys;
            return keys == null ? 0 : keys.length;
        }

        @Override
        public StorableKey<S> getAlternateKey(int index) {
            StorableKey<S>[] keys = this.mAltKeys;
            if (keys == null) {
                throw new IndexOutOfBoundsException();
            }
            return keys[index];
        }

        @Override
        public StorableKey<S>[] getAlternateKeys() {
            StorableKey<S>[] keys = this.mAltKeys;
            if (keys == null) {
                return new StorableKey[0];
            }
            return (StorableKey[])keys.clone();
        }

        @Override
        public int getAliasCount() {
            String[] aliases = this.mAliases;
            return aliases == null ? 0 : aliases.length;
        }

        @Override
        public String getAlias(int index) {
            String[] aliases = this.mAliases;
            if (aliases == null) {
                throw new IndexOutOfBoundsException();
            }
            return aliases[index];
        }

        @Override
        public String[] getAliases() {
            String[] aliases = this.mAliases;
            if (aliases == null) {
                return new String[0];
            }
            return (String[])aliases.clone();
        }

        @Override
        public int getIndexCount() {
            StorableIndex<S>[] indexes = this.mIndexes;
            return indexes == null ? 0 : indexes.length;
        }

        @Override
        public StorableIndex<S> getIndex(int index) {
            StorableIndex<S>[] indexes = this.mIndexes;
            if (indexes == null) {
                throw new IndexOutOfBoundsException();
            }
            return indexes[index];
        }

        @Override
        public StorableIndex<S>[] getIndexes() {
            StorableIndex<S>[] indexes = this.mIndexes;
            if (indexes == null) {
                return new StorableIndex[0];
            }
            return (StorableIndex[])indexes.clone();
        }

        @Override
        public StorableKey<S> getPartitionKey() {
            return this.mPartitionKey;
        }

        @Override
        public final boolean isIndependent() {
            return this.mIndependent;
        }

        @Override
        public final boolean isAuthoritative() {
            return this.mAuthoritative;
        }
    }

    private static class NameAndDirection {
        final String name;
        final Direction direction;

        NameAndDirection(String name, Direction direction) {
            this.name = name;
            this.direction = direction;
        }

        public int hashCode() {
            return this.name.hashCode() + this.direction.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NameAndDirection) {
                return this.name.equals(((NameAndDirection)obj).name);
            }
            return false;
        }
    }
}

