/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.info;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.util.Appender;
import java.io.IOException;
import java.io.Serializable;
import org.cojen.util.WeakCanonicalSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedProperty<S extends Storable>
implements Serializable,
Appender {
    private static final long serialVersionUID = 1L;
    static WeakCanonicalSet cCanonical = new WeakCanonicalSet();
    private final ChainedProperty<S> mProperty;
    private final Direction mDirection;

    public static <S extends Storable> OrderedProperty<S> get(StorableProperty<S> property, Direction direction) {
        return OrderedProperty.get(ChainedProperty.get(property), direction);
    }

    public static <S extends Storable> OrderedProperty<S> get(ChainedProperty<S> property, Direction direction) {
        return (OrderedProperty)cCanonical.put(new OrderedProperty<S>(property, direction));
    }

    public static <S extends Storable> OrderedProperty<S> parse(StorableInfo<S> info, String str) throws IllegalArgumentException {
        return OrderedProperty.parse(info, str, Direction.ASCENDING);
    }

    public static <S extends Storable> OrderedProperty<S> parse(StorableInfo<S> info, String str, Direction defaultDirection) throws IllegalArgumentException {
        if (info == null || str == null || defaultDirection == null) {
            throw new IllegalArgumentException();
        }
        Direction direction = defaultDirection;
        if (str.length() > 0) {
            if (str.charAt(0) == '+') {
                direction = Direction.ASCENDING;
                str = str.substring(1);
            } else if (str.charAt(0) == '-') {
                direction = Direction.DESCENDING;
                str = str.substring(1);
            } else if (str.charAt(0) == '~') {
                direction = Direction.UNSPECIFIED;
                str = str.substring(1);
            }
        }
        if (direction == null) {
            direction = Direction.ASCENDING;
        }
        return OrderedProperty.get(ChainedProperty.parse(info, str), direction);
    }

    private OrderedProperty(ChainedProperty<S> property, Direction direction) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        this.mProperty = property;
        this.mDirection = direction == null ? Direction.UNSPECIFIED : direction;
    }

    public ChainedProperty<S> getChainedProperty() {
        return this.mProperty;
    }

    public Direction getDirection() {
        return this.mDirection;
    }

    public OrderedProperty<S> reverse() {
        if (this.mDirection == Direction.UNSPECIFIED) {
            return this;
        }
        return OrderedProperty.get(this.mProperty, this.mDirection.reverse());
    }

    public OrderedProperty<S> direction(Direction direction) {
        return OrderedProperty.get(this.mProperty, direction);
    }

    public int hashCode() {
        return this.mProperty.hashCode() + this.mDirection.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OrderedProperty) {
            OrderedProperty other = (OrderedProperty)obj;
            return this.mProperty.equals(other.mProperty) && this.mDirection.equals((Object)other.mDirection);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mDirection.toCharacter());
        try {
            this.mProperty.appendTo(buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    @Override
    public void appendTo(Appendable app) throws IOException {
        app.append(this.mDirection.toCharacter());
        this.mProperty.appendTo(app);
    }

    private Object readResolve() {
        return OrderedProperty.get(this.mProperty, this.mDirection);
    }
}

