/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.info;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.util.Appender;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.cojen.util.WeakCanonicalSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedProperty<S extends Storable>
implements Serializable,
Appender {
    private static final long serialVersionUID = 1L;
    static WeakCanonicalSet cCanonical = new WeakCanonicalSet();
    private final StorableProperty<S> mPrime;
    private final StorableProperty<?>[] mChain;
    private final boolean[] mOuterJoin;

    public static <S extends Storable> ChainedProperty<S> get(StorableProperty<S> prime) {
        return (ChainedProperty)cCanonical.put(new ChainedProperty<S>(prime, null, null));
    }

    public static <S extends Storable> ChainedProperty<S> get(StorableProperty<S> prime, StorableProperty<?> ... chain) {
        return (ChainedProperty)cCanonical.put(new ChainedProperty<S>(prime, chain, null));
    }

    public static <S extends Storable> ChainedProperty<S> get(StorableProperty<S> prime, StorableProperty<?>[] chain, boolean[] outerJoin) {
        return (ChainedProperty)cCanonical.put(new ChainedProperty<S>(prime, chain, outerJoin));
    }

    public static <S extends Storable> ChainedProperty<S> parse(StorableInfo<S> info, String str) throws IllegalArgumentException {
        StorableProperty<S> prime;
        String name;
        if (info == null || str == null) {
            throw new IllegalArgumentException();
        }
        int pos = 0;
        int dot = str.indexOf(46, pos);
        if (dot < 0) {
            name = str.trim();
        } else {
            name = str.substring(pos, dot).trim();
            pos = dot + 1;
        }
        ArrayList<Boolean> outerJoinList = null;
        if (name.startsWith("(") && name.endsWith(")")) {
            outerJoinList = new ArrayList<Boolean>(4);
            outerJoinList.add(true);
            name = name.substring(1, name.length() - 1).trim();
        }
        if ((prime = info.getAllProperties().get(name)) == null) {
            throw new IllegalArgumentException("Property \"" + name + "\" not found for type: \"" + info.getStorableType().getName() + '\"');
        }
        if (pos <= 0) {
            if (outerJoinList == null || !((Boolean)outerJoinList.get(0)).booleanValue()) {
                return ChainedProperty.get(prime);
            }
            return ChainedProperty.get(prime, null, new boolean[]{true});
        }
        ArrayList chain = new ArrayList(4);
        Class<Object> type = prime.getType();
        while (pos > 0) {
            dot = str.indexOf(46, pos);
            if (dot < 0) {
                name = str.substring(pos).trim();
                pos = -1;
            } else {
                name = str.substring(pos, dot).trim();
                pos = dot + 1;
            }
            if (name.startsWith("(") && name.endsWith(")")) {
                if (outerJoinList == null) {
                    outerJoinList = new ArrayList(4);
                    outerJoinList.add(false);
                    int i = chain.size();
                    while (--i >= 0) {
                        outerJoinList.add(false);
                    }
                }
                outerJoinList.add(true);
                name = name.substring(1, name.length() - 1).trim();
            } else if (outerJoinList != null) {
                outerJoinList.add(false);
            }
            if (Storable.class.isAssignableFrom(type)) {
                StorableInfo<?> propInfo = StorableIntrospector.examine(type);
                Map<String, StorableProperty<?>> props = propInfo.getAllProperties();
                StorableProperty<?> prop = props.get(name);
                if (prop == null) {
                    throw new IllegalArgumentException("Property \"" + name + "\" not found for type: \"" + type.getName() + '\"');
                }
                chain.add(prop);
                type = prop.isJoin() ? prop.getJoinedType() : prop.getType();
                continue;
            }
            throw new IllegalArgumentException("Property \"" + name + "\" not found for type \"" + type.getName() + "\" because it has no properties");
        }
        boolean[] outerJoin = null;
        if (outerJoinList != null) {
            outerJoin = new boolean[outerJoinList.size()];
            int i = outerJoinList.size();
            while (--i >= 0) {
                outerJoin[i] = (Boolean)outerJoinList.get(i);
            }
        }
        return ChainedProperty.get(prime, chain.toArray(new StorableProperty[chain.size()]), outerJoin);
    }

    private ChainedProperty(StorableProperty<S> prime, StorableProperty<?>[] chain, boolean[] outerJoin) {
        if (prime == null) {
            throw new IllegalArgumentException("No prime property");
        }
        this.mPrime = prime;
        StorableProperty[] storablePropertyArray = this.mChain = chain == null || chain.length == 0 ? null : (StorableProperty[])chain.clone();
        if (outerJoin != null) {
            int expectedLength = (chain == null ? 0 : chain.length) + 1;
            if (outerJoin.length > expectedLength) {
                throw new IllegalArgumentException("Outer join array too long: " + outerJoin.length + " > " + expectedLength);
            }
            boolean[] newOuterJoin = new boolean[expectedLength];
            System.arraycopy(outerJoin, 0, newOuterJoin, 0, outerJoin.length);
            outerJoin = newOuterJoin;
        }
        this.mOuterJoin = outerJoin;
    }

    public StorableProperty<S> getPrimeProperty() {
        return this.mPrime;
    }

    public Class<?> getType() {
        return this.getLastProperty().getType();
    }

    public boolean isNullable() {
        if (this.mPrime.isNullable()) {
            return true;
        }
        if (this.mChain != null) {
            for (StorableProperty<?> prop : this.mChain) {
                if (!prop.isNullable()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDerived() {
        if (this.mPrime.isDerived()) {
            return true;
        }
        if (this.mChain != null) {
            for (StorableProperty<?> prop : this.mChain) {
                if (!prop.isDerived()) continue;
                return true;
            }
        }
        return false;
    }

    public StorableProperty<?> getLastProperty() {
        return this.mChain == null ? this.mPrime : this.mChain[this.mChain.length - 1];
    }

    public int getChainCount() {
        return this.mChain == null ? 0 : this.mChain.length;
    }

    public StorableProperty<?> getChainedProperty(int index) throws IndexOutOfBoundsException {
        if (this.mChain == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.mChain[index];
    }

    public boolean isOuterJoin(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mOuterJoin == null) {
            if (index > this.getChainCount()) {
                throw new IndexOutOfBoundsException();
            }
            return false;
        }
        return this.mOuterJoin[index];
    }

    public ChainedProperty<S> append(StorableProperty<?> property) {
        return this.append(property, false);
    }

    public ChainedProperty<S> append(StorableProperty<?> property, boolean outerJoin) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        StorableProperty[] newChain = new StorableProperty[this.getChainCount() + 1];
        if (newChain.length > 1) {
            System.arraycopy(this.mChain, 0, newChain, 0, this.mChain.length);
        }
        newChain[newChain.length - 1] = property;
        boolean[] newOuterJoin = this.mOuterJoin;
        if (outerJoin) {
            newOuterJoin = new boolean[newChain.length + 1];
            if (this.mOuterJoin != null) {
                System.arraycopy(this.mOuterJoin, 0, newOuterJoin, 0, this.mOuterJoin.length);
            }
            newOuterJoin[newOuterJoin.length - 1] = true;
        }
        return ChainedProperty.get(this.mPrime, newChain, newOuterJoin);
    }

    public ChainedProperty<S> append(ChainedProperty<?> property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        int propChainCount = property.getChainCount();
        if (propChainCount == 0) {
            return this.append(property.getPrimeProperty(), property.isOuterJoin(0));
        }
        StorableProperty[] newChain = new StorableProperty[this.getChainCount() + 1 + propChainCount];
        int pos = 0;
        if (this.getChainCount() > 0) {
            System.arraycopy(this.mChain, 0, newChain, 0, this.mChain.length);
            pos = this.mChain.length;
        }
        newChain[pos++] = property.getPrimeProperty();
        for (int i = 0; i < propChainCount; ++i) {
            newChain[pos++] = property.getChainedProperty(i);
        }
        boolean[] newOuterJoin = this.mOuterJoin;
        if (property.mOuterJoin != null) {
            newOuterJoin = new boolean[newChain.length + 1];
            if (this.mOuterJoin != null) {
                System.arraycopy(this.mOuterJoin, 0, newOuterJoin, 0, this.mOuterJoin.length);
            }
            System.arraycopy(property.mOuterJoin, 0, newOuterJoin, this.getChainCount() + 1, property.mOuterJoin.length);
        }
        return ChainedProperty.get(this.mPrime, newChain, newOuterJoin);
    }

    public ChainedProperty<S> trim() {
        if (this.getChainCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.getChainCount() == 1) {
            if (!this.isOuterJoin(0)) {
                return ChainedProperty.get(this.mPrime);
            }
            return ChainedProperty.get(this.mPrime, null, new boolean[]{true});
        }
        StorableProperty[] newChain = new StorableProperty[this.getChainCount() - 1];
        System.arraycopy(this.mChain, 0, newChain, 0, newChain.length);
        boolean[] newOuterJoin = this.mOuterJoin;
        if (newOuterJoin != null && newOuterJoin.length > newChain.length + 1) {
            newOuterJoin = new boolean[newChain.length + 1];
            System.arraycopy(this.mOuterJoin, 0, newOuterJoin, 0, newChain.length + 1);
        }
        return ChainedProperty.get(this.mPrime, newChain, newOuterJoin);
    }

    public ChainedProperty<?> tail() {
        if (this.getChainCount() == 0) {
            throw new IllegalStateException();
        }
        if (this.getChainCount() == 1) {
            if (!this.isOuterJoin(1)) {
                return ChainedProperty.get(this.mChain[0]);
            }
            return ChainedProperty.get(this.mChain[0], null, new boolean[]{true});
        }
        StorableProperty[] newChain = new StorableProperty[this.getChainCount() - 1];
        System.arraycopy(this.mChain, 1, newChain, 0, newChain.length);
        boolean[] newOuterJoin = this.mOuterJoin;
        if (newOuterJoin != null) {
            newOuterJoin = new boolean[newChain.length + 1];
            System.arraycopy(this.mOuterJoin, 1, newOuterJoin, 0, this.mOuterJoin.length - 1);
        }
        return ChainedProperty.get(this.mChain[0], newChain, newOuterJoin);
    }

    public int hashCode() {
        boolean[] outerJoin;
        int hash = this.mPrime.hashCode();
        StorableProperty<?>[] chain = this.mChain;
        if (chain != null) {
            int i = chain.length;
            while (--i >= 0) {
                hash = hash * 31 + chain[i].hashCode();
            }
        }
        if ((outerJoin = this.mOuterJoin) != null) {
            int i = outerJoin.length;
            while (--i >= 0) {
                if (!outerJoin[i]) continue;
                ++hash;
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChainedProperty) {
            ChainedProperty other = (ChainedProperty)obj;
            if (this.getType() == other.getType() && this.mPrime == other.mPrime && ChainedProperty.identityEquals(this.mChain, other.mChain)) {
                int count = this.getChainCount() + 1;
                for (int i = 0; i < count; ++i) {
                    if (this.isOuterJoin(i) == other.isOuterJoin(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean identityEquals(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.mChain == null && !this.isOuterJoin(0)) {
            return this.mPrime.getName();
        }
        StringBuilder buf = new StringBuilder();
        try {
            this.appendTo(buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    @Override
    public void appendTo(Appendable app) throws IOException {
        this.appendPropTo(app, this.mPrime.getName(), this.isOuterJoin(0));
        StorableProperty<?>[] chain = this.mChain;
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                app.append('.');
                this.appendPropTo(app, chain[i].getName(), this.isOuterJoin(i + 1));
            }
        }
    }

    private void appendPropTo(Appendable app, String name, boolean outer) throws IOException {
        if (outer) {
            app.append('(');
        }
        app.append(name);
        if (outer) {
            app.append(')');
        }
    }

    private Object readResolve() {
        return cCanonical.put((Object)this);
    }
}

