/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyFilterList<S extends Storable> {
    private final PropertyFilter<S> mPropFilter;
    private final PropertyFilterList<S> mNext;
    private final int mNextRemaining;
    private final int mNextBlankRemaining;
    private PropertyFilterList<S> mPrev;
    private int mPrevRemaining = -1;
    private int mBlankCount = -1;

    PropertyFilterList(PropertyFilter<S> propFilter, PropertyFilterList<S> next) {
        this.mPropFilter = propFilter;
        this.mNext = next;
        int n = this.mNextRemaining = next == null ? 0 : next.mNextRemaining + 1;
        this.mNextBlankRemaining = next == null ? 0 : next.mNextBlankRemaining + (next.mPropFilter.isConstant() ? 0 : 1);
    }

    public PropertyFilter<S> getPropertyFilter() {
        return this.mPropFilter;
    }

    public Class<?> getNaturalPropertyType() {
        return this.mPropFilter.getType();
    }

    public Class<?> getObjectPropertyType() {
        return this.mPropFilter.getBoxedType();
    }

    public PropertyFilterList<S> getNext() {
        return this.mNext;
    }

    public int getNextRemaining() {
        return this.mNextRemaining;
    }

    public int getNextBlankRemaining() {
        return this.mNextBlankRemaining;
    }

    public PropertyFilterList<S> getPrevious() {
        return this.mPrev;
    }

    public int getPreviousRemaining() {
        int remaining = this.mPrevRemaining;
        if (remaining < 0) {
            remaining = this.mPrev == null ? 0 : this.mPrev.getPreviousRemaining() + 1;
            this.mPrevRemaining = remaining;
        }
        return remaining;
    }

    public int getBlankCount() {
        int count = this.mBlankCount;
        if (count < 0) {
            this.mBlankCount = count = (this.mPropFilter.isConstant() ? 0 : 1) + (this.mPrev == null ? 0 : this.mPrev.getBlankCount());
        }
        return count;
    }

    public PropertyFilterList<S> get(int index) {
        if (index <= 0) {
            if (index == 0) {
                return this;
            }
            if ((index = this.mNextRemaining + index + 1) <= 0) {
                if (index == 0) {
                    return this;
                }
                return null;
            }
        }
        if (this.mNext == null) {
            return null;
        }
        return this.mNext.get(index - 1);
    }

    public boolean contains(PropertyFilter<S> propFilter) {
        if (this.mPropFilter == propFilter) {
            return true;
        }
        if (this.mNext == null) {
            return false;
        }
        return this.mNext.contains(propFilter);
    }

    PropertyFilterList<S> prepend(PropertyFilter<S> propFilter) {
        PropertyFilterList<S> head = new PropertyFilterList<S>(propFilter, this);
        this.mPrev = head;
        return head;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Builder<S extends Storable>
    extends Visitor<S, PropertyFilterList<S>, PropertyFilterList<S>> {
        Builder() {
        }

        @Override
        public PropertyFilterList<S> visit(OrFilter<S> filter, PropertyFilterList<S> list) {
            list = (PropertyFilterList)filter.getRightFilter().accept(this, list);
            list = (PropertyFilterList)filter.getLeftFilter().accept(this, list);
            return list;
        }

        @Override
        public PropertyFilterList<S> visit(AndFilter<S> filter, PropertyFilterList<S> list) {
            list = (PropertyFilterList)filter.getRightFilter().accept(this, list);
            list = (PropertyFilterList)filter.getLeftFilter().accept(this, list);
            return list;
        }

        @Override
        public PropertyFilterList<S> visit(PropertyFilter<S> filter, PropertyFilterList<S> list) {
            return list == null ? new PropertyFilterList<S>(filter, null) : list.prepend(filter);
        }

        @Override
        public PropertyFilterList<S> visit(ExistsFilter<S> filter, PropertyFilterList<S> list) {
            for (PropertyFilterList<S> subList = filter.getJoinedSubFilter().getTailPropertyFilterList(); subList != null; subList = subList.getPrevious()) {
                PropertyFilter<S> joinedFilter = subList.getPropertyFilter();
                list = list == null ? new PropertyFilterList<S>(joinedFilter, null) : list.prepend(joinedFilter);
            }
            return list;
        }
    }
}

