/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.MalformedFilterException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterParser<S extends Storable> {
    private final Class<S> mType;
    private final String mFilter;
    private int mPos;

    FilterParser(Class<S> type, String filter) {
        this(type, filter, 0);
    }

    private FilterParser(Class<S> type, String filter, int pos) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (filter == null) {
            throw new IllegalArgumentException("Query filter must not be null");
        }
        this.mType = type;
        this.mFilter = filter;
        this.mPos = pos;
    }

    Filter<S> parseRoot() {
        Filter<S> filter = this.parseFilter();
        int c = this.nextCharIgnoreWhitespace();
        if (c >= 0) {
            --this.mPos;
            throw this.error("Unexpected trailing characters");
        }
        return filter;
    }

    private Filter<S> parseFilter() {
        return this.parseOrFilter();
    }

    private Filter<S> parseOrFilter() {
        int c;
        Filter<S> filter = this.parseAndFilter();
        while ((c = this.nextCharIgnoreWhitespace()) == 124) {
            this.operatorCheck();
            filter = filter.or(this.parseAndFilter());
        }
        --this.mPos;
        return filter;
    }

    private Filter<S> parseAndFilter() {
        int c;
        Filter<S> filter = this.parseNotFilter();
        while ((c = this.nextCharIgnoreWhitespace()) == 38) {
            this.operatorCheck();
            filter = filter.and(this.parseNotFilter());
        }
        --this.mPos;
        return filter;
    }

    private Filter<S> parseNotFilter() {
        int c = this.nextCharIgnoreWhitespace();
        if (c == 33) {
            return this.parseEntityFilter().not();
        }
        --this.mPos;
        return this.parseEntityFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Filter<S> parseEntityFilter() {
        Filter<?> subFilter;
        int c;
        block11: {
            c = this.nextCharIgnoreWhitespace();
            if (c == 40) {
                block10: {
                    int savedPos = this.mPos--;
                    try {
                        if (!Character.isJavaIdentifierStart(this.nextCharIgnoreWhitespace())) break block10;
                        this.parseIdentifier();
                        if (this.nextCharIgnoreWhitespace() != 41) break block10;
                        break block11;
                    }
                    finally {
                        this.mPos = savedPos;
                    }
                }
                Filter<S> test = this.parseFilter();
                c = this.nextCharIgnoreWhitespace();
                if (c != 41) {
                    --this.mPos;
                    throw this.error("Right paren expected");
                }
                return test;
            }
        }
        --this.mPos;
        ChainedProperty<S> chained = this.parseChainedProperty();
        c = this.nextCharIgnoreWhitespace();
        if (c == 46) {
            Filter<?> subFilter2 = this.parseChainedFilter(chained, true);
            return ExistsFilter.build(chained, subFilter2, false);
        }
        if (c != 40) {
            --this.mPos;
            return this.parsePropertyFilter(chained);
        }
        c = this.nextCharIgnoreWhitespace();
        if (c == 41) {
            subFilter = null;
        } else {
            --this.mPos;
            subFilter = this.parseChainedFilter(chained, false);
            c = this.nextCharIgnoreWhitespace();
            if (c != 41) {
                --this.mPos;
                throw this.error("Right paren expected");
            }
        }
        return ExistsFilter.build(chained, subFilter, false);
    }

    private PropertyFilter<S> parsePropertyFilter(ChainedProperty<S> chained) {
        RelOp op;
        int c = this.nextCharIgnoreWhitespace();
        switch (c) {
            case 61: {
                op = RelOp.EQ;
                this.operatorCheck();
                break;
            }
            case 33: {
                c = this.nextChar();
                if (c != 61) {
                    --this.mPos;
                    throw this.error("Inequality operator must be specified as '!='");
                }
                op = RelOp.NE;
                this.operatorCheck();
                break;
            }
            case 60: {
                c = this.nextChar();
                if (c == 61) {
                    op = RelOp.LE;
                } else {
                    --this.mPos;
                    op = RelOp.LT;
                }
                this.operatorCheck();
                break;
            }
            case 62: {
                c = this.nextChar();
                if (c == 61) {
                    op = RelOp.GE;
                } else {
                    --this.mPos;
                    op = RelOp.GT;
                }
                this.operatorCheck();
                break;
            }
            case 63: {
                --this.mPos;
                throw this.error("Relational operator missing");
            }
            case -1: {
                throw this.error("Relational operator expected");
            }
            default: {
                --this.mPos;
                throw this.error("Unexpected operator character: '" + (char)c + '\'');
            }
        }
        c = this.nextCharIgnoreWhitespace();
        if (c != 63) {
            --this.mPos;
            throw this.error("Parameter placeholder '?' required");
        }
        return PropertyFilter.getCanonical(chained, op, 0);
    }

    private void operatorCheck() {
        int c = this.nextChar();
        --this.mPos;
        switch (c) {
            case -1: 
            case 0: 
            case 9: 
            case 10: 
            case 13: 
            case 32: 
            case 40: 
            case 41: 
            case 63: {
                return;
            }
        }
        if (Character.isWhitespace(c)) {
            return;
        }
        if (!Character.isJavaIdentifierStart(c)) {
            throw this.error("Unknown operator");
        }
    }

    private Filter<?> parseChainedFilter(ChainedProperty<S> chained, boolean oneEntity) {
        FilterParser<Storable> chainedParser = new FilterParser<Storable>(chained.getLastProperty().getJoinedType(), this.mFilter, this.mPos);
        Filter<Storable> chainedFilter = oneEntity ? super.parseEntityFilter() : super.parseFilter();
        this.mPos = chainedParser.mPos;
        return chainedFilter;
    }

    ChainedProperty<S> parseChainedProperty() {
        ArrayList<Boolean> outerJoinList = null;
        int lastOuterJoinPos = -1;
        if (this.nextChar() == 40) {
            lastOuterJoinPos = this.mPos - 1;
            this.nextCharIgnoreWhitespace();
            outerJoinList = new ArrayList<Boolean>(4);
            outerJoinList.add(true);
        }
        --this.mPos;
        String ident = this.parseIdentifier();
        StorableProperty<S> prime = StorableIntrospector.examine(this.mType).getAllProperties().get(ident);
        if (prime == null) {
            this.mPos -= ident.length();
            throw this.error("Property \"" + ident + "\" not found for type: \"" + this.mType.getName() + '\"');
        }
        if (outerJoinList != null && ((Boolean)outerJoinList.get(0)).booleanValue() && this.nextCharIgnoreWhitespace() != 41) {
            --this.mPos;
            throw this.error("Right paren expected");
        }
        if (this.nextCharIgnoreWhitespace() != 46 || prime.isQuery()) {
            --this.mPos;
            if (outerJoinList != null && ((Boolean)outerJoinList.get(0)).booleanValue()) {
                if (prime.isQuery()) {
                    return ChainedProperty.get(prime, null, new boolean[]{true});
                }
                if (lastOuterJoinPos >= 0) {
                    this.mPos = lastOuterJoinPos;
                }
                throw this.error("Outer join not allowed for non-join property");
            }
            return ChainedProperty.get(prime);
        }
        ArrayList<StorableProperty<Object>> chain = new ArrayList<StorableProperty<Object>>(4);
        StorableProperty<Object> prop = prime;
        Class<?> type = prop.getType();
        do {
            lastOuterJoinPos = -1;
            if (this.nextChar() == 40) {
                lastOuterJoinPos = this.mPos - 1;
                this.nextCharIgnoreWhitespace();
                if (outerJoinList == null) {
                    outerJoinList = new ArrayList(4);
                    outerJoinList.add(false);
                    int i = chain.size();
                    while (--i >= 0) {
                        outerJoinList.add(false);
                    }
                }
                outerJoinList.add(true);
            } else if (outerJoinList != null) {
                outerJoinList.add(false);
            }
            --this.mPos;
            ident = this.parseIdentifier();
            if (Storable.class.isAssignableFrom(type)) {
                StorableInfo<?> info = StorableIntrospector.examine(type);
                Map<String, StorableProperty<?>> props = info.getAllProperties();
                prop = props.get(ident);
                if (prop == null) {
                    this.mPos -= ident.length();
                    throw this.error("Property \"" + ident + "\" not found for type: \"" + type.getName() + '\"');
                }
            } else {
                throw this.error("Property \"" + ident + "\" not found for type \"" + type.getName() + "\" because it has no properties");
            }
            chain.add(prop);
            type = prop.getType();
            if (outerJoinList == null || !((Boolean)outerJoinList.get(outerJoinList.size() - 1)).booleanValue() || this.nextCharIgnoreWhitespace() == 41) continue;
            --this.mPos;
            throw this.error("Right paren expected");
        } while (this.nextCharIgnoreWhitespace() == 46 && !prop.isQuery());
        --this.mPos;
        boolean[] outerJoin = null;
        if (outerJoinList != null) {
            if (!prop.isQuery() && ((Boolean)outerJoinList.get(outerJoinList.size() - 1)).booleanValue()) {
                if (lastOuterJoinPos >= 0) {
                    this.mPos = lastOuterJoinPos;
                }
                throw this.error("Outer join not allowed for non-join property");
            }
            outerJoin = new boolean[outerJoinList.size()];
            int i = outerJoinList.size();
            while (--i >= 0) {
                outerJoin[i] = (Boolean)outerJoinList.get(i);
            }
        }
        return ChainedProperty.get(prime, chain.toArray(new StorableProperty[chain.size()]), outerJoin);
    }

    private String parseIdentifier() {
        int start = this.mPos--;
        int c = this.nextChar();
        if (c < 0) {
            throw this.error("Identifier expected");
        }
        if (!Character.isJavaIdentifierStart(c)) {
            throw this.error("Not a valid character for start of identifier: '" + (char)c + '\'');
        }
        while (Character.isJavaIdentifierPart(c = this.nextChar())) {
        }
        return this.mFilter.substring(start, --this.mPos);
    }

    private int nextChar() {
        int pos = this.mPos;
        String filter = this.mFilter;
        int c = pos >= filter.length() ? -1 : (int)this.mFilter.charAt(pos);
        this.mPos = pos + 1;
        return c;
    }

    private int nextCharIgnoreWhitespace() {
        int c;
        block3: while ((c = this.nextChar()) >= 0) {
            switch (c) {
                case 0: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            if (Character.isWhitespace(c)) continue;
            return c;
        }
        return c;
    }

    private MalformedFilterException error(String message) {
        return this.error(message, this.mPos);
    }

    private MalformedFilterException error(String message, int pos) {
        int remaining;
        message = pos <= 0 || this.mFilter.length() == 0 ? message + " (at start of filter expession)" : (pos >= this.mFilter.length() ? message + " (at end of filter expression)" : ((remaining = this.mFilter.length() - pos) <= 20 ? message + " (at \"" + this.mFilter.substring(pos) + "\")" : message + " (at \"" + this.mFilter.substring(pos, pos + 17) + "...\")"));
        return new MalformedFilterException(this.mFilter, message, pos);
    }
}

