/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.filter;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Distributer<S extends Storable>
extends Visitor<S, Filter<S>, Filter<S>> {
    private final boolean mDoRight;
    private final boolean mDoAnd;

    Distributer(boolean doRight, boolean doAnd) {
        this.mDoRight = doRight;
        this.mDoAnd = doAnd;
    }

    @Override
    public Filter<S> visit(OrFilter<S> filter, Filter<S> distribute) {
        return OrFilter.getCanonical((Filter)filter.getLeftFilter().accept(this, distribute), (Filter)filter.getRightFilter().accept(this, distribute));
    }

    @Override
    public Filter<S> visit(AndFilter<S> filter, Filter<S> distribute) {
        return AndFilter.getCanonical((Filter)filter.getLeftFilter().accept(this, distribute), (Filter)filter.getRightFilter().accept(this, distribute));
    }

    @Override
    public Filter<S> visit(PropertyFilter<S> filter, Filter<S> distribute) {
        if (this.mDoRight) {
            return this.mDoAnd ? filter.and(distribute) : filter.or(distribute);
        }
        return this.mDoAnd ? distribute.and(filter) : distribute.or(filter);
    }

    @Override
    public Filter<S> visit(ExistsFilter<S> filter, Filter<S> distribute) {
        if (this.mDoRight) {
            return this.mDoAnd ? filter.and(distribute) : filter.or(distribute);
        }
        return this.mDoAnd ? distribute.and(filter) : distribute.or(filter);
    }
}

