/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mSource;
    private volatile long mRemaining;

    public LimitCursor(Cursor<S> source, long limit) {
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit is negative: " + limit);
        }
        this.mSource = source;
        this.mRemaining = limit;
    }

    @Override
    public boolean hasNext() throws FetchException {
        try {
            if (this.mSource.hasNext()) {
                if (this.mRemaining > 0L) {
                    return true;
                }
                this.mSource.close();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public S next() throws FetchException {
        if (this.mRemaining <= 0L) {
            throw new NoSuchElementException();
        }
        S next = this.mSource.next();
        if (--this.mRemaining <= 0L) {
            this.mSource.close();
        }
        return next;
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (this.mRemaining <= 0L) {
            return 0;
        }
        if ((long)amount > this.mRemaining) {
            amount = (int)this.mRemaining;
        }
        if ((this.mRemaining -= (long)(amount = this.mSource.skipNext(amount))) <= 0L) {
            this.mSource.close();
        }
        return amount;
    }

    @Override
    public void close() throws FetchException {
        this.mSource.close();
    }
}

