/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorCursor<S>
extends AbstractCursor<S> {
    private static final AtomicReferenceFieldUpdater<IteratorCursor, Lock> lockUpdater = AtomicReferenceFieldUpdater.newUpdater(IteratorCursor.class, Lock.class, "mLock");
    private volatile Iterator<S> mIterator;
    private volatile Lock mLock;

    public IteratorCursor(Iterable<S> iterable) {
        this(iterable, null);
    }

    public IteratorCursor(Iterable<S> iterable, Lock lock) {
        if (iterable == null) {
            this.mIterator = null;
            this.mLock = null;
        } else {
            if (lock != null) {
                lock.lock();
            }
            this.mIterator = iterable.iterator();
            this.mLock = lock;
        }
    }

    public IteratorCursor(Iterator<S> iterator) {
        this.mIterator = iterator;
        this.mLock = null;
    }

    @Override
    public void close() {
        this.mIterator = null;
        Lock lock = lockUpdater.getAndSet(this, null);
        if (lock != null) {
            lock.unlock();
        }
    }

    @Override
    public boolean hasNext() {
        Iterator<S> it = this.mIterator;
        return it != null && it.hasNext();
    }

    @Override
    public S next() {
        Iterator<S> it = this.mIterator;
        if (it == null) {
            throw new NoSuchElementException();
        }
        return it.next();
    }
}

