/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.cursor.AbstractCursor;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectionCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mLeftCursor;
    private final Cursor<S> mRightCursor;
    private final Comparator<S> mOrder;
    private S mNext;

    public IntersectionCursor(Cursor<S> left, Cursor<S> right, Comparator<S> order) {
        if (left == null || right == null || order == null) {
            throw new IllegalArgumentException();
        }
        this.mLeftCursor = left;
        this.mRightCursor = right;
        this.mOrder = order;
    }

    @Override
    public void close() throws FetchException {
        this.mLeftCursor.close();
        this.mRightCursor.close();
        this.mNext = null;
    }

    @Override
    public boolean hasNext() throws FetchException {
        if (this.mNext != null) {
            return true;
        }
        try {
            S nextLeft;
            block11: {
                if (!this.mLeftCursor.hasNext()) {
                    this.close();
                    return false;
                }
                nextLeft = this.mLeftCursor.next();
                if (!this.mRightCursor.hasNext()) {
                    this.close();
                    return false;
                }
                S nextRight = this.mRightCursor.next();
                while (true) {
                    int result;
                    if ((result = this.mOrder.compare(nextLeft, nextRight)) < 0) {
                        if (this.mLeftCursor.hasNext()) {
                            nextLeft = this.mLeftCursor.next();
                            continue;
                        }
                        this.close();
                        return false;
                    }
                    if (result <= 0) break block11;
                    if (!this.mRightCursor.hasNext()) break;
                    nextRight = this.mRightCursor.next();
                }
                this.close();
                return false;
            }
            this.mNext = nextLeft;
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public S next() throws FetchException {
        try {
            if (this.hasNext()) {
                S next = this.mNext;
                this.mNext = null;
                return next;
            }
        }
        catch (FetchException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        throw new NoSuchElementException();
    }
}

