/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.FilteredCursor;
import com.amazon.carbonado.cursor.PropertyOrdinalMapVisitor;
import com.amazon.carbonado.cursor.ShortCircuitOptimizer;
import com.amazon.carbonado.filter.AndFilter;
import com.amazon.carbonado.filter.ExistsFilter;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.OrFilter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.filter.Visitor;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.util.QuickConstructorGenerator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;
import org.cojen.util.ThrowUnchecked;
import org.cojen.util.WeakIdentityMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilteredCursorGenerator {
    private static final String SUB_FILTER_INIT_METHOD = "subFilterInit$";
    private static Map cCache = new WeakIdentityMap();

    FilteredCursorGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <S extends Storable> Factory<S> getFactory(Filter<S> filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        Map map = cCache;
        synchronized (map) {
            Factory factory = (Factory)cCache.get(filter);
            if (factory != null) {
                return factory;
            }
            Class<Cursor<S>> clazz = FilteredCursorGenerator.generateClass(filter);
            factory = QuickConstructorGenerator.getInstance(clazz, Factory.class);
            cCache.put(filter, factory);
            return factory;
        }
    }

    private static <S extends Storable> Class<Cursor<S>> generateClass(Filter<S> filter) {
        filter.accept(new Validator(), null);
        Class<S> type = filter.getStorableType();
        String name = type.getName();
        int index = name.lastIndexOf(46);
        String packageName = index >= 0 ? name.substring(0, index) : "";
        ClassLoader loader = type.getClassLoader();
        ClassInjector ci = ClassInjector.create((String)(packageName + ".FilteredCursor"), (ClassLoader)loader);
        ClassFile cf = new ClassFile(ci.getClassName(), FilteredCursor.class);
        cf.markSynthetic();
        cf.setSourceFile(FilteredCursorGenerator.class.getName());
        cf.setTarget("1.5");
        TypeDesc cursorType = TypeDesc.forClass(Cursor.class);
        TypeDesc objectArrayType = TypeDesc.forClass(Object[].class);
        TypeDesc[] params = new TypeDesc[]{cursorType, objectArrayType};
        MethodInfo ctor = cf.addConstructor(Modifiers.PUBLIC, params);
        CodeBuilder ctorBuilder = new CodeBuilder(ctor);
        ctorBuilder.loadThis();
        ctorBuilder.loadLocal(ctorBuilder.getParameter(0));
        ctorBuilder.invokeSuperConstructor(new TypeDesc[]{cursorType});
        params = new TypeDesc[]{TypeDesc.OBJECT};
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, "isAllowed", TypeDesc.BOOLEAN, params);
        CodeBuilder isAllowedBuilder = new CodeBuilder(mi);
        LocalVariable storableVar = isAllowedBuilder.getParameter(0);
        isAllowedBuilder.loadLocal(storableVar);
        Label notNull = isAllowedBuilder.createLabel();
        isAllowedBuilder.ifNullBranch((Location)notNull, false);
        isAllowedBuilder.loadConstant(false);
        isAllowedBuilder.returnValue(TypeDesc.BOOLEAN);
        notNull.setLocation();
        isAllowedBuilder.loadLocal(storableVar);
        TypeDesc storableType = TypeDesc.forClass(type);
        isAllowedBuilder.checkCast(storableType);
        storableVar = isAllowedBuilder.createLocalVariable("storable", storableType);
        isAllowedBuilder.storeLocal(storableVar);
        PropertyOrdinalMapVisitor visitor = new PropertyOrdinalMapVisitor();
        filter.accept(visitor, null);
        Map<PropertyFilter, Integer> propertyOrdinalMap = visitor.getPropertyOrdinalMap();
        filter = ShortCircuitOptimizer.optimize(filter);
        CodeGen cg = new CodeGen(propertyOrdinalMap, cf, ctorBuilder, isAllowedBuilder, storableVar);
        filter.accept(cg, null);
        List<Filter> subFilters = cg.finishSubFilterInit();
        ctorBuilder.returnVoid();
        Class generated = ci.defineClass(cf);
        if (subFilters != null && subFilters.size() > 0) {
            try {
                Method init = generated.getMethod(SUB_FILTER_INIT_METHOD, Filter[].class);
                init.invoke(null, new Object[]{subFilters.toArray(new Filter[subFilters.size()])});
            }
            catch (Exception e) {
                ThrowUnchecked.fireDeclaredRootCause((Throwable)e, (Class[])new Class[0]);
            }
        }
        return generated;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CodeGen<S extends Storable>
    extends Visitor<S, Object, Object> {
        private static final String FIELD_PREFIX = "value$";
        private static final String FILTER_FIELD_PREFIX = "filter$";
        private final Map<PropertyFilter, Integer> mPropertyOrdinalMap;
        private final ClassFile mClassFile;
        private final CodeBuilder mCtorBuilder;
        private final CodeBuilder mIsAllowedBuilder;
        private final LocalVariable mStorableVar;
        private final Stack<Scope> mScopeStack;
        private final Map<PropertyFilter, Object> mGeneratedPropertyFilters;
        private List<Filter> mSubFilters;
        private Map<Filter, String> mGeneratedSubFilters;
        private CodeBuilder mSubFilterInitBuilder;

        CodeGen(Map<PropertyFilter, Integer> propertyOrdinalMap, ClassFile cf, CodeBuilder ctorBuilder, CodeBuilder isAllowedBuilder, LocalVariable storableVar) {
            this.mPropertyOrdinalMap = propertyOrdinalMap;
            this.mClassFile = cf;
            this.mCtorBuilder = ctorBuilder;
            this.mIsAllowedBuilder = isAllowedBuilder;
            this.mStorableVar = storableVar;
            this.mScopeStack = new Stack();
            this.mScopeStack.push(new Scope(null, null));
            this.mGeneratedPropertyFilters = new IdentityHashMap<PropertyFilter, Object>();
        }

        public List<Filter> finishSubFilterInit() {
            if (this.mSubFilterInitBuilder != null) {
                this.mSubFilterInitBuilder.returnVoid();
            }
            if (this.mSubFilters == null) {
                return Collections.emptyList();
            }
            return this.mSubFilters;
        }

        @Override
        public Object visit(OrFilter<S> filter, Object param) {
            Label failLocation = this.mIsAllowedBuilder.createLabel();
            this.mScopeStack.push(new Scope(failLocation, this.getScope().mSuccessLocation));
            filter.getLeftFilter().accept(this, param);
            failLocation.setLocation();
            this.mScopeStack.pop();
            filter.getRightFilter().accept(this, param);
            return null;
        }

        @Override
        public Object visit(AndFilter<S> filter, Object param) {
            Label successLocation = this.mIsAllowedBuilder.createLabel();
            this.mScopeStack.push(new Scope(this.getScope().mFailLocation, successLocation));
            filter.getLeftFilter().accept(this, param);
            successLocation.setLocation();
            this.mScopeStack.pop();
            filter.getRightFilter().accept(this, param);
            return null;
        }

        @Override
        public Object visit(PropertyFilter<S> filter, Object param) {
            TypeDesc type = TypeDesc.forClass(filter.getChainedProperty().getType());
            String fieldName = this.addFilterField(filter, type);
            this.loadChainedProperty(this.mIsAllowedBuilder, filter.getChainedProperty());
            this.addPropertyFilter(this.mIsAllowedBuilder, fieldName, type, filter.getOperator());
            return null;
        }

        @Override
        public Object visit(ExistsFilter<S> filter, Object param) {
            CodeBuilder b = this.mIsAllowedBuilder;
            this.loadChainedProperty(b, filter.getChainedProperty());
            if (!filter.getChainedProperty().getLastProperty().isQuery()) {
                this.getScope().successIfNullElseFail(b, filter.isNotExists());
                return null;
            }
            final ArrayList subPropFilters = new ArrayList();
            filter.getSubFilter().accept(new Visitor(){

                public Object visit(PropertyFilter filter, Object param) {
                    subPropFilters.add(filter);
                    return null;
                }

                public Object visit(ExistsFilter filter, Object param) {
                    return filter.getSubFilter().accept(this, param);
                }
            }, null);
            TypeDesc queryType = TypeDesc.forClass(Query.class);
            if (!filter.getSubFilter().isOpen()) {
                String subFilterFieldName = this.addStaticFilterField(filter.getSubFilter());
                TypeDesc filterType = TypeDesc.forClass(Filter.class);
                b.loadStaticField(subFilterFieldName, filterType);
                b.invokeInterface(queryType, "and", queryType, new TypeDesc[]{filterType});
                for (PropertyFilter subPropFilter : subPropFilters) {
                    String fieldName = this.addFilterField(subPropFilter, TypeDesc.OBJECT);
                    b.loadThis();
                    b.loadField(fieldName, TypeDesc.OBJECT);
                    b.invokeInterface(queryType, "with", queryType, new TypeDesc[]{TypeDesc.OBJECT});
                }
            }
            b.invokeInterface(queryType, "exists", TypeDesc.BOOLEAN, null);
            RelOp op = filter.isNotExists() ? RelOp.EQ : RelOp.NE;
            this.getScope().successIfZeroComparisonElseFail(b, op);
            return null;
        }

        private String addFilterField(PropertyFilter filter, TypeDesc type) {
            int propertyOrdinal = this.mPropertyOrdinalMap.get(filter);
            String fieldName = FIELD_PREFIX + propertyOrdinal;
            if (this.mGeneratedPropertyFilters.containsKey(filter)) {
                return fieldName;
            }
            TypeDesc fieldType = CodeGen.actualFieldType(type);
            this.mClassFile.addField(Modifiers.PRIVATE.toFinal(true), fieldName, fieldType);
            CodeBuilder b = this.mCtorBuilder;
            b.loadThis();
            b.loadLocal(b.getParameter(1));
            b.loadConstant(propertyOrdinal);
            b.loadFromArray(TypeDesc.OBJECT);
            if (type != TypeDesc.OBJECT) {
                b.checkCast(type.toObjectType());
                this.convertProperty(b, type.toObjectType(), fieldType);
            }
            b.storeField(fieldName, fieldType);
            this.mGeneratedPropertyFilters.put(filter, filter);
            return fieldName;
        }

        private String addStaticFilterField(Filter filter) {
            if (this.mSubFilters == null) {
                this.mSubFilters = new ArrayList<Filter>();
                this.mGeneratedSubFilters = new IdentityHashMap<Filter, String>();
            }
            if (this.mGeneratedSubFilters.containsKey(filter)) {
                return this.mGeneratedSubFilters.get(filter);
            }
            int filterOrdinal = this.mSubFilters.size();
            String fieldName = FILTER_FIELD_PREFIX + filterOrdinal;
            TypeDesc filterType = TypeDesc.forClass(Filter.class);
            this.mClassFile.addField(Modifiers.PRIVATE.toStatic(true), fieldName, filterType);
            this.mSubFilters.add(filter);
            if (this.mSubFilterInitBuilder == null) {
                TypeDesc filterArrayType = filterType.toArrayType();
                this.mSubFilterInitBuilder = new CodeBuilder(this.mClassFile.addMethod(Modifiers.PUBLIC.toStatic(true), FilteredCursorGenerator.SUB_FILTER_INIT_METHOD, null, new TypeDesc[]{filterArrayType}));
                this.mSubFilterInitBuilder.loadStaticField(fieldName, filterType);
                Label isNull = this.mSubFilterInitBuilder.createLabel();
                this.mSubFilterInitBuilder.ifNullBranch((Location)isNull, true);
                CodeBuilderUtil.throwException(this.mSubFilterInitBuilder, IllegalStateException.class, null);
                isNull.setLocation();
            }
            this.mSubFilterInitBuilder.loadLocal(this.mSubFilterInitBuilder.getParameter(0));
            this.mSubFilterInitBuilder.loadConstant(filterOrdinal);
            this.mSubFilterInitBuilder.loadFromArray(filterType);
            this.mSubFilterInitBuilder.storeStaticField(fieldName, filterType);
            this.mGeneratedSubFilters.put(filter, fieldName);
            return fieldName;
        }

        private Scope getScope() {
            return this.mScopeStack.peek();
        }

        private void loadChainedProperty(CodeBuilder b, ChainedProperty<?> chained) {
            b.loadLocal(this.mStorableVar);
            this.loadProperty(b, chained.getPrimeProperty());
            for (int i = 0; i < chained.getChainCount(); ++i) {
                b.dup();
                Label notNull = b.createLabel();
                b.ifNullBranch((Location)notNull, false);
                b.pop();
                if (chained.isOuterJoin(i)) {
                    this.getScope().success(b);
                } else {
                    this.getScope().fail(b);
                }
                notNull.setLocation();
                this.loadProperty(b, chained.getChainedProperty(i));
            }
        }

        private void loadProperty(CodeBuilder b, StorableProperty<?> property) {
            Method readMethod = property.getReadMethod();
            if (readMethod == null) {
                String readName = property.getReadMethodName();
                try {
                    readMethod = property.getEnclosingType().getDeclaredMethod(readName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Property \"" + property.getName() + "\" cannot be read");
                }
            }
            b.invoke(readMethod);
        }

        private void addPropertyFilter(CodeBuilder b, String fieldName, TypeDesc type, RelOp relOp) {
            TypeDesc primitiveType;
            TypeDesc fieldType = CodeGen.actualFieldType(type);
            if (type.getTypeCode() == 0) {
                LocalVariable actualValue = b.createLocalVariable("temp", type);
                b.storeLocal(actualValue);
                b.loadLocal(actualValue);
                Label notNull = b.createLabel();
                switch (relOp) {
                    default: {
                        b.ifNullBranch((Location)notNull, false);
                        b.loadThis();
                        b.loadField(fieldName, fieldType);
                        this.getScope().successIfNullElseFail(b, true);
                        break;
                    }
                    case NE: 
                    case GT: {
                        b.ifNullBranch((Location)notNull, false);
                        b.loadThis();
                        b.loadField(fieldName, fieldType);
                        this.getScope().successIfNullElseFail(b, false);
                        break;
                    }
                    case LT: {
                        this.getScope().failIfNull(b, true);
                        break;
                    }
                    case GE: {
                        this.getScope().successIfNull(b, true);
                    }
                }
                notNull.setLocation();
                b.loadThis();
                b.loadField(fieldName, fieldType);
                switch (relOp) {
                    default: {
                        this.getScope().failIfNull(b, true);
                        break;
                    }
                    case NE: 
                    case LE: 
                    case LT: {
                        this.getScope().successIfNull(b, true);
                    }
                }
                b.loadLocal(actualValue);
            }
            if ((primitiveType = type.toPrimitiveType()) == null) {
                b.loadThis();
                b.loadField(fieldName, fieldType);
                switch (relOp) {
                    default: {
                        if (fieldType.isArray()) {
                            String methodName;
                            TypeDesc arraysDesc = TypeDesc.forClass(Arrays.class);
                            TypeDesc componentType = fieldType.getComponentType();
                            TypeDesc arrayType = fieldType;
                            if (componentType.isArray()) {
                                methodName = "deepEquals";
                                arrayType = TypeDesc.OBJECT.toArrayType();
                            } else {
                                methodName = "equals";
                                if (!componentType.isPrimitive()) {
                                    arrayType = TypeDesc.OBJECT.toArrayType();
                                }
                            }
                            b.invokeStatic(arraysDesc, methodName, TypeDesc.BOOLEAN, new TypeDesc[]{arrayType, arrayType});
                        } else {
                            b.invokeVirtual(TypeDesc.OBJECT, "equals", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.OBJECT});
                        }
                        this.getScope().successIfZeroComparisonElseFail(b, relOp.reverse());
                        break;
                    }
                    case LE: 
                    case GT: 
                    case LT: 
                    case GE: {
                        b.invokeInterface(TypeDesc.forClass(Comparable.class), "compareTo", TypeDesc.INT, new TypeDesc[]{TypeDesc.OBJECT});
                        this.getScope().successIfZeroComparisonElseFail(b, relOp);
                        break;
                    }
                }
            } else {
                if (!type.isPrimitive()) {
                    b.convert(type, primitiveType);
                }
                if (primitiveType == TypeDesc.FLOAT) {
                    this.convertProperty(b, primitiveType, TypeDesc.INT);
                    primitiveType = TypeDesc.INT;
                } else if (primitiveType == TypeDesc.DOUBLE) {
                    this.convertProperty(b, primitiveType, TypeDesc.LONG);
                    primitiveType = TypeDesc.LONG;
                }
                b.loadThis();
                b.loadField(fieldName, fieldType);
                b.convert(fieldType, primitiveType);
                switch (primitiveType.getTypeCode()) {
                    default: {
                        this.getScope().successIfComparisonElseFail(b, relOp);
                        break;
                    }
                    case 11: {
                        b.math((byte)-108);
                        this.getScope().successIfZeroComparisonElseFail(b, relOp);
                    }
                }
            }
        }

        private static TypeDesc actualFieldType(TypeDesc type) {
            if (type.toPrimitiveType() == TypeDesc.FLOAT) {
                type = type.isPrimitive() ? TypeDesc.INT : TypeDesc.INT.toObjectType();
            } else if (type.toPrimitiveType() == TypeDesc.DOUBLE) {
                type = type.isPrimitive() ? TypeDesc.LONG : TypeDesc.LONG.toObjectType();
            }
            return type;
        }

        private void convertProperty(CodeBuilder b, TypeDesc fromType, TypeDesc toType) {
            TypeDesc fromPrimType = fromType.toPrimitiveType();
            if (fromPrimType != TypeDesc.FLOAT && fromPrimType != TypeDesc.DOUBLE) {
                b.convert(fromType, toType);
                return;
            }
            TypeDesc toPrimType = toType.toPrimitiveType();
            if (toPrimType != TypeDesc.INT && toPrimType != TypeDesc.LONG) {
                b.convert(fromType, toType);
                return;
            }
            Label done = b.createLabel();
            if (!fromType.isPrimitive() && !toType.isPrimitive()) {
                b.dup();
                Label notNull = b.createLabel();
                b.ifNullBranch((Location)notNull, false);
                b.pop();
                b.loadNull();
                b.branch((Location)done);
                notNull.setLocation();
            }
            b.convert(fromType, toPrimType, 1);
            Label box = b.createLabel();
            if (toPrimType == TypeDesc.INT) {
                b.dup();
                b.ifZeroComparisonBranch((Location)box, ">=");
                b.loadConstant(Integer.MAX_VALUE);
                b.math((byte)-126);
            } else {
                b.dup2();
                b.loadConstant(0L);
                b.math((byte)-108);
                b.ifZeroComparisonBranch((Location)box, ">=");
                b.loadConstant(Long.MAX_VALUE);
                b.math((byte)-125);
            }
            box.setLocation();
            b.convert(toPrimType, toType);
            done.setLocation();
        }

        private static class Scope {
            final Label mFailLocation;
            final Label mSuccessLocation;

            Scope(Label failLocation, Label successLocation) {
                this.mFailLocation = failLocation;
                this.mSuccessLocation = successLocation;
            }

            void fail(CodeBuilder b) {
                if (this.mFailLocation != null) {
                    b.branch((Location)this.mFailLocation);
                } else {
                    b.loadConstant(false);
                    b.returnValue(TypeDesc.BOOLEAN);
                }
            }

            void failIfNull(CodeBuilder b, boolean choice) {
                if (this.mFailLocation != null) {
                    b.ifNullBranch((Location)this.mFailLocation, choice);
                } else {
                    Label pass = b.createLabel();
                    b.ifNullBranch((Location)pass, !choice);
                    b.loadConstant(false);
                    b.returnValue(TypeDesc.BOOLEAN);
                    pass.setLocation();
                }
            }

            void success(CodeBuilder b) {
                if (this.mSuccessLocation != null) {
                    b.branch((Location)this.mSuccessLocation);
                } else {
                    b.loadConstant(true);
                    b.returnValue(TypeDesc.BOOLEAN);
                }
            }

            void successIfNull(CodeBuilder b, boolean choice) {
                if (this.mSuccessLocation != null) {
                    b.ifNullBranch((Location)this.mSuccessLocation, choice);
                } else {
                    Label pass = b.createLabel();
                    b.ifNullBranch((Location)pass, !choice);
                    b.loadConstant(true);
                    b.returnValue(TypeDesc.BOOLEAN);
                    pass.setLocation();
                }
            }

            void successIfNullElseFail(CodeBuilder b, boolean choice) {
                if (this.mSuccessLocation != null) {
                    b.ifNullBranch((Location)this.mSuccessLocation, choice);
                    this.fail(b);
                } else if (this.mFailLocation != null) {
                    b.ifNullBranch((Location)this.mFailLocation, !choice);
                    this.success(b);
                } else {
                    Label success = b.createLabel();
                    b.ifNullBranch((Location)success, choice);
                    b.loadConstant(false);
                    b.returnValue(TypeDesc.BOOLEAN);
                    success.setLocation();
                    b.loadConstant(true);
                    b.returnValue(TypeDesc.BOOLEAN);
                }
            }

            void successIfZeroComparisonElseFail(CodeBuilder b, RelOp relOp) {
                if (this.mSuccessLocation != null) {
                    b.ifZeroComparisonBranch((Location)this.mSuccessLocation, this.relOpToChoice(relOp));
                    this.fail(b);
                } else if (this.mFailLocation != null) {
                    b.ifZeroComparisonBranch((Location)this.mFailLocation, this.relOpToChoice(relOp.reverse()));
                    this.success(b);
                } else if (relOp == RelOp.NE) {
                    b.returnValue(TypeDesc.BOOLEAN);
                } else if (relOp == RelOp.EQ) {
                    b.loadConstant(1);
                    b.math((byte)126);
                    b.loadConstant(1);
                    b.math((byte)-126);
                    b.returnValue(TypeDesc.BOOLEAN);
                } else {
                    Label success = b.createLabel();
                    b.ifZeroComparisonBranch((Location)success, this.relOpToChoice(relOp));
                    b.loadConstant(false);
                    b.returnValue(TypeDesc.BOOLEAN);
                    success.setLocation();
                    b.loadConstant(true);
                    b.returnValue(TypeDesc.BOOLEAN);
                }
            }

            void successIfComparisonElseFail(CodeBuilder b, RelOp relOp) {
                if (this.mSuccessLocation != null) {
                    b.ifComparisonBranch((Location)this.mSuccessLocation, this.relOpToChoice(relOp));
                    this.fail(b);
                } else if (this.mFailLocation != null) {
                    b.ifComparisonBranch((Location)this.mFailLocation, this.relOpToChoice(relOp.reverse()));
                    this.success(b);
                } else {
                    Label success = b.createLabel();
                    b.ifComparisonBranch((Location)success, this.relOpToChoice(relOp));
                    b.loadConstant(false);
                    b.returnValue(TypeDesc.BOOLEAN);
                    success.setLocation();
                    b.loadConstant(true);
                    b.returnValue(TypeDesc.BOOLEAN);
                }
            }

            private String relOpToChoice(RelOp relOp) {
                switch (relOp) {
                    default: {
                        return "==";
                    }
                    case NE: {
                        return "!=";
                    }
                    case LT: {
                        return "<";
                    }
                    case GE: {
                        return ">=";
                    }
                    case GT: {
                        return ">";
                    }
                    case LE: 
                }
                return "<=";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Validator<S extends Storable>
    extends Visitor<S, Object, Object> {
        Validator() {
        }

        @Override
        public Object visit(PropertyFilter<S> filter, Object param) {
            ChainedProperty<S> chained = filter.getChainedProperty();
            switch (filter.getOperator()) {
                case EQ: 
                case NE: {
                    break;
                }
                default: {
                    TypeDesc typeDesc = TypeDesc.forClass(chained.getType()).toObjectType();
                    if (Comparable.class.isAssignableFrom(typeDesc.toClass())) break;
                    throw new UnsupportedOperationException("Property \"" + chained + "\" does not implement Comparable");
                }
            }
            this.checkForReadMethod(chained, chained.getPrimeProperty());
            for (int i = 0; i < chained.getChainCount(); ++i) {
                this.checkForReadMethod(chained, chained.getChainedProperty(i));
            }
            return null;
        }

        private void checkForReadMethod(ChainedProperty<S> chained, StorableProperty<?> property) {
            if (property.getReadMethod() == null) {
                String msg = chained.getChainCount() == 0 ? "Property \"" + property.getName() + "\" cannot be read" : "Property \"" + property.getName() + "\" of \"" + chained + "\" cannot be read";
                throw new UnsupportedOperationException(msg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory<S extends Storable> {
        public Cursor<S> newFilteredCursor(Cursor<S> var1, Object ... var2);
    }
}

