/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.cursor;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.cursor.AbstractCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerCursor<S>
extends AbstractCursor<S> {
    private final Cursor<S> mSource;
    private final Query.Controller mController;
    private byte mCount;

    public static <S> Cursor<S> apply(Cursor<S> source, Query.Controller controller) {
        return controller == null ? source : new ControllerCursor<S>(source, controller);
    }

    private ControllerCursor(Cursor<S> source, Query.Controller controller) {
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        if (controller == null) {
            throw new IllegalArgumentException("Controller is null");
        }
        this.mSource = source;
        this.mController = controller;
        controller.begin();
    }

    @Override
    public boolean hasNext() throws FetchException {
        if (this.mSource.hasNext()) {
            this.continueCheck();
            return true;
        }
        return false;
    }

    @Override
    public S next() throws FetchException {
        S next = this.mSource.next();
        this.continueCheck();
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FetchException {
        try {
            this.mSource.close();
        }
        finally {
            this.mController.close();
        }
    }

    private void continueCheck() throws FetchException {
        this.mCount = (byte)(this.mCount + 1);
        if (this.mCount == 0) {
            try {
                this.mController.continueCheck();
            }
            catch (FetchException e) {
                try {
                    this.close();
                }
                catch (FetchException fetchException) {
                    // empty catch block
                }
                throw e;
            }
        }
    }
}

