/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.constraint;

import com.amazon.carbonado.MalformedTypeException;
import com.amazon.carbonado.constraint.ConstraintDefinition;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@ConstraintDefinition
public @interface TextConstraint {
    public String[] allowed() default {};

    public String[] disallowed() default {};

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Constraint {
        private final String mPropertyName;
        private final String[] mAllowed;
        private final String[] mDisallowed;

        public Constraint(Class<?> type, String propertyName, TextConstraint ann) {
            this(type, propertyName, ann.allowed(), ann.disallowed());
        }

        public Constraint(Class<?> type, String propertyName, String[] allowed, String[] disallowed) {
            this.mPropertyName = propertyName;
            if (disallowed == null || disallowed.length == 0) {
                disallowed = null;
            } else {
                disallowed = (String[])disallowed.clone();
                Arrays.sort(disallowed);
            }
            if (allowed == null || allowed.length == 0) {
                allowed = null;
            } else {
                allowed = (String[])allowed.clone();
                Arrays.sort(allowed);
                if (disallowed != null) {
                    for (String value : allowed) {
                        if (Arrays.binarySearch(disallowed, value) < 0) continue;
                        throw new MalformedTypeException(type, "Allowed value contradiction for text constraint on property \"" + propertyName + "\": " + value);
                    }
                    disallowed = null;
                }
            }
            this.mDisallowed = disallowed;
            this.mAllowed = allowed;
        }

        public void constrain(CharSequence propertyValue) {
            this.constrain(((Object)propertyValue).toString());
        }

        public void constrain(String propertyValue) {
            if (propertyValue == null) {
                return;
            }
            if (this.mDisallowed != null && Arrays.binarySearch(this.mDisallowed, propertyValue) >= 0) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is disallowed: " + propertyValue);
            }
            if (this.mAllowed != null && Arrays.binarySearch(this.mAllowed, propertyValue) < 0) {
                throw new IllegalArgumentException("Value for \"" + this.mPropertyName + "\" is not allowed: " + propertyValue);
            }
        }

        public void constrain(char propertyValue) {
            this.constrain(Character.toString(propertyValue));
        }

        public void constrain(char[] propertyValue) {
            if (propertyValue != null) {
                this.constrain(new String(propertyValue));
            }
        }
    }
}

