/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.BTreeStatDefinition;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.CursorsExistException;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.SplitRequiredException;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.RelatchRequiredException;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tree
implements Loggable {
    private static final String TRACE_ROOT_SPLIT = "RootSplit:";
    private DatabaseImpl database;
    private ChildReference root;
    private int maxTreeEntriesPerNode;
    private StatGroup stats;
    private IntStat rootSplits;
    private LongStat relatchesRequired;
    private SharedLatch rootLatch;
    private ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL = new ThreadLocal();
    private static SplitRequiredException splitRequiredException = new SplitRequiredException();
    private TestHook waitHook;
    private TestHook searchHook;
    private TestHook ckptHook;

    public Tree(DatabaseImpl database) {
        this.init(database);
        this.setDatabase(database);
    }

    public Tree() {
        this.init(null);
        this.maxTreeEntriesPerNode = 0;
    }

    private void init(DatabaseImpl database) {
        this.rootLatch = new SharedLatch("RootLatch");
        this.root = null;
        this.database = database;
        this.stats = new StatGroup("BTree", "Composition of btree, types and counts of nodes.");
        this.relatchesRequired = new LongStat(this.stats, BTreeStatDefinition.BTREE_RELATCHES_REQUIRED);
        this.rootSplits = new IntStat(this.stats, BTreeStatDefinition.BTREE_ROOT_SPLITS);
    }

    public void setDatabase(DatabaseImpl database) {
        this.database = database;
        this.maxTreeEntriesPerNode = database.getNodeMaxTreeEntries();
    }

    public DatabaseImpl getDatabase() {
        return this.database;
    }

    public void setRoot(ChildReference newRoot, boolean notLatched) {
        assert (notLatched || this.rootLatch.isWriteLockedByCurrentThread());
        this.root = newRoot;
    }

    public ChildReference makeRootChildReference(Node target, byte[] key, long lsn) {
        return new RootChildReference(target, key, lsn);
    }

    private ChildReference makeRootChildReference() {
        return new RootChildReference();
    }

    public boolean rootExists() {
        if (this.root == null) {
            return false;
        }
        return this.root.getTarget() != null || this.root.getLsn() != -1L;
    }

    public boolean isRootResident() {
        return this.root != null && this.root.getTarget() != null;
    }

    public long getRootLsn() {
        if (this.root == null) {
            return -1L;
        }
        return this.root.getLsn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxLNs() {
        int topLevelSlots;
        int levels;
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            levels = rootIN.getLevel() & 0xFFFF;
            topLevelSlots = rootIN.getNEntries();
            Object var5_4 = null;
            this.rootLatch.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.rootLatch.release();
            throw throwable;
        }
        return (long)((double)topLevelSlots * Math.pow(this.database.getNodeMaxTreeEntries(), levels - 1));
    }

    int getTreeStats() {
        return this.rootSplits.get();
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.treeStatsAccumulatorTL.set(tSA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedExclusive(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireExclusive();
            IN iN = wrl.doWork(this.root);
            Object var4_3 = null;
            this.rootLatch.release();
            return iN;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rootLatch.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedShared(WithRootLatched wrl) throws DatabaseException {
        try {
            this.rootLatch.acquireShared();
            IN iN = wrl.doWork(this.root);
            Object var4_3 = null;
            this.rootLatch.release();
            return iN;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rootLatch.release();
            throw throwable;
        }
    }

    public void latchRootLatchExclusive() throws DatabaseException {
        this.rootLatch.acquireExclusive();
    }

    public void releaseRootLatch() throws DatabaseException {
        this.rootLatch.releaseIfOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(byte[] idKey, LocalUtilizationTracker localTracker) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        boolean rootNeedsUpdating;
        IN rootIN;
        ArrayList<SplitInfo> nodeLadder;
        IN subtreeRootIN;
        INList inList;
        EnvironmentImpl envImpl;
        block13: {
            block12: {
                envImpl = this.database.getDbEnvironment();
                inList = envImpl.getInMemoryINs();
                subtreeRootIN = null;
                nodeLadder = new ArrayList<SplitInfo>();
                rootIN = null;
                rootNeedsUpdating = false;
                this.rootLatch.acquireExclusive();
                try {
                    if (!this.rootExists()) {
                        Object var12_9 = null;
                        break block12;
                    }
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                    rootIN.latch(CacheMode.UNCHANGED);
                    this.searchDeletableSubTree(rootIN, idKey, nodeLadder);
                    if (nodeLadder.size() != 0) {
                        SplitInfo detachPoint = nodeLadder.get(nodeLadder.size() - 1);
                        boolean deleteOk = detachPoint.parent.deleteEntry(detachPoint.index, true);
                        assert (deleteOk);
                        subtreeRootIN = detachPoint.child;
                        if (this.database.isDeferredWriteMode()) {
                            subtreeRootIN.accountForDeferredWriteSubtreeRemoval(inList, detachPoint.parent);
                        }
                        rootNeedsUpdating = this.cascadeUpdates(nodeLadder, -1);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    this.releaseNodeLadderLatches(nodeLadder);
                    if (rootIN != null) {
                        rootIN.releaseLatch();
                    }
                    this.rootLatch.release();
                    throw throwable;
                }
            }
            this.releaseNodeLadderLatches(nodeLadder);
            if (rootIN != null) {
                rootIN.releaseLatch();
            }
            this.rootLatch.release();
            return;
        }
        Object var12_10 = null;
        this.releaseNodeLadderLatches(nodeLadder);
        if (rootIN != null) {
            rootIN.releaseLatch();
        }
        this.rootLatch.release();
        if (subtreeRootIN != null) {
            if (rootNeedsUpdating) {
                envImpl.getDbTree().optionalModifyDbRoot(this.database);
                RecoveryManager.traceRootDeletion(envImpl.getLogger(), this.database);
            }
            if (!this.database.isDeferredWriteMode()) {
                subtreeRootIN.accountForSubtreeRemoval(inList, localTracker);
            }
            LoggerUtils.envLogMsg(Level.FINE, envImpl, "SubtreeRemoval: subtreeRoot = " + subtreeRootIN.getNodeId());
        }
    }

    private void releaseNodeLadderLatches(ArrayList<SplitInfo> nodeLadder) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        while (iter.hasPrevious()) {
            SplitInfo info = iter.previous();
            info.child.releaseLatch();
        }
    }

    private boolean cascadeUpdates(ArrayList<SplitInfo> nodeLadder, int index) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        LogManager logManager = envImpl.getLogManager();
        long newLsn = -1L;
        SplitInfo info = null;
        while (iter.hasPrevious()) {
            info = iter.previous();
            if (newLsn != -1L) {
                info.parent.updateEntry(info.index, newLsn);
            }
            newLsn = info.parent.optionalLog(logManager);
        }
        boolean rootNeedsUpdating = false;
        if (info != null) {
            assert (info.parent.isDbRoot());
            assert (this.rootLatch.isWriteLockedByCurrentThread());
            this.root.updateLsnAfterOptionalLog(this.database, newLsn);
            rootNeedsUpdating = true;
        }
        return rootNeedsUpdating;
    }

    public IN getFirstNode(CacheMode cacheMode) throws DatabaseException {
        return this.search(null, SearchType.LEFT, null, cacheMode, null);
    }

    public IN getLastNode(CacheMode cacheMode) throws DatabaseException {
        return this.search(null, SearchType.RIGHT, null, cacheMode, null);
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, CacheMode cacheMode) throws DatabaseException {
        return this.getParentINForChildIN(child, requireExactMatch, cacheMode, -1, null);
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList) throws DatabaseException {
        if (child == null) {
            throw EnvironmentFailureException.unexpectedState("getParentNode passed null");
        }
        assert (child.isLatchOwnerForWrite());
        byte[] treeKey = child.getIdentifierKey();
        boolean isRoot = child.isRoot();
        child.releaseLatch();
        return this.getParentINForChildIN(child.getNodeId(), isRoot, treeKey, requireExactMatch, cacheMode, targetLevel, trackingList, true);
    }

    public SearchResult getParentINForChildIN(long targetNodeId, boolean targetIsRoot, byte[] targetTreeKey, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList, boolean doFetch) throws DatabaseException {
        IN rootIN = this.getRootINLatchedExclusive(cacheMode);
        SearchResult result = new SearchResult();
        if (rootIN != null) {
            if (trackingList != null) {
                trackingList.add(new TrackingInfo(this.root.getLsn(), rootIN.getNodeId(), rootIN.getNEntries()));
            }
            IN potentialParent = rootIN;
            boolean success = false;
            try {
                try {
                    while (result.keepSearching) {
                        assert (TestHookExecute.doHookIfSet(this.searchHook));
                        potentialParent.findParent(SearchType.NORMAL, targetNodeId, targetIsRoot, targetTreeKey, result, requireExactMatch, cacheMode, targetLevel, doFetch);
                        if (trackingList != null) {
                            trackingList.get(trackingList.size() - 1).setIndex(result.index);
                            if (result.keepSearching) {
                                trackingList.add(new TrackingInfo(potentialParent.getLsn(result.index), result.parent.getNodeId(), result.parent.getNEntries()));
                            }
                        }
                        potentialParent = result.parent;
                    }
                    success = true;
                }
                catch (RelatchRequiredException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                Object var16_13 = null;
                if (!success) {
                    potentialParent.releaseLatch();
                }
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (!success) {
                    potentialParent.releaseLatch();
                }
                throw throwable;
            }
        }
        return result;
    }

    public boolean getParentBINForChildLN(TreeLocation location, byte[] key, boolean splitsAllowed, boolean findDeletedEntries, CacheMode cacheMode) throws DatabaseException {
        location.reset();
        IN searchResult = splitsAllowed ? this.searchSplitsAllowed(key, cacheMode, null) : this.search(key, SearchType.NORMAL, null, cacheMode, null);
        if (searchResult == null) {
            return false;
        }
        try {
            location.bin = (BIN)searchResult;
            boolean exactSearch = false;
            boolean indicateIfExact = true;
            if (!findDeletedEntries) {
                exactSearch = true;
                indicateIfExact = false;
            }
            location.index = location.bin.findEntry(key, indicateIfExact, exactSearch);
            boolean match = false;
            if (findDeletedEntries) {
                match = location.index >= 0 && (location.index & 0x10000) != 0;
                location.index &= 0xFFFEFFFF;
            } else {
                boolean bl = match = location.index >= 0;
            }
            if (match) {
                location.childLsn = location.bin.getLsn(location.index);
                return true;
            }
            location.lnKey = key;
            return false;
        }
        catch (RuntimeException e) {
            searchResult.releaseLatch();
            throw e;
        }
    }

    public BIN getNextBin(BIN bin, CacheMode cacheMode) throws DatabaseException {
        return this.getNextBinInternal(bin, true, cacheMode);
    }

    public BIN getPrevBin(BIN bin, CacheMode cacheMode) throws DatabaseException {
        return this.getNextBinInternal(bin, false, cacheMode);
    }

    private BIN getNextBinInternal(BIN bin, boolean forward, CacheMode cacheMode) throws DatabaseException {
        byte[] idKey = null;
        idKey = bin.getNEntries() == 0 ? bin.getIdentifierKey() : (forward ? bin.getKey(bin.getNEntries() - 1) : bin.getKey(0));
        IN next = bin;
        boolean nextIsLatched = false;
        assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
        IN parent = null;
        IN nextIN = null;
        boolean nextINIsLatched = false;
        try {
            while (true) {
                SearchResult result = null;
                nextIsLatched = false;
                result = this.getParentINForChildIN(next, true, cacheMode);
                if (!result.exactParentFound) {
                    assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString();
                    return null;
                }
                parent = result.parent;
                assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
                int index = parent.findEntry(idKey, false, false);
                boolean moreEntriesThisBin = false;
                if (forward) {
                    if (++index < parent.getNEntries()) {
                        moreEntriesThisBin = true;
                    }
                } else {
                    if (index > 0) {
                        moreEntriesThisBin = true;
                    }
                    --index;
                }
                if (moreEntriesThisBin) {
                    nextIN = (IN)parent.fetchTargetWithExclusiveLatch(index);
                    nextIN.latch(cacheMode);
                    nextINIsLatched = true;
                    assert (LatchSupport.countLatchesHeld() == 2) : LatchSupport.latchesHeldToString();
                    if (nextIN.isBIN()) {
                        parent.releaseLatch();
                        parent = null;
                        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                        if (treeStatsAccumulator != null) {
                            nextIN.accumulateStats(treeStatsAccumulator);
                        }
                        return (BIN)nextIN;
                    }
                    IN ret = this.searchSubTree(nextIN, null, forward ? SearchType.LEFT : SearchType.RIGHT, null, cacheMode, null);
                    nextINIsLatched = false;
                    parent.releaseLatch();
                    parent = null;
                    assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
                    if (ret.isBIN()) {
                        return (BIN)ret;
                    }
                    throw EnvironmentFailureException.unexpectedState("subtree did not have a BIN for leaf");
                }
                next = parent;
                nextIsLatched = true;
                parent = null;
            }
        }
        catch (DatabaseException e) {
            if (next != null && nextIsLatched) {
                next.releaseLatch();
            }
            if (parent != null) {
                parent.releaseLatch();
            }
            if (nextIN != null && nextINIsLatched) {
                nextIN.releaseLatch();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitRoot(CacheMode cacheMode) throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        IN curRoot = null;
        curRoot = (IN)this.root.fetchTarget(this.database, null);
        curRoot.latch(cacheMode);
        long curRootLsn = 0L;
        long logLsn = 0L;
        IN newRoot = null;
        try {
            byte[] rootIdKey = curRoot.getKey(0);
            newRoot = new IN(this.database, rootIdKey, this.maxTreeEntriesPerNode, curRoot.getLevel() + 1);
            newRoot.latch(cacheMode);
            newRoot.setIsRoot(true);
            curRoot.setIsRoot(false);
            try {
                curRootLsn = curRoot.optionalLogProvisional(logManager, newRoot);
                boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, curRootLsn));
                assert (insertOk);
                logLsn = newRoot.optionalLog(logManager);
            }
            catch (DatabaseException e) {
                curRoot.setIsRoot(true);
                throw e;
            }
            inMemoryINs.add(newRoot);
            this.root.setTarget(newRoot);
            this.root.updateLsnAfterOptionalLog(this.database, logLsn);
            curRoot.split(newRoot, 0, this.maxTreeEntriesPerNode, cacheMode);
            this.root.setLsn(newRoot.getLastLoggedVersion());
            Object var14_12 = null;
            newRoot.releaseLatch();
            curRoot.releaseLatch();
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            newRoot.releaseLatch();
            curRoot.releaseLatch();
            throw throwable;
        }
        this.rootSplits.increment();
        this.traceSplitRoot(Level.FINE, TRACE_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
    }

    public IN search(byte[] key, SearchType searchType, BINBoundary binBoundary, CacheMode cacheMode, Comparator<byte[]> searchComparator) {
        IN rootIN = this.getRootIN(cacheMode);
        if (rootIN != null) {
            return this.searchSubTree(rootIN, key, searchType, binBoundary, cacheMode, searchComparator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN searchSplitsAllowed(byte[] key, CacheMode cacheMode, Comparator<byte[]> searchComparator) {
        IN insertTarget = null;
        block6: while (insertTarget == null) {
            Object var12_13;
            this.rootLatch.acquireShared();
            boolean rootLatched = true;
            boolean rootLatchedExclusive = false;
            boolean rootINLatched = false;
            boolean success = false;
            IN rootIN = null;
            try {
                while (this.rootExists()) {
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                    if (rootIN.needsSplitting()) {
                        if (!rootLatchedExclusive) {
                            rootIN = null;
                            this.rootLatch.release();
                            this.rootLatch.acquireExclusive();
                            rootLatchedExclusive = true;
                            continue;
                        }
                        this.splitRoot(cacheMode);
                        this.rootLatch.release();
                        rootLatched = false;
                        EnvironmentImpl env = this.database.getDbEnvironment();
                        env.getDbTree().optionalModifyDbRoot(this.database);
                        rootLatched = true;
                        this.rootLatch.acquireExclusive();
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                        rootIN.latch(cacheMode);
                    } else {
                        rootIN.latchShared(cacheMode);
                    }
                    rootINLatched = true;
                    break;
                }
                success = true;
                var12_13 = null;
                if (!success && rootINLatched) {
                    rootIN.releaseLatch();
                }
                if (rootLatched) {
                    this.rootLatch.release();
                }
            }
            catch (Throwable throwable) {
                var12_13 = null;
                if (!success && rootINLatched) {
                    rootIN.releaseLatch();
                }
                if (rootLatched) {
                    this.rootLatch.release();
                }
                throw throwable;
            }
            if (rootIN == null) break;
            try {
                assert (rootINLatched);
                while (true) {
                    try {
                        insertTarget = this.searchSubTreeSplitsAllowed(rootIN, key, cacheMode, searchComparator);
                        continue block6;
                    }
                    catch (RelatchRequiredException RRE) {
                        this.relatchesRequired.increment();
                        this.database.getDbEnvironment().incRelatchesRequired();
                        this.rootLatch.acquireExclusive();
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                        rootIN.latch(cacheMode);
                        this.rootLatch.release();
                        continue;
                    }
                    break;
                }
            }
            catch (SplitRequiredException e) {
            }
        }
        return insertTarget;
    }

    public void loadStats(StatsConfig config, BtreeStats btreeStats) {
        btreeStats.setTreeStats(this.stats.cloneGroup(false));
        if (config.getClear()) {
            this.relatchesRequired.clear();
        }
    }

    private IN searchSubTree(IN parent, byte[] key, SearchType searchType, BINBoundary binBoundary, CacheMode cacheMode, Comparator<byte[]> searchComparator) {
        assert (parent == null || parent.isRoot() || parent.isLatchOwnerForWrite());
        for (int i = 0; i < 2; ++i) {
            try {
                return this.searchSubTreeInternal(parent, key, searchType, binBoundary, cacheMode, searchComparator);
            }
            catch (RelatchRequiredException RRE) {
                parent = this.getRootINLatchedExclusive(cacheMode);
                continue;
            }
        }
        throw EnvironmentFailureException.unexpectedState("searchSubTreeInternal should have completed in two tries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IN searchSubTreeInternal(IN parent, byte[] key, SearchType searchType, BINBoundary binBoundary, CacheMode cacheMode, Comparator<byte[]> searchComparator) throws RelatchRequiredException {
        block40: {
            block38: {
                block36: {
                    block37: {
                        if (parent == null) {
                            return null;
                        }
                        if ((searchType == SearchType.LEFT || searchType == SearchType.RIGHT) && key != null) {
                            throw EnvironmentFailureException.unexpectedState("searchSubTree passed key and left/right search");
                        }
                        if (!Tree.$assertionsDisabled && !parent.isLatchOwnerForRead()) {
                            throw new AssertionError();
                        }
                        if (binBoundary != null) {
                            binBoundary.isLastBin = true;
                            binBoundary.isFirstBin = true;
                        }
                        child = null;
                        grandParent = null;
                        childIsLatched = false;
                        grandParentIsLatched = false;
                        maintainGrandParentLatches = parent.isLatchOwnerForWrite() == false;
                        treeStatsAccumulator = this.getTreeStatsAccumulator();
                        success = false;
                        try {
                            do {
                                if (treeStatsAccumulator != null) {
                                    parent.accumulateStats(treeStatsAccumulator);
                                }
                                if (parent.getNEntries() == 0) {
                                    success = true;
                                    var15_15 = parent;
                                    var17_17 = null;
                                    if (success) break block36;
                                    break block37;
                                }
                                if (searchType == SearchType.NORMAL) {
                                    index = parent.findEntry(key, false, false, searchComparator);
                                } else if (searchType == SearchType.LEFT) {
                                    index = 0;
                                } else {
                                    if (searchType != SearchType.RIGHT) throw EnvironmentFailureException.unexpectedState("Invalid value of searchType: " + searchType);
                                    index = parent.getNEntries() - 1;
                                }
                                if (!Tree.$assertionsDisabled && index < 0) {
                                    throw new AssertionError();
                                }
                                if (binBoundary != null) {
                                    if (index != parent.getNEntries() - 1) {
                                        binBoundary.isLastBin = false;
                                    }
                                    if (index != 0) {
                                        binBoundary.isFirstBin = false;
                                    }
                                }
                                if (maintainGrandParentLatches && parent.getTarget(index) == null && !parent.isAlwaysLatchedExclusively()) {
                                    if (grandParent == null) {
                                        throw RelatchRequiredException.relatchRequiredException;
                                    }
                                    parent.releaseLatch();
                                    parent.latch(cacheMode);
                                    grandParent.releaseLatch();
                                    grandParentIsLatched = false;
                                    grandParent = null;
                                }
                                child = (IN)parent.fetchTarget(index);
                                if (grandParent != null) {
                                    grandParent.releaseLatch();
                                    grandParentIsLatched = false;
                                }
                                if (maintainGrandParentLatches) {
                                    child.latchShared(cacheMode);
                                } else {
                                    child.latch(cacheMode);
                                }
                                childIsLatched = true;
                                if (treeStatsAccumulator != null) {
                                    child.accumulateStats(treeStatsAccumulator);
                                }
                                if (maintainGrandParentLatches) {
                                    grandParent = parent;
                                    grandParentIsLatched = true;
                                    continue;
                                }
                                parent.releaseLatch();
                            } while (!(parent = child).isBIN());
                            success = true;
                            var15_16 = child;
                            break block38;
                        }
                        catch (Throwable var16_23) {
                            var17_19 = null;
                            if (!success) {
                                try {
                                    if (child != null && childIsLatched) {
                                        child.releaseLatch();
                                    }
                                    if (parent != child) {
                                        parent.releaseLatch();
                                    }
                                }
                                catch (Exception e) {
                                    LoggerUtils.traceAndLogException(this.database.getDbEnvironment(), "Tree", "searchSubTreeInternal", "", e);
                                }
                            }
                            if (grandParent == null) throw var16_23;
                            if (grandParentIsLatched == false) throw var16_23;
                            grandParent.releaseLatch();
                            grandParentIsLatched = false;
                            throw var16_23;
                        }
                    }
                    ** try [egrp 1[TRYBLOCK] [3 : 428->456)] { 
lbl92:
                    // 1 sources

                    if (child != null && childIsLatched) {
                        child.releaseLatch();
                    }
                    if (parent != child) {
                        parent.releaseLatch();
                    }
                    break block36;
lbl97:
                    // 1 sources

                    catch (Exception e) {
                        LoggerUtils.traceAndLogException(this.database.getDbEnvironment(), "Tree", "searchSubTreeInternal", "", e);
                    }
                }
                if (grandParent == null) return var15_15;
                if (grandParentIsLatched == false) return var15_15;
                grandParent.releaseLatch();
                return var15_15;
            }
            var17_18 = null;
            if (!success) {
                ** try [egrp 1[TRYBLOCK] [3 : 428->456)] { 
lbl108:
                // 1 sources

                if (child != null && childIsLatched) {
                    child.releaseLatch();
                }
                if (parent != child) {
                    parent.releaseLatch();
                }
                break block40;
lbl113:
                // 1 sources

                catch (Exception e) {
                    LoggerUtils.traceAndLogException(this.database.getDbEnvironment(), "Tree", "searchSubTreeInternal", "", e);
                }
            }
        }
        if (grandParent == null) return var15_16;
        if (grandParentIsLatched == false) return var15_16;
        grandParent.releaseLatch();
        return var15_16;
    }

    public void searchDeletableSubTree(IN parent, byte[] key, ArrayList<SplitInfo> nodeLadder) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        assert (parent != null);
        assert (key != null);
        assert (((IN)parent).isLatchOwnerForWrite());
        Node child = null;
        IN lowestMultipleEntryIN = null;
        while (((IN)parent).getNEntries() != 0) {
            if (((IN)parent).getNEntries() > 1) {
                lowestMultipleEntryIN = parent;
            }
            int index = ((IN)parent).findEntry(key, false, false);
            assert (index >= 0);
            child = (IN)((IN)parent).fetchTargetWithExclusiveLatch(index);
            ((IN)child).latch(CacheMode.UNCHANGED);
            nodeLadder.add(new SplitInfo((IN)parent, (IN)child, index));
            parent = child;
            if (!parent.isBIN()) continue;
        }
        if (child != null && child.isBIN()) {
            if (((IN)child).getNEntries() != 0) {
                throw NodeNotEmptyException.NODE_NOT_EMPTY;
            }
            if (((BIN)child).nCursors() > 0) {
                throw CursorsExistException.CURSORS_EXIST;
            }
        }
        if (lowestMultipleEntryIN != null) {
            ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
            while (iter.hasPrevious()) {
                SplitInfo info = iter.previous();
                if (info.parent != lowestMultipleEntryIN) {
                    info.child.releaseLatch();
                    iter.remove();
                    continue;
                }
                break;
            }
        } else {
            this.releaseNodeLadderLatches(nodeLadder);
            nodeLadder.clear();
        }
    }

    private IN searchSubTreeSplitsAllowed(IN parent, byte[] key, CacheMode cacheMode, Comparator<byte[]> searchComparator) throws RelatchRequiredException, SplitRequiredException {
        if (parent != null) {
            while (true) {
                try {
                    return this.searchSubTreeUntilSplit(parent, key, cacheMode, searchComparator);
                }
                catch (SplitRequiredException e) {
                    assert (TestHookExecute.doHookIfSet(this.waitHook));
                    parent = this.forceSplit(parent, key, cacheMode);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IN searchSubTreeUntilSplit(IN parent, byte[] key, CacheMode cacheMode, Comparator<byte[]> searchComparator) throws RelatchRequiredException, SplitRequiredException {
        IN iN;
        boolean latchingIsExclusive = parent.isLatchOwnerForWrite();
        IN child = null;
        boolean childIsLatched = false;
        boolean success = false;
        try {
            do {
                if (parent.getNEntries() == 0) {
                    success = true;
                    IN iN2 = parent;
                    Object var12_12 = null;
                    if (success) return iN2;
                    if (child != null && childIsLatched) {
                        child.releaseLatch();
                    }
                    if (parent == child) return iN2;
                    parent.releaseLatch();
                    return iN2;
                }
                int index = parent.findEntry(key, false, false, searchComparator);
                assert (index >= 0);
                child = (IN)parent.fetchTarget(index);
                if (latchingIsExclusive) {
                    child.latch(cacheMode);
                } else {
                    child.latchShared(cacheMode);
                }
                childIsLatched = true;
                if (child.needsSplitting()) {
                    this.database.getDbEnvironment().lazyCompress(child);
                    if (child.needsSplitting()) {
                        throw splitRequiredException;
                    }
                }
                parent.releaseLatch();
            } while (!(parent = child).isBIN());
            success = true;
            iN = parent;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (success) throw throwable;
            if (child != null && childIsLatched) {
                child.releaseLatch();
            }
            if (parent == child) throw throwable;
            parent.releaseLatch();
            throw throwable;
        }
        Object var12_13 = null;
        if (success) return iN;
        if (child != null && childIsLatched) {
            child.releaseLatch();
        }
        if (parent == child) return iN;
        parent.releaseLatch();
        return iN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN forceSplit(IN parent, byte[] key, CacheMode cacheMode) throws DatabaseException, SplitRequiredException {
        boolean isRootLatched;
        IN originalParent;
        block24: {
            block25: {
                ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
                boolean allLeftSideDescent = true;
                boolean allRightSideDescent = true;
                IN child = null;
                originalParent = parent;
                ListIterator iter = null;
                isRootLatched = false;
                boolean success = false;
                try {
                    int index;
                    if (originalParent.isDbRoot()) {
                        this.rootLatch.acquireExclusive();
                        isRootLatched = true;
                        originalParent = parent = (IN)this.root.fetchTarget(this.database, null);
                    }
                    originalParent.latch(cacheMode);
                    if (originalParent.needsSplitting() || !originalParent.isRoot()) {
                        throw splitRequiredException;
                    }
                    while (parent.getNEntries() != 0) {
                        index = parent.findEntry(key, false, false);
                        if (index != 0) {
                            allLeftSideDescent = false;
                        }
                        if (index != parent.getNEntries() - 1) {
                            allRightSideDescent = false;
                        }
                        assert (index >= 0);
                        child = (IN)parent.getTarget(index);
                        if (child == null) break;
                        child.latch(cacheMode);
                        nodeLadder.add(new SplitInfo(parent, child, index));
                        parent = child;
                        if (!parent.isBIN()) continue;
                    }
                    boolean startedSplits = false;
                    LogManager logManager = this.database.getDbEnvironment().getLogManager();
                    iter = nodeLadder.listIterator(nodeLadder.size());
                    long lastParentForSplit = -1L;
                    while (iter.hasPrevious()) {
                        SplitInfo info = (SplitInfo)iter.previous();
                        iter.remove();
                        child = info.child;
                        parent = info.parent;
                        index = info.index;
                        if (child.needsSplitting()) {
                            if (allLeftSideDescent || allRightSideDescent) {
                                child.splitSpecial(parent, index, this.maxTreeEntriesPerNode, key, allLeftSideDescent, cacheMode);
                            } else {
                                child.split(parent, index, this.maxTreeEntriesPerNode, cacheMode);
                            }
                            lastParentForSplit = parent.getNodeId();
                            startedSplits = true;
                            if (parent.isDbRoot()) {
                                assert (isRootLatched);
                                this.root.setLsn(parent.getLastLoggedVersion());
                                parent.setDirty(true);
                            }
                        } else if (startedSplits) {
                            long newLsn = 0L;
                            newLsn = lastParentForSplit == child.getNodeId() ? child.getLastLoggedVersion() : child.optionalLog(logManager);
                            parent.updateEntry(index, newLsn);
                        }
                        child.releaseLatch();
                        child = null;
                    }
                    success = true;
                    Object var21_18 = null;
                    if (success) break block24;
                    if (child != null) {
                        child.releaseLatch();
                    }
                    if (nodeLadder.size() <= 0) break block25;
                    iter = nodeLadder.listIterator(nodeLadder.size());
                }
                catch (Throwable throwable) {
                    Object var21_19 = null;
                    if (!success) {
                        if (child != null) {
                            child.releaseLatch();
                        }
                        if (nodeLadder.size() > 0) {
                            iter = nodeLadder.listIterator(nodeLadder.size());
                            while (iter.hasPrevious()) {
                                SplitInfo info = (SplitInfo)iter.previous();
                                info.child.releaseLatch();
                            }
                        }
                        originalParent.releaseLatch();
                    }
                    if (isRootLatched) {
                        this.rootLatch.release();
                    }
                    throw throwable;
                }
                while (iter.hasPrevious()) {
                    SplitInfo info = (SplitInfo)iter.previous();
                    info.child.releaseLatch();
                }
            }
            originalParent.releaseLatch();
        }
        if (isRootLatched) {
            this.rootLatch.release();
        }
        return originalParent;
    }

    public IN getRootIN(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, false);
    }

    public IN getRootINLatchedExclusive(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN getRootINInternal(CacheMode cacheMode, boolean exclusive) throws DatabaseException {
        this.rootLatch.acquireShared();
        IN rootIN = null;
        try {
            if (this.rootExists()) {
                rootIN = (IN)this.root.fetchTarget(this.database, null);
                if (exclusive) {
                    rootIN.latch(cacheMode);
                } else {
                    rootIN.latchShared(cacheMode);
                }
            }
            IN iN = rootIN;
            Object var6_5 = null;
            this.rootLatch.release();
            return iN;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.rootLatch.release();
            throw throwable;
        }
    }

    public IN getResidentRootIN(boolean latched) throws DatabaseException {
        IN rootIN = null;
        if (this.rootExists() && (rootIN = (IN)this.root.getTarget()) != null && latched) {
            rootIN.latchShared(CacheMode.UNCHANGED);
        }
        return rootIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findBinForInsert(byte[] key, CursorImpl cursor) {
        BIN bin = cursor.latchBIN();
        if (bin != null) {
            if (!bin.needsSplitting() && bin.isKeyInBounds(key)) {
                return;
            }
            bin.releaseLatch();
        }
        boolean rootLatchIsHeld = false;
        try {
            block11: {
                IN in;
                while (true) {
                    rootLatchIsHeld = true;
                    this.rootLatch.acquireShared();
                    if (!this.rootExists()) {
                        this.rootLatch.release();
                        this.rootLatch.acquireExclusive();
                        if (this.rootExists()) {
                            this.rootLatch.release();
                            rootLatchIsHeld = false;
                            continue;
                        }
                        CacheMode cacheMode = cursor.getCacheMode();
                        EnvironmentImpl env = this.database.getDbEnvironment();
                        LogManager logManager = env.getLogManager();
                        INList inMemoryINs = env.getInMemoryINs();
                        bin = new BIN(this.database, key, this.maxTreeEntriesPerNode, 1);
                        bin.latch(cacheMode);
                        long logLsn = bin.optionalLogProvisional(logManager, null);
                        IN rootIN = new IN(this.database, key, this.maxTreeEntriesPerNode, 2);
                        rootIN.latch(cacheMode);
                        rootIN.setIsRoot(true);
                        boolean insertOk = rootIN.insertEntry(new ChildReference(bin, key, logLsn));
                        assert (insertOk);
                        logLsn = rootIN.optionalLog(logManager);
                        rootIN.setDirty(true);
                        this.root = this.makeRootChildReference(rootIN, new byte[0], logLsn);
                        rootIN.releaseLatch();
                        inMemoryINs.add(bin);
                        inMemoryINs.add(rootIN);
                        this.rootLatch.release();
                        rootLatchIsHeld = false;
                        break block11;
                    }
                    this.rootLatch.release();
                    rootLatchIsHeld = false;
                    in = this.searchSplitsAllowed(key, cursor.getCacheMode(), null);
                    if (in != null) break;
                }
                bin = (BIN)in;
            }
            Object var14_12 = null;
            if (rootLatchIsHeld) {
                this.rootLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            if (rootLatchIsHeld) {
                this.rootLatch.release();
            }
            throw throwable;
        }
        assert (TestHookExecute.doHookIfSet(this.ckptHook));
        cursor.setBIN(bin);
    }

    @Override
    public int getLogSize() {
        int size = 1;
        if (this.root != null) {
            size += this.root.getLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        byte booleans = (byte)(this.root != null ? 1 : 0);
        logBuffer.put(booleans);
        if (this.root != null) {
            this.root.writeToLog(logBuffer);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean rootExists = false;
        byte booleans = itemBuffer.get();
        boolean bl = rootExists = (booleans & 1) != 0;
        if (rootExists) {
            this.root = this.makeRootChildReference();
            this.root.readFromLog(itemBuffer, entryVersion);
        }
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<root>");
        if (this.root != null) {
            this.root.dumpLog(sb, verbose);
        }
        sb.append("</root>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildINList() throws DatabaseException {
        INList inMemoryList = this.database.getDbEnvironment().getInMemoryINs();
        if (this.root != null) {
            this.rootLatch.acquireShared();
            try {
                Node rootIN = this.root.getTarget();
                if (rootIN != null) {
                    rootIN.rebuildINList(inMemoryList);
                }
                Object var4_3 = null;
                this.rootLatch.release();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.rootLatch.release();
                throw throwable;
            }
        }
    }

    public void dump() {
        System.out.println(this.dumpString(0));
    }

    public String dumpString(int nSpaces) {
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<tree>");
        sb.append('\n');
        if (this.root != null) {
            sb.append(DbLsn.dumpString(this.root.getLsn(), nSpaces));
            sb.append('\n');
            IN rootIN = (IN)this.root.getTarget();
            if (rootIN == null) {
                sb.append("<in/>");
            } else {
                sb.append(rootIN.toString());
            }
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("</tree>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateDelete(int index) throws DatabaseException {
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            boolean bl = rootIN.validateSubtreeBeforeDelete(index);
            Object var5_4 = null;
            this.rootLatch.release();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.rootLatch.release();
            throw throwable;
        }
    }

    public void validateINList(IN parent) throws DatabaseException {
        if (parent == null) {
            parent = (IN)this.root.getTarget();
        }
        if (parent != null) {
            INList inList = this.database.getDbEnvironment().getInMemoryINs();
            if (!inList.contains(parent)) {
                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " missing from INList");
            }
            int i = 0;
            while (true) {
                block9: {
                    try {
                        Node node = parent.getTarget(i);
                        if (i >= parent.getNEntries()) {
                            if (node != null) {
                                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " has stray node " + node + " at index " + i);
                            }
                            byte[] key = parent.getKey(i);
                            if (key != null) {
                                throw EnvironmentFailureException.unexpectedState("IN " + parent.getNodeId() + " has stray key " + key + " at index " + i);
                            }
                        }
                        if (!(node instanceof IN)) break block9;
                        this.validateINList((IN)node);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void setWaitHook(TestHook hook) {
        this.waitHook = hook;
    }

    public void setSearchHook(TestHook hook) {
        this.searchHook = hook;
    }

    public void setCkptHook(TestHook hook) {
        this.ckptHook = hook;
    }

    private void traceSplitRoot(Level level, String splitType, IN newRoot, long newRootLsn, IN oldRoot, long oldRootLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(splitType);
            sb.append(" newRoot=").append(newRoot.getNodeId());
            sb.append(" newRootLsn=").append(DbLsn.getNoFormatString(newRootLsn));
            sb.append(" oldRoot=").append(oldRoot.getNodeId());
            sb.append(" oldRootLsn=").append(DbLsn.getNoFormatString(oldRootLsn));
            LoggerUtils.logMsg(logger, this.database.getDbEnvironment(), level, sb.toString());
        }
    }

    private static class SplitInfo {
        IN parent;
        IN child;
        int index;

        SplitInfo(IN parent, IN child, int index) {
            this.parent = parent;
            this.child = child;
            this.index = index;
        }
    }

    private class RootChildReference
    extends ChildReference {
        private RootChildReference() {
        }

        private RootChildReference(Node target, byte[] key, long lsn) {
            super(target, key, lsn);
        }

        public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
            if (this.getTarget() == null && !Tree.this.rootLatch.isWriteLockedByCurrentThread()) {
                Tree.this.rootLatch.release();
                Tree.this.rootLatch.acquireExclusive();
            }
            return super.fetchTarget(database, in);
        }

        public void setTarget(Node target) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.setTarget(target);
        }

        public void clearTarget() {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.clearTarget();
        }

        public void setLsn(long lsn) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.setLsn(lsn);
        }

        void updateLsnAfterOptionalLog(DatabaseImpl dbImpl, long lsn) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.updateLsnAfterOptionalLog(dbImpl, lsn);
        }
    }

    public static class SearchType {
        public static final SearchType NORMAL = new SearchType();
        public static final SearchType LEFT = new SearchType();
        public static final SearchType RIGHT = new SearchType();

        private SearchType() {
        }
    }
}

