/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.tree.dupConvert.INDeleteInfo;
import com.sleepycat.je.tree.dupConvert.INDupDeleteInfo;
import com.sleepycat.je.txn.TxnChain;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnEnd;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilizationFileReader
extends FileReader {
    private static final boolean DEBUG = true;
    private final Map<Long, FileSummary> summaries = new HashMap<Long, FileSummary>();
    private final Map<Long, NodeInfo> activeINs = new HashMap<Long, NodeInfo>();
    private final Map<TxnChain.CompareSlot, NodeInfo> activeLNs = new TreeMap<TxnChain.CompareSlot, NodeInfo>();
    private final Map<Long, List<Object>> txns = new HashMap<Long, List<Object>>();
    private final List<Object> twoEntryList;
    private final Map<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
    private final DbTree dbTree;

    private UtilizationFileReader(EnvironmentImpl envImpl, int readBufferSize) throws DatabaseException {
        super(envImpl, readBufferSize, true, -1L, null, -1L, -1L);
        this.dbTree = envImpl.getDbTree();
        this.twoEntryList = new ArrayList<Object>();
        this.twoEntryList.add(null);
        this.twoEntryList.add(null);
    }

    @Override
    protected boolean isTargetEntry() {
        return this.currentEntryHeader.getType() != LogEntryType.LOG_FILE_HEADER.getTypeNum() && !this.currentEntryHeader.isInvisible();
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryHeader.getType());
        LogEntry entry = lastEntryType.getNewLogEntry();
        entry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
        ExtendedFileSummary summary = (ExtendedFileSummary)this.summaries.get(this.window.currentFileNum());
        if (summary == null) {
            summary = new ExtendedFileSummary();
            this.summaries.put(this.window.currentFileNum(), summary);
        }
        int size = this.getLastEntrySize();
        ++summary.totalCount;
        summary.totalSize += size;
        if (entry instanceof LNLogEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            int otherSize = lnEntry.getLastLoggedSize();
            if (size != otherSize) {
                System.out.println("LogReader.getLastEntrySize=" + size + " LNEntry.getLastLoggedSize=" + otherSize + " " + lnEntry.getLogType());
            }
            if (lastEntryType.isTransactional()) {
                Long txnId = lnEntry.getTransactionId();
                List<Object> txnEntries = this.txns.get(txnId);
                if (txnEntries == null) {
                    txnEntries = new ArrayList<Object>();
                    this.txns.put(txnId, txnEntries);
                }
                txnEntries.add(summary);
                txnEntries.add(lnEntry);
            } else {
                this.twoEntryList.set(0, summary);
                this.twoEntryList.set(1, lnEntry);
                this.applyTxn(this.twoEntryList, true);
            }
        } else if (entry instanceof INLogEntry) {
            INLogEntry inEntry = (INLogEntry)entry;
            Long nodeId = inEntry.getNodeId();
            ++summary.totalINCount;
            summary.totalINSize += size;
            this.countObsoleteIN(nodeId);
            this.putActiveIN(nodeId, size, summary, inEntry.getDbId().getId());
        } else if (entry instanceof BINDeltaLogEntry) {
            ++summary.totalINCount;
            summary.totalINSize += size;
            ++summary.obsoleteINCount;
            summary.recalcObsoleteINSize += size;
        } else if (entry instanceof SingleItemEntry) {
            Long txnId;
            List<Object> txnEntries;
            Object item = ((SingleItemEntry)entry).getMainItem();
            long deletedNodeId = item instanceof INDeleteInfo ? ((INDeleteInfo)item).getDeletedNodeId() : (item instanceof INDupDeleteInfo ? ((INDupDeleteInfo)item).getDeletedNodeId() : -1L);
            if (deletedNodeId != -1L) {
                Long nodeId = deletedNodeId;
                this.countObsoleteIN(nodeId);
                this.activeINs.remove(nodeId);
            }
            if (item instanceof TxnEnd && (txnEntries = this.txns.remove(txnId = Long.valueOf(entry.getTransactionId()))) != null) {
                this.applyTxn(txnEntries, item instanceof TxnCommit);
            }
        }
        return true;
    }

    private void applyTxn(List<Object> entries, boolean commit) {
        for (int i = 0; i < entries.size(); i += 2) {
            ExtendedFileSummary summary = (ExtendedFileSummary)entries.get(i);
            LNLogEntry lnEntry = (LNLogEntry)entries.get(i + 1);
            DatabaseId dbId = lnEntry.getDbId();
            DatabaseImpl dbImpl = this.dbTree.getDb(dbId, -1L, this.dbCache);
            int size = lnEntry.getLastLoggedSize();
            ++summary.totalLNCount;
            summary.totalLNSize += size;
            if (!commit || lnEntry.isDeleted() || dbImpl == null || dbImpl.isDeleteFinished()) {
                ++summary.obsoleteLNCount;
                summary.recalcObsoleteLNSize += size;
            }
            if (!commit || dbImpl == null) continue;
            lnEntry.postFetchInit(dbImpl);
            TxnChain.CompareSlot slot = new TxnChain.CompareSlot(dbImpl, lnEntry);
            this.countObsoleteLN(slot);
            if (dbImpl.isDeleteFinished() || lnEntry.isDeleted()) {
                this.activeLNs.remove(slot);
                continue;
            }
            this.putActiveLN(slot, size, summary, lnEntry.getDbId().getId());
        }
    }

    private void finishProcessing() {
        for (List<Object> txnEntries : this.txns.values()) {
            this.applyTxn(txnEntries, false);
        }
    }

    private void cleanUp() {
        this.dbTree.releaseDbs(this.dbCache);
    }

    private void putActiveIN(Long nodeId, int size, ExtendedFileSummary summary, long dbId) {
        NodeInfo info = this.activeINs.get(nodeId);
        if (info == null) {
            info = new NodeInfo();
            this.activeINs.put(nodeId, info);
        }
        info.size = size;
        info.summary = summary;
        info.dbId = dbId;
    }

    private void putActiveLN(TxnChain.CompareSlot slot, int size, ExtendedFileSummary summary, long dbId) {
        NodeInfo info = this.activeLNs.get(slot);
        if (info == null) {
            info = new NodeInfo();
            this.activeLNs.put(slot, info);
        }
        info.size = size;
        info.summary = summary;
        info.dbId = dbId;
    }

    private void countObsoleteIN(Long nodeId) {
        NodeInfo info = this.activeINs.get(nodeId);
        if (info != null) {
            ExtendedFileSummary summary = info.summary;
            ++summary.obsoleteINCount;
            summary.recalcObsoleteINSize += info.size;
        }
    }

    private void countObsoleteLN(TxnChain.CompareSlot slot) {
        NodeInfo info = this.activeLNs.get(slot);
        if (info != null) {
            ExtendedFileSummary summary = info.summary;
            ++summary.obsoleteLNCount;
            summary.recalcObsoleteLNSize += info.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, FileSummary> calcFileSummaryMap(EnvironmentImpl envImpl) {
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        UtilizationFileReader reader = new UtilizationFileReader(envImpl, readBufferSize);
        try {
            while (reader.readNextEntry()) {
            }
            reader.finishProcessing();
            Map<Long, FileSummary> map = reader.summaries;
            Object var5_4 = null;
            reader.cleanUp();
            return map;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reader.cleanUp();
            throw throwable;
        }
    }

    private static class NodeInfo {
        ExtendedFileSummary summary;
        int size;
        long dbId;

        private NodeInfo() {
        }
    }

    private static class ExtendedFileSummary
    extends FileSummary {
        private int recalcObsoleteINSize;
        private int recalcObsoleteLNSize;

        private ExtendedFileSummary() {
        }

        public int getObsoleteLNSize() {
            return this.recalcObsoleteLNSize;
        }

        public int getObsoleteINSize() {
            return this.recalcObsoleteINSize;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(super.toString());
            buf.append("<extended-info recalcObsoleteINSize=\"");
            buf.append(this.recalcObsoleteINSize);
            buf.append("\" recalcObsoleteLNSize=\"");
            buf.append(this.recalcObsoleteLNSize);
            buf.append("\"/>");
            return buf.toString();
        }
    }
}

