/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ForwardCursor;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.CountEstimator;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cursor
implements ForwardCursor {
    static final int READ_PRIMARY_MAX_RETRIES = 10000;
    static final int SLEEP_BEFORE_READ_PRIMARY_RETRY = 1;
    CursorImpl cursorImpl;
    CursorConfig config;
    private boolean updateOperationsProhibited;
    private Database dbHandle;
    private DatabaseImpl dbImpl;
    private boolean readUncommittedDefault;
    private boolean serializableIsolationDefault;
    private Logger logger;
    private boolean nonCloning = false;
    private CacheMode cacheMode;
    private boolean cacheModeOverridden;
    private RangeConstraint cursorRangeConstraint;
    private Transaction transaction;
    private static final DatabaseEntry EMPTY_DUP_DATA = new DatabaseEntry(new byte[0]);
    private static final DatabaseEntry NO_RETURN_DATA = new DatabaseEntry();

    Cursor(Database dbHandle, Transaction txn, CursorConfig cursorConfig) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        Locker locker = LockerFactory.getReadableLocker(dbHandle.getEnvironment(), txn, dbHandle.isTransactional(), cursorConfig.getReadCommitted());
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, false);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        locker = LockerFactory.getReadableLocker(dbHandle.getEnvironment(), dbHandle, locker, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, false);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, retainNonTxnLocks);
    }

    Cursor(DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen("Can't access Database:");
        }
        this.init(null, databaseImpl, locker, cursorConfig, retainNonTxnLocks);
    }

    private void init(Database dbHandle, DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        assert (locker != null);
        try {
            locker.openCursorHook(databaseImpl);
        }
        catch (RuntimeException e) {
            locker.operationEnd();
            throw e;
        }
        this.cursorImpl = new CursorImpl(databaseImpl, locker, retainNonTxnLocks);
        this.transaction = locker.getTransaction();
        this.cacheMode = databaseImpl.getDefaultCacheMode();
        this.cursorImpl.setAllowEviction(true);
        this.readUncommittedDefault = cursorConfig.getReadUncommitted() || locker.isReadUncommittedDefault();
        this.serializableIsolationDefault = this.cursorImpl.getLocker().isSerializableIsolation();
        this.updateOperationsProhibited = databaseImpl.isTransactional() && !locker.isTransactional() || dbHandle != null && !dbHandle.isWritable();
        this.dbImpl = databaseImpl;
        if (dbHandle != null) {
            this.dbHandle = dbHandle;
            dbHandle.addCursor(this);
        }
        this.config = cursorConfig;
        this.logger = databaseImpl.getDbEnvironment().getLogger();
    }

    Cursor(Cursor cursor, boolean samePosition) {
        this.readUncommittedDefault = cursor.readUncommittedDefault;
        this.serializableIsolationDefault = cursor.serializableIsolationDefault;
        this.updateOperationsProhibited = cursor.updateOperationsProhibited;
        this.cursorImpl = cursor.cursorImpl.dup(samePosition);
        this.dbImpl = cursor.dbImpl;
        this.dbHandle = cursor.dbHandle;
        if (this.dbHandle != null) {
            this.dbHandle.addCursor(this);
        }
        this.config = cursor.config;
        this.logger = this.dbImpl.getDbEnvironment().getLogger();
        this.cacheMode = cursor.cacheMode;
        this.cacheModeOverridden = cursor.cacheModeOverridden;
    }

    void setNonCloning(boolean nonCloning) {
        this.nonCloning = nonCloning;
    }

    CursorImpl getCursorImpl() {
        return this.cursorImpl;
    }

    @Override
    public Database getDatabase() {
        return this.dbHandle;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.dbImpl;
    }

    public CursorConfig getConfig() {
        try {
            return this.config.clone();
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheModeOverridden = cacheMode != null;
        this.cacheMode = cacheMode != null ? cacheMode : this.dbImpl.getDefaultCacheMode();
    }

    public void setRangeConstraint(RangeConstraint rangeConstraint) {
        this.cursorRangeConstraint = rangeConstraint;
    }

    private boolean checkRangeConstraint(DatabaseEntry key) {
        assert (key.getOffset() == 0);
        assert (key.getData().length == key.getSize());
        if (this.cursorRangeConstraint == null) {
            return true;
        }
        return this.cursorRangeConstraint.inBounds(key.getData());
    }

    @Override
    public void close() throws DatabaseException {
        try {
            if (this.cursorImpl.isClosed()) {
                return;
            }
            this.checkEnv();
            this.cursorImpl.close();
            if (this.dbHandle != null) {
                this.dbHandle.removeCursor(this);
                this.dbHandle = null;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public int count() throws DatabaseException {
        this.checkState(true);
        this.trace(Level.FINEST, "Cursor.count: ", null);
        return this.countInternal();
    }

    public long countEstimate() throws DatabaseException {
        this.checkState(true);
        this.trace(Level.FINEST, "Cursor.countEstimate: ", null);
        return this.countEstimateInternal();
    }

    public Cursor dup(boolean samePosition) throws DatabaseException {
        try {
            this.checkState(false);
            return new Cursor(this, samePosition);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public OperationStatus delete() throws LockConflictException, DatabaseException, UnsupportedOperationException {
        this.checkState(true);
        this.checkUpdatesAllowed("delete");
        this.trace(Level.FINEST, "Cursor.delete: ", null);
        return this.deleteInternal(this.dbImpl.getRepContext());
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("put");
        this.trace(Level.FINEST, "Cursor.put: ", key, data, null);
        return this.putInternal(key, data, PutMode.OVERWRITE);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("putNoOverwrite");
        this.trace(Level.FINEST, "Cursor.putNoOverwrite: ", key, data, null);
        return this.putInternal(key, data, PutMode.NO_OVERWRITE);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("putNoDupData");
        this.trace(Level.FINEST, "Cursor.putNoDupData: ", key, data, null);
        return this.putInternal(key, data, PutMode.NO_DUP_DATA);
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        this.checkUpdatesAllowed("putCurrent");
        this.trace(Level.FINEST, "Cursor.putCurrent: ", null, data, null);
        return this.putInternal(null, data, PutMode.CURRENT);
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        try {
            this.checkState(true);
            Cursor.checkArgsNoValRequired(key, data);
            this.trace(Level.FINEST, "Cursor.getCurrent: ", lockMode);
            return this.getCurrentInternal(key, data, lockMode);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getFirst: ", lockMode);
        return this.position(key, data, lockMode, true);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getLast: ", lockMode);
        return this.position(key, data, lockMode, false);
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNext: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextDup: ", lockMode);
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_DUP);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_NODUP);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrev: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevDup: ", lockMode);
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_DUP);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_NODUP);
    }

    public long skipNext(long maxCount, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        if (maxCount <= 0L) {
            throw new IllegalArgumentException("maxCount must be positive: " + maxCount);
        }
        this.trace(Level.FINEST, "Cursor.skipNext: ", lockMode);
        return this.skipInternal(maxCount, true, key, data, lockMode);
    }

    public long skipPrev(long maxCount, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        if (maxCount <= 0L) {
            throw new IllegalArgumentException("maxCount must be positive: " + maxCount);
        }
        this.trace(Level.FINEST, "Cursor.skipPrev: ", lockMode);
        return this.skipInternal(maxCount, false, key, data, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long skipInternal(long maxCount, boolean forward, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        LockType lockType = this.getLockType(lockMode, false);
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            long l;
            Object var17_13;
            boolean success;
            CursorImpl dup;
            this.checkTxnState();
            while (true) {
                block7: {
                    dup = this.beginMoveCursor(true);
                    success = false;
                    try {
                        long count = dup.skip(forward, maxCount, null);
                        if (count <= 0L) {
                            long l2 = 0L;
                            var17_13 = null;
                            this.endMoveCursor(dup, success);
                            return l2;
                        }
                        OperationStatus status = this.getCurrentWithCursorImpl(dup, key, data, lockType);
                        if (status == OperationStatus.KEYEMPTY) {
                            break block7;
                        }
                        success = true;
                        l = count;
                        break;
                    }
                    catch (Throwable throwable) {
                        var17_13 = null;
                        this.endMoveCursor(dup, success);
                        throw throwable;
                    }
                }
                var17_13 = null;
                this.endMoveCursor(dup, success);
            }
            var17_13 = null;
            this.endMoveCursor(dup, success);
            return l;
        }
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKeyRange: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET_RANGE);
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBoth: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        Cursor.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBothRange: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH_RANGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getNextAfterPrefix(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getNextAfterPrefix: ", key, null, lockMode);
        Comparator<byte[]> searchComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] prefix, byte[] checkKey) {
                int cmp;
                int prefixLen = prefix.length;
                int checkLen = Math.min(checkKey.length, prefixLen);
                Comparator<byte[]> btreeComparator = Cursor.this.dbImpl.getBtreeComparator();
                if (btreeComparator == null) {
                    cmp = Key.compareUnsignedBytes(prefix, 0, prefixLen, checkKey, 0, checkLen);
                } else {
                    byte[] key2 = new byte[checkLen];
                    System.arraycopy(checkKey, 0, key2, 0, checkLen);
                    cmp = btreeComparator.compare(prefix, key2);
                }
                return cmp != 0 ? cmp : 1;
            }
        };
        OperationStatus status = OperationStatus.NOTFOUND;
        LockType lockType = this.getLockType(lockMode, false);
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            KeyChangeStatus result = this.searchInternal(dup, key, data, lockType, lockType, CursorImpl.SearchMode.SET_RANGE, searchComparator, this.cursorRangeConstraint);
            status = result.status;
            Object var10_9 = null;
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countInternal() {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.countHandleDups();
            }
            return this.countNoDups();
        }
    }

    long countEstimateInternal() {
        if (this.dbImpl.getSortedDuplicates()) {
            return this.countEstimateHandleDups();
        }
        return this.countNoDups();
    }

    private int countNoDups() {
        try {
            this.beginUseExistingCursor();
            OperationStatus status = this.cursorImpl.getCurrent(null, null, LockType.NONE);
            this.endUseExistingCursor();
            return status == OperationStatus.SUCCESS ? 1 : 0;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    OperationStatus deleteInternal(ReplicationContext repContext) {
        try {
            OperationStatus status;
            boolean hasUserTriggers;
            DatabaseEntry oldKey = null;
            DatabaseEntry oldData = null;
            boolean doNotifyTriggers = this.dbHandle != null && this.dbHandle.hasTriggers();
            boolean bl = hasUserTriggers = this.dbImpl != null && this.dbImpl.getTriggers() != null;
            if ((doNotifyTriggers || hasUserTriggers) && (status = this.getCurrentInternal(oldKey = new DatabaseEntry(), oldData = new DatabaseEntry(), LockMode.RMW)) != OperationStatus.SUCCESS) {
                return OperationStatus.KEYEMPTY;
            }
            if (doNotifyTriggers) {
                this.dbHandle.notifyTriggers(this.cursorImpl.getLocker(), oldKey, oldData, null);
            }
            if ((status = this.deleteNoNotify(repContext)) == OperationStatus.SUCCESS && hasUserTriggers) {
                TriggerManager.runDeleteTriggers(this.cursorImpl.getLocker(), this.dbImpl, oldKey, oldData);
            }
            return status;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus deleteNoNotify(ReplicationContext repContext) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            this.beginUseExistingCursor();
            OperationStatus status = this.cursorImpl.delete(repContext);
            this.endUseExistingCursor();
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putInternal(DatabaseEntry key, DatabaseEntry data, PutMode putMode) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.putHandleDups(key, data, putMode);
            }
            if (putMode == PutMode.NO_DUP_DATA) {
                throw new UnsupportedOperationException("Database is not configured for duplicate data.");
            }
            return this.putNoDups(key, data, putMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putForReplay(byte[] key, LN ln, PutMode putMode, ReplicationContext repContext) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            assert (putMode != PutMode.CURRENT);
            return this.putNotify(new DatabaseEntry(key), new DatabaseEntry(ln.getData()), ln, putMode, repContext);
        }
    }

    private OperationStatus putNoDups(DatabaseEntry key, DatabaseEntry data, PutMode putMode) {
        LN ln = putMode == PutMode.CURRENT ? null : LN.makeLN(this.dbImpl.getDbEnvironment(), data);
        return this.putNotify(key, data, ln, putMode, this.dbImpl.getRepContext());
    }

    private OperationStatus putNotify(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, ReplicationContext repContext) {
        try {
            OperationStatus commitStatus;
            boolean hasUserTriggers;
            DatabaseEntry oldData = null;
            DatabaseEntry newData = null;
            DatabaseEntry returnNewData = null;
            boolean doNotifyTriggers = this.dbHandle != null && this.dbHandle.hasTriggers();
            boolean bl = hasUserTriggers = this.dbImpl != null && this.dbImpl.getTriggers() != null;
            if (doNotifyTriggers || hasUserTriggers) {
                newData = data.getPartial() ? (returnNewData = new DatabaseEntry()) : data;
                oldData = new DatabaseEntry();
            }
            if (putMode == PutMode.CURRENT) {
                byte[] replaceKey;
                assert (ln == null);
                byte[] byArray = replaceKey = key != null ? Key.makeKey(key) : null;
                if (doNotifyTriggers && key == null) {
                    key = new DatabaseEntry();
                }
                commitStatus = this.putCurrentNoNotify(replaceKey, data, key, oldData, returnNewData, repContext);
            } else {
                assert (ln != null);
                commitStatus = this.putNoNotify(key, data, ln, putMode, oldData, returnNewData, repContext);
            }
            if (commitStatus == OperationStatus.SUCCESS && (doNotifyTriggers || hasUserTriggers)) {
                if (oldData != null && oldData.getData() == null) {
                    oldData = null;
                }
                if (newData != null && newData.getData() == null) {
                    newData = null;
                }
                if (doNotifyTriggers) {
                    this.dbHandle.notifyTriggers(this.cursorImpl.getLocker(), key, oldData, newData);
                }
                if (hasUserTriggers) {
                    TriggerManager.runPutTriggers(this.cursorImpl.getLocker(), this.dbImpl, key, oldData, newData);
                }
            }
            return commitStatus;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus putNoNotify(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        OperationStatus operationStatus;
        Locker nextKeyLocker;
        block9: {
            assert (key != null);
            assert (ln != null);
            assert (putMode != null);
            assert (putMode != PutMode.CURRENT);
            nextKeyLocker = null;
            CursorImpl nextKeyCursor = null;
            try {
                Locker cursorLocker = this.cursorImpl.getLocker();
                if (this.dbImpl.getDbEnvironment().getTxnManager().areOtherSerializableTransactionsActive(cursorLocker)) {
                    nextKeyLocker = BuddyLocker.createBuddyLocker(this.dbImpl.getDbEnvironment(), cursorLocker);
                    nextKeyCursor = new CursorImpl(this.dbImpl, nextKeyLocker);
                    nextKeyCursor.setAllowEviction(true);
                    nextKeyCursor.lockNextKeyForInsert(key);
                }
                operationStatus = this.putAllowPhantoms(key, data, ln, putMode, returnOldData, returnNewData, nextKeyCursor, repContext);
                Object var13_12 = null;
                if (nextKeyCursor == null) break block9;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var13_13 = null;
                    if (nextKeyCursor != null) {
                        nextKeyCursor.close();
                    }
                    if (nextKeyLocker == null) break block10;
                    nextKeyLocker.operationEnd();
                }
                throw throwable;
            }
            nextKeyCursor.close();
        }
        if (nextKeyLocker != null) {
            nextKeyLocker.operationEnd();
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus putAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, CursorImpl nextKeyCursor, ReplicationContext repContext) {
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = this.beginMoveCursor(false, nextKeyCursor);
        try {
            OperationStatus operationStatus = status = dup.put(key, data, ln, putMode, returnOldData, returnNewData, repContext);
            Object var13_12 = null;
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            return operationStatus;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
    }

    private OperationStatus putCurrentNoNotify(byte[] replaceKey, DatabaseEntry replaceData, DatabaseEntry returnKey, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        assert (replaceData != null);
        this.beginUseExistingCursor();
        OperationStatus status = this.cursorImpl.putCurrent(replaceKey, replaceData, returnKey, returnOldData, returnNewData, repContext);
        this.endUseExistingCursor();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus position(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.positionHandleDups(key, data, lockMode, first);
            }
            return this.positionNoDups(key, data, lockMode, first);
        }
    }

    private OperationStatus positionNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.positionAllowPhantoms(key, data, this.getLockType(lockMode, false), first);
            }
            while (true) {
                try {
                    if (!first) {
                        this.cursorImpl.lockEof(LockType.RANGE_READ);
                    }
                    LockType lockType = this.getLockType(lockMode, first);
                    OperationStatus status = this.positionAllowPhantoms(key, data, lockType, first);
                    if (first && status != OperationStatus.SUCCESS) {
                        this.cursorImpl.lockEof(LockType.RANGE_READ);
                    }
                    return status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus positionAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType lockType, boolean first) {
        assert (key != null && data != null);
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            if (!dup.positionFirstOrLast(first)) {
                status = OperationStatus.NOTFOUND;
                assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString();
            } else {
                assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
                status = dup.getCurrentAlreadyLatched(key, data, lockType);
                if (status != OperationStatus.SUCCESS) {
                    status = dup.getNext(key, data, lockType, first, false, null);
                }
            }
            Object var8_7 = null;
            this.cursorImpl.releaseBIN();
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.cursorImpl.releaseBIN();
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus search(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.searchHandleDups(key, data, lockMode, searchMode);
            }
            return this.searchNoDups(key, data, lockMode, searchMode, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus searchForReplay(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            return this.searchNoDups(key, data, lockMode, searchMode, null);
        }
    }

    private OperationStatus searchNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode, Comparator<byte[]> searchComparator) {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                LockType lockType = this.getLockType(lockMode, false);
                KeyChangeStatus result = this.searchAllowPhantoms(key, data, lockType, lockType, searchMode, searchComparator, this.cursorRangeConstraint);
                return result.status;
            }
            while (true) {
                try {
                    KeyChangeStatus result;
                    LockType searchLockType = this.getLockType(lockMode, false);
                    LockType advanceLockType = this.getLockType(lockMode, true);
                    DatabaseEntry tryKey = Cursor.cloneEntry(key);
                    DatabaseEntry tryData = Cursor.cloneEntry(data);
                    if (searchMode.isExactSearch()) {
                        result = this.searchExactAndRangeLock(tryKey, tryData, searchLockType, advanceLockType, searchMode, searchComparator);
                    } else {
                        result = this.searchAllowPhantoms(tryKey, tryData, searchLockType, advanceLockType, searchMode, searchComparator, null);
                        if (result.status != OperationStatus.SUCCESS) {
                            this.cursorImpl.lockEof(LockType.RANGE_READ);
                        }
                        if (result.status == OperationStatus.SUCCESS && !this.checkRangeConstraint(tryKey)) {
                            result.status = OperationStatus.NOTFOUND;
                        }
                    }
                    if (result.status == OperationStatus.SUCCESS) {
                        Cursor.copyEntry(tryKey, key);
                        Cursor.copyEntry(tryData, data);
                    }
                    return result.status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyChangeStatus searchExactAndRangeLock(DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchMode, Comparator<byte[]> searchComparator) {
        KeyChangeStatus result = null;
        DatabaseEntry origData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            result = this.searchInternal(dup, key, data, searchLockType, advanceLockType, CursorImpl.SearchMode.SET_RANGE, searchComparator, null);
            if (result.keyChange && result.status == OperationStatus.SUCCESS) {
                result.status = OperationStatus.NOTFOUND;
            }
            if (!this.checkDataMatch(searchMode, origData, data)) {
                result.status = OperationStatus.NOTFOUND;
            }
            Object var11_10 = null;
            this.endMoveCursor(dup, result != null && result.status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.endMoveCursor(dup, result != null && result.status == OperationStatus.SUCCESS);
            throw throwable;
        }
        if (result.status != OperationStatus.SUCCESS && !result.keyChange) {
            this.cursorImpl.lockEof(LockType.RANGE_READ);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyChangeStatus searchAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchMode, Comparator<byte[]> searchComparator, RangeConstraint rangeConstraint) {
        OperationStatus status = OperationStatus.NOTFOUND;
        DatabaseEntry origData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            KeyChangeStatus result = this.searchInternal(dup, key, data, searchLockType, advanceLockType, searchMode, searchComparator, rangeConstraint);
            if (!this.checkDataMatch(searchMode, origData, data)) {
                result.status = OperationStatus.NOTFOUND;
            }
            status = result.status;
            KeyChangeStatus keyChangeStatus = result;
            Object var14_13 = null;
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            return keyChangeStatus;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
    }

    private boolean checkDataMatch(CursorImpl.SearchMode searchMode, DatabaseEntry data1, DatabaseEntry data2) {
        int size2;
        if (!searchMode.isDataSearch()) {
            return true;
        }
        int size1 = data1.getSize();
        if (size1 != (size2 = data2.getSize())) {
            return false;
        }
        return Key.compareUnsignedBytes(data1.getData(), data1.getOffset(), size1, data2.getData(), data2.getOffset(), size2) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyChangeStatus searchInternal(CursorImpl dup, DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchModeParam, Comparator<byte[]> searchComparator, RangeConstraint rangeConstraint) {
        CursorImpl.SearchMode searchMode;
        assert (key != null && data != null);
        switch (searchModeParam) {
            case BOTH: {
                searchMode = CursorImpl.SearchMode.SET;
                break;
            }
            case BOTH_RANGE: {
                searchMode = CursorImpl.SearchMode.SET_RANGE;
                break;
            }
            default: {
                searchMode = searchModeParam;
            }
        }
        assert (rangeConstraint == null || searchMode == CursorImpl.SearchMode.SET_RANGE);
        OperationStatus status = OperationStatus.NOTFOUND;
        boolean keyChange = false;
        try {
            int searchResult = dup.searchAndPosition(key, searchMode, searchLockType, searchComparator);
            if ((searchResult & 1) != 0) {
                DatabaseEntry useKey;
                boolean exactKeyMatch = (searchResult & 2) != 0;
                boolean foundLast = (searchResult & 4) != 0;
                boolean rangeMatch = searchMode == CursorImpl.SearchMode.SET_RANGE && !exactKeyMatch;
                DatabaseEntry databaseEntry = useKey = searchModeParam == CursorImpl.SearchMode.SET ? null : key;
                if (rangeMatch || (status = dup.getCurrentAlreadyLatched(useKey, data, searchLockType)) == OperationStatus.KEYEMPTY) {
                    if (foundLast) {
                        status = OperationStatus.NOTFOUND;
                    } else if (searchMode == CursorImpl.SearchMode.SET) {
                        assert (status == OperationStatus.KEYEMPTY);
                        status = OperationStatus.NOTFOUND;
                    } else {
                        assert (searchMode == CursorImpl.SearchMode.SET_RANGE);
                        status = dup.getNext(key, data, advanceLockType, true, rangeMatch, rangeConstraint);
                        keyChange = status == OperationStatus.SUCCESS;
                    }
                }
            }
            Object var18_17 = null;
            this.cursorImpl.releaseBIN();
            if (status != OperationStatus.SUCCESS && dup != this.cursorImpl) {
                dup.releaseBIN();
            }
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            this.cursorImpl.releaseBIN();
            if (status != OperationStatus.SUCCESS && dup != this.cursorImpl) {
                dup.releaseBIN();
            }
            throw throwable;
        }
        return new KeyChangeStatus(status, keyChange);
    }

    OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) {
        if (this.dbImpl.getSortedDuplicates()) {
            return this.retrieveNextHandleDups(key, data, lockMode, getMode);
        }
        return this.retrieveNextNoDups(key, data, lockMode, getMode);
    }

    private OperationStatus retrieveNextNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getModeParam) {
        GetMode getMode;
        switch (getModeParam) {
            case NEXT_DUP: 
            case PREV_DUP: {
                return OperationStatus.NOTFOUND;
            }
            case NEXT_NODUP: {
                getMode = GetMode.NEXT;
                break;
            }
            case PREV_NODUP: {
                getMode = GetMode.PREV;
                break;
            }
            default: {
                getMode = getModeParam;
            }
        }
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.retrieveNextAllowPhantoms(key, data, this.getLockType(lockMode, false), getMode, this.cursorRangeConstraint);
            }
            while (true) {
                try {
                    if (!getMode.isForward()) {
                        this.rangeLockCurrentPosition(getMode);
                    }
                    LockType lockType = this.getLockType(lockMode, getMode.isForward());
                    DatabaseEntry tryKey = Cursor.cloneEntry(key);
                    DatabaseEntry tryData = Cursor.cloneEntry(data);
                    OperationStatus status = this.retrieveNextAllowPhantoms(tryKey, tryData, lockType, getMode, null);
                    if (getMode.isForward() && status != OperationStatus.SUCCESS) {
                        this.cursorImpl.lockEof(LockType.RANGE_READ);
                    }
                    if (status == OperationStatus.SUCCESS && !this.checkRangeConstraint(tryKey)) {
                        status = OperationStatus.NOTFOUND;
                    }
                    if (status == OperationStatus.SUCCESS) {
                        Cursor.copyEntry(tryKey, key);
                        Cursor.copyEntry(tryData, data);
                    }
                    return status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeLockCurrentPosition(GetMode getMode) {
        OperationStatus status;
        DatabaseEntry tempKey = new DatabaseEntry();
        DatabaseEntry tempData = new DatabaseEntry();
        tempKey.setPartial(0, 0, true);
        tempData.setPartial(0, 0, true);
        CursorImpl dup = this.cursorImpl.cloneCursor(true, this.cacheMode);
        try {
            status = dup.getCurrent(tempKey, tempData, LockType.RANGE_READ);
            if (status != OperationStatus.SUCCESS) {
                while (true) {
                    assert (LatchSupport.countLatchesHeld() == 0);
                    status = dup.getNext(tempKey, tempData, LockType.RANGE_READ, true, false, null);
                    if (!this.checkForInsertion(GetMode.NEXT, this.cursorImpl, dup)) break;
                    dup.close(this.cursorImpl);
                    dup = this.cursorImpl.cloneCursor(true, this.cacheMode);
                }
                assert (LatchSupport.countLatchesHeld() == 0);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            dup.close(this.cursorImpl);
            throw throwable;
        }
        dup.close(this.cursorImpl);
        if (status != OperationStatus.SUCCESS) {
            this.cursorImpl.lockEof(LockType.RANGE_READ);
        }
    }

    private OperationStatus retrieveNextAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType lockType, GetMode getMode, RangeConstraint rangeConstraint) {
        OperationStatus status;
        CursorImpl dup;
        assert (key != null && data != null);
        while (true) {
            block8: {
                assert (LatchSupport.countLatchesHeld() == 0);
                dup = this.beginMoveCursor(true);
                try {
                    if (getMode == GetMode.NEXT) {
                        status = dup.getNext(key, data, lockType, true, false, rangeConstraint);
                        break block8;
                    }
                    if (getMode == GetMode.PREV) {
                        status = dup.getNext(key, data, lockType, false, false, rangeConstraint);
                        break block8;
                    }
                    throw EnvironmentFailureException.unexpectedState("unknown GetMode: " + (Object)((Object)getMode));
                }
                catch (DatabaseException DBE) {
                    this.endMoveCursor(dup, false);
                    throw DBE;
                }
            }
            if (!this.checkForInsertion(getMode, this.cursorImpl, dup)) break;
            this.endMoveCursor(dup, false);
        }
        this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        assert (LatchSupport.countLatchesHeld() == 0);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus getCurrentInternal(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.getCurrentHandleDups(key, data, lockMode);
            }
            return this.getCurrentNoDups(key, data, lockMode);
        }
    }

    private OperationStatus getCurrentNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        LockType lockType = this.getLockType(lockMode, false);
        this.beginUseExistingCursor();
        OperationStatus status = this.cursorImpl.getCurrent(key, data, lockType);
        this.endUseExistingCursor();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForInsertion(GetMode getMode, CursorImpl origCursor, CursorImpl dupCursor) {
        boolean forward = getMode.isForward();
        boolean ret = false;
        if (origCursor.getBIN() != dupCursor.getBIN()) {
            BIN origBIN = origCursor.latchBIN();
            try {
                if (forward) {
                    if (origBIN.getNEntries() - 1 > origCursor.getIndex()) {
                        for (int i = origCursor.getIndex() + 1; i < origBIN.getNEntries(); ++i) {
                            LN ln;
                            Node n;
                            if (origBIN.isEntryKnownDeleted(i) || (n = origBIN.fetchTarget(i)) == null || (ln = (LN)n).isDeleted()) continue;
                            ret = true;
                            break;
                        }
                    }
                } else if (origCursor.getIndex() > 0) {
                    for (int i = 0; i < origCursor.getIndex(); ++i) {
                        LN ln;
                        Node n;
                        if (origBIN.isEntryKnownDeleted(i) || (n = origBIN.fetchTarget(i)) == null || (ln = (LN)n).isDeleted()) continue;
                        ret = true;
                        break;
                    }
                }
                Object var11_13 = null;
                origCursor.releaseBIN();
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                origCursor.releaseBIN();
                throw throwable;
            }
            return ret;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countHandleDups() {
        Cursor c;
        block4: {
            int n;
            byte[] currentKey = this.cursorImpl.getCurrentKey();
            DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
            c = this.dup(false);
            try {
                c.setNonCloning(true);
                this.setPrefixConstraint(c, currentKey);
                OperationStatus status = c.searchNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, CursorImpl.SearchMode.SET_RANGE, null);
                if (status == OperationStatus.SUCCESS) break block4;
                n = 0;
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                c.close();
                throw throwable;
            }
            c.close();
            return n;
        }
        long count = c.cursorImpl.skip(true, 0L, c.cursorRangeConstraint) + 1L;
        if (count > Integer.MAX_VALUE) {
            throw new IllegalStateException("count exceeded integer size: " + count);
        }
        int n = (int)count;
        Object var9_8 = null;
        c.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long countEstimateHandleDups() {
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
        Cursor c1 = this.dup(false);
        try {
            boolean c2Inclusive;
            Cursor c2;
            block9: {
                long l;
                OperationStatus status;
                block10: {
                    c1.setNonCloning(true);
                    this.setPrefixConstraint(c1, currentKey);
                    status = c1.searchNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, CursorImpl.SearchMode.SET_RANGE, null);
                    if (status != OperationStatus.SUCCESS) {
                        long l2 = 0L;
                        Object var12_7 = null;
                        c1.close();
                        return l2;
                    }
                    c2 = c1.dup(true);
                    c2.setNonCloning(true);
                    status = c2.dupsGetNextNoDup(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED);
                    if (status == OperationStatus.SUCCESS) {
                        c2Inclusive = false;
                        break block9;
                    }
                    c2Inclusive = true;
                    status = c2.positionNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, false);
                    if (status == OperationStatus.SUCCESS) break block10;
                    long l3 = 0L;
                    Object var10_16 = null;
                    c2.close();
                    Object var12_8 = null;
                    c1.close();
                    return l3;
                }
                try {
                    while (!this.haveSameDupPrefix(twoPartKey, currentKey)) {
                        status = c2.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, GetMode.PREV);
                        if (status == OperationStatus.SUCCESS) continue;
                        l = 0L;
                        Object var10_17 = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_19 = null;
                    c2.close();
                    throw throwable;
                }
                {
                    c2.close();
                    Object var12_9 = null;
                    c1.close();
                    return l;
                }
            }
            long l = CountEstimator.count(this.dbImpl, c1.cursorImpl, true, c2.cursorImpl, c2Inclusive);
            Object var10_18 = null;
            c2.close();
            Object var12_10 = null;
            c1.close();
            return l;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            c1.close();
            throw throwable;
        }
    }

    private OperationStatus putHandleDups(DatabaseEntry key, DatabaseEntry data, PutMode putMode) {
        switch (putMode) {
            case OVERWRITE: {
                return this.dupsPutOverwrite(key, data);
            }
            case NO_OVERWRITE: {
                return this.dupsPutNoOverwrite(key, data);
            }
            case NO_DUP_DATA: {
                return this.dupsPutNoDupData(key, data);
            }
            case CURRENT: {
                return this.dupsPutCurrent(data);
            }
        }
        throw EnvironmentFailureException.unexpectedState(putMode.toString());
    }

    private OperationStatus dupsPutOverwrite(DatabaseEntry key, DatabaseEntry data) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        return this.putNoDups(twoPartKey, EMPTY_DUP_DATA, PutMode.OVERWRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsPutNoOverwrite(DatabaseEntry key, DatabaseEntry data) {
        Cursor c;
        block8: {
            OperationStatus status;
            block7: {
                DatabaseEntry data2;
                DatabaseEntry key2;
                block6: {
                    OperationStatus operationStatus;
                    key2 = new DatabaseEntry();
                    data2 = new DatabaseEntry();
                    c = this.dup(false);
                    try {
                        c.setNonCloning(true);
                        Cursor.copyEntry(key, key2);
                        status = c.dupsGetSearchKeyRange(key2, data2, LockMode.RMW);
                        if (status != OperationStatus.SUCCESS || !key.equals(key2)) break block6;
                        operationStatus = OperationStatus.KEYEXIST;
                        Object var9_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        c.close();
                        throw throwable;
                    }
                    c.close();
                    return operationStatus;
                }
                if (status != OperationStatus.SUCCESS) {
                    c.cursorImpl.lockEof(LockType.WRITE);
                }
                Cursor.copyEntry(key, key2);
                status = c.dupsGetSearchKey(key2, data2, LockMode.RMW);
                if (status != OperationStatus.SUCCESS) break block7;
                OperationStatus operationStatus = OperationStatus.KEYEXIST;
                Object var9_12 = null;
                c.close();
                return operationStatus;
            }
            status = c.dupsPutNoDupData(key, data);
            if (status == OperationStatus.SUCCESS) break block8;
            OperationStatus operationStatus = status;
            Object var9_13 = null;
            c.close();
            return operationStatus;
        }
        this.swapCursor(c);
        OperationStatus operationStatus = OperationStatus.SUCCESS;
        Object var9_14 = null;
        c.close();
        return operationStatus;
    }

    private OperationStatus dupsPutNoDupData(DatabaseEntry key, DatabaseEntry data) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        return this.putNoDups(twoPartKey, EMPTY_DUP_DATA, PutMode.NO_OVERWRITE);
    }

    private OperationStatus dupsPutCurrent(DatabaseEntry newData) {
        DatabaseEntry oldTwoPartKey = new DatabaseEntry();
        OperationStatus status = this.getCurrentNoDups(oldTwoPartKey, NO_RETURN_DATA, LockMode.RMW);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DatabaseEntry key = new DatabaseEntry();
        DupKeyData.split(oldTwoPartKey, key, null);
        DatabaseEntry newTwoPartKey = DupKeyData.combine(key, newData);
        return this.putNoDups(newTwoPartKey, EMPTY_DUP_DATA, PutMode.CURRENT);
    }

    private OperationStatus getCurrentHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationStatus status = this.getCurrentNoDups(twoPartKey, NO_RETURN_DATA, lockMode);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    private OperationStatus getCurrentWithCursorImpl(CursorImpl c, DatabaseEntry key, DatabaseEntry data, LockType lockType) {
        if (!this.dbImpl.getSortedDuplicates()) {
            return c.getCurrent(key, data, lockType);
        }
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationStatus status = c.getCurrent(twoPartKey, NO_RETURN_DATA, lockType);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    private OperationStatus positionHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationStatus status = this.positionNoDups(twoPartKey, NO_RETURN_DATA, lockMode, first);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    private OperationStatus retrieveNextHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) {
        switch (getMode) {
            case NEXT: 
            case PREV: {
                return this.dupsGetNextOrPrev(key, data, lockMode, getMode);
            }
            case NEXT_DUP: {
                return this.dupsGetNextOrPrevDup(key, data, lockMode, GetMode.NEXT);
            }
            case PREV_DUP: {
                return this.dupsGetNextOrPrevDup(key, data, lockMode, GetMode.PREV);
            }
            case NEXT_NODUP: {
                return this.dupsGetNextNoDup(key, data, lockMode);
            }
            case PREV_NODUP: {
                return this.dupsGetPrevNoDup(key, data, lockMode);
            }
        }
        throw EnvironmentFailureException.unexpectedState(getMode.toString());
    }

    private OperationStatus dupsGetNextOrPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationStatus status = this.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, getMode);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetNextOrPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) {
        DatabaseEntry twoPartKey;
        Cursor c;
        block3: {
            OperationStatus operationStatus;
            byte[] currentKey = this.cursorImpl.getCurrentKey();
            c = this.dup(true);
            try {
                c.setNonCloning(true);
                this.setPrefixConstraint(c, currentKey);
                twoPartKey = new DatabaseEntry();
                OperationStatus status = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, getMode);
                if (status == OperationStatus.SUCCESS) break block3;
                operationStatus = status;
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                c.close();
                throw throwable;
            }
            c.close();
            return operationStatus;
        }
        DupKeyData.split(twoPartKey, key, data);
        this.swapCursor(c);
        OperationStatus operationStatus = OperationStatus.SUCCESS;
        Object var11_12 = null;
        c.close();
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        Cursor c;
        DatabaseEntry twoPartKey;
        block3: {
            OperationStatus operationStatus;
            byte[] currentKey = this.cursorImpl.getCurrentKey();
            twoPartKey = DupKeyData.removeData(currentKey);
            c = this.dup(false);
            try {
                c.setNonCloning(true);
                DupKeyData.NextNoDupComparator searchComparator = new DupKeyData.NextNoDupComparator(this.dbImpl.getBtreeComparator());
                OperationStatus status = c.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, searchComparator);
                if (status == OperationStatus.SUCCESS) break block3;
                operationStatus = status;
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                c.close();
                throw throwable;
            }
            c.close();
            return operationStatus;
        }
        DupKeyData.split(twoPartKey, key, data);
        this.swapCursor(c);
        OperationStatus operationStatus = OperationStatus.SUCCESS;
        Object var11_12 = null;
        c.close();
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationStatus operationStatus;
        OperationStatus status;
        Cursor c;
        DatabaseEntry twoPartKey;
        byte[] currentKey;
        block9: {
            block10: {
                OperationStatus operationStatus2;
                currentKey = this.cursorImpl.getCurrentKey();
                twoPartKey = DupKeyData.removeData(currentKey);
                c = this.dup(false);
                try {
                    c.setNonCloning(true);
                    this.setPrefixConstraint(c, currentKey);
                    status = c.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, null);
                    if (status != OperationStatus.SUCCESS) break block9;
                    c.setRangeConstraint(null);
                    status = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, GetMode.PREV);
                    if (status == OperationStatus.SUCCESS) break block10;
                    operationStatus2 = status;
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    c.close();
                    throw throwable;
                }
                c.close();
                return operationStatus2;
            }
            DupKeyData.split(twoPartKey, key, data);
            this.swapCursor(c);
            OperationStatus operationStatus3 = OperationStatus.SUCCESS;
            Object var10_13 = null;
            c.close();
            return operationStatus3;
        }
        Object var10_14 = null;
        c.close();
        c = this.dup(true);
        try {
            c.setNonCloning(true);
            while (true) {
                if ((status = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, GetMode.PREV)) == OperationStatus.SUCCESS) break block11;
                operationStatus = status;
                Object var12_17 = null;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            c.close();
            throw throwable;
        }
        {
            block12: {
                block11: {
                    c.close();
                    return operationStatus;
                }
                if (this.haveSameDupPrefix(twoPartKey, currentKey)) break block12;
                DupKeyData.split(twoPartKey, key, data);
                this.swapCursor(c);
                OperationStatus operationStatus4 = OperationStatus.SUCCESS;
                Object var12_18 = null;
                c.close();
                return operationStatus4;
            }
            continue;
        }
    }

    private OperationStatus searchHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) {
        switch (searchMode) {
            case SET: {
                return this.dupsGetSearchKey(key, data, lockMode);
            }
            case SET_RANGE: {
                return this.dupsGetSearchKeyRange(key, data, lockMode);
            }
            case BOTH: {
                return this.dupsGetSearchBoth(key, data, lockMode);
            }
            case BOTH_RANGE: {
                return this.dupsGetSearchBothRange(key, data, lockMode);
            }
        }
        throw EnvironmentFailureException.unexpectedState(searchMode.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        Cursor c;
        DatabaseEntry twoPartKey;
        block3: {
            OperationStatus operationStatus;
            twoPartKey = new DatabaseEntry(DupKeyData.makePrefixKey(key.getData(), key.getOffset(), key.getSize()));
            c = this.dup(false);
            try {
                c.setNonCloning(true);
                this.setPrefixConstraint(c, key);
                OperationStatus status = c.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, null);
                if (status == OperationStatus.SUCCESS) break block3;
                operationStatus = OperationStatus.NOTFOUND;
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                c.close();
                throw throwable;
            }
            c.close();
            return operationStatus;
        }
        DupKeyData.split(twoPartKey, key, data);
        this.swapCursor(c);
        OperationStatus operationStatus = OperationStatus.SUCCESS;
        Object var9_10 = null;
        c.close();
        return operationStatus;
    }

    private OperationStatus dupsGetSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        DatabaseEntry twoPartKey = new DatabaseEntry(DupKeyData.makePrefixKey(key.getData(), key.getOffset(), key.getSize()));
        OperationStatus status = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, null);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    private OperationStatus dupsGetSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        OperationStatus status = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.BOTH, null);
        if (status != OperationStatus.SUCCESS) {
            return status;
        }
        DupKeyData.split(twoPartKey, key, data);
        return OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus dupsGetSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        Cursor c;
        DatabaseEntry twoPartKey;
        block3: {
            OperationStatus operationStatus;
            twoPartKey = DupKeyData.combine(key, data);
            byte[] currentKey = twoPartKey.getData();
            c = this.dup(false);
            try {
                c.setNonCloning(true);
                this.setPrefixConstraint(c, key);
                OperationStatus status = c.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, CursorImpl.SearchMode.SET_RANGE, null);
                if (status == OperationStatus.SUCCESS) break block3;
                operationStatus = OperationStatus.NOTFOUND;
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                c.close();
                throw throwable;
            }
            c.close();
            return operationStatus;
        }
        DupKeyData.split(twoPartKey, key, data);
        this.swapCursor(c);
        OperationStatus operationStatus = OperationStatus.SUCCESS;
        Object var10_11 = null;
        c.close();
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OperationStatus readPrimaryAfterGet(Database priDb, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, int retries) throws DatabaseException {
        OperationStatus operationStatus;
        Cursor cursor;
        block9: {
            OperationStatus operationStatus2;
            block8: {
                OperationStatus operationStatus3;
                block7: {
                    DatabaseEntry copyToPartialEntry = null;
                    boolean readUncommitted = this.isReadUncommittedMode(lockMode);
                    if (readUncommitted && data.getPartial()) {
                        if (data.getPartialLength() == 0) {
                            data.setData(LogUtils.ZERO_LENGTH_BYTE_ARRAY);
                            return OperationStatus.SUCCESS;
                        }
                        copyToPartialEntry = data;
                        data = new DatabaseEntry();
                    }
                    Locker locker = this.cursorImpl.getLocker();
                    cursor = null;
                    try {
                        boolean possibleIntegrityError;
                        cursor = new Cursor(priDb, locker, null, true);
                        LockMode primaryLockMode = readUncommitted ? LockMode.READ_UNCOMMITTED : lockMode;
                        OperationStatus status = cursor.search(pKey, data, primaryLockMode, CursorImpl.SearchMode.SET);
                        if (status != OperationStatus.SUCCESS) {
                            if (!readUncommitted) throw this.dbHandle.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
                            status = this.getCurrentInternal(key, pKey, lockMode);
                            if (status != OperationStatus.KEYEMPTY) throw this.dbHandle.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
                            operationStatus3 = status;
                            Object var16_16 = null;
                            if (cursor == null) return operationStatus3;
                            break block7;
                        }
                        if (readUncommitted && (possibleIntegrityError = this.checkForPrimaryUpdate(key, pKey, data, retries))) {
                            if (retries >= 10000) throw this.dbHandle.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
                            operationStatus2 = OperationStatus.KEYEMPTY;
                            break block8;
                        }
                        if (copyToPartialEntry != null) {
                            LN.setEntry(copyToPartialEntry, data.getData());
                        }
                        operationStatus = OperationStatus.SUCCESS;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var16_19 = null;
                        if (cursor == null) throw throwable;
                        cursor.close();
                        throw throwable;
                    }
                }
                cursor.close();
                return operationStatus3;
            }
            Object var16_17 = null;
            if (cursor == null) return operationStatus2;
            cursor.close();
            return operationStatus2;
        }
        Object var16_18 = null;
        if (cursor == null) return operationStatus;
        cursor.close();
        return operationStatus;
    }

    boolean checkForPrimaryUpdate(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, int retries) {
        return false;
    }

    private boolean haveSameDupPrefix(DatabaseEntry twoPartKey1, byte[] keyBytes2) {
        assert (twoPartKey1.getOffset() == 0);
        assert (twoPartKey1.getData().length == twoPartKey1.getSize());
        return DupKeyData.compareMainKey(twoPartKey1.getData(), keyBytes2, this.dbImpl.getBtreeComparator()) == 0;
    }

    private void setPrefixConstraint(Cursor c, final byte[] keyBytes2) {
        c.setRangeConstraint(new RangeConstraint(){

            public boolean inBounds(byte[] checkKey) {
                return DupKeyData.compareMainKey(checkKey, keyBytes2, Cursor.this.dbImpl.getBtreeComparator()) == 0;
            }
        });
    }

    private void setPrefixConstraint(Cursor c, final DatabaseEntry key2) {
        c.setRangeConstraint(new RangeConstraint(){

            public boolean inBounds(byte[] checkKey) {
                return DupKeyData.compareMainKey(checkKey, key2.getData(), key2.getOffset(), key2.getSize(), Cursor.this.dbImpl.getBtreeComparator()) == 0;
            }
        });
    }

    private CursorImpl beginMoveCursor(boolean addCursor, CursorImpl usePosition) {
        if (this.cursorImpl.isNotInitialized()) {
            this.cursorImpl.setCacheMode(this.cacheMode);
            this.cursorImpl.criticalEviction();
            return this.cursorImpl;
        }
        if (this.nonCloning) {
            this.cursorImpl.setCacheMode(this.cacheMode);
            if (addCursor) {
                this.cursorImpl.criticalEviction();
            } else {
                this.cursorImpl.reset();
            }
            return this.cursorImpl;
        }
        CursorImpl dup = this.cursorImpl.cloneCursor(addCursor, this.cacheMode, usePosition);
        dup.setClosingLocker(this.cursorImpl);
        return dup;
    }

    private CursorImpl beginMoveCursor(boolean addCursor) {
        return this.beginMoveCursor(addCursor, null);
    }

    private void endMoveCursor(CursorImpl dup, boolean success) {
        dup.clearClosingLocker();
        if (dup == this.cursorImpl) {
            if (success) {
                this.cursorImpl.criticalEviction();
            } else {
                this.cursorImpl.reset();
            }
        } else {
            if (success) {
                this.cursorImpl.close(dup);
                this.cursorImpl = dup;
            } else {
                dup.close(this.cursorImpl);
            }
            if (!this.cacheModeOverridden) {
                this.cacheMode = this.dbImpl.getDefaultCacheMode();
            }
        }
    }

    private void beginUseExistingCursor() {
        this.cursorImpl.setCacheMode(this.cacheMode);
        this.cursorImpl.criticalEviction();
    }

    private void endUseExistingCursor() {
        this.cursorImpl.criticalEviction();
    }

    private void swapCursor(Cursor other) {
        CursorImpl otherImpl = other.cursorImpl;
        other.cursorImpl = this.cursorImpl;
        this.cursorImpl = otherImpl;
    }

    boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        return this.cursorImpl.advanceCursor(key, data);
    }

    private LockType getLockType(LockMode lockMode, boolean rangeLock) {
        if (this.isReadUncommittedMode(lockMode)) {
            return LockType.NONE;
        }
        if (lockMode == null || lockMode == LockMode.DEFAULT) {
            return rangeLock ? LockType.RANGE_READ : LockType.READ;
        }
        if (lockMode == LockMode.RMW) {
            return rangeLock ? LockType.RANGE_WRITE : LockType.WRITE;
        }
        if (lockMode == LockMode.READ_COMMITTED) {
            throw new IllegalArgumentException(lockMode.toString() + " not allowed with Cursor methods, " + "use CursorConfig.setReadCommitted instead.");
        }
        assert (false) : lockMode;
        return LockType.NONE;
    }

    boolean isReadUncommittedMode(LockMode lockMode) {
        return lockMode == LockMode.READ_UNCOMMITTED || this.readUncommittedDefault && (lockMode == null || lockMode == LockMode.DEFAULT);
    }

    private boolean isSerializableIsolation(LockMode lockMode) {
        return this.serializableIsolationDefault && !this.isReadUncommittedMode(lockMode);
    }

    protected void checkUpdatesAllowed(String operation) {
        if (this.updateOperationsProhibited) {
            throw new UnsupportedOperationException("A transaction was not supplied when opening this cursor: " + operation);
        }
    }

    static void checkArgsNoValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
    }

    static void checkArgsValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
    }

    void checkState(boolean mustBeInitialized) {
        this.checkEnv();
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen("Can't call Cursor method:");
        }
        this.cursorImpl.checkCursorState(mustBeInitialized);
    }

    void checkEnv() {
        this.cursorImpl.checkEnv();
    }

    private Object getTxnSynchronizer() {
        return this.transaction != null ? this.transaction : this;
    }

    private void checkTxnState() {
        if (this.transaction == null) {
            return;
        }
        this.transaction.checkOpen();
        this.transaction.getTxn().checkState(false);
    }

    void trace(Level level, String methodName, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (key != null) {
                sb.append(" key=").append(key.dumpData());
            }
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    private void traceCursorImpl(StringBuilder sb) {
        sb.append(" locker=").append(this.cursorImpl.getLocker().getId());
        if (this.cursorImpl.getBIN() != null) {
            sb.append(" bin=").append(this.cursorImpl.getBIN().getNodeId());
        }
        sb.append(" idx=").append(this.cursorImpl.getIndex());
    }

    private static DatabaseEntry cloneEntry(DatabaseEntry from) {
        DatabaseEntry to = new DatabaseEntry();
        Cursor.copyEntry(from, to);
        return to;
    }

    private static void copyEntry(DatabaseEntry from, DatabaseEntry to) {
        to.setPartial(from.getPartialOffset(), from.getPartialLength(), from.getPartial());
        to.setData(from.getData(), from.getOffset(), from.getSize());
    }

    static {
        NO_RETURN_DATA.setPartial(0, 0, true);
    }

    private static class KeyChangeStatus {
        public OperationStatus status;
        public boolean keyChange;

        public KeyChangeStatus(OperationStatus status, boolean keyChange) {
            this.status = status;
            this.keyChange = keyChange;
        }
    }
}

