/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.repo.sleepycat.BDBCursor;
import com.amazon.carbonado.repo.sleepycat.BDBRepository;
import com.amazon.carbonado.repo.sleepycat.BDBStorage;
import com.amazon.carbonado.repo.sleepycat.JE_Cursor;
import com.amazon.carbonado.repo.sleepycat.JE_ExceptionTransformer;
import com.amazon.carbonado.repo.sleepycat.JE_Repository;
import com.amazon.carbonado.repo.sleepycat.JE_SetConfigOption;
import com.amazon.carbonado.repo.sleepycat.JE_Transaction;
import com.amazon.carbonado.txn.TransactionScope;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JE_Storage<S extends Storable>
extends BDBStorage<JE_Transaction, S> {
    private Database mDatabase;
    private String mName;

    JE_Storage(JE_Repository repository, Class<S> type) throws DatabaseException, RepositoryException {
        super((BDBRepository)repository, type);
        this.open(repository.mEnv.getConfig().getReadOnly());
    }

    public long countAll() throws FetchException {
        JEVersion v = JEVersion.CURRENT_VERSION;
        if (v.getMajor() == 3 && v.getMinor() < 1) {
            return super.countAll();
        }
        IsolationLevel level = this.getRepository().getTransactionIsolationLevel();
        if (level != null && level.isAtLeast(IsolationLevel.REPEATABLE_READ)) {
            return super.countAll();
        }
        try {
            return this.mDatabase.count();
        }
        catch (DatabaseException e) {
            throw JE_ExceptionTransformer.getInstance().transformIntoFetchException(e);
        }
    }

    protected boolean db_exists(JE_Transaction jetxn, byte[] key, boolean rmw) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        DatabaseEntry dataEntry = new DatabaseEntry();
        dataEntry.setPartial(0, 0, true);
        OperationStatus status = this.mDatabase.get(jetxn == null ? null : jetxn.mTxn, keyEntry, dataEntry, (LockMode)(rmw ? LockMode.RMW : null));
        return status != OperationStatus.NOTFOUND;
    }

    protected byte[] db_get(JE_Transaction jetxn, byte[] key, boolean rmw) throws Exception {
        DatabaseEntry dataEntry;
        DatabaseEntry keyEntry;
        OperationStatus status = this.mDatabase.get(jetxn == null ? null : jetxn.mTxn, keyEntry = new DatabaseEntry(key), dataEntry = new DatabaseEntry(), (LockMode)(rmw ? LockMode.RMW : null));
        if (status == OperationStatus.NOTFOUND) {
            return NOT_FOUND;
        }
        return dataEntry.getData();
    }

    protected Object db_putNoOverwrite(JE_Transaction jetxn, byte[] key, byte[] value) throws Exception {
        DatabaseEntry dataEntry;
        DatabaseEntry keyEntry;
        Transaction txn = jetxn == null ? null : jetxn.mTxn;
        OperationStatus status = this.mDatabase.putNoOverwrite(txn, keyEntry = new DatabaseEntry(key), dataEntry = new DatabaseEntry(value));
        if (status == OperationStatus.SUCCESS) {
            if (jetxn != null) {
                jetxn.addUndo(new UndoByDelete(this.mDatabase, txn, key));
            }
            return SUCCESS;
        }
        if (status == OperationStatus.KEYEXIST) {
            return KEY_EXIST;
        }
        return NOT_FOUND;
    }

    protected boolean db_put(JE_Transaction jetxn, byte[] key, byte[] value) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        DatabaseEntry dataEntry = new DatabaseEntry(value);
        if (jetxn == null) {
            return this.mDatabase.put(null, keyEntry, dataEntry) == OperationStatus.SUCCESS;
        }
        Transaction txn = jetxn.mTxn;
        DatabaseEntry oldEntry = new DatabaseEntry();
        OperationStatus getResult = this.mDatabase.get(txn, keyEntry, oldEntry, LockMode.RMW);
        if (this.mDatabase.put(txn, keyEntry, dataEntry) == OperationStatus.SUCCESS) {
            if (getResult == OperationStatus.NOTFOUND) {
                jetxn.addUndo(new UndoByDelete(this.mDatabase, txn, key));
            } else {
                jetxn.addUndo(new UndoByPut(this.mDatabase, txn, key, oldEntry));
            }
            return true;
        }
        return false;
    }

    protected boolean db_delete(JE_Transaction jetxn, byte[] key) throws Exception {
        DatabaseEntry keyEntry = new DatabaseEntry(key);
        if (jetxn == null) {
            return this.mDatabase.delete(null, keyEntry) == OperationStatus.SUCCESS;
        }
        Transaction txn = jetxn.mTxn;
        DatabaseEntry oldEntry = new DatabaseEntry();
        if (this.mDatabase.get(txn, keyEntry, oldEntry, LockMode.RMW) == OperationStatus.NOTFOUND) {
            return false;
        }
        if (this.mDatabase.delete(txn, keyEntry) == OperationStatus.SUCCESS) {
            jetxn.addUndo(new UndoByPut(this.mDatabase, txn, key, oldEntry));
            return true;
        }
        return false;
    }

    protected void db_truncate(JE_Transaction jetxn) throws Exception {
        this.close();
        JE_Repository repository = (JE_Repository)this.getRepository();
        repository.mEnv.truncateDatabase(jetxn == null ? null : jetxn.mTxn, this.mName, false);
        this.open(false, jetxn, false);
    }

    protected boolean db_isEmpty(JE_Transaction jetxn, Object database, boolean rmw) throws Exception {
        Cursor cursor = ((Database)database).openCursor(jetxn == null ? null : jetxn.mTxn, null);
        OperationStatus status = cursor.getFirst(new DatabaseEntry(), new DatabaseEntry(), (LockMode)(rmw ? LockMode.RMW : null));
        cursor.close();
        return status == OperationStatus.NOTFOUND;
    }

    protected void db_close(Object database) throws Exception {
        ((Database)database).close();
    }

    protected Object env_openPrimaryDatabase(JE_Transaction jetxn, String name) throws Exception {
        DatabaseConfig config;
        JE_Repository repository = (JE_Repository)this.getRepository();
        Environment env = repository.mEnv;
        boolean readOnly = env.getConfig().getReadOnly();
        try {
            config = (DatabaseConfig)repository.getInitialDatabaseConfig();
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Unsupported initial environment config. Must be instance of " + DatabaseConfig.class.getName(), (Throwable)e);
        }
        if (config == null) {
            config = new DatabaseConfig();
            JE_SetConfigOption.setBooleanParam(config, "setSortedDuplicates", false);
        } else if (config.getSortedDuplicates()) {
            throw new IllegalArgumentException("DatabaseConfig: getSortedDuplicates is true");
        }
        JE_SetConfigOption.setBooleanParam(config, "setTransactional", repository.mDatabasesTransactional);
        JE_SetConfigOption.setBooleanParam(config, "setReadOnly", readOnly);
        JE_SetConfigOption.setBooleanParam(config, "setAllowCreate", !readOnly);
        this.runDatabasePrepareForOpeningHook(config);
        this.mName = name;
        this.mDatabase = env.openDatabase(jetxn == null ? null : jetxn.mTxn, name, config);
        return this.mDatabase;
    }

    protected void env_removeDatabase(JE_Transaction jetxn, String databaseName) throws Exception {
        this.mDatabase.getEnvironment().removeDatabase(jetxn == null ? null : jetxn.mTxn, databaseName);
    }

    protected BDBCursor<JE_Transaction, S> openCursor(TransactionScope<JE_Transaction> scope, byte[] startBound, boolean inclusiveStart, byte[] endBound, boolean inclusiveEnd, int maxPrefix, boolean reverse, Object database) throws Exception {
        return new JE_Cursor(scope, startBound, inclusiveStart, endBound, inclusiveEnd, maxPrefix, reverse, this, (Database)database);
    }

    private class UndoByPut
    implements JE_Transaction.UndoAction {
        private final Database mDb;
        private final Transaction mTxn;
        private final byte[] mKey;
        private final DatabaseEntry mEntry;

        UndoByPut(Database db, Transaction txn, byte[] key, DatabaseEntry entry) {
            this.mDb = db;
            this.mTxn = txn;
            this.mKey = key;
            this.mEntry = entry;
        }

        public void apply() throws DatabaseException {
            if (this.mDb == JE_Storage.this.mDatabase) {
                this.mDb.put(this.mTxn, new DatabaseEntry(this.mKey), this.mEntry);
            }
        }
    }

    private class UndoByDelete
    implements JE_Transaction.UndoAction {
        private final Database mDb;
        private final Transaction mTxn;
        private final byte[] mKey;

        UndoByDelete(Database db, Transaction txn, byte[] key) {
            this.mDb = db;
            this.mTxn = txn;
            this.mKey = key;
        }

        public void apply() throws DatabaseException {
            if (this.mDb == JE_Storage.this.mDatabase) {
                this.mDb.delete(this.mTxn, new DatabaseEntry(this.mKey));
            }
        }
    }
}

