/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.sleepycat;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.repo.sleepycat.BDBProduct;
import com.amazon.carbonado.repo.sleepycat.BDBRepositoryBuilder;
import com.amazon.carbonado.repo.sleepycat.BDBStorage;
import com.amazon.carbonado.repo.sleepycat.DBX_Storage;
import com.amazon.carbonado.repo.sleepycat.DB_Repository;
import com.amazon.carbonado.spi.ExceptionTransformer;
import com.sleepycat.db.Transaction;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBX_Repository
extends DB_Repository {
    final ReadWriteLock mRWLock = new ReentrantReadWriteLock(false);
    private final Lock mTxnLock = new ReentrantLock(true);
    private final Condition mTxnCondition = this.mTxnLock.newCondition();
    private Object mActiveTxn;
    private Thread mActiveTxnThread;

    DBX_Repository(AtomicReference<Repository> rootRef, BDBRepositoryBuilder builder) throws RepositoryException {
        super(rootRef, builder);
    }

    DBX_Repository(AtomicReference<Repository> rootRef, BDBRepositoryBuilder builder, ExceptionTransformer exTransformer) throws RepositoryException {
        super(rootRef, builder, exTransformer);
    }

    @Override
    public BDBProduct getBDBProduct() {
        return BDBProduct.DB;
    }

    @Override
    protected <S extends Storable> BDBStorage<Transaction, S> createBDBStorage(Class<S> type) throws Exception {
        return new DBX_Storage<S>(this, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Transaction txn_begin(Transaction parent, IsolationLevel level) throws Exception {
        if (level == IsolationLevel.READ_UNCOMMITTED) {
            return super.txn_begin(parent, level);
        }
        Lock lock = this.acquire(parent, this.mLockTimeoutMicros);
        try {
            Transaction txn = super.txn_begin(parent, level);
            if (lock != null) {
                this.addActiveTxn(txn);
            }
            Transaction transaction = txn;
            return transaction;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Transaction txn_begin(Transaction parent, IsolationLevel level, int timeout, TimeUnit unit) throws Exception {
        long timeoutMicros = unit.toMicros(timeout);
        if (level == IsolationLevel.READ_UNCOMMITTED) {
            Transaction txn = super.txn_begin(parent, level);
            txn.setLockTimeout(timeoutMicros);
            return txn;
        }
        Lock lock = this.acquire(parent, timeoutMicros);
        try {
            Transaction txn = super.txn_begin(parent, level);
            txn.setLockTimeout(timeoutMicros);
            if (lock != null) {
                this.addActiveTxn(txn);
            }
            Transaction transaction = txn;
            return transaction;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Transaction txn_begin_nowait(Transaction parent, IsolationLevel level) throws Exception {
        if (level == IsolationLevel.READ_UNCOMMITTED) {
            return super.txn_begin_nowait(parent, level);
        }
        Lock lock = this.acquire(parent, 0L);
        try {
            Transaction txn = super.txn_begin_nowait(parent, level);
            if (lock != null) {
                this.addActiveTxn(txn);
            }
            Transaction transaction = txn;
            return transaction;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    @Override
    protected void txn_commit(Transaction txn) throws Exception {
        super.txn_commit(txn);
        this.release(txn);
    }

    @Override
    protected void txn_abort(Transaction txn) throws Exception {
        super.txn_abort(txn);
        this.release(txn);
    }

    private Lock acquire(Transaction parent, long timeoutMicros) throws Exception {
        if (parent != null) {
            return null;
        }
        Thread thread = Thread.currentThread();
        Lock lock = this.mTxnLock;
        lock.lock();
        try {
            block6: {
                if (this.mActiveTxnThread == thread) {
                    return lock;
                }
                if (this.mActiveTxn != null) {
                    long timeoutNanos = TimeUnit.MICROSECONDS.toNanos(timeoutMicros);
                    do {
                        timeoutNanos = this.mTxnCondition.awaitNanos(timeoutNanos);
                        if (this.mActiveTxn == null) break block6;
                    } while (timeoutNanos > 0L);
                    throw new PersistTimeoutException("Timed out waiting for transaction semaphore: " + timeoutMicros + " microseconds");
                }
            }
            this.mActiveTxnThread = thread;
            return lock;
        }
        catch (Exception e) {
            lock.unlock();
            throw e;
        }
    }

    private void addActiveTxn(Transaction txn) {
        Object active = this.mActiveTxn;
        if (active == null) {
            this.mActiveTxn = txn;
        } else if (active instanceof Transaction) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(active);
            list.add(txn);
            this.mActiveTxn = list;
        } else {
            ((ArrayList)active).add(txn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(Transaction txn) {
        Lock lock = this.mTxnLock;
        lock.lock();
        try {
            ArrayList list;
            Object active = this.mActiveTxn;
            if (txn == active) {
                this.mActiveTxn = null;
                this.mActiveTxnThread = null;
                this.mTxnCondition.signal();
            } else if (active instanceof ArrayList && (list = (ArrayList)active).remove(txn)) {
                if (list.isEmpty()) {
                    this.mActiveTxn = null;
                    this.mActiveTxnThread = null;
                }
                this.mTxnCondition.signal();
            }
        }
        finally {
            lock.unlock();
        }
    }
}

