/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractWeakPool<K, V, E extends Exception> {
    private final ConcurrentMap<K, ValueRef<K, V>> mValues = new ConcurrentHashMap<K, ValueRef<K, V>>();
    private final ReferenceQueue<V> mValueRefQueue = new ReferenceQueue();

    protected AbstractWeakPool() {
    }

    public V get(K key) throws E {
        Object value;
        this.clean();
        ValueRef valueRef = (ValueRef)this.mValues.get(key);
        if (valueRef == null || (value = valueRef.get()) == null) {
            ValueRef existingRef;
            try {
                value = this.create(key);
            }
            catch (Exception e) {
                ThrowUnchecked.fire((Throwable)e);
                return null;
            }
            valueRef = new ValueRef(value, this.mValueRefQueue, key);
            while ((existingRef = this.mValues.putIfAbsent(key, valueRef)) != null) {
                Object existing = existingRef.get();
                if (existing != null) {
                    value = existing;
                    valueRef.clear();
                    break;
                }
                this.mValues.remove(existingRef.mKey, existingRef);
            }
        }
        return (V)value;
    }

    public V remove(Object key) {
        Object value;
        this.clean();
        ValueRef valueRef = (ValueRef)this.mValues.remove(key);
        if (valueRef != null && (value = valueRef.get()) != null) {
            valueRef.clear();
            return (V)value;
        }
        return null;
    }

    protected abstract V create(K var1) throws E;

    private void clean() {
        Reference<V> ref;
        while ((ref = this.mValueRefQueue.poll()) != null) {
            this.mValues.remove(((ValueRef)ref).mKey, ref);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueRef<K, V>
    extends WeakReference<V> {
        final K mKey;

        ValueRef(V value, ReferenceQueue<V> queue, K key) {
            super(value, queue);
            this.mKey = key;
        }
    }
}

