/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.txn;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.spi.ExceptionTransformer;
import com.amazon.carbonado.txn.TransactionManager;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionScope<Txn> {
    final Lock mLock = new ReentrantLock(true);
    TransactionManager<Txn> mTxnMgr;
    TransactionImpl<Txn> mActive;
    private Map<Class<?>, CursorList<TransactionImpl<Txn>>> mCursors;
    private boolean mClosed;
    private boolean mDetached;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionScope(TransactionManager<Txn> txnMgr, boolean closed) {
        this.mTxnMgr = txnMgr;
        if (closed) {
            this.mLock.lock();
            try {
                this.mClosed = true;
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction enter(IsolationLevel level) {
        this.mLock.lock();
        try {
            TransactionImpl<Txn> parent = this.mActive;
            IsolationLevel actualLevel = this.mTxnMgr.selectIsolationLevel(parent, level);
            if (actualLevel == null) {
                if (parent == null) {
                    throw new UnsupportedOperationException("Desired isolation level not supported: " + (Object)((Object)level));
                }
                throw new UnsupportedOperationException("Desired isolation level not supported: " + (Object)((Object)level) + "; parent isolation level: " + (Object)((Object)parent.getIsolationLevel()));
            }
            TransactionImpl<Txn> txn = new TransactionImpl<Txn>(this, parent, false, actualLevel);
            this.mActive = txn;
            this.mTxnMgr.entered(txn, parent);
            TransactionImpl<Txn> transactionImpl = txn;
            return transactionImpl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction enterTop(IsolationLevel level) {
        this.mLock.lock();
        try {
            IsolationLevel actualLevel = this.mTxnMgr.selectIsolationLevel(null, level);
            if (actualLevel == null) {
                throw new UnsupportedOperationException("Desired isolation level not supported: " + (Object)((Object)level));
            }
            TransactionImpl<Txn> txn = new TransactionImpl<Txn>(this, this.mActive, true, actualLevel);
            this.mActive = txn;
            this.mTxnMgr.entered(txn, null);
            TransactionImpl<Txn> transactionImpl = txn;
            return transactionImpl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    void exited(TransactionImpl<Txn> txn, TransactionImpl<Txn> active) {
        this.mActive = active;
        this.mTxnMgr.exited(txn, active);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends Storable> void register(Class<S> type, Cursor<S> cursor) {
        this.mLock.lock();
        try {
            CursorList<TransactionImpl<Object>> cursorList;
            this.checkClosed();
            if (this.mCursors == null) {
                this.mCursors = new IdentityHashMap();
            }
            if ((cursorList = this.mCursors.get(type)) == null) {
                cursorList = new CursorList();
                this.mCursors.put(type, cursorList);
            }
            cursorList.register(cursor, this.mActive);
            if (this.mActive != null) {
                this.mActive.register(cursor);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends Storable> void unregister(Class<S> type, Cursor<S> cursor) {
        this.mLock.lock();
        try {
            TransactionImpl<Txn> txnImpl;
            CursorList<TransactionImpl<Txn>> cursorList;
            if (this.mCursors != null && (cursorList = this.mCursors.get(type)) != null && (txnImpl = cursorList.unregister(cursor)) != null) {
                txnImpl.unregister(cursor);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public Lock getLock() {
        return this.mLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Txn getTxn() throws Exception {
        this.mLock.lock();
        try {
            this.checkClosed();
            Txn Txn = this.mActive == null ? null : (Txn)this.mActive.getTxn();
            return Txn;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Txn getActiveTxn() {
        this.mLock.lock();
        try {
            this.checkClosed();
            Txn Txn = this.mActive == null ? null : (Txn)this.mActive.getActiveTxn();
            return Txn;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isForUpdate() {
        this.mLock.lock();
        try {
            boolean bl = this.mClosed || this.mActive == null ? false : this.mActive.isForUpdate();
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsolationLevel getIsolationLevel() {
        this.mLock.lock();
        try {
            IsolationLevel isolationLevel = this.mClosed || this.mActive == null ? null : this.mActive.getIsolationLevel();
            return isolationLevel;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach() {
        block5: {
            this.mLock.lock();
            try {
                if (this.mTxnMgr.setLocalScope(this, this.mDetached)) {
                    this.mDetached = false;
                    break block5;
                }
                if (!this.mDetached) {
                    throw new IllegalStateException("Transaction scope is not detached");
                }
                throw new IllegalStateException("Current thread has a different transaction already attached");
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        block4: {
            this.mLock.lock();
            try {
                if (this.mDetached || this.mTxnMgr.removeLocalScope(this)) {
                    this.mDetached = true;
                    break block4;
                }
                throw new IllegalStateException("Transaction is attached to a different thread");
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markDetached() {
        this.mLock.lock();
        try {
            this.mDetached = true;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInactive() {
        this.mLock.lock();
        try {
            boolean bl = this.mActive == null;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws RepositoryException {
        block8: {
            this.mLock.lock();
            try {
                if (this.mClosed) break block8;
                while (this.mActive != null) {
                    this.mActive.exit();
                }
                if (this.mCursors == null) break block8;
                try {
                    for (CursorList<TransactionImpl<Txn>> cursorList : this.mCursors.values()) {
                        cursorList.closeCursors();
                    }
                }
                finally {
                    this.mCursors = null;
                }
            }
            finally {
                this.mClosed = true;
                this.mTxnMgr = TransactionManager.Closed.THE;
                this.mLock.unlock();
            }
        }
    }

    private void checkClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Repository is closed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CursorList<V> {
        private int mSize;
        private Cursor<?>[] mCursors = new Cursor[8];
        private V[] mValues;

        CursorList() {
        }

        void register(Cursor<?> cursor, V value) {
            int size = this.mSize;
            Cursor<?>[] cursors = this.mCursors;
            if (size == cursors.length) {
                int newLength = size << 1;
                Cursor[] newCursors = new Cursor[newLength];
                System.arraycopy(cursors, 0, newCursors, 0, size);
                cursors = newCursors;
                this.mCursors = newCursors;
                if (this.mValues != null) {
                    Object[] newValues = new Object[newLength];
                    System.arraycopy(this.mValues, 0, newValues, 0, size);
                    this.mValues = newValues;
                }
            }
            cursors[size] = cursor;
            if (value != null) {
                Object[] values = this.mValues;
                if (values == null) {
                    this.mValues = values = new Object[cursors.length];
                }
                values[size] = value;
            }
            this.mSize = size + 1;
        }

        V unregister(Cursor<?> cursor) {
            V value;
            int i;
            int size;
            Cursor<?>[] cursors;
            block7: {
                cursors = this.mCursors;
                i = size = this.mSize;
                while (--i >= 0) {
                    if (cursors[i] != cursor) continue;
                    break block7;
                }
                return null;
            }
            V[] values = this.mValues;
            if (values == null) {
                value = null;
                if (i == size - 1) {
                    cursors[i] = null;
                } else {
                    System.arraycopy(cursors, i + 1, cursors, i, size - i - 1);
                }
            } else {
                value = values[i];
                if (i == size - 1) {
                    cursors[i] = null;
                    values[i] = null;
                } else {
                    System.arraycopy(cursors, i + 1, cursors, i, size - i - 1);
                    System.arraycopy(values, i + 1, values, i, size - i - 1);
                }
            }
            this.mSize = size - 1;
            return value;
        }

        int size() {
            return this.mSize;
        }

        Cursor<?> getCursor(int index) {
            return this.mCursors[index];
        }

        V getValue(int index) {
            V[] values = this.mValues;
            return values == null ? null : (V)values[index];
        }

        void closeCursors() throws PersistException {
            try {
                Cursor<?>[] cursors = this.mCursors;
                V[] values = this.mValues;
                int i = this.mSize;
                if (values == null) {
                    while (--i >= 0) {
                        Cursor<?> cursor = cursors[i];
                        if (cursor == null) continue;
                        cursor.close();
                        cursors[i] = null;
                    }
                } else {
                    while (--i >= 0) {
                        Cursor<?> cursor = cursors[i];
                        if (cursor == null) continue;
                        cursor.close();
                        cursors[i] = null;
                        values[i] = null;
                    }
                }
            }
            catch (FetchException e) {
                throw e.toPersistException();
            }
            this.mSize = 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransactionImpl<Txn>
    implements Transaction {
        private static final int READY = 0;
        private static final int PRE_COMMITED = 1;
        private static final int EXITED = 2;
        private final TransactionScope<Txn> mScope;
        private final TransactionImpl<Txn> mParent;
        private final boolean mTop;
        private final IsolationLevel mLevel;
        private boolean mForUpdate;
        private int mDesiredLockTimeout;
        private TimeUnit mTimeoutUnit;
        private TransactionImpl<Txn> mChild;
        private int mState;
        private Txn mTxn;
        private CursorList<?> mCursorList;

        TransactionImpl(TransactionScope<Txn> scope, TransactionImpl<Txn> parent, boolean top, IsolationLevel level) {
            this.mScope = scope;
            this.mParent = parent;
            this.mTop = top;
            this.mLevel = level;
            if (!top && parent != null) {
                parent.mChild = this;
                this.mDesiredLockTimeout = parent.mDesiredLockTimeout;
                this.mTimeoutUnit = parent.mTimeoutUnit;
            }
        }

        @Override
        public boolean preCommit() throws PersistException {
            this.mScope.mLock.lock();
            switch (this.mState) {
                case 2: {
                    this.mScope.mLock.unlock();
                    return false;
                }
                case 1: {
                    this.mScope.mLock.unlock();
                }
            }
            try {
                if (this.mChild != null) {
                    this.mChild.commit();
                }
                this.closeCursors();
                this.mState = 1;
                return true;
            }
            catch (Throwable e) {
                this.mState = 0;
                this.mScope.mLock.unlock();
                throw ExceptionTransformer.getInstance().toPersistException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() throws PersistException {
            block15: {
                TransactionScope<Txn> scope = this.mScope;
                scope.mLock.lock();
                try {
                    switch (this.mState) {
                        case 2: {
                            return;
                        }
                        case 1: {
                            this.mState = 0;
                            scope.mLock.unlock();
                            break;
                        }
                        default: {
                            if (this.mChild != null) {
                                this.mChild.commit();
                            }
                            this.closeCursors();
                        }
                    }
                    if (this.mTxn == null) break block15;
                    if (this.mParent == null || this.mParent.mTxn != this.mTxn) {
                        try {
                            if (!scope.mTxnMgr.commitTxn(this.mTxn)) {
                                this.mTxn = null;
                            }
                            break block15;
                        }
                        catch (Throwable e) {
                            try {
                                scope.mTxnMgr.abortTxn(this.mTxn);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.mTxn = null;
                            throw ExceptionTransformer.getInstance().toPersistException(e);
                        }
                    }
                    this.mTxn = null;
                }
                finally {
                    scope.mLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exit() throws PersistException {
            TransactionScope<Txn> scope = this.mScope;
            scope.mLock.lock();
            try {
                switch (this.mState) {
                    case 2: {
                        return;
                    }
                    case 1: {
                        scope.mLock.unlock();
                        break;
                    }
                }
                Exception exception = null;
                try {
                    block24: {
                        block23: {
                            if (this.mChild != null) {
                                try {
                                    this.mChild.exit();
                                }
                                catch (Exception e) {
                                    if (exception != null) break block23;
                                    exception = e;
                                }
                            }
                        }
                        try {
                            this.closeCursors();
                        }
                        catch (Exception e) {
                            if (exception != null) break block24;
                            exception = e;
                        }
                    }
                    if (this.mTxn != null) {
                        try {
                            block25: {
                                if (this.mParent == null || this.mParent.mTxn != this.mTxn) {
                                    try {
                                        scope.mTxnMgr.abortTxn(this.mTxn);
                                    }
                                    catch (Exception e) {
                                        if (exception != null) break block25;
                                        exception = e;
                                    }
                                }
                            }
                            this.mTxn = null;
                        }
                        catch (Throwable throwable) {
                            this.mTxn = null;
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.mState = 2;
                    scope.exited(this, this.mParent);
                    if (exception != null) {
                        throw ExceptionTransformer.getInstance().toPersistException(exception);
                    }
                }
            }
            finally {
                scope.mLock.unlock();
            }
        }

        @Override
        public void setForUpdate(boolean forUpdate) {
            this.mForUpdate = forUpdate &= this.mScope.mTxnMgr.supportsForUpdate();
            Txn txn = this.mTxn;
            if (txn != null) {
                this.mScope.mTxnMgr.setForUpdate(txn, forUpdate);
            }
        }

        @Override
        public boolean isForUpdate() {
            return this.mForUpdate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDesiredLockTimeout(int timeout, TimeUnit unit) {
            TransactionScope<Txn> scope = this.mScope;
            scope.mLock.lock();
            try {
                if (timeout < 0) {
                    this.mDesiredLockTimeout = 0;
                    this.mTimeoutUnit = null;
                } else {
                    this.mDesiredLockTimeout = timeout;
                    this.mTimeoutUnit = unit;
                }
            }
            finally {
                scope.mLock.unlock();
            }
        }

        @Override
        public IsolationLevel getIsolationLevel() {
            return this.mLevel;
        }

        @Override
        public void detach() {
            this.mScope.detach();
        }

        @Override
        public void attach() {
            this.mScope.attach();
        }

        <S extends Storable> void register(Cursor<S> cursor) {
            if (this.mCursorList == null) {
                this.mCursorList = new CursorList();
            }
            this.mCursorList.register(cursor, null);
        }

        <S extends Storable> void unregister(Cursor<S> cursor) {
            if (this.mCursorList != null) {
                this.mCursorList.unregister(cursor);
            }
        }

        Txn getTxn() throws Exception {
            TransactionScope<Txn> scope = this.mScope;
            if (this.mTxn != null) {
                scope.mTxnMgr.reuseTxn(this.mTxn);
            } else {
                Object parentTxn = this.mParent == null || this.mTop ? null : (Object)this.mParent.getTxn();
                this.mTxn = this.mTimeoutUnit == null ? scope.mTxnMgr.createTxn(parentTxn, this.mLevel) : scope.mTxnMgr.createTxn(parentTxn, this.mLevel, this.mDesiredLockTimeout, this.mTimeoutUnit);
            }
            if (this.mForUpdate) {
                scope.mTxnMgr.setForUpdate(this.mTxn, true);
            }
            return this.mTxn;
        }

        Txn getActiveTxn() {
            return this.mTxn;
        }

        private void closeCursors() throws PersistException {
            if (this.mCursorList != null) {
                this.mCursorList.closeCursors();
            }
        }
    }
}

