/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.synthetic;

import com.amazon.carbonado.info.StorablePropertyAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticProperty
implements Comparable<SyntheticProperty> {
    private final Class mType;
    private final String mName;
    private String mReadMethodName;
    private String mWriteMethodName;
    private boolean mIsNullable = false;
    private boolean mIsVersion = false;
    private StorablePropertyAdapter mAdapter;
    private List<String> mAnnotationDescs;

    public static String makeReadMethodName(String name, Class type) {
        return (type == Boolean.TYPE ? "is" : "get") + SyntheticProperty.makeUppercase(name);
    }

    public static String makeWriteMethodName(String name) {
        return "set" + SyntheticProperty.makeUppercase(name);
    }

    public SyntheticProperty(String name, Class type) {
        if (name == null || type == null) {
            throw new IllegalArgumentException();
        }
        this.mName = name;
        this.mType = type;
    }

    public SyntheticProperty(String name, Class type, boolean isNullable, boolean isVersion) {
        this.mIsNullable = isNullable;
        this.mIsVersion = isVersion;
        this.mName = name;
        this.mType = type;
    }

    public String getName() {
        return this.mName;
    }

    public Class getType() {
        return this.mType;
    }

    public boolean isNullable() {
        return this.mIsNullable;
    }

    public void setIsNullable(boolean isNullable) {
        this.mIsNullable = isNullable;
    }

    public boolean isVersion() {
        return this.mIsVersion;
    }

    public void setIsVersion(boolean isVersion) {
        this.mIsVersion = isVersion;
    }

    public String getReadMethodName() {
        if (this.mReadMethodName == null) {
            this.mReadMethodName = SyntheticProperty.makeReadMethodName(this.mName, this.mType);
        }
        return this.mReadMethodName;
    }

    void setReadMethodName(String name) {
        this.mReadMethodName = name;
    }

    public String getWriteMethodName() {
        if (this.mWriteMethodName == null) {
            this.mWriteMethodName = SyntheticProperty.makeWriteMethodName(this.mName);
        }
        return this.mWriteMethodName;
    }

    void setWriteMethodName(String name) {
        this.mWriteMethodName = name;
    }

    public StorablePropertyAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(StorablePropertyAdapter adapter) {
        this.mAdapter = adapter;
    }

    public void addAccessorAnnotationDescriptor(String annotationDesc) {
        if (this.mAnnotationDescs == null) {
            this.mAnnotationDescs = new ArrayList<String>(4);
        }
        this.mAnnotationDescs.add(annotationDesc);
    }

    public List<String> getAccessorAnnotationDescriptors() {
        if (this.mAnnotationDescs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mAnnotationDescs);
    }

    @Override
    public int compareTo(SyntheticProperty otherProp) {
        if (this == otherProp) {
            return 0;
        }
        return this.mName.compareTo(otherProp.mName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyntheticProperty)) {
            return false;
        }
        SyntheticProperty syntheticProperty = (SyntheticProperty)o;
        if (this.mIsNullable != syntheticProperty.mIsNullable) {
            return false;
        }
        if (this.mIsVersion != syntheticProperty.mIsVersion) {
            return false;
        }
        if (this.mName != null ? !this.mName.equals(syntheticProperty.mName) : syntheticProperty.mName != null) {
            return false;
        }
        return !(this.mType != null ? !this.mType.equals(syntheticProperty.mType) : syntheticProperty.mType != null);
    }

    public int hashCode() {
        int result = this.mType != null ? this.mType.hashCode() : 0;
        result = 29 * result + (this.mName != null ? this.mName.hashCode() : 0);
        result = 29 * result + (this.mIsNullable ? 1 : 0);
        result = 29 * result + (this.mIsVersion ? 1 : 0);
        return result;
    }

    private static String makeUppercase(String name) {
        if (name.length() > 0 && !Character.isUpperCase(name.charAt(0))) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    public String toString() {
        return this.mName + '|' + (this.mIsNullable ? "NULL|" : "") + (this.mIsVersion ? "VERS|" : "") + '(' + this.mType + ')';
    }
}

