/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.info.Direction;
import java.util.Arrays;

public class IndexInfoImpl
implements IndexInfo {
    private final String mName;
    private final boolean mUnique;
    private final boolean mClustered;
    private final String[] mPropertyNames;
    private final Direction[] mPropertyDirections;

    public IndexInfoImpl(String name, boolean unique, boolean clustered, String[] propertyNames, Direction[] propertyDirections) {
        this.mName = name;
        this.mUnique = unique;
        this.mClustered = clustered;
        if (propertyNames == null || propertyNames.length == 0) {
            throw new IllegalArgumentException();
        }
        int i = propertyNames.length;
        while (--i >= 0) {
            if (propertyNames[i] != null) continue;
            throw new IllegalArgumentException();
        }
        propertyNames = (String[])propertyNames.clone();
        if (propertyDirections == null) {
            propertyDirections = new Direction[propertyNames.length];
        } else {
            if (propertyNames.length != propertyDirections.length) {
                throw new IllegalArgumentException();
            }
            propertyDirections = (Direction[])propertyDirections.clone();
        }
        i = propertyDirections.length;
        while (--i >= 0) {
            if (propertyDirections[i] != null) continue;
            propertyDirections[i] = Direction.UNSPECIFIED;
        }
        this.mPropertyNames = propertyNames;
        this.mPropertyDirections = propertyDirections;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isUnique() {
        return this.mUnique;
    }

    public boolean isClustered() {
        return this.mClustered;
    }

    public String[] getPropertyNames() {
        return (String[])this.mPropertyNames.clone();
    }

    public Direction[] getPropertyDirections() {
        return (Direction[])this.mPropertyDirections.clone();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IndexInfo {name=");
        b.append(this.mName);
        b.append(", unique=");
        b.append(this.mUnique);
        b.append(", propertyNames=");
        b.append(Arrays.toString(this.mPropertyNames));
        b.append(", propertyDirections=");
        b.append(Arrays.toString((Object[])this.mPropertyDirections));
        b.append('}');
        return b.toString();
    }
}

