/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryBuilder;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.capability.Capability;
import com.amazon.carbonado.util.BelatedCreator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BelatedRepositoryCreator
extends BelatedCreator<Repository, SupportException> {
    final Log mLog;
    final RepositoryBuilder mBuilder;
    final AtomicReference<Repository> mRootRef;
    private boolean mRetry;

    public BelatedRepositoryCreator(Log log, RepositoryBuilder builder, int minRetryDelayMillis) {
        this(log, builder, new AtomicReference<Repository>(), minRetryDelayMillis);
    }

    public BelatedRepositoryCreator(Log log, RepositoryBuilder builder, AtomicReference<Repository> rootRef, int minRetryDelayMillis) {
        super(Repository.class, minRetryDelayMillis);
        this.mLog = log;
        this.mBuilder = builder;
        this.mRootRef = rootRef;
    }

    @Override
    protected Repository createReal() throws SupportException {
        Exception error;
        AtomicReference<Repository> rootRef = this.mRetry ? new AtomicReference<Repository>() : this.mRootRef;
        this.mRetry = true;
        try {
            return this.mBuilder.build(rootRef);
        }
        catch (SupportException e) {
            throw e;
        }
        catch (RepositoryException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException) {
                throw new SupportException(cause);
            }
            error = e;
        }
        catch (Exception e) {
            error = e;
        }
        this.mLog.error((Object)("Error building Repository \"" + this.mBuilder.getName() + '\"'), (Throwable)error);
        return null;
    }

    @Override
    protected Repository createBogus() {
        return new BogusRepository();
    }

    @Override
    protected void timedOutNotification(long timedOutMillis) {
        this.mLog.error((Object)("Timed out waiting for Repository \"" + this.mBuilder.getName() + "\" to build after waiting " + timedOutMillis + " milliseconds"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BogusRepository
    implements Repository {
        private BogusRepository() {
        }

        @Override
        public String getName() {
            return BelatedRepositoryCreator.this.mBuilder.getName();
        }

        @Override
        public synchronized <S extends Storable> Storage<S> storageFor(Class<S> type) {
            throw this.error();
        }

        @Override
        public Transaction enterTransaction() {
            throw this.error();
        }

        @Override
        public Transaction enterTransaction(IsolationLevel level) {
            throw this.error();
        }

        @Override
        public Transaction enterTopTransaction(IsolationLevel level) {
            throw this.error();
        }

        @Override
        public IsolationLevel getTransactionIsolationLevel() {
            return null;
        }

        @Override
        public <C extends Capability> C getCapability(Class<C> capabilityType) {
            throw this.error();
        }

        @Override
        public void close() {
        }

        public boolean isClosed() {
            return false;
        }

        private IllegalStateException error() {
            return new IllegalStateException("Creation of Repository \"" + BelatedRepositoryCreator.this.mBuilder.getName() + "\" is delayed");
        }
    }
}

