/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.spi;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryBuilder;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.TriggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryBuilder
implements RepositoryBuilder {
    private final Set<TriggerFactory> mTriggerFactories = new LinkedHashSet<TriggerFactory>(2);

    protected AbstractRepositoryBuilder() {
    }

    @Override
    public Repository build() throws ConfigurationException, RepositoryException {
        return this.build(new AtomicReference<Repository>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTriggerFactory(TriggerFactory factory) {
        Set<TriggerFactory> set = this.mTriggerFactories;
        synchronized (set) {
            return this.mTriggerFactories.add(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTriggerFactory(TriggerFactory factory) {
        Set<TriggerFactory> set = this.mTriggerFactories;
        synchronized (set) {
            return this.mTriggerFactories.remove(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<TriggerFactory> getTriggerFactories() {
        Set<TriggerFactory> set = this.mTriggerFactories;
        synchronized (set) {
            if (this.mTriggerFactories.size() == 0) {
                return Collections.emptyList();
            }
            return new ArrayList<TriggerFactory>(this.mTriggerFactories);
        }
    }

    public final void assertReady() throws ConfigurationException {
        ArrayList<String> messages = new ArrayList<String>();
        this.errorCheck(messages);
        int size = messages.size();
        if (size == 0) {
            return;
        }
        StringBuilder b = new StringBuilder();
        if (size > 1) {
            b.append("Multiple problems: ");
        }
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                b.append("; ");
            }
            b.append(messages.get(i));
        }
        throw new ConfigurationException(b.toString());
    }

    public void errorCheck(Collection<String> messages) throws ConfigurationException {
        if (this.getName() == null) {
            messages.add("name missing");
        }
    }
}

