/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.map;

import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.repo.map.MapTransaction;
import com.amazon.carbonado.txn.TransactionManager;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapTransactionManager
extends TransactionManager<MapTransaction> {
    private final int mLockTimeout;
    private final TimeUnit mLockTimeoutUnit;

    MapTransactionManager(int lockTimeout, TimeUnit lockTimeoutUnit) {
        this.mLockTimeout = lockTimeout;
        this.mLockTimeoutUnit = lockTimeoutUnit;
    }

    @Override
    protected IsolationLevel selectIsolationLevel(Transaction parent, IsolationLevel level) {
        if (level == null) {
            if (parent == null) {
                return IsolationLevel.READ_COMMITTED;
            }
            return parent.getIsolationLevel();
        }
        switch (level) {
            case NONE: {
                return IsolationLevel.NONE;
            }
            case READ_UNCOMMITTED: 
            case READ_COMMITTED: {
                return IsolationLevel.READ_COMMITTED;
            }
            case REPEATABLE_READ: 
            case SERIALIZABLE: {
                return IsolationLevel.SERIALIZABLE;
            }
        }
        return null;
    }

    @Override
    protected boolean supportsForUpdate() {
        return true;
    }

    @Override
    protected MapTransaction createTxn(MapTransaction parent, IsolationLevel level) throws Exception {
        if (level == IsolationLevel.NONE) {
            return null;
        }
        return new MapTransaction(parent, level, this.mLockTimeout, this.mLockTimeoutUnit);
    }

    @Override
    protected MapTransaction createTxn(MapTransaction parent, IsolationLevel level, int timeout, TimeUnit unit) throws Exception {
        if (level == IsolationLevel.NONE) {
            return null;
        }
        return new MapTransaction(parent, level, timeout, unit);
    }

    @Override
    protected boolean commitTxn(MapTransaction txn) throws PersistException {
        txn.commit();
        return false;
    }

    @Override
    protected void abortTxn(MapTransaction txn) throws PersistException {
        txn.abort();
    }
}

