/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.logging;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryBuilder;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.TriggerFactory;
import com.amazon.carbonado.repo.logging.CommonsLog;
import com.amazon.carbonado.repo.logging.Log;
import com.amazon.carbonado.repo.logging.LoggingRepository;
import com.amazon.carbonado.spi.AbstractRepositoryBuilder;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingRepositoryBuilder
extends AbstractRepositoryBuilder {
    private String mName;
    private Boolean mMaster;
    private Log mLog;
    private RepositoryBuilder mRepoBuilder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repository build(AtomicReference<Repository> rootRef) throws RepositoryException {
        Repository actual;
        if (this.mName == null && this.mRepoBuilder != null) {
            this.mName = this.mRepoBuilder.getName();
        }
        this.assertReady();
        if (this.mLog == null) {
            this.mLog = new CommonsLog(LoggingRepository.class);
        }
        String originalName = this.mRepoBuilder.getName();
        boolean originalIsMaster = this.mRepoBuilder.isMaster();
        boolean enabled = this.mLog.isEnabled();
        boolean master = this.mMaster != null ? this.mMaster : originalIsMaster;
        try {
            if (enabled) {
                this.mRepoBuilder.setName("Logging " + this.mName);
            }
            this.mRepoBuilder.setMaster(master);
            for (TriggerFactory factory : this.getTriggerFactories()) {
                this.mRepoBuilder.addTriggerFactory(factory);
            }
            actual = this.mRepoBuilder.build(rootRef);
        }
        finally {
            this.mRepoBuilder.setName(originalName);
            this.mRepoBuilder.setMaster(originalIsMaster);
        }
        if (!enabled) {
            return actual;
        }
        LoggingRepository repo = new LoggingRepository(rootRef, actual, this.mLog);
        rootRef.set(repo);
        return repo;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setMaster(boolean master) {
        this.mMaster = master;
    }

    @Override
    public boolean isMaster() {
        return this.mMaster != null ? this.mMaster : (this.mRepoBuilder != null ? this.mRepoBuilder.isMaster() : false);
    }

    public void setLog(Log log) {
        this.mLog = log;
    }

    public Log getLog() {
        return this.mLog;
    }

    public void setActualRepositoryBuilder(RepositoryBuilder builder) {
        this.mRepoBuilder = builder;
    }

    public RepositoryBuilder getActualRepositoryBuilder() {
        return this.mRepoBuilder;
    }

    @Override
    public void errorCheck(Collection<String> messages) throws ConfigurationException {
        super.errorCheck(messages);
        if (this.mRepoBuilder == null) {
            messages.add("Actual repository builder must be set");
        }
    }
}

