/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.lob.Blob;
import com.amazon.carbonado.repo.jdbc.JDBCBlob;
import com.amazon.carbonado.repo.jdbc.JDBCBlobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCClob;
import com.amazon.carbonado.repo.jdbc.JDBCClobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCExceptionTransformer;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.JDBCSupportStrategy;
import com.amazon.carbonado.repo.jdbc.OracleBlob;
import com.amazon.carbonado.repo.jdbc.OracleClob;
import com.amazon.carbonado.repo.jdbc.OracleExceptionTransformer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.LogFactory;

class OracleSupportStrategy
extends JDBCSupportStrategy {
    private static final String DEFAULT_SEQUENCE_SELECT_STATEMENT = "SELECT %s.NEXTVAL FROM DUAL";
    private static final String TRUNCATE_STATEMENT = "TRUNCATE TABLE %s";
    private static final int BLOB_CHUNK_LIMIT = 2000;
    private static final int CLOB_CHUNK_LIMIT = 1000;
    final Method mBLOB_empty_lob;
    final Method mBLOB_getBinaryStream;
    final Method mBLOB_length;
    final Method mBLOB_getBinaryOutputStream;
    final Method mBLOB_trim;
    final Method mCLOB_empty_lob;
    final Method mCLOB_getCharacterStream;
    final Method mCLOB_length;
    final Method mCLOB_getCharacterOutputStream;
    final Method mCLOB_trim;

    protected OracleSupportStrategy(JDBCRepository repo) {
        super(repo);
        this.setSequenceSelectStatement(DEFAULT_SEQUENCE_SELECT_STATEMENT);
        this.setTruncateTableStatement(TRUNCATE_STATEMENT);
        Method blob_empty_lob = null;
        Method blob_getBinaryStream = null;
        Method blob_length = null;
        Method blob_getBinaryOutputStream = null;
        Method blob_trim = null;
        try {
            Class<?> blobClass = Class.forName("oracle.sql.BLOB");
            blob_empty_lob = blobClass.getMethod("empty_lob", new Class[0]);
            blob_getBinaryStream = blobClass.getMethod("getBinaryStream", Long.TYPE);
            blob_length = blobClass.getMethod("length", new Class[0]);
            blob_getBinaryOutputStream = blobClass.getMethod("getBinaryOutputStream", Long.TYPE);
            blob_trim = blobClass.getMethod("trim", Long.TYPE);
        }
        catch (ClassNotFoundException e) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to find Oracle BLOB class", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to find Oracle BLOB method", (Throwable)e);
        }
        this.mBLOB_empty_lob = blob_empty_lob;
        this.mBLOB_getBinaryStream = blob_getBinaryStream;
        this.mBLOB_length = blob_length;
        this.mBLOB_getBinaryOutputStream = blob_getBinaryOutputStream;
        this.mBLOB_trim = blob_trim;
        Method clob_empty_lob = null;
        Method clob_getCharacterStream = null;
        Method clob_length = null;
        Method clob_getCharacterOutputStream = null;
        Method clob_trim = null;
        try {
            Class<?> clobClass = Class.forName("oracle.sql.CLOB");
            clob_empty_lob = clobClass.getMethod("empty_lob", new Class[0]);
            clob_getCharacterStream = clobClass.getMethod("getCharacterStream", Long.TYPE);
            clob_length = clobClass.getMethod("length", new Class[0]);
            clob_getCharacterOutputStream = clobClass.getMethod("getCharacterOutputStream", Long.TYPE);
            clob_trim = clobClass.getMethod("trim", Long.TYPE);
        }
        catch (ClassNotFoundException e) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to find Oracle CLOB class", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LogFactory.getLog(this.getClass()).warn((Object)"Unable to find Oracle CLOB method", (Throwable)e);
        }
        this.mCLOB_empty_lob = clob_empty_lob;
        this.mCLOB_getCharacterStream = clob_getCharacterStream;
        this.mCLOB_length = clob_length;
        this.mCLOB_getCharacterOutputStream = clob_getCharacterOutputStream;
        this.mCLOB_trim = clob_trim;
    }

    JDBCExceptionTransformer createExceptionTransformer() {
        return new OracleExceptionTransformer();
    }

    JDBCBlob convertBlob(java.sql.Blob blob, JDBCBlobLoader loader) {
        return blob == null ? null : new OracleBlob(this.mRepo, blob, loader);
    }

    JDBCClob convertClob(Clob clob, JDBCClobLoader loader) {
        return clob == null ? null : new OracleClob(this.mRepo, clob, loader);
    }

    Blob setBlobValue(PreparedStatement ps, int column, Blob blob) throws PersistException {
        try {
            long length = blob.getLength();
            if (length > 2000L || (long)((int)length) != length) {
                if (this.mBLOB_empty_lob == null) {
                    return super.setBlobValue(ps, column, blob);
                }
                try {
                    ps.setBlob(column, (java.sql.Blob)this.mBLOB_empty_lob.invoke(null, new Object[0]));
                    return blob;
                }
                catch (InvocationTargetException e) {
                    throw this.mRepo.toPersistException(e.getCause());
                }
                catch (Exception e) {
                    throw this.mRepo.toPersistException(e);
                }
            }
            if (blob instanceof OracleBlob) {
                ps.setBlob(column, ((OracleBlob)blob).getInternalBlobForPersist());
                return null;
            }
            ps.setBinaryStream(column, blob.openInputStream(), (int)length);
            return null;
        }
        catch (SQLException e) {
            throw this.mRepo.toPersistException(e);
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    com.amazon.carbonado.lob.Clob setClobValue(PreparedStatement ps, int column, com.amazon.carbonado.lob.Clob clob) throws PersistException {
        try {
            long length = clob.getLength();
            if (length > 1000L || (long)((int)length) != length) {
                if (this.mCLOB_empty_lob == null) {
                    return super.setClobValue(ps, column, clob);
                }
                try {
                    ps.setClob(column, (Clob)this.mCLOB_empty_lob.invoke(null, new Object[0]));
                    return clob;
                }
                catch (InvocationTargetException e) {
                    throw this.mRepo.toPersistException(e.getCause());
                }
                catch (Exception e) {
                    throw this.mRepo.toPersistException(e);
                }
            }
            if (clob instanceof OracleClob) {
                ps.setClob(column, ((OracleClob)clob).getInternalClobForPersist());
                return null;
            }
            ps.setCharacterStream(column, clob.openReader(), (int)length);
            return null;
        }
        catch (SQLException e) {
            throw this.mRepo.toPersistException(e);
        }
        catch (FetchException e) {
            throw e.toPersistException();
        }
    }

    JDBCSupportStrategy.SliceOption getSliceOption() {
        return JDBCSupportStrategy.SliceOption.FROM_AND_TO;
    }

    String buildSelectWithSlice(String select, boolean from, boolean to) {
        if (to) {
            if (from) {
                return "SELECT * FROM (SELECT \"A ROW\".*, ROWNUM \"A ROWNUM\" FROM (" + select + ") \"A ROW\") WHERE \"A ROWNUM\" > ? AND \"A ROWNUM\" <= ?";
            }
            return "SELECT * FROM (" + select + ") WHERE ROWNUM <= ?";
        }
        if (from) {
            return "SELECT * FROM (SELECT \"A ROW\".*, ROWNUM \"A ROWNUM\" FROM (" + select + ") \"A ROW\") WHERE \"A ROWNUM\" > ?";
        }
        return select;
    }
}

