/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.repo.jdbc.JDBCExceptionTransformer;
import java.sql.SQLException;

class OracleExceptionTransformer
extends JDBCExceptionTransformer {
    public static int UNIQUE_CONSTRAINT_VIOLATION = 1;
    public static int INSUFFICIENT_PRIVILEGES = 1031;
    public static int DEADLOCK_DETECTED = 60;
    public static int PROCESSING_CANCELED = 1013;

    OracleExceptionTransformer() {
    }

    public boolean isUniqueConstraintError(SQLException e) {
        if (this.isConstraintError(e)) {
            String sqlstate = e.getSQLState();
            int errorCode = e.getErrorCode();
            return UNIQUE_CONSTRAINT_VIOLATION == errorCode || SQLSTATE_UNIQUE_CONSTRAINT_VIOLATION.equals(sqlstate);
        }
        return false;
    }

    public boolean isInsufficientPrivilegesError(SQLException e) {
        if (e != null) {
            int errorCode = e.getErrorCode();
            return INSUFFICIENT_PRIVILEGES == errorCode;
        }
        return false;
    }

    public boolean isDeadlockError(SQLException e) {
        if (super.isDeadlockError(e)) {
            return true;
        }
        if (e != null) {
            int errorCode = e.getErrorCode();
            return DEADLOCK_DETECTED == errorCode;
        }
        return false;
    }

    public boolean isTimeoutError(SQLException e) {
        return super.isTimeoutError(e) || e != null && PROCESSING_CANCELED == e.getErrorCode();
    }
}

