/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.repo.jdbc.JDBCBlob;
import com.amazon.carbonado.repo.jdbc.JDBCBlobLoader;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.OracleSupportStrategy;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;

class OracleBlob
extends JDBCBlob {
    OracleBlob(JDBCRepository repo, Blob blob, JDBCBlobLoader loader) {
        super(repo, blob, loader);
    }

    public InputStream openInputStream() throws FetchException {
        return this.openInputStream(0L);
    }

    public InputStream openInputStream(long pos) throws FetchException {
        Method m = this.support().mBLOB_getBinaryStream;
        if (m == null) {
            return super.openInputStream(pos);
        }
        try {
            return (InputStream)m.invoke((Object)this.getInternalBlobForFetch(), pos);
        }
        catch (InvocationTargetException e) {
            throw this.mRepo.toFetchException(e.getCause());
        }
        catch (Exception e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public InputStream openInputStream(long pos, int bufferSize) throws FetchException {
        return this.openInputStream(pos);
    }

    public long getLength() throws FetchException {
        Method m = this.support().mBLOB_length;
        if (m == null) {
            return super.getLength();
        }
        try {
            return (Long)m.invoke((Object)this.getInternalBlobForFetch(), new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw this.mRepo.toFetchException(e.getCause());
        }
        catch (Exception e) {
            throw this.mRepo.toFetchException(e);
        }
    }

    public OutputStream openOutputStream() throws PersistException {
        return this.openOutputStream(0L);
    }

    public OutputStream openOutputStream(long pos) throws PersistException {
        Method m = this.support().mBLOB_getBinaryOutputStream;
        if (m == null) {
            return super.openOutputStream(pos);
        }
        try {
            return (OutputStream)m.invoke((Object)this.getInternalBlobForPersist(), pos);
        }
        catch (InvocationTargetException e) {
            throw this.mRepo.toPersistException(e.getCause());
        }
        catch (Exception e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    public OutputStream openOutputStream(long pos, int bufferSize) throws PersistException {
        return this.openOutputStream(pos);
    }

    public void setLength(long length) throws PersistException {
        Method m = this.support().mBLOB_trim;
        if (m == null) {
            super.setLength(length);
            return;
        }
        try {
            m.invoke((Object)this.getInternalBlobForPersist(), length);
        }
        catch (InvocationTargetException e) {
            throw this.mRepo.toPersistException(e.getCause());
        }
        catch (Exception e) {
            throw this.mRepo.toPersistException(e);
        }
    }

    private OracleSupportStrategy support() {
        return (OracleSupportStrategy)this.mRepo.getSupportStrategy();
    }
}

