/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.LoggingConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingDataSource
implements DataSource {
    private final Log mLog;
    private final DataSource mDataSource;

    public static DataSource create(DataSource ds) {
        return LoggingDataSource.create(ds, null);
    }

    public static DataSource create(DataSource ds, Log log) {
        if (ds == null) {
            throw new IllegalArgumentException();
        }
        if (log == null) {
            log = LogFactory.getLog(LoggingDataSource.class);
        }
        if (!log.isDebugEnabled()) {
            return ds;
        }
        return new LoggingDataSource(log, ds);
    }

    private LoggingDataSource(Log log, DataSource ds) {
        this.mLog = log;
        this.mDataSource = ds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.mLog.debug((Object)"DataSource.getConnection()");
        return new LoggingConnection(this.mLog, this.mDataSource.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.mLog.debug((Object)"DataSource.getConnection(username, password)");
        return new LoggingConnection(this.mLog, this.mDataSource.getConnection(username, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.mDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter writer) throws SQLException {
        this.mDataSource.setLogWriter(writer);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.mDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.mDataSource.getLoginTimeout();
    }

    public void close() throws SQLException {
        this.mLog.debug((Object)"DataSource.close()");
        if (!JDBCRepository.closeDataSource(this.mDataSource)) {
            this.mLog.debug((Object)("DataSource doesn't have a close method: " + this.mDataSource.getClass().getName()));
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

