/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.MismatchException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableKey;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.info.StorablePropertyConstraint;
import com.amazon.carbonado.lob.Clob;
import com.amazon.carbonado.repo.jdbc.JDBCStorableInfo;
import com.amazon.carbonado.repo.jdbc.JDBCStorableProperty;
import com.amazon.carbonado.repo.jdbc.SchemaResolver;
import com.amazon.carbonado.util.SoftValuedCache;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.KeyFactory;
import org.cojen.util.ThrowUnchecked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCStorableIntrospector
extends StorableIntrospector {
    private static SoftValuedCache<Object, JDBCStorableInfo<?>> cCache = SoftValuedCache.newCache(11);

    public static <S extends Storable> JDBCStorableInfo<S> examine(Class<S> type, DataSource ds, String catalog, String schema) throws SQLException, SupportException {
        return JDBCStorableIntrospector.examine(type, ds, catalog, schema, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <S extends Storable> JDBCStorableInfo<S> examine(Class<S> type, DataSource ds, String catalog, String schema, SchemaResolver resolver, boolean primaryKeyCheckDisabled) throws SQLException, SupportException {
        Object key = KeyFactory.createKey((Object[])new Object[]{type, ds, catalog, schema});
        SoftValuedCache<Object, JDBCStorableInfo<?>> softValuedCache = cCache;
        synchronized (softValuedCache) {
            JDBCStorableInfo<Object> jInfo;
            block18: {
                jInfo = cCache.get(key);
                if (jInfo != null) {
                    return jInfo;
                }
                StorableInfo<S> mainInfo = JDBCStorableIntrospector.examine(type);
                Connection con = ds.getConnection();
                try {
                    try {
                        jInfo = JDBCStorableIntrospector.examine(mainInfo, con, catalog, schema, resolver, primaryKeyCheckDisabled);
                        if (!jInfo.isSupported() && resolver != null && resolver.resolve(mainInfo, con, catalog, schema)) {
                            jInfo = JDBCStorableIntrospector.examine(mainInfo, con, catalog, schema, resolver, primaryKeyCheckDisabled);
                        }
                    }
                    catch (SupportException e) {
                        if (resolver != null && resolver.resolve(mainInfo, con, catalog, schema)) {
                            jInfo = JDBCStorableIntrospector.examine(mainInfo, con, catalog, schema, resolver, primaryKeyCheckDisabled);
                            break block18;
                        }
                        throw e;
                    }
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
            }
            cCache.put(key, jInfo);
            try {
                for (JDBCStorableProperty<Object> jProperty : jInfo.getAllProperties().values()) {
                    JProperty jp = (JProperty)jProperty;
                    jp.fillInternalJoinElements(ds, catalog, schema, resolver);
                    jp.fillExternalJoinElements(ds, catalog, schema, resolver);
                }
            }
            catch (Throwable e) {
                cCache.remove(key);
                ThrowUnchecked.fire((Throwable)e);
            }
            return jInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S extends Storable> JDBCStorableInfo<S> examine(StorableInfo<S> mainInfo, Connection con, String searchCatalog, String searchSchema, SchemaResolver resolver, boolean primaryKeyCheckDisabled) throws SQLException, SupportException {
        String quote;
        ArrayList<String> errorMessages;
        LinkedHashMap jProperties;
        String qualifiedTableName;
        String tableName;
        String schema;
        String catalog;
        DatabaseMetaData meta;
        block66: {
            String[] tableAliases;
            meta = con.getMetaData();
            String databaseProductName = meta.getDatabaseProductName();
            String userName = meta.getUserName();
            if (mainInfo.getAliasCount() > 0) {
                tableAliases = mainInfo.getAliases();
            } else {
                String name = mainInfo.getStorableType().getSimpleName();
                tableAliases = JDBCStorableIntrospector.generateAliases(name);
            }
            catalog = null;
            schema = null;
            tableName = null;
            String tableType = null;
            HashMap<String, Integer> fitnessMap = new HashMap<String, Integer>();
            fitnessMap.put("LOCAL TEMPORARY", 1);
            fitnessMap.put("GLOBAL TEMPORARY", 2);
            fitnessMap.put("VIEW", 3);
            fitnessMap.put("SYSTEM TABLE", 4);
            fitnessMap.put("TABLE", 5);
            fitnessMap.put("ALIAS", 6);
            fitnessMap.put("SYNONYM", 7);
            for (int i = 0; i < tableAliases.length; ++i) {
                ResultSet rs = meta.getTables(searchCatalog, searchSchema, tableAliases[i], null);
                try {
                    int bestFitness = 0;
                    while (rs.next()) {
                        String type = rs.getString("TABLE_TYPE");
                        Integer fitness = (Integer)fitnessMap.get(type);
                        if (fitness == null) continue;
                        String rsSchema = rs.getString("TABLE_SCHEM");
                        if (searchSchema == null && userName != null && userName.equalsIgnoreCase(rsSchema)) {
                            fitness = fitness + 7;
                        }
                        if (fitness <= bestFitness) continue;
                        bestFitness = fitness;
                        catalog = rs.getString("TABLE_CAT");
                        schema = rsSchema;
                        tableName = rs.getString("TABLE_NAME");
                        tableType = type;
                    }
                }
                finally {
                    rs.close();
                }
                if (tableName != null) break;
            }
            if (tableName == null && !mainInfo.isIndependent()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Unable to find matching table name for type \"");
                buf.append(mainInfo.getStorableType().getName());
                buf.append("\" by looking for ");
                JDBCStorableIntrospector.appendToSentence(buf, tableAliases);
                buf.append(" with catalog " + searchCatalog + " and schema " + searchSchema);
                throw new MismatchException(buf.toString());
            }
            qualifiedTableName = tableName;
            String resolvedTableName = tableName;
            if (tableName != null && databaseProductName.toUpperCase().contains("ORACLE")) {
                if ("TABLE".equals(tableType) && searchSchema != null) {
                    qualifiedTableName = searchSchema + '.' + tableName;
                } else if ("SYNONYM".equals(tableType)) {
                    String select = "SELECT TABLE_OWNER,TABLE_NAME FROM ALL_SYNONYMS WHERE OWNER=? AND SYNONYM_NAME=?";
                    PreparedStatement ps = con.prepareStatement(select);
                    ps.setString(1, schema);
                    ps.setString(2, tableName);
                    try {
                        ResultSet rs = ps.executeQuery();
                        try {
                            if (rs.next()) {
                                schema = rs.getString("TABLE_OWNER");
                                resolvedTableName = rs.getString("TABLE_NAME");
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        ps.close();
                    }
                }
            }
            TreeMap<String, ColumnInfo> columnMap = new TreeMap<String, ColumnInfo>(String.CASE_INSENSITIVE_ORDER);
            if (resolvedTableName != null) {
                ResultSet rs = meta.getColumns(catalog, schema, resolvedTableName, null);
                rs.setFetchSize(1000);
                try {
                    while (rs.next()) {
                        ColumnInfo info = new ColumnInfo(rs);
                        columnMap.put(info.columnName, info);
                    }
                }
                finally {
                    rs.close();
                }
            }
            Map<String, StorableProperty<S>> mainProperties = mainInfo.getAllProperties();
            HashMap<String, String> columnToProperty = new HashMap<String, String>();
            jProperties = new LinkedHashMap(mainProperties.size());
            errorMessages = new ArrayList<String>();
            for (StorableProperty<S> mainProperty : mainProperties.values()) {
                if (mainProperty.isDerived() || mainProperty.isJoin() || tableName == null) {
                    jProperties.put(mainProperty.getName(), new JProperty<S>(mainProperty, primaryKeyCheckDisabled));
                    continue;
                }
                String[] columnAliases = mainProperty.getAliasCount() > 0 ? mainProperty.getAliases() : JDBCStorableIntrospector.generateAliases(mainProperty.getName());
                JProperty<S> jProperty = null;
                boolean addedError = false;
                for (int i = 0; i < columnAliases.length; ++i) {
                    boolean autoIncrement;
                    ColumnInfo columnInfo = (ColumnInfo)columnMap.get(columnAliases[i]);
                    if (columnInfo == null) continue;
                    AccessInfo accessInfo = JDBCStorableIntrospector.getAccessInfo(mainProperty, columnInfo.dataType, columnInfo.dataTypeName, columnInfo.columnSize, columnInfo.decimalDigits);
                    if (accessInfo == null) {
                        TypeDesc propertyType = TypeDesc.forClass(mainProperty.getType());
                        String message = "Property \"" + mainProperty.getName() + "\" has type \"" + propertyType.getFullName() + "\" which is incompatible with database type \"" + columnInfo.dataTypeName + '\"';
                        if (columnInfo.decimalDigits > 0) {
                            message = message + " (decimal digits = " + columnInfo.decimalDigits + ')';
                        }
                        errorMessages.add(message);
                        addedError = true;
                        break;
                    }
                    if (columnInfo.nullable) {
                        if (!mainProperty.isNullable()) {
                            errorMessages.add("Property \"" + mainProperty.getName() + "\" must have a Nullable annotation");
                        }
                    } else if (mainProperty.isNullable() && !mainProperty.isIndependent()) {
                        errorMessages.add("Property \"" + mainProperty.getName() + "\" must not have a Nullable annotation");
                    }
                    if (autoIncrement = mainProperty.isAutomatic()) {
                        PreparedStatement ps = con.prepareStatement("SELECT " + columnInfo.columnName + " FROM " + tableName + " WHERE 1=0");
                        try {
                            ResultSet rs = ps.executeQuery();
                            try {
                                autoIncrement = rs.getMetaData().isAutoIncrement(1);
                            }
                            finally {
                                rs.close();
                            }
                        }
                        finally {
                            ps.close();
                        }
                    }
                    jProperty = new JProperty<S>(mainProperty, columnInfo, autoIncrement, primaryKeyCheckDisabled, accessInfo.mResultSetGet, accessInfo.mPreparedStatementSet, accessInfo.getAdapter());
                    break;
                }
                if (jProperty != null) {
                    jProperties.put(mainProperty.getName(), jProperty);
                    columnToProperty.put(jProperty.getColumnName(), jProperty.getName());
                    continue;
                }
                if (mainProperty.isIndependent()) {
                    jProperties.put(mainProperty.getName(), new JProperty<S>(mainProperty, primaryKeyCheckDisabled));
                    continue;
                }
                if (addedError) continue;
                StringBuilder buf = new StringBuilder();
                buf.append("Unable to find matching database column for property \"");
                buf.append(mainProperty.getName());
                buf.append("\" by looking for ");
                JDBCStorableIntrospector.appendToSentence(buf, columnAliases);
                errorMessages.add(buf.toString());
            }
            if (errorMessages.size() > 0) {
                throw new MismatchException(mainInfo.getStorableType(), errorMessages);
            }
            if (resolvedTableName != null) {
                ResultSet rs;
                try {
                    rs = meta.getPrimaryKeys(catalog, schema, resolvedTableName);
                }
                catch (SQLException e) {
                    JDBCStorableIntrospector.getLog().info((Object)("Unable to get primary keys for table \"" + resolvedTableName + "\" with catalog " + catalog + " and schema " + schema + ": " + e));
                    break block66;
                }
                ArrayList<String> pkProps = new ArrayList<String>();
                try {
                    while (rs.next()) {
                        String columnName = rs.getString("COLUMN_NAME");
                        String propertyName = (String)columnToProperty.get(columnName);
                        if (propertyName == null) {
                            errorMessages.add("Column \"" + columnName + "\" must be part of primary or alternate key");
                            continue;
                        }
                        pkProps.add(propertyName);
                    }
                }
                finally {
                    rs.close();
                }
                if (errorMessages.size() <= 0 && pkProps.size() != 0 && !JDBCStorableIntrospector.matchesKey(pkProps, mainInfo.getPrimaryKey())) {
                    boolean foundAnyAltKey = false;
                    for (StorableKey<S> altKey : mainInfo.getAlternateKeys()) {
                        if (!JDBCStorableIntrospector.matchesKey(pkProps, altKey)) continue;
                        foundAnyAltKey = true;
                        if (!JDBCStorableIntrospector.matchesSubKey(pkProps, mainInfo.getPrimaryKey())) {
                            continue;
                        }
                        break block66;
                    }
                    if (foundAnyAltKey) {
                        errorMessages.add("Actual primary key matches a declared alternate key, but declared primary key must be a strict subset. " + mainInfo.getPrimaryKey().getProperties() + " is not a subset of " + pkProps);
                    } else {
                        errorMessages.add("Actual primary key does not match any declared primary or alternate key: " + pkProps);
                    }
                }
            }
        }
        if (errorMessages.size() > 0) {
            if (primaryKeyCheckDisabled) {
                for (String errorMessage : errorMessages) {
                    JDBCStorableIntrospector.getLog().warn((Object)("Suppressed error: " + errorMessage));
                }
                errorMessages.clear();
            } else {
                throw new MismatchException(mainInfo.getStorableType(), errorMessages);
            }
        }
        IndexInfo[] indexInfo = new IndexInfo[]{};
        if (JDBCStorableIntrospector.needsQuotes(tableName) && (quote = meta.getIdentifierQuoteString()) != null && !quote.equals(" ")) {
            tableName = quote + tableName + quote;
            qualifiedTableName = quote + qualifiedTableName + quote;
        }
        return new JInfo<S>(mainInfo, catalog, schema, tableName, qualifiedTableName, indexInfo, jProperties);
    }

    private static boolean needsQuotes(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() == 0) {
            return true;
        }
        char c = str.charAt(0);
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
            return true;
        }
        int i = str.length();
        while (--i >= 0) {
            c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c >= '0' && c <= '9') continue;
            return true;
        }
        return false;
    }

    private static boolean matchesKey(Collection<String> keyProps, StorableKey<?> declaredKey) {
        if (keyProps.size() != declaredKey.getProperties().size()) {
            return false;
        }
        return JDBCStorableIntrospector.matchesSubKey(keyProps, declaredKey);
    }

    private static boolean matchesSubKey(Collection<String> keyProps, StorableKey<?> declaredKey) {
        for (OrderedProperty<?> declaredKeyProp : declaredKey.getProperties()) {
            ChainedProperty<?> chained = declaredKeyProp.getChainedProperty();
            if (chained.getChainCount() > 0) {
                return false;
            }
            if (keyProps.contains(chained.getLastProperty().getName())) continue;
            return false;
        }
        return true;
    }

    private static Log getLog() {
        return LogFactory.getLog(JDBCStorableIntrospector.class);
    }

    private static AccessInfo getAccessInfo(StorableProperty property, int dataType, String dataTypeName, int columnSize, int decimalDigits) {
        AccessInfo info = JDBCStorableIntrospector.getAccessInfo(property.getType(), dataType, dataTypeName, columnSize, decimalDigits);
        if (info != null) {
            return info;
        }
        StorablePropertyAdapter adapter = property.getAdapter();
        if (adapter != null) {
            Method[] toMethods;
            for (Method toMethod : toMethods = adapter.findAdaptMethodsTo(property.getType())) {
                Class<?> fromType = toMethod.getParameterTypes()[0];
                if (adapter.findAdaptMethod(property.getType(), fromType) == null || (info = JDBCStorableIntrospector.getAccessInfo(fromType, dataType, dataTypeName, columnSize, decimalDigits)) == null) continue;
                info.setAdapter(adapter);
                return info;
            }
        }
        return null;
    }

    private static AccessInfo getAccessInfo(Class desiredClass, int dataType, String dataTypeName, int columnSize, int decimalDigits) {
        String suffix;
        Class<Object> actualClass;
        TypeDesc desiredType;
        if (!desiredClass.isPrimitive() && (desiredType = TypeDesc.forClass((Class)desiredClass)).toPrimitiveType() != null) {
            desiredType = desiredType.toPrimitiveType();
            desiredClass = desiredType.toClass();
        }
        if (desiredClass == Object.class) {
            return new AccessInfo("Object", Object.class);
        }
        switch (dataType) {
            default: {
                return null;
            }
            case -7: 
            case 16: {
                if (desiredClass == Boolean.TYPE) {
                    actualClass = Boolean.TYPE;
                    suffix = "Boolean";
                    break;
                }
                if (desiredClass == String.class) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                return null;
            }
            case -6: {
                if (desiredClass == Byte.TYPE) {
                    actualClass = Byte.TYPE;
                    suffix = "Byte";
                    break;
                }
                if (desiredClass == Short.TYPE) {
                    actualClass = Short.TYPE;
                    suffix = "Short";
                    break;
                }
                if (desiredClass == String.class) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                return null;
            }
            case 5: {
                if (desiredClass == Short.TYPE) {
                    actualClass = Short.TYPE;
                    suffix = "Short";
                    break;
                }
                if (desiredClass == Integer.TYPE) {
                    actualClass = Integer.TYPE;
                    suffix = "Int";
                    break;
                }
                if (desiredClass == String.class) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                return null;
            }
            case 4: {
                if (desiredClass == Integer.TYPE) {
                    actualClass = Integer.TYPE;
                    suffix = "Int";
                    break;
                }
                if (desiredClass == Long.TYPE) {
                    actualClass = Long.TYPE;
                    suffix = "Long";
                    break;
                }
                if (desiredClass == String.class) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                return null;
            }
            case -5: {
                if (desiredClass == Long.TYPE) {
                    actualClass = Long.TYPE;
                    suffix = "Long";
                    break;
                }
                if (desiredClass == String.class) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                if (desiredClass == Float.TYPE) {
                    actualClass = Float.TYPE;
                    suffix = "Float";
                    break;
                }
                if (desiredClass == Double.TYPE) {
                    actualClass = Double.TYPE;
                    suffix = "Double";
                    break;
                }
                if (desiredClass == String.class) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                return null;
            }
            case 2: 
            case 3: {
                if (desiredClass == Integer.TYPE) {
                    if (decimalDigits == 0) {
                        actualClass = Integer.TYPE;
                        suffix = "Int";
                        break;
                    }
                    return null;
                }
                if (desiredClass == Long.TYPE) {
                    if (decimalDigits == 0) {
                        actualClass = Long.TYPE;
                        suffix = "Long";
                        break;
                    }
                    return null;
                }
                if (desiredClass == Double.TYPE) {
                    actualClass = Double.TYPE;
                    suffix = "Double";
                    break;
                }
                if (desiredClass == BigDecimal.class) {
                    actualClass = BigDecimal.class;
                    suffix = "BigDecimal";
                    break;
                }
                if (desiredClass == Short.TYPE) {
                    if (decimalDigits == 0) {
                        actualClass = Short.TYPE;
                        suffix = "Short";
                        break;
                    }
                    return null;
                }
                if (desiredClass == Byte.TYPE) {
                    if (decimalDigits == 0) {
                        actualClass = Byte.TYPE;
                        suffix = "Byte";
                        break;
                    }
                    return null;
                }
                if (desiredClass == String.class) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                return null;
            }
            case -1: 
            case 1: 
            case 12: {
                if (desiredClass == String.class) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                if (desiredClass == Character.TYPE && columnSize == 1) {
                    actualClass = String.class;
                    suffix = "String";
                    break;
                }
                return null;
            }
            case 91: {
                if (desiredClass == Date.class) {
                    actualClass = Timestamp.class;
                    suffix = "Timestamp";
                    break;
                }
                return null;
            }
            case 92: {
                if (desiredClass == Time.class) {
                    actualClass = Time.class;
                    suffix = "Time";
                    break;
                }
                return null;
            }
            case 93: {
                if (desiredClass == Timestamp.class) {
                    actualClass = Timestamp.class;
                    suffix = "Timestamp";
                    break;
                }
                return null;
            }
            case -4: 
            case -3: 
            case -2: {
                if (desiredClass == byte[].class) {
                    actualClass = byte[].class;
                    suffix = "Bytes";
                    break;
                }
                return null;
            }
            case 2004: {
                if (desiredClass == com.amazon.carbonado.lob.Blob.class) {
                    actualClass = Blob.class;
                    suffix = "Blob";
                    break;
                }
                return null;
            }
            case 2005: {
                if (desiredClass == Clob.class) {
                    actualClass = java.sql.Clob.class;
                    suffix = "Clob";
                    break;
                }
                return null;
            }
        }
        return new AccessInfo(suffix, actualClass);
    }

    private static void appendToSentence(StringBuilder buf, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                if (i + 1 >= names.length) {
                    buf.append(" or ");
                } else {
                    buf.append(", ");
                }
            }
            buf.append('\"');
            buf.append(names[i]);
            buf.append('\"');
        }
    }

    static String[] generateAliases(String base) {
        int length = base.length();
        if (length <= 1) {
            return new String[]{base.toUpperCase(), base.toLowerCase()};
        }
        ArrayList<String> aliases = new ArrayList<String>(4);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < length) {
            char c;
            if ((c = base.charAt(i++)) == '_' || !Character.isJavaIdentifierPart(c)) {
                buf.append(c);
                continue;
            }
            buf.append(Character.toUpperCase(c));
            break;
        }
        boolean canSeparate = false;
        boolean appendedIdentifierPart = false;
        while (i < length) {
            char c = base.charAt(i);
            if (c == '_' || !Character.isJavaIdentifierPart(c)) {
                canSeparate = false;
                appendedIdentifierPart = false;
            } else if (Character.isLowerCase(c)) {
                canSeparate = true;
                appendedIdentifierPart = true;
            } else {
                if (appendedIdentifierPart && i + 1 < length && Character.isLowerCase(base.charAt(i + 1))) {
                    canSeparate = true;
                }
                if (canSeparate) {
                    buf.append('_');
                }
                canSeparate = false;
                appendedIdentifierPart = true;
            }
            buf.append(c);
            ++i;
        }
        String derived = buf.toString();
        JDBCStorableIntrospector.addToSet(aliases, derived.toUpperCase());
        JDBCStorableIntrospector.addToSet(aliases, derived.toLowerCase());
        JDBCStorableIntrospector.addToSet(aliases, derived);
        JDBCStorableIntrospector.addToSet(aliases, base.toUpperCase());
        JDBCStorableIntrospector.addToSet(aliases, base.toLowerCase());
        JDBCStorableIntrospector.addToSet(aliases, base);
        return aliases.toArray(new String[aliases.size()]);
    }

    private static void addToSet(ArrayList<String> list, String value) {
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    static String intern(String str) {
        return str == null ? null : str.intern();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JProperty<S extends Storable>
    implements JDBCStorableProperty<S> {
        private static final long serialVersionUID = -7333912817502875485L;
        private final StorableProperty<S> mMainProperty;
        private final String mColumnName;
        private final Integer mDataType;
        private final String mDataTypeName;
        private final boolean mColumnNullable;
        private final Method mResultSetGet;
        private final Method mPreparedStatementSet;
        private final StorablePropertyAdapter mAdapter;
        private final Integer mColumnSize;
        private final Integer mDecimalDigits;
        private final Integer mCharOctetLength;
        private final Integer mOrdinalPosition;
        private final boolean mAutoIncrement;
        private final boolean mPrimaryKeyCheckDisabled;
        private JDBCStorableProperty<S>[] mInternal;
        private JDBCStorableProperty<?>[] mExternal;

        JProperty(StorableProperty<S> mainProperty, ColumnInfo columnInfo, boolean autoIncrement, boolean primaryKeyCheckDisabled, Method resultSetGet, Method preparedStatementSet, StorablePropertyAdapter adapter) {
            this.mMainProperty = mainProperty;
            this.mColumnName = columnInfo.columnName;
            this.mDataType = columnInfo.dataType;
            this.mDataTypeName = columnInfo.dataTypeName;
            this.mColumnNullable = columnInfo.nullable;
            this.mResultSetGet = resultSetGet;
            this.mPreparedStatementSet = preparedStatementSet;
            this.mAdapter = adapter;
            this.mColumnSize = columnInfo.columnSize;
            this.mDecimalDigits = columnInfo.decimalDigits;
            this.mCharOctetLength = columnInfo.charOctetLength;
            this.mOrdinalPosition = columnInfo.ordinalPosition;
            this.mAutoIncrement = autoIncrement;
            this.mPrimaryKeyCheckDisabled = primaryKeyCheckDisabled;
        }

        JProperty(StorableProperty<S> mainProperty, boolean primaryKeyCheckDisabled) {
            this.mMainProperty = mainProperty;
            this.mColumnName = null;
            this.mDataType = null;
            this.mDataTypeName = null;
            this.mColumnNullable = false;
            this.mResultSetGet = null;
            this.mPreparedStatementSet = null;
            this.mAdapter = null;
            this.mColumnSize = null;
            this.mDecimalDigits = null;
            this.mCharOctetLength = null;
            this.mOrdinalPosition = null;
            this.mAutoIncrement = false;
            this.mPrimaryKeyCheckDisabled = primaryKeyCheckDisabled;
        }

        @Override
        public String getName() {
            return this.mMainProperty.getName();
        }

        @Override
        public String getBeanName() {
            return this.mMainProperty.getBeanName();
        }

        @Override
        public Class<?> getType() {
            return this.mMainProperty.getType();
        }

        @Override
        public Class<?>[] getCovariantTypes() {
            return this.mMainProperty.getCovariantTypes();
        }

        @Override
        public int getNumber() {
            return this.mMainProperty.getNumber();
        }

        @Override
        public Class<S> getEnclosingType() {
            return this.mMainProperty.getEnclosingType();
        }

        @Override
        public Method getReadMethod() {
            return this.mMainProperty.getReadMethod();
        }

        @Override
        public String getReadMethodName() {
            return this.mMainProperty.getReadMethodName();
        }

        @Override
        public Method getWriteMethod() {
            return this.mMainProperty.getWriteMethod();
        }

        @Override
        public String getWriteMethodName() {
            return this.mMainProperty.getWriteMethodName();
        }

        @Override
        public boolean isNullable() {
            return this.mMainProperty.isNullable();
        }

        @Override
        public boolean isPrimaryKeyMember() {
            return this.mMainProperty.isPrimaryKeyMember();
        }

        @Override
        public boolean isAlternateKeyMember() {
            return this.mMainProperty.isAlternateKeyMember();
        }

        @Override
        public boolean isPartitionKeyMember() {
            return this.mMainProperty.isPartitionKeyMember();
        }

        @Override
        public int getAliasCount() {
            return this.mMainProperty.getAliasCount();
        }

        @Override
        public String getAlias(int index) {
            return this.mMainProperty.getAlias(index);
        }

        @Override
        public String[] getAliases() {
            return this.mMainProperty.getAliases();
        }

        @Override
        public boolean isJoin() {
            return this.mMainProperty.isJoin();
        }

        @Override
        public boolean isOneToOneJoin() {
            return this.mMainProperty.isOneToOneJoin();
        }

        @Override
        public Class<? extends Storable> getJoinedType() {
            return this.mMainProperty.getJoinedType();
        }

        @Override
        public int getJoinElementCount() {
            return this.mMainProperty.getJoinElementCount();
        }

        @Override
        public boolean isQuery() {
            return this.mMainProperty.isQuery();
        }

        @Override
        public int getConstraintCount() {
            return this.mMainProperty.getConstraintCount();
        }

        @Override
        public StorablePropertyConstraint getConstraint(int index) {
            return this.mMainProperty.getConstraint(index);
        }

        @Override
        public StorablePropertyConstraint[] getConstraints() {
            return this.mMainProperty.getConstraints();
        }

        @Override
        public StorablePropertyAdapter getAdapter() {
            return this.mMainProperty.getAdapter();
        }

        @Override
        public String getSequenceName() {
            return this.mMainProperty.getSequenceName();
        }

        @Override
        public boolean isAutomatic() {
            return this.mMainProperty.isAutomatic();
        }

        @Override
        public boolean isVersion() {
            return this.mMainProperty.isVersion();
        }

        @Override
        public boolean isIndependent() {
            return this.mMainProperty.isIndependent();
        }

        @Override
        public boolean isDerived() {
            return this.mMainProperty.isDerived();
        }

        @Override
        public ChainedProperty<S>[] getDerivedFromProperties() {
            return this.mMainProperty.getDerivedFromProperties();
        }

        @Override
        public ChainedProperty<?>[] getDerivedToProperties() {
            return this.mMainProperty.getDerivedToProperties();
        }

        @Override
        public boolean shouldCopyDerived() {
            return this.mMainProperty.shouldCopyDerived();
        }

        @Override
        public boolean isSupported() {
            if (this.isJoin()) {
                return true;
            }
            return this.mColumnName != null;
        }

        @Override
        public boolean isSelectable() {
            return this.mColumnName != null && !this.isJoin() && !this.isDerived();
        }

        @Override
        public boolean isAutoIncrement() {
            return this.mAutoIncrement;
        }

        @Override
        public String getColumnName() {
            return this.mColumnName;
        }

        @Override
        public Integer getDataType() {
            return this.mDataType;
        }

        @Override
        public String getDataTypeName() {
            return this.mDataTypeName;
        }

        @Override
        public boolean isColumnNullable() {
            return this.mColumnNullable;
        }

        @Override
        public Method getResultSetGetMethod() {
            return this.mResultSetGet;
        }

        @Override
        public Method getPreparedStatementSetMethod() {
            return this.mPreparedStatementSet;
        }

        @Override
        public StorablePropertyAdapter getAppliedAdapter() {
            return this.mAdapter;
        }

        @Override
        public Integer getColumnSize() {
            return this.mColumnSize;
        }

        @Override
        public Integer getDecimalDigits() {
            return this.mDecimalDigits;
        }

        @Override
        public Integer getCharOctetLength() {
            return this.mCharOctetLength;
        }

        @Override
        public Integer getOrdinalPosition() {
            return this.mOrdinalPosition;
        }

        @Override
        public JDBCStorableProperty<S> getInternalJoinElement(int index) {
            if (this.mInternal == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mInternal[index];
        }

        @Override
        public JDBCStorableProperty<S>[] getInternalJoinElements() {
            if (this.mInternal == null) {
                return new JDBCStorableProperty[0];
            }
            return (JDBCStorableProperty[])this.mInternal.clone();
        }

        @Override
        public JDBCStorableProperty<?> getExternalJoinElement(int index) {
            if (this.mExternal == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mExternal[index];
        }

        @Override
        public JDBCStorableProperty<?>[] getExternalJoinElements() {
            if (this.mExternal == null) {
                return new JDBCStorableProperty[0];
            }
            return (JDBCStorableProperty[])this.mExternal.clone();
        }

        @Override
        public String toString() {
            return ((Object)this.mMainProperty).toString();
        }

        @Override
        public void appendTo(Appendable app) throws IOException {
            this.mMainProperty.appendTo(app);
        }

        void fillInternalJoinElements(DataSource ds, String catalog, String schema, SchemaResolver resolver) throws SQLException, SupportException {
            StorableProperty<S>[] mainInternal = this.mMainProperty.getInternalJoinElements();
            if (mainInternal.length == 0) {
                this.mInternal = null;
                return;
            }
            JDBCStorableInfo<S> info = JDBCStorableIntrospector.examine(this.getEnclosingType(), ds, catalog, schema, resolver, this.mPrimaryKeyCheckDisabled);
            JDBCStorableProperty[] internal = new JDBCStorableProperty[mainInternal.length];
            int i = mainInternal.length;
            while (--i >= 0) {
                internal[i] = info.getAllProperties().get(mainInternal[i].getName());
            }
            this.mInternal = internal;
        }

        void fillExternalJoinElements(DataSource ds, String catalog, String schema, SchemaResolver resolver) throws SQLException, SupportException {
            StorableProperty<?>[] mainExternal = this.mMainProperty.getExternalJoinElements();
            if (mainExternal.length == 0) {
                this.mExternal = null;
                return;
            }
            JDBCStorableInfo<Storable> info = JDBCStorableIntrospector.examine(this.getJoinedType(), ds, catalog, schema, resolver, this.mPrimaryKeyCheckDisabled);
            JDBCStorableProperty[] external = new JDBCStorableProperty[mainExternal.length];
            int i = mainExternal.length;
            while (--i >= 0) {
                external[i] = info.getAllProperties().get(mainExternal[i].getName());
            }
            this.mExternal = external;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JInfo<S extends Storable>
    implements JDBCStorableInfo<S> {
        private final StorableInfo<S> mMainInfo;
        private final String mCatalogName;
        private final String mSchemaName;
        private final String mTableName;
        private final String mQualifiedTableName;
        private final IndexInfo[] mIndexInfo;
        private final Map<String, JDBCStorableProperty<S>> mAllProperties;
        private transient Map<String, JDBCStorableProperty<S>> mPrimaryKeyProperties;
        private transient Map<String, JDBCStorableProperty<S>> mDataProperties;
        private transient Map<String, JDBCStorableProperty<S>> mIdentityProperties;
        private transient JDBCStorableProperty<S> mVersionProperty;

        JInfo(StorableInfo<S> mainInfo, String catalogName, String schemaName, String tableName, String qualifiedTableName, IndexInfo[] indexInfo, Map<String, JDBCStorableProperty<S>> allProperties) {
            this.mMainInfo = mainInfo;
            this.mCatalogName = JDBCStorableIntrospector.intern(catalogName);
            this.mSchemaName = JDBCStorableIntrospector.intern(schemaName);
            this.mTableName = JDBCStorableIntrospector.intern(tableName);
            this.mQualifiedTableName = JDBCStorableIntrospector.intern(qualifiedTableName);
            this.mIndexInfo = indexInfo;
            this.mAllProperties = Collections.unmodifiableMap(allProperties);
        }

        @Override
        public String getName() {
            return this.mMainInfo.getName();
        }

        @Override
        public Class<S> getStorableType() {
            return this.mMainInfo.getStorableType();
        }

        @Override
        public StorableKey<S> getPrimaryKey() {
            return this.mMainInfo.getPrimaryKey();
        }

        @Override
        public int getAlternateKeyCount() {
            return this.mMainInfo.getAlternateKeyCount();
        }

        @Override
        public StorableKey<S> getAlternateKey(int index) {
            return this.mMainInfo.getAlternateKey(index);
        }

        @Override
        public StorableKey<S>[] getAlternateKeys() {
            return this.mMainInfo.getAlternateKeys();
        }

        @Override
        public StorableKey<S> getPartitionKey() {
            return this.mMainInfo.getPartitionKey();
        }

        @Override
        public int getAliasCount() {
            return this.mMainInfo.getAliasCount();
        }

        @Override
        public String getAlias(int index) {
            return this.mMainInfo.getAlias(index);
        }

        @Override
        public String[] getAliases() {
            return this.mMainInfo.getAliases();
        }

        @Override
        public int getIndexCount() {
            return this.mMainInfo.getIndexCount();
        }

        @Override
        public StorableIndex<S> getIndex(int index) {
            return this.mMainInfo.getIndex(index);
        }

        @Override
        public StorableIndex<S>[] getIndexes() {
            return this.mMainInfo.getIndexes();
        }

        @Override
        public boolean isIndependent() {
            return this.mMainInfo.isIndependent();
        }

        @Override
        public boolean isAuthoritative() {
            return this.mMainInfo.isAuthoritative();
        }

        @Override
        public boolean isSupported() {
            return this.mTableName != null;
        }

        @Override
        public String getCatalogName() {
            return this.mCatalogName;
        }

        @Override
        public String getSchemaName() {
            return this.mSchemaName;
        }

        @Override
        public String getTableName() {
            return this.mTableName;
        }

        @Override
        public String getQualifiedTableName() {
            return this.mQualifiedTableName;
        }

        @Override
        public IndexInfo[] getIndexInfo() {
            return (IndexInfo[])this.mIndexInfo.clone();
        }

        @Override
        public Map<String, JDBCStorableProperty<S>> getAllProperties() {
            return this.mAllProperties;
        }

        @Override
        public Map<String, JDBCStorableProperty<S>> getPrimaryKeyProperties() {
            if (this.mPrimaryKeyProperties == null) {
                LinkedHashMap<String, JDBCStorableProperty<S>> pkProps = new LinkedHashMap<String, JDBCStorableProperty<S>>(this.mAllProperties.size());
                for (Map.Entry<String, JDBCStorableProperty<S>> entry : this.mAllProperties.entrySet()) {
                    JDBCStorableProperty<S> property = entry.getValue();
                    if (!property.isPrimaryKeyMember()) continue;
                    pkProps.put(entry.getKey(), property);
                }
                this.mPrimaryKeyProperties = Collections.unmodifiableMap(pkProps);
            }
            return this.mPrimaryKeyProperties;
        }

        @Override
        public Map<String, JDBCStorableProperty<S>> getDataProperties() {
            if (this.mDataProperties == null) {
                LinkedHashMap<String, JDBCStorableProperty<S>> dataProps = new LinkedHashMap<String, JDBCStorableProperty<S>>(this.mAllProperties.size());
                for (Map.Entry<String, JDBCStorableProperty<S>> entry : this.mAllProperties.entrySet()) {
                    JDBCStorableProperty<S> property = entry.getValue();
                    if (property.isPrimaryKeyMember() || property.isJoin()) continue;
                    dataProps.put(entry.getKey(), property);
                }
                this.mDataProperties = Collections.unmodifiableMap(dataProps);
            }
            return this.mDataProperties;
        }

        @Override
        public Map<String, JDBCStorableProperty<S>> getIdentityProperties() {
            if (this.mIdentityProperties == null) {
                LinkedHashMap<String, JDBCStorableProperty<S>> idProps = new LinkedHashMap<String, JDBCStorableProperty<S>>(1);
                for (Map.Entry<String, JDBCStorableProperty<S>> entry : this.getPrimaryKeyProperties().entrySet()) {
                    JDBCStorableProperty<S> property = entry.getValue();
                    if (!property.isAutoIncrement()) continue;
                    idProps.put(entry.getKey(), property);
                }
                this.mIdentityProperties = Collections.unmodifiableMap(idProps);
            }
            return this.mIdentityProperties;
        }

        @Override
        public JDBCStorableProperty<S> getVersionProperty() {
            if (this.mVersionProperty == null) {
                for (JDBCStorableProperty<S> property : this.mAllProperties.values()) {
                    if (!property.isVersion()) continue;
                    this.mVersionProperty = property;
                    break;
                }
            }
            return this.mVersionProperty;
        }
    }

    private static class AccessInfo {
        final Method mResultSetGet;
        final Method mPreparedStatementSet;
        private StorablePropertyAdapter mAdapter;

        AccessInfo(String suffix, Class actualClass) {
            try {
                this.mResultSetGet = ResultSet.class.getMethod("get" + suffix, Integer.TYPE);
                this.mPreparedStatementSet = PreparedStatement.class.getMethod("set" + suffix, Integer.TYPE, actualClass);
            }
            catch (NoSuchMethodException e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        StorablePropertyAdapter getAdapter() {
            return this.mAdapter;
        }

        void setAdapter(StorablePropertyAdapter adapter) {
            this.mAdapter = adapter;
        }
    }

    private static class ColumnInfo {
        final String columnName;
        final int dataType;
        final String dataTypeName;
        final int columnSize;
        final int decimalDigits;
        final boolean nullable;
        final int charOctetLength;
        final int ordinalPosition;

        ColumnInfo(ResultSet rs) throws SQLException {
            this.columnName = JDBCStorableIntrospector.intern(rs.getString("COLUMN_NAME"));
            this.dataTypeName = JDBCStorableIntrospector.intern(rs.getString("TYPE_NAME"));
            this.columnSize = rs.getInt("COLUMN_SIZE");
            this.decimalDigits = rs.getInt("DECIMAL_DIGITS");
            this.nullable = rs.getInt("NULLABLE") == 1;
            this.charOctetLength = rs.getInt("CHAR_OCTET_LENGTH");
            this.ordinalPosition = rs.getInt("ORDINAL_POSITION");
            int dt = rs.getInt("DATA_TYPE");
            if (dt == 1111) {
                if ("BLOB".equalsIgnoreCase(this.dataTypeName)) {
                    dt = 2004;
                } else if ("CLOB".equalsIgnoreCase(this.dataTypeName)) {
                    dt = 2005;
                } else if ("FLOAT".equalsIgnoreCase(this.dataTypeName)) {
                    dt = 6;
                } else if ("TIMESTAMP".equalsIgnoreCase(this.dataTypeName)) {
                    dt = 93;
                } else if (this.dataTypeName.toUpperCase().contains("TIMESTAMP")) {
                    dt = 93;
                }
            } else if (dt == -4 && "BLOB".equalsIgnoreCase(this.dataTypeName)) {
                dt = 2004;
            } else if (dt == -1 && "CLOB".equalsIgnoreCase(this.dataTypeName)) {
                dt = 2005;
            }
            this.dataType = dt;
        }
    }
}

