/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.ConfigurationException;
import com.amazon.carbonado.Repository;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.repo.jdbc.JDBCRepository;
import com.amazon.carbonado.repo.jdbc.LoggingDataSource;
import com.amazon.carbonado.repo.jdbc.SchemaResolver;
import com.amazon.carbonado.repo.jdbc.SimpleDataSource;
import com.amazon.carbonado.spi.AbstractRepositoryBuilder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCRepositoryBuilder
extends AbstractRepositoryBuilder {
    private String mName;
    private boolean mIsMaster = true;
    private DataSource mDataSource;
    private boolean mDataSourceClose;
    private boolean mDataSourceLogging;
    private String mCatalog;
    private String mSchema;
    private String mDriverClassName;
    private String mURL;
    private String mUsername;
    private String mPassword;
    private Integer mFetchSize;
    private Map<String, Boolean> mAutoVersioningMap;
    private Map<String, Boolean> mSuppressReloadMap;
    private String mSequenceSelectStatement;
    private boolean mForceStoredSequence;
    private boolean mPrimaryKeyCheckDisabled;
    private SchemaResolver mResolver;

    @Override
    public Repository build(AtomicReference<Repository> rootRef) throws RepositoryException {
        this.assertReady();
        Repository originalRoot = rootRef.get();
        JDBCRepository repo = new JDBCRepository(rootRef, this.getName(), this.isMaster(), this.getTriggerFactories(), this.getDataSource(), this.getDataSourceCloseOnShutdown(), this.mCatalog, this.mSchema, this.mFetchSize, this.getAutoVersioningMap(), this.getSuppressReloadMap(), this.mSequenceSelectStatement, this.mForceStoredSequence, this.mPrimaryKeyCheckDisabled, this.mResolver);
        rootRef.compareAndSet(originalRoot, repo);
        return repo;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public boolean isMaster() {
        return this.mIsMaster;
    }

    @Override
    public void setMaster(boolean b) {
        this.mIsMaster = b;
    }

    public void setDataSource(DataSource dataSource) {
        this.mDataSource = dataSource;
        this.mDriverClassName = null;
        this.mURL = null;
        this.mUsername = null;
        this.mPassword = null;
    }

    public DataSource getDataSource() throws ConfigurationException {
        if (this.mDataSource == null && this.mDriverClassName != null && this.mURL != null) {
            try {
                this.mDataSource = new SimpleDataSource(this.mDriverClassName, this.mURL, this.mUsername, this.mPassword);
            }
            catch (SQLException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw new ConfigurationException(cause);
            }
        }
        DataSource ds = this.mDataSource;
        if (this.getDataSourceLogging() && !(ds instanceof LoggingDataSource)) {
            ds = LoggingDataSource.create(ds);
        }
        return ds;
    }

    public void setDataSourceCloseOnShutdown(boolean b) {
        this.mDataSourceClose = b;
    }

    public boolean getDataSourceCloseOnShutdown() {
        return this.mDataSourceClose;
    }

    public void setDataSourceLogging(boolean b) {
        this.mDataSourceLogging = b;
    }

    public boolean getDataSourceLogging() {
        return this.mDataSourceLogging;
    }

    public void setCatalog(String catalog) {
        this.mCatalog = catalog;
    }

    public String getCatalog() {
        return this.mCatalog;
    }

    public void setSchema(String schema) {
        this.mSchema = schema;
    }

    public String getSchema() {
        return this.mSchema;
    }

    public void setDriverClassName(String driverClassName) {
        this.mDriverClassName = driverClassName;
    }

    public String getDriverClassName() {
        return this.mDriverClassName;
    }

    public void setDriverURL(String url) {
        this.mURL = url;
    }

    public String getDriverURL() {
        return this.mURL;
    }

    public void setUserName(String username) {
        this.mUsername = username;
    }

    public String getUserName() {
        return this.mUsername;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setDefaultFetchSize(Integer size) {
        this.mFetchSize = size;
    }

    public Integer getDefaultFetchSize() {
        return this.mFetchSize;
    }

    public void setAutoVersioningEnabled(boolean enabled, String className) {
        if (this.mAutoVersioningMap == null) {
            this.mAutoVersioningMap = new HashMap<String, Boolean>();
        }
        this.mAutoVersioningMap.put(className, enabled);
    }

    private Map<String, Boolean> getAutoVersioningMap() {
        if (this.mAutoVersioningMap == null) {
            return null;
        }
        return new HashMap<String, Boolean>(this.mAutoVersioningMap);
    }

    public void setSuppressReload(boolean suppress, String className) {
        if (this.mSuppressReloadMap == null) {
            this.mSuppressReloadMap = new HashMap<String, Boolean>();
        }
        this.mSuppressReloadMap.put(className, suppress);
    }

    private Map<String, Boolean> getSuppressReloadMap() {
        if (this.mSuppressReloadMap == null) {
            return null;
        }
        return new HashMap<String, Boolean>(this.mSuppressReloadMap);
    }

    public String getSequenceSelectStatement() {
        return this.mSequenceSelectStatement;
    }

    public void setSequenceSelectStatement(String sequenceSelectStatement) {
        this.mSequenceSelectStatement = sequenceSelectStatement;
    }

    public boolean isForceStoredSequence() {
        return this.mForceStoredSequence;
    }

    public void setForceStoredSequence(boolean forceStoredSequence) {
        this.mForceStoredSequence = forceStoredSequence;
    }

    public void setPrimaryKeyCheckDisabled(boolean primaryKeyCheckDisabled) {
        this.mPrimaryKeyCheckDisabled = primaryKeyCheckDisabled;
    }

    @Override
    public void errorCheck(Collection<String> messages) throws ConfigurationException {
        super.errorCheck(messages);
        if (this.mDataSource == null) {
            if (this.mDriverClassName == null) {
                messages.add("driverClassName missing");
            }
            if (this.mURL == null) {
                messages.add("driverURL missing");
            }
            if (messages.size() == 0) {
                this.getDataSource();
            }
        }
    }

    void setSchemaResolver(SchemaResolver resolver) {
        this.mResolver = resolver;
    }
}

