/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.jdbc;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.AbstractCursor;
import com.amazon.carbonado.repo.jdbc.JDBCStorage;
import com.amazon.carbonado.repo.jdbc.JDBCTransaction;
import com.amazon.carbonado.txn.TransactionScope;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCCursor<S extends Storable>
extends AbstractCursor<S> {
    private final JDBCStorage<S> mStorage;
    private final TransactionScope<JDBCTransaction> mScope;
    private final Connection mConnection;
    private final PreparedStatement mStatement;
    private ResultSet mResultSet;
    private boolean mHasNext;

    JDBCCursor(JDBCStorage<S> storage, TransactionScope<JDBCTransaction> scope, Connection con, PreparedStatement statement) throws SQLException {
        this.mStorage = storage;
        this.mScope = scope;
        this.mConnection = con;
        this.mStatement = statement;
        this.mResultSet = statement.executeQuery();
        scope.register(storage.getStorableType(), this);
    }

    @Override
    public void close() throws FetchException {
        if (this.mResultSet != null) {
            try {
                this.mScope.unregister(this.mStorage.getStorableType(), this);
                this.mResultSet.close();
                this.mStatement.close();
                this.mStorage.mRepository.yieldConnection(this.mConnection);
            }
            catch (SQLException e) {
                throw this.mStorage.getJDBCRepository().toFetchException(e);
            }
            finally {
                this.mResultSet = null;
                this.mHasNext = false;
            }
        }
    }

    @Override
    public boolean hasNext() throws FetchException {
        ResultSet rs = this.mResultSet;
        if (rs == null) {
            return false;
        }
        if (!this.mHasNext) {
            try {
                this.mHasNext = rs.next();
            }
            catch (SQLException e) {
                try {
                    this.close();
                }
                catch (FetchException fetchException) {
                    // empty catch block
                }
                throw this.mStorage.getJDBCRepository().toFetchException(e);
            }
            if (!this.mHasNext) {
                this.close();
            }
        }
        return this.mHasNext;
    }

    @Override
    public S next() throws FetchException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            S obj = this.mStorage.instantiate(this.mResultSet);
            this.mHasNext = false;
            return obj;
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (FetchException fetchException) {
                // empty catch block
            }
            throw this.mStorage.getJDBCRepository().toFetchException(e);
        }
    }

    @Override
    public int skipNext(int amount) throws FetchException {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Cannot skip negative amount: " + amount);
            }
            return 0;
        }
        int actual = 0;
        while (amount > 0 && this.hasNext()) {
            ++actual;
            --amount;
            this.mHasNext = false;
        }
        return actual;
    }
}

