/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchDeadlockException;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.FetchTimeoutException;
import com.amazon.carbonado.IsolationLevel;
import com.amazon.carbonado.PersistDeadlockException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.PersistTimeoutException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.Storage;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.Trigger;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.cursor.MergeSortBuffer;
import com.amazon.carbonado.cursor.SortBuffer;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.qe.BoundaryType;
import com.amazon.carbonado.qe.QueryEngine;
import com.amazon.carbonado.qe.QueryExecutorFactory;
import com.amazon.carbonado.qe.StorableIndexSet;
import com.amazon.carbonado.qe.StorageAccess;
import com.amazon.carbonado.repo.indexed.DerivedIndexesTrigger;
import com.amazon.carbonado.repo.indexed.IndexAnalysis;
import com.amazon.carbonado.repo.indexed.IndexEntryGenerator;
import com.amazon.carbonado.repo.indexed.IndexedRepository;
import com.amazon.carbonado.repo.indexed.ManagedIndex;
import com.amazon.carbonado.repo.indexed.StoredIndexInfo;
import com.amazon.carbonado.util.Throttle;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexedStorage<S extends Storable>
implements Storage<S>,
StorageAccess<S> {
    final IndexedRepository mRepository;
    final Storage<S> mMasterStorage;
    private final Map<StorableIndex<S>, IndexInfo> mAllIndexInfoMap;
    private final StorableIndexSet<S> mQueryableIndexSet;
    private final QueryEngine<S> mQueryEngine;

    IndexedStorage(IndexAnalysis<S> analysis) throws RepositoryException {
        this.mRepository = analysis.repository;
        this.mMasterStorage = analysis.masterStorage;
        this.mAllIndexInfoMap = analysis.allIndexInfoMap;
        this.mQueryableIndexSet = analysis.queryableIndexSet;
        if (analysis.indexesTrigger != null && !this.addTrigger(analysis.indexesTrigger)) {
            throw new RepositoryException("Unable to add trigger for managing indexes");
        }
        for (StorableIndex storableIndex : analysis.removeIndexSet) {
            this.removeIndex(storableIndex);
        }
        for (StorableIndex storableIndex : analysis.addIndexSet) {
            this.registerIndex((ManagedIndex)this.mAllIndexInfoMap.get(storableIndex));
        }
        this.mQueryEngine = new QueryEngine<S>(this.mMasterStorage.getStorableType(), this.mRepository);
        if (analysis.derivedToDependencies != null) {
            for (ChainedProperty chainedProperty : analysis.derivedToDependencies) {
                this.addTrigger(new DerivedIndexesTrigger(this.mRepository, this.getStorableType(), chainedProperty));
            }
        }
    }

    @Override
    public Class<S> getStorableType() {
        return this.mMasterStorage.getStorableType();
    }

    @Override
    public S prepare() {
        return this.mMasterStorage.prepare();
    }

    @Override
    public Query<S> query() throws FetchException {
        return this.mQueryEngine.query();
    }

    @Override
    public Query<S> query(String filter) throws FetchException {
        return this.mQueryEngine.query(filter);
    }

    @Override
    public Query<S> query(Filter<S> filter) throws FetchException {
        return this.mQueryEngine.query(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws PersistException {
        block5: {
            for (IndexInfo info : this.mAllIndexInfoMap.values()) {
                if (!(info instanceof ManagedIndex)) continue;
                break block5;
            }
            this.mMasterStorage.truncate();
            return;
        }
        Transaction txn = this.mRepository.enterTransaction();
        try {
            this.mMasterStorage.truncate();
            for (IndexInfo info : this.mAllIndexInfoMap.values()) {
                if (!(info instanceof ManagedIndex)) continue;
                ((ManagedIndex)info).getIndexEntryStorage().truncate();
            }
            txn.commit();
        }
        finally {
            txn.exit();
        }
    }

    @Override
    public boolean addTrigger(Trigger<? super S> trigger) {
        return this.mMasterStorage.addTrigger(trigger);
    }

    @Override
    public boolean removeTrigger(Trigger<? super S> trigger) {
        return this.mMasterStorage.removeTrigger(trigger);
    }

    @Override
    public QueryExecutorFactory<S> getQueryExecutorFactory() {
        return this.mQueryEngine;
    }

    @Override
    public Collection<StorableIndex<S>> getAllIndexes() {
        return this.mQueryableIndexSet;
    }

    @Override
    public Storage<S> storageDelegate(StorableIndex<S> index) {
        if (this.mAllIndexInfoMap.get(index) instanceof ManagedIndex) {
            return null;
        }
        return this.mMasterStorage;
    }

    @Override
    public SortBuffer<S> createSortBuffer() {
        return new MergeSortBuffer();
    }

    @Override
    public SortBuffer<S> createSortBuffer(Query.Controller controller) {
        return new MergeSortBuffer(controller);
    }

    @Override
    public long countAll() throws FetchException {
        return this.mMasterStorage.query().count();
    }

    @Override
    public long countAll(Query.Controller controller) throws FetchException {
        return this.mMasterStorage.query().count(controller);
    }

    @Override
    public Cursor<S> fetchAll() throws FetchException {
        return this.mMasterStorage.query().fetch();
    }

    @Override
    public Cursor<S> fetchAll(Query.Controller controller) throws FetchException {
        return this.mMasterStorage.query().fetch(controller);
    }

    @Override
    public Cursor<S> fetchOne(StorableIndex<S> index, Object[] identityValues) throws FetchException {
        ManagedIndex indexInfo = (ManagedIndex)this.mAllIndexInfoMap.get(index);
        return indexInfo.fetchOne(this, identityValues);
    }

    @Override
    public Cursor<S> fetchOne(StorableIndex<S> index, Object[] identityValues, Query.Controller controller) throws FetchException {
        ManagedIndex indexInfo = (ManagedIndex)this.mAllIndexInfoMap.get(index);
        return indexInfo.fetchOne(this, identityValues, controller);
    }

    @Override
    public Query<?> indexEntryQuery(StorableIndex<S> index) throws FetchException {
        ManagedIndex indexInfo = (ManagedIndex)this.mAllIndexInfoMap.get(index);
        return indexInfo.getIndexEntryStorage().query();
    }

    @Override
    public Cursor<S> fetchFromIndexEntryQuery(StorableIndex<S> index, Query<?> indexEntryQuery) throws FetchException {
        ManagedIndex indexInfo = (ManagedIndex)this.mAllIndexInfoMap.get(index);
        return indexInfo.fetchFromIndexEntryQuery(this, indexEntryQuery);
    }

    @Override
    public Cursor<S> fetchFromIndexEntryQuery(StorableIndex<S> index, Query<?> indexEntryQuery, Query.Controller controller) throws FetchException {
        ManagedIndex indexInfo = (ManagedIndex)this.mAllIndexInfoMap.get(index);
        return indexInfo.fetchFromIndexEntryQuery(this, indexEntryQuery, controller);
    }

    @Override
    public Cursor<S> fetchSubset(StorableIndex<S> index, Object[] identityValues, BoundaryType rangeStartBoundary, Object rangeStartValue, BoundaryType rangeEndBoundary, Object rangeEndValue, boolean reverseRange, boolean reverseOrder) throws FetchException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cursor<S> fetchSubset(StorableIndex<S> index, Object[] identityValues, BoundaryType rangeStartBoundary, Object rangeStartValue, BoundaryType rangeEndBoundary, Object rangeEndValue, boolean reverseRange, boolean reverseOrder, Query.Controller controller) throws FetchException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndex(ManagedIndex<S> managedIndex) throws RepositoryException {
        Transaction txn;
        StorableIndex index = managedIndex.getIndex();
        if (StoredIndexInfo.class.isAssignableFrom(this.getStorableType())) {
            throw new IllegalStateException("StoredIndexInfo cannot have indexes");
        }
        StoredIndexInfo info = this.mRepository.getWrappedRepository().storageFor(StoredIndexInfo.class).prepare();
        info.setIndexName(index.getNameDescriptor());
        try {
            Transaction txn2 = this.mRepository.getWrappedRepository().enterTopTransaction(IsolationLevel.READ_COMMITTED);
            try {
                if (info.tryLoad()) {
                    return;
                }
            }
            finally {
                txn2.exit();
            }
        }
        catch (FetchException e) {
            if (e instanceof FetchDeadlockException || e instanceof FetchTimeoutException) {
                txn = this.mRepository.getWrappedRepository().enterTransaction(IsolationLevel.READ_COMMITTED);
                try {
                    if (info.tryLoad()) {
                        return;
                    }
                }
                finally {
                    txn.exit();
                }
            }
            throw e;
        }
        managedIndex.buildIndex(this.mRepository.getIndexRepairThrottle());
        boolean top = true;
        while (true) {
            try {
                txn = top ? this.mRepository.getWrappedRepository().enterTopTransaction(IsolationLevel.READ_COMMITTED) : this.mRepository.getWrappedRepository().enterTransaction(IsolationLevel.READ_COMMITTED);
                txn.setForUpdate(true);
                try {
                    if (!info.tryLoad()) {
                        info.setIndexTypeDescriptor(index.getTypeDescriptor());
                        info.setCreationTimestamp(System.currentTimeMillis());
                        info.setVersionNumber(0);
                        info.insert();
                        txn.commit();
                    }
                }
                finally {
                    txn.exit();
                }
            }
            catch (RepositoryException e) {
                if ((e instanceof FetchDeadlockException || e instanceof FetchTimeoutException || e instanceof PersistDeadlockException || e instanceof PersistTimeoutException) && top) {
                    top = false;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void unregisterIndex(StorableIndex index) throws RepositoryException {
        if (StoredIndexInfo.class.isAssignableFrom(this.getStorableType())) {
            return;
        }
        this.unregisterIndex(index.getNameDescriptor());
    }

    private void unregisterIndex(String indexName) throws RepositoryException {
        StoredIndexInfo info = this.mRepository.getWrappedRepository().storageFor(StoredIndexInfo.class).prepare();
        info.setIndexName(indexName);
        info.tryDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIndex(StorableIndex index) throws RepositoryException {
        Throttle throttle;
        Storage<?> indexEntryStorage;
        Log log = LogFactory.getLog(IndexedStorage.class);
        if (log.isInfoEnabled()) {
            StringBuilder b = new StringBuilder();
            b.append("Removing index on ");
            b.append(this.getStorableType().getName());
            b.append(": ");
            try {
                index.appendTo(b);
            }
            catch (IOException e) {
                // empty catch block
            }
            log.info((Object)b.toString());
        }
        Class<Storable> indexEntryClass = IndexEntryGenerator.getIndexAccess(index).getReferenceClass();
        try {
            indexEntryStorage = this.mRepository.getIndexEntryStorageFor(indexEntryClass);
        }
        catch (Exception e) {
            this.unregisterIndex(index);
            return;
        }
        double desiredSpeed = this.mRepository.getIndexRepairThrottle();
        Throttle throttle2 = throttle = desiredSpeed < 1.0 ? new Throttle(1280) : null;
        if (throttle == null) {
            indexEntryStorage.truncate();
        } else {
            long totalDropped = 0L;
            while (true) {
                Transaction txn = this.mRepository.getWrappedRepository().enterTopTransaction(IsolationLevel.READ_COMMITTED);
                txn.setForUpdate(true);
                try {
                    Cursor<?> cursor = indexEntryStorage.query().fetch();
                    if (!cursor.hasNext()) break;
                    int count = 0;
                    long savedTotal = totalDropped;
                    boolean anyFailure = false;
                    try {
                        while (count++ < 128 && cursor.hasNext()) {
                            if (((Storable)cursor.next()).tryDelete()) {
                                ++totalDropped;
                                continue;
                            }
                            anyFailure = true;
                        }
                    }
                    finally {
                        cursor.close();
                    }
                    txn.commit();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Removed " + totalDropped + " index entries"));
                    }
                    if (anyFailure && totalDropped <= savedTotal) {
                        log.warn((Object)"No indexes removed in last batch. Aborting index removal cleanup");
                        break;
                    }
                }
                catch (FetchException e) {
                    throw e.toPersistException();
                }
                finally {
                    txn.exit();
                }
                try {
                    throttle.throttle(desiredSpeed, 10L);
                }
                catch (InterruptedException e) {
                    throw new RepositoryException("Index removal interrupted");
                }
            }
        }
        this.unregisterIndex(index);
    }
}

