/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.repo.indexed;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.RepositoryException;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.Transaction;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.repo.indexed.IndexEntryAccessor;
import com.amazon.carbonado.repo.indexed.IndexedRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DependentStorableFetcher<S extends Storable, D extends Storable> {
    private final IndexedRepository mRepository;
    private final IndexEntryAccessor<D>[] mIndexEntryAccessors;
    private final Filter<D> mFilter;
    private final String[] mJoinProperties;
    private Query<D> mQuery;

    DependentStorableFetcher(IndexedRepository repository, Class<S> sType, ChainedProperty<D> derivedTo) throws RepositoryException {
        if (derivedTo.getChainCount() == 0) {
            throw new IllegalArgumentException();
        }
        if (derivedTo.getLastProperty().getType() != sType) {
            throw new IllegalArgumentException();
        }
        if (!derivedTo.getLastProperty().isJoin()) {
            throw new IllegalArgumentException();
        }
        Class<D> dType = derivedTo.getPrimeProperty().getEnclosingType();
        ArrayList<IndexEntryAccessor<D>> accessorList = new ArrayList<IndexEntryAccessor<D>>();
        block0: for (IndexEntryAccessor<D> acc : repository.getIndexEntryAccessors(dType)) {
            for (String indexPropName : acc.getPropertyNames()) {
                if (!indexPropName.equals(derivedTo.getPrimeProperty().getName())) continue;
                accessorList.add(acc);
                continue block0;
            }
        }
        if (accessorList.size() == 0) {
            throw new SupportException("Unable to find index accessors for derived-to property: " + derivedTo + ", enclosing type: " + dType.getName() + ", source type: " + sType.getName());
        }
        StorableProperty<?> join = derivedTo.getLastProperty();
        ChainedProperty<?> base = derivedTo.getChainCount() <= 1 ? null : derivedTo.tail().trim();
        int joinElementCount = join.getJoinElementCount();
        String[] joinProperties = new String[joinElementCount];
        Filter dFilter = Filter.getOpenFilter(dType);
        for (int i = 0; i < joinElementCount; ++i) {
            joinProperties[i] = join.getExternalJoinElement(i).getName();
            StorableProperty<?> internal = join.getInternalJoinElement(i);
            dFilter = base == null ? dFilter.and(internal.getName(), RelOp.EQ) : dFilter.and(base.append(internal).toString(), RelOp.EQ);
        }
        this.mRepository = repository;
        this.mIndexEntryAccessors = accessorList.toArray(new IndexEntryAccessor[accessorList.size()]);
        this.mFilter = dFilter;
        this.mJoinProperties = joinProperties;
    }

    public Transaction enterTransaction() {
        return this.mRepository.enterTransaction();
    }

    public Cursor<D> fetchDependenentStorables(S storable) throws FetchException {
        Query<D> query = this.query();
        for (String property : this.mJoinProperties) {
            query = query.with(storable.getPropertyValue(property));
        }
        return query.fetch();
    }

    public int createIndexEntries(D master, List<Storable> indexEntries) throws FetchException {
        IndexEntryAccessor<D>[] accessors = this.mIndexEntryAccessors;
        int length = accessors.length;
        for (int i = 0; i < length; ++i) {
            IndexEntryAccessor<D> accessor = accessors[i];
            Object indexEntry = accessor.getIndexEntryStorage().prepare();
            accessor.copyFromMaster((Storable)indexEntry, master);
            indexEntries.add((Storable)indexEntry);
        }
        return length;
    }

    public int hashCode() {
        return this.mFilter.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DependentStorableFetcher) {
            DependentStorableFetcher other = (DependentStorableFetcher)obj;
            return this.mFilter.equals(other.mFilter) && Arrays.equals(this.mJoinProperties, other.mJoinProperties) && Arrays.equals(this.mIndexEntryAccessors, other.mIndexEntryAccessors);
        }
        return false;
    }

    public String toString() {
        return "DependentStorableFetcher: {indexes=" + Arrays.toString(this.mIndexEntryAccessors) + ", filter=" + this.mFilter + ", join properties=" + Arrays.toString(this.mJoinProperties) + '}';
    }

    private Query<D> query() throws FetchException {
        Query<D> query = this.mQuery;
        if (query == null) {
            try {
                this.mQuery = query = this.mRepository.storageFor(this.mFilter.getStorableType()).query(this.mFilter);
            }
            catch (RepositoryException e) {
                throw e.toFetchException();
            }
        }
        return query;
    }
}

