/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Cursor;
import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.Query;
import com.amazon.carbonado.Storable;
import com.amazon.carbonado.cursor.SortedCursor;
import com.amazon.carbonado.cursor.UnionCursor;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.FilterValues;
import com.amazon.carbonado.qe.AbstractQueryExecutor;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.QueryExecutor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionQueryExecutor<S extends Storable>
extends AbstractQueryExecutor<S> {
    private final QueryExecutor<S>[] mExecutors;
    private final OrderingList<S> mTotalOrdering;
    private final Comparator<S> mOrderComparator;

    private static <E> E ensureNotNull(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        return e;
    }

    public UnionQueryExecutor(QueryExecutor<S> ... executors) {
        this(Arrays.asList((Object[])UnionQueryExecutor.ensureNotNull(executors)));
    }

    public UnionQueryExecutor(List<QueryExecutor<S>> executors) {
        this(executors, null);
    }

    public UnionQueryExecutor(List<QueryExecutor<S>> executors, OrderingList<S> totalOrdering) {
        if (executors == null || executors.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (totalOrdering == null) {
            totalOrdering = executors.get(0).getOrdering();
            for (int i = 1; i < executors.size(); ++i) {
                if (totalOrdering.equals(executors.get(i).getOrdering())) continue;
                throw new IllegalArgumentException("Ordering doesn't match");
            }
        }
        this.mExecutors = new QueryExecutor[executors.size()];
        executors.toArray(this.mExecutors);
        this.mTotalOrdering = totalOrdering;
        this.mOrderComparator = SortedCursor.createComparator(totalOrdering);
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values) throws FetchException {
        return this.fetch(values, null);
    }

    @Override
    public Cursor<S> fetch(FilterValues<S> values, Query.Controller controller) throws FetchException {
        UnionCursor<S> cursor = null;
        for (QueryExecutor<S> executor : this.mExecutors) {
            UnionCursor<S> subCursor = executor.fetch(values, controller);
            cursor = cursor == null ? subCursor : new UnionCursor<S>(cursor, subCursor, this.mOrderComparator);
        }
        return cursor;
    }

    @Override
    public Filter<S> getFilter() {
        Filter<S> filter = null;
        for (QueryExecutor<S> executor : this.mExecutors) {
            Filter<S> subFilter = executor.getFilter();
            filter = filter == null ? subFilter : filter.or(subFilter);
        }
        return filter;
    }

    @Override
    public OrderingList<S> getOrdering() {
        return this.mTotalOrdering;
    }

    @Override
    public boolean printNative(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        boolean result = false;
        for (QueryExecutor<S> executor : this.mExecutors) {
            result |= executor.printNative(app, indentLevel, values);
        }
        return result;
    }

    @Override
    public boolean printPlan(Appendable app, int indentLevel, FilterValues<S> values) throws IOException {
        this.indent(app, indentLevel);
        app.append("union");
        this.newline(app);
        for (QueryExecutor<S> executor : this.mExecutors) {
            executor.printPlan(app, this.increaseIndent(indentLevel), values);
        }
        return true;
    }
}

