/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.qe;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.filter.Filter;
import com.amazon.carbonado.filter.PropertyFilter;
import com.amazon.carbonado.filter.RelOp;
import com.amazon.carbonado.info.ChainedProperty;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableIndex;
import com.amazon.carbonado.qe.FilteringScore;
import com.amazon.carbonado.qe.OrderingList;
import com.amazon.carbonado.qe.PropertyFilterList;
import java.util.Comparator;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingScore<S extends Storable> {
    private final OrderedProperty<S>[] mIndexProperties;
    private final boolean mIndexClustered;
    private final OrderingList<S> mHandledOrdering;
    private final OrderingList<S> mRemainderOrdering;
    private final boolean mShouldReverseOrder;
    private final OrderingList<S> mFreeOrdering;
    private final OrderingList<S> mUnusedOrdering;

    public static <S extends Storable> OrderingScore<S> evaluate(StorableIndex<S> index, Filter<S> filter, OrderingList<S> ordering) {
        if (index == null) {
            throw new IllegalArgumentException("Index required");
        }
        return OrderingScore.evaluate(index.getOrderedProperties(), index.isUnique(), index.isClustered(), filter, ordering);
    }

    /*
     * WARNING - void declaration
     */
    public static <S extends Storable> OrderingScore<S> evaluate(OrderedProperty<S>[] indexProperties, boolean unique, boolean clustered, Filter<S> filter, OrderingList<S> ordering) {
        void var8_10;
        OrderingList<S> unusedOrdering;
        OrderingList<S> freeOrdering;
        OrderingList handledOrdering;
        HashSet identityPropSet;
        block24: {
            int i;
            if (indexProperties == null) {
                throw new IllegalArgumentException("Index properties required");
            }
            PropertyFilterList<S> filterList = PropertyFilterList.get(filter);
            if (ordering == null) {
                ordering = OrderingList.emptyList();
            }
            identityPropSet = new HashSet(filterList.size());
            for (PropertyFilter propertyFilter : filterList) {
                if (propertyFilter.getOperator() != RelOp.EQ) continue;
                identityPropSet.add(propertyFilter.getChainedProperty());
            }
            handledOrdering = OrderingList.emptyList();
            OrderingList orderingList = OrderingList.emptyList();
            freeOrdering = OrderingList.emptyList();
            unusedOrdering = OrderingList.emptyList();
            for (i = 0; i < indexProperties.length; ++i) {
                OrderedProperty<S> indexProp = indexProperties[i];
                ChainedProperty<S> indexChained = indexProp.getChainedProperty();
                if (!identityPropSet.contains(indexChained)) continue;
                unusedOrdering = unusedOrdering.concat(indexProp.direction(Direction.UNSPECIFIED));
            }
            if (unique) {
                for (i = 0; i < indexProperties.length; ++i) {
                    ChainedProperty<S> indexChained = indexProperties[i].getChainedProperty();
                    if (identityPropSet.contains(indexChained)) {
                        continue;
                    }
                    break block24;
                }
                return new OrderingScore<S>(indexProperties, clustered, handledOrdering, orderingList, false, freeOrdering, unusedOrdering);
            }
        }
        Boolean shouldReverseOrder = null;
        HashSet seen = new HashSet();
        boolean gap = false;
        int indexPos = 0;
        block3: for (int i = 0; i < ordering.size(); ++i) {
            OrderedProperty property = ordering.get(i);
            ChainedProperty chained = property.getChainedProperty();
            if (seen.contains(chained)) continue;
            seen.add(chained);
            if (identityPropSet.contains(chained)) continue;
            while (!gap && indexPos < indexProperties.length) {
                OrderedProperty<S> indexProp = indexProperties[indexPos];
                ChainedProperty<S> indexChained = indexProp.getChainedProperty();
                if (chained.equals(indexChained)) {
                    Direction indexDir = indexProp.getDirection();
                    if (indexDir == Direction.UNSPECIFIED) {
                        indexDir = Direction.ASCENDING;
                    }
                    if (shouldReverseOrder != null && shouldReverseOrder.booleanValue()) {
                        indexDir = indexDir.reverse();
                    }
                    if (property.getDirection() == Direction.UNSPECIFIED) {
                        property = property.direction(indexDir);
                    } else if (shouldReverseOrder == null) {
                        shouldReverseOrder = indexDir != property.getDirection();
                        if (shouldReverseOrder.booleanValue()) {
                            handledOrdering = handledOrdering.reverseDirections();
                        }
                    } else if (indexDir != property.getDirection()) break;
                    handledOrdering = handledOrdering.concat(property);
                    ++indexPos;
                    continue block3;
                }
                if (!identityPropSet.contains(indexChained)) break;
                ++indexPos;
            }
            OrderingList orderingList = var8_10.concat(property);
            gap = true;
        }
        while (indexPos < indexProperties.length) {
            OrderedProperty<S> freeProp = indexProperties[indexPos];
            ChainedProperty<S> freeChained = freeProp.getChainedProperty();
            if (!identityPropSet.contains(freeChained)) {
                if (shouldReverseOrder == null) {
                    freeProp = freeProp.direction(Direction.UNSPECIFIED);
                } else {
                    Direction freePropDir = freeProp.getDirection();
                    if (freePropDir == Direction.UNSPECIFIED) {
                        freePropDir = Direction.ASCENDING;
                    }
                    if (shouldReverseOrder.booleanValue()) {
                        freeProp = freeProp.direction(freePropDir.reverse());
                    }
                }
                freeOrdering = freeOrdering.concat(freeProp);
            }
            ++indexPos;
        }
        if (shouldReverseOrder == null) {
            shouldReverseOrder = false;
        }
        return new OrderingScore<S>(indexProperties, clustered, handledOrdering, var8_10, shouldReverseOrder, freeOrdering, unusedOrdering);
    }

    public static Comparator<OrderingScore<?>> fullComparator() {
        return Full.INSTANCE;
    }

    private OrderingScore(OrderedProperty<S>[] indexProperties, boolean indexClustered, OrderingList<S> handledOrdering, OrderingList<S> remainderOrdering, boolean shouldReverseOrder, OrderingList<S> freeOrdering, OrderingList<S> unusedOrdering) {
        this.mIndexProperties = indexProperties;
        this.mIndexClustered = indexClustered;
        this.mHandledOrdering = handledOrdering;
        this.mRemainderOrdering = remainderOrdering;
        this.mShouldReverseOrder = shouldReverseOrder;
        this.mFreeOrdering = freeOrdering;
        this.mUnusedOrdering = unusedOrdering;
    }

    private OrderingScore(OrderingScore<S> score, OrderingList<S> remainderOrdering) {
        this.mIndexProperties = score.mIndexProperties;
        this.mIndexClustered = score.mIndexClustered;
        this.mHandledOrdering = score.mHandledOrdering;
        this.mRemainderOrdering = remainderOrdering;
        this.mShouldReverseOrder = score.mShouldReverseOrder;
        this.mFreeOrdering = score.mFreeOrdering;
        this.mUnusedOrdering = score.mUnusedOrdering;
    }

    public boolean isIndexClustered() {
        return this.mIndexClustered;
    }

    public int getIndexPropertyCount() {
        return this.mIndexProperties.length;
    }

    public int getHandledCount() {
        return this.mHandledOrdering.size();
    }

    public OrderingList<S> getHandledOrdering() {
        return this.mHandledOrdering;
    }

    public int getRemainderCount() {
        return this.mRemainderOrdering.size();
    }

    public OrderingList<S> getRemainderOrdering() {
        return this.mRemainderOrdering;
    }

    public boolean shouldReverseOrder() {
        return this.mShouldReverseOrder;
    }

    public OrderingList<S> getFreeOrdering() {
        return this.mFreeOrdering;
    }

    public OrderingList<S> getUnusedOrdering() {
        return this.mUnusedOrdering;
    }

    public boolean canMergeRemainderOrdering(OrderingScore<S> other) {
        if (this == other || this.getHandledCount() == 0 && other.getHandledCount() == 0) {
            return true;
        }
        if (this.isIndexClustered() == other.isIndexClustered() && this.getIndexPropertyCount() == other.getIndexPropertyCount() && this.shouldReverseOrder() == other.shouldReverseOrder() && this.getHandledOrdering().equals(other.getHandledOrdering())) {
            OrderingList<S> thisRemainderOrdering = this.getRemainderOrdering();
            OrderingList<S> otherRemainderOrdering = other.getRemainderOrdering();
            int size = Math.min(thisRemainderOrdering.size(), otherRemainderOrdering.size());
            for (int i = 0; i < size; ++i) {
                if (((OrderedProperty)thisRemainderOrdering.get(i)).equals(otherRemainderOrdering.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public OrderingList<S> mergeRemainderOrdering(OrderingScore<S> other) {
        OrderingList<S> thisRemainderOrdering = this.getRemainderOrdering();
        if (this == other) {
            return thisRemainderOrdering;
        }
        OrderingList<S> otherRemainderOrdering = other.getRemainderOrdering();
        if (thisRemainderOrdering.size() == 0) {
            return otherRemainderOrdering;
        }
        if (otherRemainderOrdering.size() == 0) {
            return thisRemainderOrdering;
        }
        if (thisRemainderOrdering.size() >= otherRemainderOrdering.size()) {
            return thisRemainderOrdering;
        }
        return otherRemainderOrdering;
    }

    public OrderingScore<S> withRemainderOrdering(OrderingList<S> ordering) {
        return new OrderingScore<S>(this, ordering);
    }

    public String toString() {
        return "OrderingScore {handledCount=" + this.getHandledCount() + ", remainderCount=" + this.getRemainderCount() + ", shouldReverseOrder=" + this.shouldReverseOrder() + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Full
    implements Comparator<OrderingScore<?>> {
        static final Comparator<OrderingScore<?>> INSTANCE = new Full();

        private Full() {
        }

        @Override
        public int compare(OrderingScore<?> first, OrderingScore<?> second) {
            if (first == second) {
                return 0;
            }
            int result = FilteringScore.nullCompare(first, second);
            if (result != 0) {
                return result;
            }
            int total = first.getHandledCount() + first.getRemainderCount();
            double firstRatio = (double)first.getHandledCount() / (double)total;
            total = second.getHandledCount() + second.getRemainderCount();
            double otherRatio = (double)second.getHandledCount() / (double)total;
            if (firstRatio > otherRatio) {
                return -1;
            }
            if (firstRatio < otherRatio) {
                return 1;
            }
            if (Double.isNaN(firstRatio)) {
                if (Double.isNaN(otherRatio)) {
                    return 0;
                }
                return 1;
            }
            if (Double.isNaN(otherRatio)) {
                return -1;
            }
            if (first.isIndexClustered()) {
                if (!second.isIndexClustered()) {
                    return -1;
                }
            } else if (second.isIndexClustered()) {
                return 1;
            }
            if (first.getIndexPropertyCount() < second.getIndexPropertyCount()) {
                return -1;
            }
            if (first.getIndexPropertyCount() > second.getIndexPropertyCount()) {
                return 1;
            }
            if (first.shouldReverseOrder()) {
                if (!second.shouldReverseOrder()) {
                    return 1;
                }
            } else if (second.shouldReverseOrder()) {
                return -1;
            }
            return 0;
        }
    }
}

