/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.lob;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.lob.AbstractBlob;
import com.amazon.carbonado.spi.RAFInputStream;
import com.amazon.carbonado.spi.RAFOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class FileBlob
extends AbstractBlob {
    private final File mFile;

    public FileBlob(File file) {
        this.mFile = file;
    }

    public InputStream openInputStream() throws FetchException {
        return this.openInputStream(0L, -1);
    }

    public InputStream openInputStream(long pos) throws FetchException {
        return this.openInputStream(pos, -1);
    }

    public InputStream openInputStream(long pos, int bufferSize) throws FetchException {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.mFile, "r");
            if (pos != 0L) {
                raf.seek(pos);
            }
            InputStream in = new RAFInputStream(raf);
            if (bufferSize < 0) {
                in = new BufferedInputStream(in);
            } else if (bufferSize > 0) {
                in = new BufferedInputStream(in, bufferSize);
            }
            return in;
        }
        catch (IOException e) {
            throw new FetchException(e);
        }
    }

    public long getLength() throws FetchException {
        return this.mFile.length();
    }

    public OutputStream openOutputStream() throws PersistException {
        return this.openOutputStream(0L, -1);
    }

    public OutputStream openOutputStream(long pos) throws PersistException {
        return this.openOutputStream(pos, -1);
    }

    public OutputStream openOutputStream(long pos, int bufferSize) throws PersistException {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.mFile, "rw");
            if (pos != 0L) {
                raf.seek(pos);
            }
            OutputStream out = new RAFOutputStream(raf);
            if (bufferSize < 0) {
                out = new BufferedOutputStream(out);
            } else if (bufferSize > 0) {
                out = new BufferedOutputStream(out, bufferSize);
            }
            return out;
        }
        catch (IOException e) {
            throw new PersistException(e);
        }
    }

    public void setLength(long length) throws PersistException {
        try {
            RandomAccessFile raf = new RandomAccessFile(this.mFile, "rw");
            raf.setLength(length);
            raf.close();
        }
        catch (IOException e) {
            throw new PersistException(e);
        }
    }

    public Object getLocator() {
        return null;
    }
}

