/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.layout;

import com.amazon.carbonado.FetchException;
import com.amazon.carbonado.PersistException;
import com.amazon.carbonado.SupportException;
import com.amazon.carbonado.UniqueConstraintException;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.info.StorablePropertyAdapter;
import com.amazon.carbonado.info.StorablePropertyAnnotation;
import com.amazon.carbonado.layout.StoredLayoutProperty;
import com.amazon.carbonado.util.AnnotationDescPrinter;
import org.cojen.classfile.TypeDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutProperty {
    private final StoredLayoutProperty mStoredLayoutProperty;

    LayoutProperty(StoredLayoutProperty storedLayoutProperty) {
        this.mStoredLayoutProperty = storedLayoutProperty;
    }

    LayoutProperty(StoredLayoutProperty storedLayoutProperty, StorableProperty<?> property, long layoutID, int ordinal) {
        this.mStoredLayoutProperty = storedLayoutProperty;
        storedLayoutProperty.setLayoutID(layoutID);
        storedLayoutProperty.setOrdinal(ordinal);
        storedLayoutProperty.setPropertyName(property.getName());
        storedLayoutProperty.setPropertyTypeDescriptor(TypeDesc.forClass(property.getType()).getDescriptor());
        storedLayoutProperty.setNullable(property.isNullable());
        storedLayoutProperty.setVersion(property.isVersion());
        storedLayoutProperty.setPrimaryKeyMember(property.isPrimaryKeyMember());
        if (property.getAdapter() != null) {
            StorablePropertyAdapter adapter = property.getAdapter();
            StorablePropertyAnnotation spa = adapter.getAnnotation();
            if (spa == null || spa.getAnnotation() == null) {
                storedLayoutProperty.setAdapterTypeName(null);
                storedLayoutProperty.setAdapterParams(null);
            } else {
                storedLayoutProperty.setAdapterTypeName(spa.getAnnotationType().getName());
                StringBuilder b = new StringBuilder();
                AnnotationDescPrinter printer = new AnnotationDescPrinter(true, b);
                printer.visit(spa.getAnnotation());
                storedLayoutProperty.setAdapterParams(b.toString());
            }
        }
    }

    public String getPropertyName() {
        return this.mStoredLayoutProperty.getPropertyName();
    }

    public String getPropertyTypeDescriptor() {
        return this.mStoredLayoutProperty.getPropertyTypeDescriptor();
    }

    public Class getPropertyType() throws SupportException {
        return this.getPropertyType(null);
    }

    public Class getPropertyType(ClassLoader loader) throws SupportException {
        TypeDesc type = TypeDesc.forDescriptor((String)this.getPropertyTypeDescriptor());
        Class propClass = type.toClass(loader);
        if (propClass == null) {
            throw new SupportException("Unable to find class \"" + type.getRootName() + "\" for property \"" + this.getPropertyName() + '\"');
        }
        return propClass;
    }

    public boolean isNullable() {
        return this.mStoredLayoutProperty.isNullable();
    }

    public boolean isPrimaryKeyMember() {
        return this.mStoredLayoutProperty.isPrimaryKeyMember();
    }

    public boolean isVersion() {
        return this.mStoredLayoutProperty.isVersion();
    }

    public String getAdapterTypeName() {
        return this.mStoredLayoutProperty.getAdapterTypeName();
    }

    public String getAdapterParams() {
        return this.mStoredLayoutProperty.getAdapterParams();
    }

    public int hashCode() {
        return this.mStoredLayoutProperty.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LayoutProperty) {
            StoredLayoutProperty thisStoredLayoutProperty = this.mStoredLayoutProperty;
            StoredLayoutProperty other = ((LayoutProperty)obj).mStoredLayoutProperty;
            boolean result = thisStoredLayoutProperty.equalProperties(other);
            if (result) {
                return result;
            }
            if (thisStoredLayoutProperty.getVersionNumber() != other.getVersionNumber()) {
                thisStoredLayoutProperty = (StoredLayoutProperty)thisStoredLayoutProperty.copy();
                thisStoredLayoutProperty.setVersionNumber(other.getVersionNumber());
                return thisStoredLayoutProperty.equalProperties(other);
            }
        }
        return false;
    }

    public String toString() {
        return this.mStoredLayoutProperty.toString();
    }

    void insert() throws PersistException {
        try {
            this.mStoredLayoutProperty.insert();
        }
        catch (UniqueConstraintException e) {
            StoredLayoutProperty existing = (StoredLayoutProperty)this.mStoredLayoutProperty.prepare();
            this.mStoredLayoutProperty.copyPrimaryKeyProperties(existing);
            try {
                existing.load();
            }
            catch (FetchException e2) {
                throw e2.toPersistException();
            }
            if (!this.equals(new LayoutProperty(existing))) {
                throw e;
            }
            this.mStoredLayoutProperty.setVersionNumber(existing.getVersionNumber());
            this.mStoredLayoutProperty.update();
        }
    }
}

