/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.info;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.capability.IndexInfo;
import com.amazon.carbonado.info.Direction;
import com.amazon.carbonado.info.OrderedProperty;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableKey;
import com.amazon.carbonado.info.StorableProperty;
import com.amazon.carbonado.util.Appender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.cojen.classfile.TypeDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorableIndex<S extends Storable>
implements Appender {
    private final StorableProperty<S>[] mProperties;
    private final Direction[] mDirections;
    private final boolean mUnique;
    private final boolean mClustered;

    public static <S extends Storable> StorableIndex<S> parseNameDescriptor(String desc, StorableInfo<S> info) throws IllegalArgumentException {
        boolean unique;
        String name = info.getStorableType().getName();
        if (!desc.startsWith(name)) {
            throw new IllegalArgumentException("Descriptor starts with wrong type name: \"" + desc + "\", \"" + name + '\"');
        }
        Map<String, StorableProperty<S>> allProperties = info.getAllProperties();
        ArrayList<StorableProperty<S>> properties = new ArrayList<StorableProperty<S>>();
        ArrayList<Direction> directions = new ArrayList<Direction>();
        try {
            int pos = name.length();
            if (desc.charAt(pos++) != '~') {
                throw new IllegalArgumentException("Invalid syntax");
            }
            int pos2 = StorableIndex.nextSep(desc, pos);
            String attr = desc.substring(pos, pos2);
            if (attr.equals("U")) {
                unique = true;
            } else if (attr.equals("N")) {
                unique = false;
            } else {
                throw new IllegalArgumentException("Unknown attribute");
            }
            pos = pos2;
            while (pos < desc.length()) {
                char sign;
                if ((sign = desc.charAt(pos++)) == '+') {
                    directions.add(Direction.ASCENDING);
                } else if (sign == '-') {
                    directions.add(Direction.DESCENDING);
                } else if (sign == '~') {
                    directions.add(Direction.UNSPECIFIED);
                } else {
                    throw new IllegalArgumentException("Unknown property direction");
                }
                int pos22 = StorableIndex.nextSep(desc, pos);
                String propertyName = desc.substring(pos, pos22);
                StorableProperty<S> property = allProperties.get(propertyName);
                if (property == null) {
                    throw new IllegalArgumentException("Unknown property: " + propertyName);
                }
                properties.add(property);
                pos = pos22;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid syntax");
        }
        int size = properties.size();
        if (size == 0 || size != directions.size()) {
            throw new IllegalArgumentException("No properties specified");
        }
        StorableIndex<S> index = new StorableIndex<S>(properties.toArray(new StorableProperty[size]), directions.toArray(new Direction[size]));
        return index.unique(unique);
    }

    private static int nextSep(String desc, int pos) {
        int pos2 = desc.length();
        int candidate = desc.indexOf(43, pos);
        if (candidate > 0) {
            pos2 = candidate;
        }
        if ((candidate = desc.indexOf(45, pos)) > 0) {
            pos2 = Math.min(candidate, pos2);
        }
        if ((candidate = desc.indexOf(126, pos)) > 0) {
            pos2 = Math.min(candidate, pos2);
        }
        return pos2;
    }

    public StorableIndex(StorableProperty<S>[] properties, Direction[] directions) {
        this(properties, directions, false);
    }

    public StorableIndex(StorableProperty<S>[] properties, Direction[] directions, boolean unique) {
        this(properties, directions, unique, false, true);
    }

    public StorableIndex(StorableProperty<S>[] properties, Direction[] directions, boolean unique, boolean clustered) {
        this(properties, directions, unique, clustered, true);
    }

    private StorableIndex(StorableProperty<S>[] properties, Direction[] directions, boolean unique, boolean clustered, boolean doClone) {
        if (properties == null || directions == null) {
            throw new IllegalArgumentException();
        }
        if (properties.length != directions.length) {
            throw new IllegalArgumentException();
        }
        if (properties.length < 1) {
            throw new IllegalArgumentException();
        }
        this.mProperties = doClone ? (StorableProperty[])properties.clone() : properties;
        this.mDirections = doClone ? (Direction[])directions.clone() : directions;
        this.mUnique = unique;
        this.mClustered = clustered;
    }

    public StorableIndex(StorableKey<S> key, Direction direction) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Set<OrderedProperty<S>> properties = key.getProperties();
        if (properties.size() < 1) {
            throw new IllegalArgumentException();
        }
        if (direction == null) {
            direction = Direction.UNSPECIFIED;
        }
        this.mProperties = new StorableProperty[properties.size()];
        this.mDirections = new Direction[properties.size()];
        int i = 0;
        for (OrderedProperty<S> prop : properties) {
            this.mProperties[i] = prop.getChainedProperty().getPrimeProperty();
            this.mDirections[i] = prop.getDirection() == Direction.UNSPECIFIED ? direction : prop.getDirection();
            ++i;
        }
        this.mUnique = true;
        this.mClustered = false;
    }

    public StorableIndex(OrderedProperty<S>[] properties, Direction direction) {
        if (properties == null || properties.length == 0) {
            throw new IllegalArgumentException();
        }
        if (direction == null) {
            direction = Direction.UNSPECIFIED;
        }
        this.mProperties = new StorableProperty[properties.length];
        this.mDirections = new Direction[properties.length];
        int i = 0;
        for (OrderedProperty<S> prop : properties) {
            this.mProperties[i] = prop.getChainedProperty().getPrimeProperty();
            this.mDirections[i] = prop.getDirection() == Direction.UNSPECIFIED ? direction : prop.getDirection();
            ++i;
        }
        this.mUnique = false;
        this.mClustered = false;
    }

    public StorableIndex(Class<S> type, IndexInfo indexInfo) {
        if (indexInfo == null) {
            throw new IllegalArgumentException();
        }
        Map<String, StorableProperty<S>> allProperties = StorableIntrospector.examine(type).getAllProperties();
        String[] propertyNames = indexInfo.getPropertyNames();
        if (propertyNames.length == 0) {
            throw new IllegalArgumentException("No properties in index info");
        }
        this.mProperties = new StorableProperty[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            StorableProperty<S> property = allProperties.get(propertyNames[i]);
            if (property == null) {
                throw new IllegalArgumentException("Property not found: " + propertyNames[i]);
            }
            this.mProperties[i] = property;
        }
        this.mDirections = indexInfo.getPropertyDirections();
        this.mUnique = indexInfo.isUnique();
        this.mClustered = indexInfo.isClustered();
    }

    public Class<S> getStorableType() {
        return this.getProperty(0).getEnclosingType();
    }

    public int getPropertyCount() {
        return this.mProperties.length;
    }

    public StorableProperty<S> getProperty(int index) {
        return this.mProperties[index];
    }

    public StorableProperty<S>[] getProperties() {
        return (StorableProperty[])this.mProperties.clone();
    }

    public Direction getPropertyDirection(int index) {
        return this.mDirections[index];
    }

    public Direction[] getPropertyDirections() {
        return (Direction[])this.mDirections.clone();
    }

    public OrderedProperty<S> getOrderedProperty(int index) {
        return OrderedProperty.get(this.mProperties[index], this.mDirections[index]);
    }

    public OrderedProperty<S>[] getOrderedProperties() {
        OrderedProperty[] ordered = new OrderedProperty[this.mProperties.length];
        int i = this.mProperties.length;
        while (--i >= 0) {
            ordered[i] = OrderedProperty.get(this.mProperties[i], this.mDirections[i]);
        }
        return ordered;
    }

    public boolean isUnique() {
        return this.mUnique;
    }

    public boolean isClustered() {
        return this.mClustered;
    }

    public StorableIndex<S> unique(boolean unique) {
        if (unique == this.mUnique) {
            return this;
        }
        return new StorableIndex<S>(this.mProperties, this.mDirections, unique, this.mClustered, false);
    }

    public StorableIndex<S> clustered(boolean clustered) {
        if (clustered == this.mClustered) {
            return this;
        }
        return new StorableIndex<S>(this.mProperties, this.mDirections, this.mUnique, clustered, false);
    }

    public StorableIndex<S> reverse() {
        int i;
        Direction[] directions;
        block2: {
            directions = this.mDirections;
            i = directions.length;
            while (--i >= 0) {
                if (directions[i] == Direction.UNSPECIFIED) continue;
                break block2;
            }
            return this;
        }
        directions = (Direction[])directions.clone();
        i = directions.length;
        while (--i >= 0) {
            directions[i] = directions[i].reverse();
        }
        return new StorableIndex<S>(this.mProperties, directions, this.mUnique, this.mClustered, false);
    }

    public StorableIndex<S> setDefaultDirection(Direction direction) {
        int i;
        Direction[] directions;
        block2: {
            directions = this.mDirections;
            i = directions.length;
            while (--i >= 0) {
                if (directions[i] != Direction.UNSPECIFIED) continue;
                break block2;
            }
            return this;
        }
        directions = (Direction[])directions.clone();
        i = directions.length;
        while (--i >= 0) {
            if (directions[i] != Direction.UNSPECIFIED) continue;
            directions[i] = direction;
        }
        return new StorableIndex<S>(this.mProperties, directions, this.mUnique, this.mClustered, false);
    }

    public StorableIndex<S> addProperty(StorableProperty<S> property, Direction direction) {
        int i = this.mProperties.length;
        while (--i >= 0) {
            if (!this.mProperties[i].equals(property)) continue;
            return this;
        }
        StorableProperty[] properties = new StorableProperty[this.mProperties.length + 1];
        Direction[] directions = new Direction[this.mDirections.length + 1];
        System.arraycopy(this.mProperties, 0, properties, 0, this.mProperties.length);
        System.arraycopy(this.mDirections, 0, directions, 0, this.mDirections.length);
        properties[properties.length - 1] = property;
        directions[directions.length - 1] = direction;
        return new StorableIndex<S>(properties, directions, this.mUnique, this.mClustered, false);
    }

    public StorableIndex<S> uniquify(StorableKey<S> key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.isUnique()) {
            return this;
        }
        StorableIndex<S> index = this;
        for (OrderedProperty<S> keyProp : key.getProperties()) {
            index = index.addProperty(keyProp.getChainedProperty().getPrimeProperty(), keyProp.getDirection());
        }
        return index.unique(true);
    }

    public String getNameDescriptor() {
        StringBuilder b = new StringBuilder();
        b.append(this.getStorableType().getName());
        b.append('~');
        b.append(this.isUnique() ? (char)'U' : 'N');
        int count = this.getPropertyCount();
        for (int i = 0; i < count; ++i) {
            b.append(this.getPropertyDirection(i).toCharacter());
            b.append(this.getProperty(i).getName());
        }
        return b.toString();
    }

    public String getTypeDescriptor() {
        StringBuilder b = new StringBuilder();
        int count = this.getPropertyCount();
        for (int i = 0; i < count; ++i) {
            StorableProperty<S> property = this.getProperty(i);
            if (property.isNullable()) {
                b.append('N');
            }
            b.append(TypeDesc.forClass(property.getType()).getDescriptor());
        }
        return b.toString();
    }

    public int hashCode() {
        return (this.mUnique ? 0 : 31) + Arrays.hashCode(this.mProperties) * 31 + Arrays.hashCode((Object[])this.mDirections);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StorableIndex) {
            StorableIndex other = (StorableIndex)obj;
            return this.isUnique() == other.isUnique() && this.isClustered() == other.isClustered() && Arrays.equals(this.mProperties, other.mProperties) && Arrays.equals((Object[])this.mDirections, (Object[])other.mDirections);
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StorableIndex ");
        try {
            this.appendTo(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return b.toString();
    }

    @Override
    public void appendTo(Appendable app) throws IOException {
        app.append("{properties=[");
        int length = this.mProperties.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                app.append(", ");
            }
            app.append(this.mDirections[i].toCharacter());
            app.append(this.mProperties[i].getName());
        }
        app.append(']');
        app.append(", unique=");
        app.append(String.valueOf(this.isUnique()));
        app.append('}');
    }
}

