/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.carbonado.gen;

import com.amazon.carbonado.Storable;
import com.amazon.carbonado.gen.CodeBuilderUtil;
import com.amazon.carbonado.info.StorableInfo;
import com.amazon.carbonado.info.StorableIntrospector;
import com.amazon.carbonado.info.StorableProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.WeakHashMap;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.ClassInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StorableCopier<S extends Storable, T extends Storable> {
    private static final WeakHashMap<Class, Object> cClassKeyCache = new WeakHashMap();
    private static final WeakHashMap<Object, From> cFromCache = new WeakHashMap();

    static synchronized Object classKey(Class clazz) {
        Object key = cClassKeyCache.get(clazz);
        if (key == null) {
            key = new Object();
            cClassKeyCache.put(clazz, key);
        }
        return key;
    }

    public static synchronized <S extends Storable> From<S> from(Class<S> source) {
        Object key = StorableCopier.classKey(source);
        From<S> from = cFromCache.get(key);
        if (from == null) {
            from = new From<S>(source);
            cFromCache.put(key, from);
        }
        return from;
    }

    protected StorableCopier() {
    }

    public abstract void copyAllProperties(S var1, T var2);

    public abstract void copyPrimaryKeyProperties(S var1, T var2);

    public abstract void copyVersionProperty(S var1, T var2);

    public abstract void copyUnequalProperties(S var1, T var2);

    public abstract void copyDirtyProperties(S var1, T var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Wrapper<W extends Storable, D extends Storable> {
        private final StorableInfo<W> mWrapperInfo;
        private final StorableInfo<D> mDelegateInfo;
        private final ClassInjector mClassInjector;
        private final ClassFile mClassFile;

        Wrapper(Class<W> wrapper, Class<D> delegate) {
            this.mWrapperInfo = StorableIntrospector.examine(wrapper);
            this.mDelegateInfo = StorableIntrospector.examine(delegate);
            ClassLoader loader = wrapper.getClassLoader();
            try {
                loader.loadClass(delegate.getName());
            }
            catch (ClassNotFoundException e) {
                loader = delegate.getClassLoader();
                try {
                    loader.loadClass(wrapper.getName());
                }
                catch (ClassNotFoundException e2) {
                    throw new IllegalStateException("Unable for find common class loader for source and target types: " + wrapper.getClass() + ", " + delegate.getClass());
                }
            }
            this.mClassInjector = ClassInjector.create((String)wrapper.getName(), (ClassLoader)loader);
            this.mClassFile = CodeBuilderUtil.createStorableClassFile(this.mClassInjector, this.mWrapperInfo.getStorableType(), false, StorableCopier.class.getName());
        }

        Constructor<? extends W> generate() {
            TypeDesc delegateType = TypeDesc.forClass(this.mDelegateInfo.getStorableType());
            this.mClassFile.addField(Modifiers.PRIVATE.toFinal(true), "delegate", delegateType);
            MethodInfo mi = this.mClassFile.addConstructor(Modifiers.PUBLIC, new TypeDesc[]{delegateType});
            CodeBuilder b = new CodeBuilder(mi);
            b.loadThis();
            b.invokeSuperConstructor(null);
            b.loadThis();
            b.loadLocal(b.getParameter(0));
            b.storeField("delegate", delegateType);
            b.returnVoid();
            for (StorableProperty<W> wrapperProp : this.mWrapperInfo.getAllProperties().values()) {
                Label notNull;
                if (wrapperProp.isDerived()) continue;
                TypeDesc wrapperPropType = TypeDesc.forClass(wrapperProp.getType());
                StorableProperty<D> delegateProp = this.mDelegateInfo.getAllProperties().get(wrapperProp.getName());
                if (delegateProp == null || delegateProp.isDerived()) {
                    this.addUnmatchedProperty(wrapperProp, wrapperPropType);
                    continue;
                }
                TypeDesc delegatePropType = TypeDesc.forClass(delegateProp.getType());
                if (wrapperPropType.equals((Object)delegatePropType)) {
                    Method m = Wrapper.canDefine(wrapperProp.getReadMethod());
                    if (m != null) {
                        b = new CodeBuilder(this.mClassFile.addMethod(m));
                        if (delegateProp.getReadMethod() == null) {
                            CodeBuilderUtil.blankValue(b, wrapperPropType);
                        } else {
                            b.loadThis();
                            b.loadField("delegate", delegateType);
                            b.invoke(delegateProp.getReadMethod());
                        }
                        b.returnValue(wrapperPropType);
                    }
                    if ((m = Wrapper.canDefine(wrapperProp.getWriteMethod())) == null) continue;
                    b = new CodeBuilder(this.mClassFile.addMethod(m));
                    if (delegateProp.getWriteMethod() != null) {
                        b.loadThis();
                        b.loadField("delegate", delegateType);
                        b.loadLocal(b.getParameter(0));
                        b.invoke(delegateProp.getWriteMethod());
                    }
                    b.returnVoid();
                    continue;
                }
                TypeDesc wrapperPrimPropType = wrapperPropType.toPrimitiveType();
                TypeDesc delegatePrimPropType = delegatePropType.toPrimitiveType();
                if (wrapperPrimPropType == null || delegatePrimPropType == null) {
                    this.addUnmatchedProperty(wrapperProp, wrapperPropType);
                    continue;
                }
                Method m = Wrapper.canDefine(wrapperProp.getReadMethod());
                if (m != null) {
                    b = new CodeBuilder(this.mClassFile.addMethod(m));
                    if (delegateProp.getReadMethod() == null) {
                        CodeBuilderUtil.blankValue(b, wrapperPropType);
                    } else {
                        b.loadThis();
                        b.loadField("delegate", delegateType);
                        b.invoke(delegateProp.getReadMethod());
                        if (wrapperPropType.isPrimitive() && !delegatePropType.isPrimitive()) {
                            b.dup();
                            notNull = b.createLabel();
                            b.ifNullBranch((Location)notNull, false);
                            CodeBuilderUtil.blankValue(b, wrapperPropType);
                            b.returnValue(wrapperPropType);
                            notNull.setLocation();
                        }
                        b.convert(delegatePropType, wrapperPropType);
                    }
                    b.returnValue(wrapperPropType);
                }
                if ((m = Wrapper.canDefine(wrapperProp.getWriteMethod())) == null) continue;
                b = new CodeBuilder(this.mClassFile.addMethod(m));
                if (delegateProp.getWriteMethod() != null) {
                    b.loadThis();
                    b.loadField("delegate", delegateType);
                    b.loadLocal(b.getParameter(0));
                    if (!wrapperPropType.isPrimitive() && delegatePropType.isPrimitive()) {
                        notNull = b.createLabel();
                        b.ifNullBranch((Location)notNull, false);
                        CodeBuilderUtil.blankValue(b, delegatePropType);
                        b.invoke(delegateProp.getWriteMethod());
                        b.returnVoid();
                        notNull.setLocation();
                        b.loadLocal(b.getParameter(0));
                    }
                    b.convert(wrapperPropType, delegatePropType);
                    b.invoke(delegateProp.getWriteMethod());
                }
                b.returnVoid();
            }
            try {
                Class wrapperClass = this.mClassInjector.defineClass(this.mClassFile);
                return wrapperClass.getConstructor(this.mDelegateInfo.getStorableType());
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        private void addUnmatchedProperty(StorableProperty<W> wrapperProp, TypeDesc wrapperPropType) {
            CodeBuilder b;
            Method m = Wrapper.canDefine(wrapperProp.getReadMethod());
            if (m != null) {
                b = new CodeBuilder(this.mClassFile.addMethod(m));
                CodeBuilderUtil.blankValue(b, wrapperPropType);
                b.returnValue(wrapperPropType);
            }
            if ((m = Wrapper.canDefine(wrapperProp.getWriteMethod())) != null) {
                b = new CodeBuilder(this.mClassFile.addMethod(m));
                b.returnVoid();
            }
        }

        private static Method canDefine(Method m) {
            return m == null || Modifier.isFinal(m.getModifiers()) ? null : m;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Direct<S extends Storable>
    extends StorableCopier<S, S> {
        static final Direct THE = new Direct();

        private Direct() {
        }

        @Override
        public void copyAllProperties(S source, S target) {
            source.copyAllProperties(target);
        }

        @Override
        public void copyPrimaryKeyProperties(S source, S target) {
            source.copyPrimaryKeyProperties(target);
        }

        @Override
        public void copyVersionProperty(S source, S target) {
            source.copyVersionProperty(target);
        }

        @Override
        public void copyUnequalProperties(S source, S target) {
            source.copyUnequalProperties(target);
        }

        @Override
        public void copyDirtyProperties(S source, S target) {
            source.copyDirtyProperties(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Wrapped<S extends Storable, T extends Storable>
    extends StorableCopier<S, T> {
        private final Constructor<? extends S> mWrapperCtor;

        private Wrapped(Constructor<? extends S> ctor) {
            this.mWrapperCtor = ctor;
        }

        @Override
        public void copyAllProperties(S source, T target) {
            source.copyAllProperties(this.wrap(target));
        }

        @Override
        public void copyPrimaryKeyProperties(S source, T target) {
            source.copyPrimaryKeyProperties(this.wrap(target));
        }

        @Override
        public void copyVersionProperty(S source, T target) {
            source.copyVersionProperty(this.wrap(target));
        }

        @Override
        public void copyUnequalProperties(S source, T target) {
            source.copyUnequalProperties(this.wrap(target));
        }

        @Override
        public void copyDirtyProperties(S source, T target) {
            source.copyDirtyProperties(this.wrap(target));
        }

        private S wrap(T target) {
            try {
                return (S)((Storable)this.mWrapperCtor.newInstance(target));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class From<S extends Storable> {
        private final Class<S> mSource;
        private final WeakHashMap<Object, StorableCopier> mCopierCache;

        From(Class<S> source) {
            this.mSource = source;
            this.mCopierCache = new WeakHashMap();
        }

        public synchronized <T extends Storable> StorableCopier<S, T> to(Class<T> target) {
            Object key = StorableCopier.classKey(target);
            StorableCopier copier = this.mCopierCache.get(key);
            if (copier == null) {
                copier = this.mSource == target ? Direct.THE : new Wrapped(new Wrapper<S, T>(this.mSource, target).generate());
                this.mCopierCache.put(key, copier);
            }
            return copier;
        }
    }
}

